/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMStringListImpl;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMCSSFontFaceRule;
import io.sf.carte.doc.style.css.om.OMCSSImportRule;
import io.sf.carte.doc.style.css.om.OMCSSMarginRule;
import io.sf.carte.doc.style.css.om.OMCSSMediaRule;
import io.sf.carte.doc.style.css.om.OMCSSNamespaceRule;
import io.sf.carte.doc.style.css.om.OMCSSPageRule;
import io.sf.carte.doc.style.css.om.OMCSSStyleRule;
import io.sf.carte.doc.style.css.om.OMCSSSupportsRule;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.w3c.CSSMarginRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private StyleSheet parent = null;
    private String href = null;
    private CSSRule ownerRule = null;
    private short sheetOrigin;
    protected CSSRuleArrayList cssRules = new CSSRuleArrayList();
    protected int currentInsertionIndex = 0;
    protected MediaQueryList destinationMedia;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler;

    protected BaseCSSStyleSheet(String title, MediaQueryList media, CSSRule ownerRule, short origin) {
        super(title);
        this.ownerRule = ownerRule;
        this.destinationMedia = media;
        this.sheetErrorHandler = this.getStyleSheetFactory().createSheetErrorHandler(this);
        this.sheetOrigin = origin;
    }

    protected BaseCSSStyleSheet(BaseCSSStyleSheet copyMe) {
        super(copyMe.getTitle());
        this.ownerRule = copyMe.ownerRule;
        this.destinationMedia = copyMe.destinationMedia;
        this.sheetOrigin = copyMe.sheetOrigin;
        this.sheetErrorHandler = copyMe.getStyleSheetFactory().createSheetErrorHandler(this);
    }

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public Node getOwnerNode() {
        return null;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.destinationMedia;
    }

    @Override
    public short getOrigin() {
        return this.sheetOrigin;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        Parser psr = this.createSACParser();
        psr.setDocumentHandler(this.createDocumentHandler(this.getOrigin(), true));
        this.currentInsertionIndex = index - 1;
        try {
            psr.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) {
        cssrule.setParentStyleSheet(this);
        this.addLocalRule(cssrule);
    }

    protected void addLocalRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        try {
            this.cssRules.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
    }

    @Override
    public OMCSSStyleRule createCSSStyleRule() {
        return new OMCSSStyleRule(this, this.getOrigin());
    }

    @Override
    public CSSFontFaceRule createCSSFontFaceRule() {
        return new OMCSSFontFaceRule(this, this.getOrigin());
    }

    @Override
    public OMCSSImportRule createCSSImportRule(MediaQueryList mediaList) {
        return new OMCSSImportRule((AbstractCSSStyleSheet)this, ((MediaListAccess)((Object)mediaList)).unmodifiable(), this.getOrigin());
    }

    @Override
    public OMCSSMediaRule createCSSMediaRule(MediaQueryList mediaList) {
        return new OMCSSMediaRule((AbstractCSSStyleSheet)this, mediaList, this.getOrigin());
    }

    @Override
    public OMCSSPageRule createCSSPageRule() {
        return new OMCSSPageRule(this, this.getOrigin());
    }

    @Override
    public OMCSSMarginRule createCSSMarginRule(String name) {
        return new OMCSSMarginRule((AbstractCSSStyleSheet)this, this.getOrigin(), name);
    }

    @Override
    protected BaseCSSStyleDeclaration createCSSStyleDeclaration(CSSStyleDeclarationRule rule) {
        if (rule.getType() == 5) {
            return new WrappedCSSStyleDeclaration(rule);
        }
        return new BaseCSSStyleDeclaration(rule);
    }

    @Override
    public BaseCSSStyleDeclaration createCSSStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    public boolean hasRuleErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (rule.getType() != 1) continue;
            CSSStyleDeclarationRule stylerule = (CSSStyleDeclarationRule)rule;
            if (stylerule.sdErrorHandler == null || !stylerule.sdErrorHandler.hasErrors() && !stylerule.sdErrorHandler.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        return this.sheetErrorHandler;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return this.parent;
    }

    public void setParentStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void addStyleSheet(AbstractCSSStyleSheet sheet) {
        if (!sheet.getDisabled()) {
            MediaQueryList mediaList = sheet.getMedia();
            int localrl = this.getCssRules().getLength();
            if (mediaList.isAllMedia()) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                for (int i = 0; i < orl; ++i) {
                    this.addLocalRule(otherRules.item(i).clone(sheet, localrl + i));
                }
            } else {
                boolean nouri = sheet.getHref() == null;
                OMCSSMediaRule mrule = this.createCSSMediaRule(mediaList);
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                for (int i = 0; i < orl; ++i) {
                    AbstractCSSRule orule = nouri ? otherRules.item(i).clone(this, localrl) : otherRules.item(i).clone(sheet, localrl);
                    orule.setParentRule(mrule);
                    mrule.addRule(orule);
                }
                this.addLocalRule(mrule);
            }
            this.getErrorHandler().mergeState(sheet.getErrorHandler());
        }
    }

    public boolean loadStyleSheet(URL url) throws DOMException, IOException {
        boolean result;
        PushbackReader re;
        int iread;
        int idx;
        URLConnection ucon = this.openConnection(url);
        InputStream is = ucon.getInputStream();
        String charset = null;
        String conType = ucon.getContentType();
        if (conType == null) {
            try {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8).replace('\"', ' ').replace('\'', ' ').trim().toUpperCase(Locale.US);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "UTF-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "UTF-8";
        } else {
            re.unread(iread);
        }
        InputSource source = new InputSource((Reader)re);
        try {
            this.setHref(url.toExternalForm());
            result = this.parseCSSStyleSheet(source);
        }
        catch (DOMException e) {
            this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, this);
            throw e;
        }
        catch (IOException e) {
            this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, this);
            throw e;
        }
        catch (CSSException e) {
            this.getStyleSheetFactory().getErrorHandler().onException((Exception)((Object)e), this);
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return result;
    }

    @Override
    public Selector[] getSelectorsForPropertyValue(String propertyName, String value) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForValue(this.cssRules, propertyName, value, selectors);
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.toArray(new Selector[0]);
    }

    private static void scanRulesForValue(CSSRuleArrayList rules, String propertyName, String value, LinkedList<Selector> selectors) {
        block4: for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: 
                case 6: {
                    CSSStyleDeclarationRule stylerule = (CSSStyleDeclarationRule)rule;
                    if (!value.equalsIgnoreCase(stylerule.getStyle().getPropertyValue(propertyName))) break;
                    SelectorList list = stylerule.getSelectorList();
                    for (int i = 0; i < list.getLength(); ++i) {
                        selectors.add(list.item(i));
                    }
                    continue block4;
                }
                case 4: {
                    OMCSSMediaRule mediarule = (OMCSSMediaRule)rule;
                    BaseCSSStyleSheet.scanRulesForValue((CSSRuleArrayList)mediarule.getCssRules(), propertyName, value, selectors);
                }
            }
        }
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    @Override
    public String toStyleString() {
        String rules = this.getCssRules().toString();
        StringBuilder buf = new StringBuilder(rules.length() + 60);
        buf.append("<style type=\"text/css\"");
        if (!this.destinationMedia.isAllMedia()) {
            buf.append(" media=\"").append(this.destinationMedia.getMediaText()).append('\"');
        }
        if (this.getTitle() != null) {
            buf.append(" title=\"").append(this.getTitle()).append('\"');
        }
        buf.append(">\n").append(rules).append("\n</style>\n");
        return buf.toString();
    }

    DocumentHandler createDocumentHandler(short origin, boolean ignoreComments) {
        return new CSSDocumentHandler(origin, ignoreComments);
    }

    protected Parser createSACParser() throws DOMException {
        return SACParserFactory.createSACParser();
    }

    @Override
    public boolean parseCSSStyleSheet(InputSource source) throws DOMException, IOException {
        return this.parseCSSStyleSheet(source, false);
    }

    @Override
    public boolean parseCSSStyleSheet(InputSource source, boolean ignoreComments) throws DOMException, IOException {
        this.getErrorHandler().reset();
        short origin = this.getOrigin();
        for (AbstractCSSRule rule : this.getCssRules()) {
            short ruleo = rule.getOrigin();
            if (ruleo >= origin) continue;
            origin = ruleo;
        }
        Parser parser = this.createSACParser();
        DocumentHandler handler = this.createDocumentHandler(origin, ignoreComments);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler((ErrorHandler)handler);
        try {
            parser.parseStyleSheet(source);
        }
        catch (CSSException e) {
            DOMException ex;
            switch (e.getCode()) {
                case 1: {
                    ex = new DOMException(9, e.getMessage());
                    break;
                }
                case 2: {
                    ex = new DOMException(12, e.getMessage());
                    break;
                }
                default: {
                    ex = new DOMException(15, e.getMessage());
                }
            }
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return !this.getErrorHandler().hasSacErrors();
    }

    class CSSDocumentHandler
    implements DocumentHandler,
    ErrorHandler {
        private BaseCSSRule currentRule = null;
        private short sheetOrigin;
        private LinkedList<String> comments = null;
        private boolean ignoreRulesForMedia = false;
        private boolean ignoreImports = false;

        CSSDocumentHandler(short origin, boolean ignoreComments) {
            this.sheetOrigin = origin;
            if (!ignoreComments) {
                this.comments = new LinkedList();
            }
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.ignoreRulesForMedia = false;
            this.ignoreImports = false;
            if (this.comments != null) {
                this.comments.clear();
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            if (this.comments != null) {
                this.comments.clear();
            }
        }

        public void comment(String text) throws CSSException {
            if (this.currentRule == null && this.comments != null) {
                this.comments.add(text);
            }
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            if (atRule.length() < 9) {
                return;
            }
            String firstchars = atRule.trim().substring(0, 9).toLowerCase(Locale.US);
            if (firstchars.equals("@supports")) {
                int idx = atRule.indexOf(123);
                int len = atRule.length();
                if (idx != -1 && idx < len - 1) {
                    OMCSSSupportsRule rule = new OMCSSSupportsRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, this.sheetOrigin);
                    rule.setConditionText(atRule.substring(9, idx).trim());
                    if (this.currentRule != null) {
                        rule.setParentRule(this.currentRule);
                        ((OMCSSMediaRule)this.currentRule).addRule(rule);
                    } else {
                        BaseCSSStyleSheet.this.addLocalRule(rule);
                    }
                    rule.setCssText(atRule.substring(idx + 1, len));
                    this.resetCurrentRule();
                }
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            BaseCSSStyleSheet.this.namespaces.put(prefix, uri);
            if (!this.ignoreRulesForMedia) {
                OMCSSNamespaceRule rule = new OMCSSNamespaceRule(BaseCSSStyleSheet.this, this.sheetOrigin, prefix, uri);
                if (this.currentRule != null) {
                    rule.setParentRule(this.currentRule);
                    ((OMCSSMediaRule)this.currentRule).addRule(rule);
                } else {
                    BaseCSSStyleSheet.this.addLocalRule(rule);
                }
                this.resetCurrentRule();
            }
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException, DOMException {
            if (this.ignoreImports) {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.ignoredImport(uri);
                }
                return;
            }
            if (((MediaListAccess)((Object)BaseCSSStyleSheet.this.destinationMedia)).match(media)) {
                OMCSSImportRule imp = new OMCSSImportRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                try {
                    imp.loadStyleSheet(uri, BaseCSSStyleSheet.this.getTitle(), media);
                }
                catch (CSSException e) {
                    throw new CSSException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new CSSException((Exception)e);
                }
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.ignoreImports = true;
            if (media.getLength() > 0) {
                SheetErrorHandler eh;
                MediaQueryList mlist = MediaQueryFactory.createMediaList(media);
                if (mlist.hasErrors() && (eh = BaseCSSStyleSheet.this.getErrorHandler()) != null) {
                    eh.badMediaList(media);
                }
                if (mlist.isNotAllMedia() || mlist.hasErrors()) {
                    this.ignoreRulesForMedia = true;
                } else {
                    this.currentRule = new OMCSSMediaRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, mlist, this.sheetOrigin);
                    this.ignoreRulesForMedia = false;
                }
            } else {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.emptyMediaList();
                }
                this.ignoreRulesForMedia = true;
            }
        }

        public void endMedia(SACMediaList media) throws CSSException {
            if (this.ignoreRulesForMedia) {
                this.ignoreRulesForMedia = false;
            } else if (this.currentRule != null) {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
            }
            this.resetCurrentRule();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule instanceof OMCSSPageRule) {
                    OMCSSMarginRule marginRule = BaseCSSStyleSheet.this.createCSSMarginRule(name);
                    marginRule.setParentRule(this.currentRule);
                    this.currentRule = marginRule;
                } else {
                    this.currentRule = new OMCSSPageRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                    if (name != null) {
                        ((OMCSSPageRule)this.currentRule).setPageType(name);
                    }
                    if (pseudo_page != null) {
                        Parser parser = BaseCSSStyleSheet.this.createSACParser();
                        InputSource source = new InputSource((Reader)new StringReader(pseudo_page));
                        try {
                            ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(parser.parseSelectors(source));
                        }
                        catch (IOException iOException) {}
                    } else {
                        ((CSSStyleDeclarationRule)this.currentRule).setSelectorText("");
                    }
                }
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule != null) {
                if (this.currentRule instanceof OMCSSPageRule) {
                    BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                    this.resetCurrentRule();
                } else {
                    OMCSSPageRule pageRule = (OMCSSPageRule)this.currentRule.getParentRule();
                    pageRule.addMarginRule((CSSMarginRule)((Object)this.currentRule));
                    this.currentRule = pageRule;
                }
            }
        }

        public void startFontFace() throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new OMCSSFontFaceRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorText("");
            }
        }

        public void endFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule != null) {
                    BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                }
                this.resetCurrentRule();
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                OMCSSStyleRule styleRule = BaseCSSStyleSheet.this.createCSSStyleRule();
                if (this.currentRule != null) {
                    styleRule.setParentRule(this.currentRule);
                }
                this.currentRule = styleRule;
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule instanceof OMCSSStyleRule) {
                BaseCSSRule pRule = (BaseCSSRule)this.currentRule.getParentRule();
                if (((OMCSSStyleRule)this.currentRule).getStyle().getLength() == 0) {
                    SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                    if (eh != null) {
                        eh.emptyRule(((OMCSSStyleRule)this.currentRule).getSelectorText());
                    }
                } else {
                    if (pRule == null) {
                        if (this.currentRule != null) {
                            BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                        }
                    } else {
                        ((OMCSSMediaRule)pRule).addRule(this.currentRule);
                    }
                    this.resetCurrentRule();
                }
                this.currentRule = pRule;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                String importantString = null;
                importantString = important ? "important" : null;
                try {
                    ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
                }
                catch (RuntimeException e) {
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    if (this.currentRule != null) {
                        ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(name, ex);
                    }
                    BaseCSSStyleSheet.this.getErrorHandler().unexpectedProperty(name, value);
                }
            }
        }

        private void resetCurrentRule() {
            if (this.currentRule != null) {
                if (this.comments != null) {
                    this.currentRule.precedingComments = new DOMStringListImpl(this.comments.toArray(new String[0]));
                }
                this.currentRule = null;
            }
            if (this.comments != null) {
                this.comments.clear();
            }
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof CSSStyleDeclarationRule && ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((CSSStyleDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(exception, previousIndex);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacWarning(exception);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof CSSStyleDeclarationRule && ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((CSSStyleDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof CSSStyleDeclarationRule && ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((CSSStyleDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((CSSStyleDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacFatalError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }
    }
}

