/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQuery;
import io.sf.carte.doc.style.css.om.MediaQueryHandler;
import io.sf.carte.doc.style.css.om.MediaQueryParser;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.doc.style.css.w3c.MediaQueryListListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class MediaQueryFactory {
    private static String[] mediaFeatures = new String[]{"any-hover", "any-pointer", "aspect-ratio", "color", "color-gamut", "color-index", "grid", "height", "hover", "monochrome", "orientation", "overflow-block", "overflow-inline", "pointer", "resolution", "scan", "update", "width"};

    public static MediaQueryList createMediaList(String mediaQueryString) {
        if (MediaQueryFactory.isPlainMediaList(mediaQueryString)) {
            return OMMediaList.createMediaList(mediaQueryString);
        }
        return MediaQueryFactory.createMediaQueryList(mediaQueryString);
    }

    public static MediaQueryList createUnmodifiable(String media) {
        if (media == null) {
            return OMMediaList.createUnmodifiable();
        }
        if (MediaQueryFactory.isPlainMediaList(media)) {
            return OMMediaList.createUnmodifiable(media);
        }
        return ((MediaListAccess)((Object)MediaQueryFactory.createMediaQueryList(media))).unmodifiable();
    }

    public static MediaQueryList createMediaQueryList(String mediaQueryString) {
        MyMediaQueryList qlist = new MyMediaQueryList();
        qlist.parse(mediaQueryString);
        return qlist;
    }

    public static MediaQueryList createMediaList(SACMediaList media) {
        int sz = media.getLength();
        boolean plainMedium = true;
        for (int i = 0; i < sz; ++i) {
            if (OMMediaList.isPlainMedium(media.item(i))) continue;
            plainMedium = false;
            break;
        }
        if (plainMedium) {
            return OMMediaList.createMediaList(media);
        }
        MyMediaQueryList qlist = new MyMediaQueryList();
        for (int i = 0; i < sz; ++i) {
            qlist.parse(media.item(i));
        }
        return qlist;
    }

    static boolean isPlainMediaList(String newMedium) {
        StringTokenizer st = new StringTokenizer(newMedium, ",");
        while (st.hasMoreTokens()) {
            if (OMMediaList.isPlainMedium(st.nextToken().trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean isMediaFeature(String string) {
        return Arrays.binarySearch(mediaFeatures, string) >= 0;
    }

    static class MyMediaQueryList
    implements MediaQueryList,
    MediaListAccess {
        LinkedList<MediaQuery> queryList = new LinkedList();
        boolean invalidQueryList = false;

        @Override
        public String getMedia() {
            if (this.queryList.isEmpty()) {
                if (this.invalidQueryList) {
                    return "not all";
                }
                return "all";
            }
            StringBuilder buf = new StringBuilder();
            Iterator it = this.queryList.iterator();
            buf.append(((MediaQuery)it.next()).getMedia());
            while (it.hasNext()) {
                buf.append(',').append(((MediaQuery)it.next()).getMedia());
            }
            return buf.toString();
        }

        @Override
        public String getMediaText() {
            return this.getMedia();
        }

        @Override
        public void setMediaText(String mediaText) throws DOMException {
            this.queryList.clear();
            if (!this.parse(mediaText)) {
                throw new DOMException(12, "Bad media query: " + mediaText);
            }
        }

        @Override
        public int getLength() {
            int sz = this.queryList.size();
            if (sz == 0 && this.invalidQueryList) {
                return 1;
            }
            return sz;
        }

        @Override
        public String item(int index) {
            int sz = this.queryList.size();
            if (sz == 0 && this.invalidQueryList && index == 0) {
                return "not all";
            }
            if (index < 0 || index >= sz) {
                return null;
            }
            return this.queryList.get(index).getMedia();
        }

        @Override
        public MediaQueryList unmodifiable() {
            return new UnmodifiableMediaQueryList();
        }

        @Override
        public void appendMedium(String newMedium) throws DOMException {
            if (!this.parse(newMedium)) {
                throw new DOMException(12, "Bad media query: " + newMedium);
            }
        }

        @Override
        public void deleteMedium(String oldMedium) throws DOMException {
            throw new DOMException(9, "Delete operation not supported");
        }

        @Override
        public boolean matches(String medium, CSSCanvas canvas) {
            Iterator it = this.queryList.iterator();
            while (it.hasNext()) {
                if (!((MediaQuery)it.next()).matches(medium, canvas)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean match(SACMediaList sacMedia) {
            if (this.isAllMedia()) {
                return true;
            }
            if (sacMedia == null) {
                return !this.isNotAllMedia();
            }
            MyMediaQueryList otherqlist = (MyMediaQueryList)MediaQueryFactory.createMediaList(sacMedia);
            if (otherqlist.isAllMedia()) {
                return true;
            }
            int sz = otherqlist.queryList.size();
            for (int i = 0; i < sz; ++i) {
                if (!this.queryList.contains(otherqlist.queryList.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public void appendSACMediaList(SACMediaList sacMedia) {
            int sz = sacMedia.getLength();
            for (int i = 0; i < sz; ++i) {
                this.parse(sacMedia.item(i));
            }
        }

        @Override
        public void addListener(MediaQueryListListener listener) throws DOMException {
            throw new DOMException(9, "You should use CSSCanvas for this");
        }

        @Override
        public void removeListener(MediaQueryListListener listener) throws DOMException {
            throw new DOMException(9, "You should use CSSCanvas for this");
        }

        @Override
        public boolean isAllMedia() {
            return this.queryList.isEmpty() && !this.invalidQueryList;
        }

        @Override
        public boolean isNotAllMedia() {
            return this.queryList.isEmpty();
        }

        @Override
        public boolean hasErrors() {
            return this.invalidQueryList;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.queryList != null) {
                for (MediaQuery mq : this.queryList) {
                    result = 31 * result + mq.hashCode();
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MyMediaQueryList)) {
                return false;
            }
            MyMediaQueryList other = (MyMediaQueryList)obj;
            return !(this.queryList == null ? other.queryList != null : !this.queryList.equals(other.queryList));
        }

        public String toString() {
            return this.getMedia();
        }

        boolean parse(String mediaQueryString) {
            this.invalidQueryList = false;
            MediaQueryParser.parse(mediaQueryString, new MyMediaQueryHandler());
            if (this.invalidQueryList && !this.queryList.isEmpty()) {
                this.invalidQueryList = false;
            }
            return !this.invalidQueryList;
        }

        public class MyMediaQueryHandler
        implements MediaQueryHandler {
            MediaQuery currentQuery = new MediaQuery();
            boolean invalidQuery = false;

            MyMediaQueryHandler() {
            }

            @Override
            public void mediaType(String mediaType) {
                this.currentQuery.setMediaType(mediaType);
            }

            @Override
            public void negativeQuery() {
                this.currentQuery.setNegative(true);
            }

            @Override
            public void onlyPrefix() {
                this.currentQuery.setOnlyPrefix(true);
            }

            @Override
            public void featureValue(String featureName, CSSValue value) {
                this.currentQuery.addFeature(featureName, (byte)0, value, null);
            }

            @Override
            public void featureRange(String featureName, byte rangeType, CSSValue minvalue, CSSValue maxvalue) {
                this.currentQuery.addFeature(featureName, rangeType, minvalue, maxvalue);
            }

            @Override
            public void endQuery() {
                if (!this.invalidQuery) {
                    MyMediaQueryList.this.queryList.add(this.currentQuery);
                }
                this.currentQuery = new MediaQuery();
                this.invalidQuery = false;
            }

            @Override
            public void invalidQuery(String message) {
                this.invalidQuery = true;
                MyMediaQueryList.this.invalidQueryList = true;
            }
        }

        private class UnmodifiableMediaQueryList
        implements MediaQueryList,
        MediaListAccess {
            UnmodifiableMediaQueryList() {
            }

            @Override
            public String getMedia() {
                return MyMediaQueryList.this.getMedia();
            }

            @Override
            public String getMediaText() {
                return this.getMedia();
            }

            @Override
            public int getLength() {
                return MyMediaQueryList.this.getLength();
            }

            @Override
            public String item(int index) {
                return MyMediaQueryList.this.item(index);
            }

            @Override
            public boolean isAllMedia() {
                return MyMediaQueryList.this.isAllMedia();
            }

            @Override
            public boolean isNotAllMedia() {
                return MyMediaQueryList.this.isNotAllMedia();
            }

            @Override
            public boolean match(SACMediaList sacMedia) {
                return MyMediaQueryList.this.match(sacMedia);
            }

            @Override
            public void appendSACMediaList(SACMediaList sacMedia) {
                throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
            }

            @Override
            public boolean matches(String medium, CSSCanvas canvas) {
                return MyMediaQueryList.this.matches(medium, canvas);
            }

            @Override
            public MediaQueryList unmodifiable() {
                return this;
            }

            @Override
            public boolean hasErrors() {
                return MyMediaQueryList.this.hasErrors();
            }

            @Override
            public void addListener(MediaQueryListListener listener) {
                MyMediaQueryList.this.addListener(listener);
            }

            @Override
            public void removeListener(MediaQueryListListener listener) {
                MyMediaQueryList.this.removeListener(listener);
            }

            @Override
            public void setMediaText(String mediaText) throws DOMException {
                throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
            }

            @Override
            public void appendMedium(String newMedium) throws DOMException {
                throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
            }

            @Override
            public void deleteMedium(String oldMedium) throws DOMException {
                throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
            }
        }
    }
}

