/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.w3c.CSSMarginRule;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.css.CSSPageRule;

class OMCSSPageRule
extends CSSStyleDeclarationRule
implements CSSPageRule {
    private String pageTypeSelector = null;
    LinkedList<CSSMarginRule> marginRules = null;

    public OMCSSPageRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("@page");
        if (this.pageTypeSelector != null) {
            buf.append(' ').append(this.pageTypeSelector);
        }
        if (this.getSelectorText().length() > 0) {
            buf.append(' ').append(this.getSelectorText());
        }
        buf.append(' ').append('{').append(this.getStyle().getCssText());
        if (this.marginRules != null) {
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                buf.append(((CSSMarginRule)it.next()).getCssText()).append('\n');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("@page");
        if (this.pageTypeSelector != null) {
            buf.append(' ').append(this.pageTypeSelector);
        }
        if (this.getSelectorText().length() > 0) {
            buf.append(' ').append(this.getSelectorText());
        }
        buf.append('{').append(((AbstractCSSStyleDeclaration)this.getStyle()).getMinifiedCssText());
        if (this.marginRules != null) {
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                buf.append(((AbstractCSSRule)it.next()).getMinifiedCssText()).append('\n');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public String getPageType() {
        return this.pageTypeSelector;
    }

    void setPageType(String pageTypeSelector) {
        this.pageTypeSelector = pageTypeSelector;
    }

    void addMarginRule(CSSMarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new LinkedList();
        }
        this.marginRules.add(marginRule);
    }

    public LinkedList<CSSMarginRule> getMarginRules() {
        return this.marginRules;
    }

    @Override
    public OMCSSPageRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        return new OMCSSPageRule(parentSheet, this.getOrigin());
    }
}

