/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.OMCSSGroupingRule;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.TokenProducer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public class OMCSSSupportsRule
extends OMCSSGroupingRule {
    private Condition condition = null;

    public OMCSSSupportsRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)12, origin);
    }

    public OMCSSSupportsRule(AbstractCSSStyleSheet parentSheet, OMCSSSupportsRule copyfrom) {
        super(parentSheet, copyfrom);
    }

    public String getConditionText() {
        return this.condition.toString();
    }

    public void setConditionText(String conditionText) {
        this.parseCondition(conditionText);
    }

    public Condition getCondition() {
        return this.condition;
    }

    private void parseCondition(String conditionText) {
        int[] allowInWords = new int[]{45, 46};
        MyTokenHandler handler = new MyTokenHandler();
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(conditionText);
        this.condition = handler.currentCond;
        while (this.condition.getParentCondition() != null) {
            this.condition = this.condition.getParentCondition();
        }
    }

    public boolean supports(CSSCanvas canvas) {
        return false;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
        sb.append("@supports ").append(this.getConditionText()).append(" {\n");
        Iterator it = this.getCssRules().iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getCssText()).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
        sb.append("@supports ").append(this.getConditionText()).append("{");
        Iterator it = this.getCssRules().iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OMCSSSupportsRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        return new OMCSSSupportsRule(parentSheet, this);
    }

    public class DeclarationCondition
    extends Condition {
        String propertyName;
        AbstractCSSValue value;

        public DeclarationCondition(String propertyName) {
            this.value = null;
            this.propertyName = propertyName;
        }

        @Override
        public void addCondition(Condition nestedCondition) {
        }

        @Override
        public Condition replaceLast(Condition newCondition) {
            return this;
        }

        public void setValue(AbstractCSSValue value) {
            this.value = value;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            return canvas.supports(this.propertyName, this.value);
        }

        @Override
        public short getType() {
            return 0;
        }

        public String toString() {
            return "(" + this.propertyName + ": " + this.value.getCssText() + ")";
        }
    }

    public class OrCondition
    extends Condition {
        LinkedList<Condition> nestedConditions;

        OrCondition() {
            this.nestedConditions = new LinkedList();
        }

        @Override
        public void addCondition(Condition condition) {
            condition.setParentCondition(this);
            this.nestedConditions.add(condition);
        }

        @Override
        public Condition replaceLast(Condition newCondition) {
            Condition last = this.nestedConditions.removeLast();
            last.setParentCondition(null);
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            Iterator it = this.nestedConditions.iterator();
            while (it.hasNext()) {
                if (!((Condition)it.next()).supports(canvas)) continue;
                return true;
            }
            return false;
        }

        @Override
        public short getType() {
            return 1;
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(" or ").append(((Condition)it.next()).toString());
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    public class AndCondition
    extends Condition {
        LinkedList<Condition> nestedConditions;

        AndCondition() {
            this.nestedConditions = new LinkedList();
        }

        @Override
        public void addCondition(Condition condition) {
            condition.setParentCondition(this);
            this.nestedConditions.add(condition);
        }

        @Override
        public Condition replaceLast(Condition newCondition) {
            Condition last = this.nestedConditions.removeLast();
            last.setParentCondition(null);
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            Iterator it = this.nestedConditions.iterator();
            while (it.hasNext()) {
                if (((Condition)it.next()).supports(canvas)) continue;
                return false;
            }
            return true;
        }

        @Override
        public short getType() {
            return 2;
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(" and ").append(it.next());
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    public class NotCondition
    extends Condition {
        Condition nestedCondition;

        NotCondition() {
        }

        @Override
        public void addCondition(Condition nestedCondition) {
            nestedCondition.setParentCondition(this);
            this.nestedCondition = nestedCondition;
        }

        @Override
        public Condition replaceLast(Condition newCondition) {
            Condition last = this.nestedCondition;
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            return !this.nestedCondition.supports(canvas);
        }

        @Override
        public short getType() {
            return 3;
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            buf.append("not ").append(this.nestedCondition.toString());
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    public abstract class Condition {
        public static final short NOT_CONDITION = 3;
        public static final short AND_CONDITION = 2;
        public static final short OR_CONDITION = 1;
        public static final short DECLARATION_CONDITION = 0;
        public Condition parent = null;

        public void setParentCondition(Condition parent) {
            this.parent = parent;
        }

        public Condition getParentCondition() {
            return this.parent;
        }

        public Condition getParent(int depth) {
            Condition cond;
            int totaldepth = 1;
            for (cond = this.getParentCondition(); cond != null; cond = cond.getParentCondition()) {
                ++totaldepth;
            }
            cond = this;
            for (int i = 0; i < totaldepth - depth; ++i) {
                cond = cond.getParentCondition();
            }
            return cond;
        }

        public abstract short getType();

        public abstract void addCondition(Condition var1);

        public abstract Condition replaceLast(Condition var1);

        public abstract boolean supports(CSSCanvas var1);
    }

    class MyTokenHandler
    implements TokenProducer.TokenHandler {
        Condition currentCond = null;
        StringBuilder buffer = new StringBuilder(64);
        int prevcp = 0;
        short parendepth = 0;
        boolean readingValue = false;

        MyTokenHandler() {
        }

        @Override
        public void word(int index, String word) {
            String lctoken = word.toLowerCase(Locale.US);
            if ("not".equals(lctoken)) {
                NotCondition newCond = new NotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.currentCond = newCond;
            } else if ("and".equals(lctoken)) {
                if (this.currentCond != null) {
                    if (this.currentCond.getType() != 2 || this.currentCond.getType() == 0) {
                        AndCondition newCond = new AndCondition();
                        if (this.parendepth == 0) {
                            newCond.addCondition(this.currentCond);
                        } else if (this.parendepth >= 1) {
                            Condition cond = this.currentCond.getParent(this.parendepth);
                            Condition oldCond = cond.replaceLast(newCond);
                            newCond.addCondition(oldCond);
                        } else {
                            newCond.addCondition(this.currentCond);
                        }
                        this.currentCond = newCond;
                    }
                } else {
                    this.currentCond = new AndCondition();
                }
            } else if ("or".equals(lctoken)) {
                if (this.currentCond != null) {
                    if (this.currentCond.getType() != 1 || this.currentCond.getType() == 0) {
                        OrCondition newCond = new OrCondition();
                        if (this.parendepth == 0) {
                            newCond.addCondition(this.currentCond);
                        } else if (this.parendepth >= 1) {
                            Condition cond = this.currentCond.getParent(this.parendepth);
                            Condition oldCond = cond.replaceLast(newCond);
                            newCond.addCondition(oldCond);
                        } else {
                            newCond.addCondition(this.currentCond);
                        }
                        this.currentCond = newCond;
                    }
                } else {
                    this.currentCond = new OrCondition();
                }
            } else {
                if (this.prevcp == 58) {
                    this.readingValue = true;
                }
                if (this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                this.buffer.append(word);
            }
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                this.parendepth = (short)(this.parendepth + 1);
            }
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.parendepth = (short)(this.parendepth - 1);
                if (this.buffer.length() != 0) {
                    if (this.readingValue) {
                        ValueFactory factory = new ValueFactory();
                        AbstractCSSValue value = factory.parseProperty(this.buffer.toString());
                        ((DeclarationCondition)this.currentCond).setValue(value);
                        this.readingValue = false;
                    } else {
                        this.error(index, (byte)4, this.buffer.toString());
                    }
                    this.buffer.setLength(0);
                }
                if (this.currentCond != null && this.currentCond.getParentCondition() != null) {
                    this.currentCond = this.currentCond.getParentCondition();
                }
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (codepoint == 58) {
                DeclarationCondition newCond = new DeclarationCondition(this.buffer.toString());
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.currentCond = newCond;
                this.buffer.setLength(0);
            } else if (codepoint == 33) {
                this.buffer.append('!');
            } else if (codepoint == 59) {
                this.error(index, (byte)4, ";");
            } else {
                this.buffer.append(Character.toChars(codepoint));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\'').append(quoted).append('\'');
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.buffer.length() != 0) {
                this.buffer.append(' ');
            }
            this.buffer.append('\"').append(quoted).append('\"');
        }

        @Override
        public void escaped(int index, int codepoint) {
            this.buffer.append('\\').append(Character.toChars(codepoint));
        }

        @Override
        public void separator(int index, int cp) {
        }

        @Override
        public void control(int index, int codepoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            OMCSSSupportsRule.this.getParentStyleSheet().getErrorHandler().ruleParsingError(OMCSSSupportsRule.this, 0, "Error near: " + context);
        }
    }
}

