/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.TokenProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class CSSParser
implements Parser {
    DocumentHandler handler = null;
    ErrorHandler errorHandler = null;

    public void setLocale(Locale locale) throws CSSException {
        if (!Locale.US.equals(locale)) {
            throw new CSSException("Locale not supported");
        }
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void parseStyleSheet(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        SheetTokenHandler handler = new SheetTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        Reader re = source.getCharacterStream();
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        this.handler.startDocument(source);
        tp.parse(re);
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        PushbackReader re;
        int iread;
        int idx;
        URL url = new URL(uri);
        URLConnection ucon = url.openConnection();
        ucon.connect();
        InputStream is = ucon.getInputStream();
        String charset = null;
        String conType = ucon.getContentType();
        if (conType == null) {
            try {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8).replace('\"', ' ').replace('\'', ' ').trim().toUpperCase(Locale.US);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "UTF-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "UTF-8";
        } else {
            re.unread(iread);
        }
        InputSource source = new InputSource((Reader)re);
        source.setURI(uri);
        SheetTokenHandler handler = new SheetTokenHandler(source);
        int[] allowInWords = new int[]{45, 95};
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        this.handler.startDocument(source);
        tp.parse(re);
        re.close();
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler handler = new DeclarationTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream());
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        Reader re = source.getCharacterStream();
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        tp.parse(re);
    }

    public String getParserVersion() {
        return "0";
    }

    public SelectorList parseSelectors(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream());
        return handler.getSelectorList();
    }

    public SelectorList parseSelectors(String seltext) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(null);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(seltext);
        return handler.getSelectorList();
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler(source);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(source.getCharacterStream());
        return handler.getLexicalUnit();
    }

    public boolean parsePriority(InputSource source) throws CSSException, IOException {
        Reader re = source.getCharacterStream();
        int cp = re.read();
        if (cp != -1) {
            int count = 0;
            StringBuilder buf = new StringBuilder(9);
            int parsingWord = 0;
            if (CSSParser.isNotSeparator(cp)) {
                buf.append(Character.toChars(cp));
                parsingWord = 1;
                count = 1;
            }
            while ((cp = re.read()) != -1 && parsingWord != 2) {
                if (CSSParser.isNotSeparator(cp)) {
                    buf.append(Character.toChars(cp));
                    count = (short)(count + 1);
                    if (count == 10) {
                        return false;
                    }
                    parsingWord = 1;
                    continue;
                }
                if (parsingWord != 1) continue;
                parsingWord = 2;
            }
            if ("important".equals(buf.toString().toLowerCase(Locale.US))) {
                return true;
            }
        }
        return false;
    }

    static boolean bufferEndsWithEscapedChar(StringBuilder buffer) {
        int len = buffer.length();
        int bufCp = buffer.codePointAt(len - 1);
        if (CSSParser.isHexCodePoint(bufCp)) {
            for (int i = 2; i <= 6; ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (CSSParser.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean isHexCodePoint(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 70 || codePoint >= 97 && codePoint <= 102;
    }

    private static boolean isNotSeparator(int cp) {
        return cp != 32 && cp != 9 && cp != 10 && cp != 12 && cp != 13;
    }

    static SACMediaList parseMediaList(String media) {
        return new MySACMediaList(media.split(","));
    }

    static class MyAnBExpression
    extends AnBExpression {
        MyAnBExpression() {
        }

        @Override
        protected SelectorList parseSelector(String selText) {
            CSSParser parser = new CSSParser();
            return parser.parseSelectors(selText);
        }
    }

    static class LocatorImpl
    implements Locator {
        int line;
        int column;
        String uri;

        LocatorImpl(int line, int column, String uri) {
            this.line = line;
            this.column = column;
            this.uri = uri;
        }

        public String getURI() {
            return this.uri;
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    abstract class CSSTokenHandler
    implements TokenProducer.TokenHandler {
        int line = 1;
        int prevlinelength = 0;
        int prevcp = 32;
        int endcp = -1;
        short parendepth = 0;
        boolean parseError = false;
        private InputSource source;

        CSSTokenHandler(InputSource source) {
            this.source = source;
        }

        @Override
        public void control(int index, int codepoint) {
            if (codepoint == 10) {
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                }
            } else if (codepoint == 12) {
                ++this.line;
                this.prevlinelength = index;
                codepoint = 10;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
            }
            this.prevcp = codepoint;
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            CSSParser.this.handler.comment(comment);
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            this.handleError(index, errCode, "Syntax error near " + context);
        }

        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                if (CSSParser.this.errorHandler != null) {
                    if (this.prevcp == this.endcp) {
                        CSSParser.this.errorHandler.fatalError(this.createException("Expected end of file", index));
                    } else {
                        CSSParser.this.errorHandler.error(this.createException(message, index));
                    }
                }
                this.parseError = true;
            }
        }

        protected void unexpectedCharError(int index, int codepoint) {
            this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'");
        }

        protected String getSourceURI() {
            if (this.source != null) {
                return this.source.getURI();
            }
            return null;
        }

        CSSParseException createException(String message, int index) {
            return new CSSParseException(message, (Locator)new LocatorImpl(this.line, index - this.prevlinelength, this.getSourceURI()));
        }

        void endDocument() {
            if (CSSParser.this.handler != null) {
                CSSParser.this.handler.endDocument(this.source);
            }
        }
    }

    class DeclarationTokenHandler
    extends CSSTokenHandler {
        private LexicalUnitImpl lunit;
        private LexicalUnitImpl currentlu;
        StringBuilder buffer;
        private boolean escapedToken;
        String propertyName;
        private boolean hexColor;
        private boolean readPriority;
        boolean priorityImportant;
        private int curlyBracketDepth;
        private int squareBracketDepth;
        boolean functionToken;

        DeclarationTokenHandler(InputSource source) {
            super(source);
            this.lunit = null;
            this.currentlu = null;
            this.buffer = new StringBuilder(128);
            this.escapedToken = false;
            this.propertyName = null;
            this.hexColor = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.curlyBracketDepth = 1;
            this.functionToken = false;
        }

        LexicalUnit getLexicalUnit() {
            return this.parseError ? null : this.lunit;
        }

        @Override
        public void word(int index, String word) {
            if (!this.parseError) {
                String lctoken = word.toLowerCase(Locale.US);
                if ("inherit".equals(lctoken)) {
                    LexicalUnitImpl lu = this.newLexicalUnit((short)12);
                    lu.value = "inherit";
                } else if (this.readPriority && "important".equals(lctoken)) {
                    this.priorityImportant = true;
                } else {
                    this.buffer.append(word);
                }
            }
            this.prevcp = 65;
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                this.parendepth = (short)(this.parendepth + 1);
                if (!this.parseError) {
                    if (this.prevcp != 65) {
                        if (!this.functionToken) {
                            this.unexpectedCharError(index, codepoint);
                            this.prevcp = codepoint;
                        } else if (this.buffer.length() == 0) {
                            this.newLexicalUnit((short)40);
                        } else {
                            this.handleError(index, (byte)9, "Unexpected token: " + this.buffer.toString());
                            this.buffer.setLength(0);
                        }
                    } else {
                        String name = this.unescapeBuffer();
                        LexicalUnitImpl lu = "url".equals(name) ? this.newLexicalUnit((short)24) : ("rgb".equals(name) ? this.newLexicalUnit((short)27) : ("attr".equals(name) ? this.newLexicalUnit((short)37) : ("rect".equals(name) ? this.newLexicalUnit((short)38) : ("counter".equals(name) ? this.newLexicalUnit((short)25) : ("counters".equals(name) ? this.newLexicalUnit((short)26) : this.newLexicalUnit((short)41))))));
                        lu.value = name;
                        this.functionToken = true;
                    }
                }
            } else if (codepoint == 123) {
                ++this.curlyBracketDepth;
                this.unexpectedCharError(index, codepoint);
            } else if (codepoint == 91) {
                ++this.squareBracketDepth;
                this.unexpectedCharError(index, codepoint);
            }
            this.prevcp = codepoint;
        }

        private LexicalUnitImpl newLexicalUnit(short unitType) {
            LexicalUnitImpl lu;
            if (this.functionToken) {
                if (this.currentlu.getLexicalUnitType() == 24) {
                    lu = this.currentlu;
                } else {
                    lu = new LexicalUnitImpl(unitType);
                    this.currentlu.addFunctionParameter(lu);
                    if (ParseHelper.isFunctionUnitType(unitType) || unitType == 40) {
                        this.currentlu = lu;
                    }
                }
            } else {
                lu = new LexicalUnitImpl(unitType);
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lu;
                }
                this.currentlu = lu;
                if (this.lunit == null) {
                    this.lunit = lu;
                }
            }
            return lu;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.processBuffer(index);
                this.parendepth = (short)(this.parendepth - 1);
                if (this.functionToken) {
                    if (this.currentlu.ownerLexicalUnit != null) {
                        this.currentlu = this.currentlu.ownerLexicalUnit;
                    } else {
                        this.functionToken = false;
                    }
                }
            } else if (codepoint == 125) {
                --this.curlyBracketDepth;
                if (this.parendepth == 0 && this.squareBracketDepth == 0) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfPropertyDeclaration(index);
                        this.handleRightCurlyBracket(index);
                    } else if (this.curlyBracketDepth == 1) {
                        this.buffer.setLength(0);
                        this.parseError = false;
                    } else {
                        this.parseError = true;
                    }
                }
            } else if (codepoint == 93) {
                --this.squareBracketDepth;
                this.unexpectedCharError(index, codepoint);
            }
            this.prevcp = codepoint;
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.functionToken && this.currentlu != null && this.currentlu.getLexicalUnitType() == 24) {
                this.buffer.append(Character.toChars(codepoint));
            } else if (codepoint == 59) {
                this.handleSemicolon(index);
            } else if (!this.parseError) {
                if (codepoint == 58) {
                    this.handleColon(index);
                } else if (codepoint == 64) {
                    this.handleAtKeyword(index);
                } else if (codepoint == 45) {
                    if (this.functionToken) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)2);
                    } else {
                        this.buffer.append('-');
                        codepoint = 65;
                    }
                } else if (codepoint == 95) {
                    this.buffer.append('_');
                    codepoint = 65;
                } else {
                    if (this.propertyName == null) {
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if (codepoint == 44) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)0);
                    } else if (codepoint == 46) {
                        this.handleFullStop(index);
                    } else if (codepoint == 37) {
                        if (this.prevcp == 65 && Character.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                            this.buffer.append('%');
                        } else {
                            this.processBuffer(index);
                            this.newLexicalUnit((short)5);
                        }
                    } else if (codepoint == 35) {
                        if (this.buffer.length() != 0) {
                            if (this.functionToken) {
                                this.buffer.append(Character.toChars(codepoint));
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else {
                            this.hexColor = true;
                        }
                    } else if (codepoint == 33) {
                        this.processBuffer(index);
                        this.readPriority = true;
                    } else if (codepoint == 43) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)1);
                    } else if (codepoint == 42) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)3);
                    } else if (codepoint == 47) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)4);
                    } else if (codepoint == 94) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)6);
                    } else if (codepoint == 126) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)11);
                    } else if (codepoint == 60) {
                        this.handleLessThanSign(index);
                    } else if (codepoint == 61) {
                        this.handleEqualsSign(index);
                    } else if (codepoint == 62) {
                        this.handleGreaterThanSign(index);
                    } else {
                        this.processBuffer(index);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleLessThanSign(int index) {
            this.newLexicalUnit((short)7);
        }

        protected void handleEqualsSign(int index) {
            if (this.prevcp == 60) {
                this.currentlu.setUnitType((short)9);
            } else if (this.prevcp == 62) {
                this.currentlu.setUnitType((short)10);
            } else if (this.prevcp == 65 || this.prevcp == 32) {
                this.buffer.append('=');
            } else {
                this.handleError(index, (byte)4, "Unexpected '='");
            }
        }

        protected void handleGreaterThanSign(int index) {
            this.newLexicalUnit((short)8);
        }

        protected void handleFullStop(int index) {
            this.buffer.append('.');
        }

        protected void handleColon(int index) {
            if (this.buffer.length() != 0) {
                if (this.propertyName == null) {
                    this.propertyName = this.unescapeBuffer();
                } else if (!"progid".equals(this.buffer.toString())) {
                    this.handleError(index, (byte)4, "Unexpected ':'");
                } else {
                    this.buffer.append(':');
                }
            } else if (this.propertyName == null) {
                this.handleError(index, (byte)4, "Unexpected ':'");
            }
        }

        protected void handleAtKeyword(int index) {
            if (this.propertyName == null) {
                this.unexpectedCharError(index, 64);
            } else {
                this.buffer.append('@');
            }
        }

        protected void handleSemicolon(int index) {
            if (this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                this.endOfPropertyDeclaration(index);
            } else {
                this.handleError(index, (byte)4, "Unexpected ';'");
            }
        }

        protected void endOfPropertyDeclaration(int index) {
            if (this.propertyName != null) {
                this.processBuffer(index);
                if (this.lunit != null) {
                    CSSParser.this.handler.property(this.propertyName, (LexicalUnit)this.lunit, this.priorityImportant);
                } else {
                    this.handleError(index, (byte)32, "Found property name but no value");
                }
                this.propertyName = null;
            }
            this.lunit = null;
            this.currentlu = null;
            this.priorityImportant = false;
            this.prevcp = 32;
            this.readPriority = false;
            this.functionToken = false;
            this.hexColor = false;
            this.parseError = false;
            this.parendepth = 0;
            this.buffer.setLength(0);
        }

        private String rawBuffer() {
            this.escapedToken = false;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        private String unescapeBuffer() {
            String s = ParseHelper.unescapeStringValue(this.buffer.toString());
            this.buffer.setLength(0);
            this.escapedToken = false;
            return s;
        }

        protected void processBuffer(int index) {
            if (this.parseError) {
                this.buffer.setLength(0);
                return;
            }
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.hexColor) {
                    if (!this.parseHexColor(buflen)) {
                        this.handleError(index - buflen, (byte)5, "Wrong color value " + this.buffer);
                    }
                    this.buffer.setLength(0);
                    this.hexColor = false;
                } else if (this.readPriority && "important".equals(this.buffer.toString())) {
                    this.priorityImportant = true;
                    this.buffer.setLength(0);
                } else if (this.propertyName == null) {
                    this.propertyName = this.unescapeBuffer();
                } else if (this.currentlu != null && this.functionToken && this.currentlu.getLexicalUnitType() == 24) {
                    this.currentlu.value = this.rawBuffer();
                } else {
                    int i;
                    String s = this.unescapeBuffer();
                    int len = s.length();
                    for (i = len - 1; i >= 0; --i) {
                        int cp = s.codePointAt(i);
                        if (Character.isLetter(cp) || cp == 37) continue;
                        if (cp >= 48 && cp <= 57 && this.parseNumber(index, s, i + 1)) break;
                        this.newLexicalUnit((short)35).value = s;
                        break;
                    }
                    if (i == -1) {
                        String lcs = s.toLowerCase(Locale.US);
                        if (lcs.equals("inherit")) {
                            this.newLexicalUnit((short)12).value = "inherit";
                        } else {
                            this.newLexicalUnit((short)35).value = lcs.equals("initial") || lcs.equals("unset") ? lcs : s;
                        }
                    }
                }
            }
        }

        private boolean parseNumber(int index, String s, int i) {
            String strnum;
            short unitType;
            String unit = null;
            if (i != s.length()) {
                unit = s.substring(i);
                unit = unit.trim().toLowerCase(Locale.US).intern();
                unitType = ParseHelper.unitFromString(unit);
                strnum = s.substring(0, i);
            } else {
                unitType = s.lastIndexOf(46, i) == -1 ? (short)13 : 14;
                strnum = s;
            }
            if (unitType == 13) {
                try {
                    int intval = Integer.parseInt(strnum);
                    LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                    lu.intValue = intval;
                }
                catch (NumberFormatException e) {
                    if (this.functionToken) {
                        return false;
                    }
                    this.newLexicalUnit((short)35).value = s;
                }
            } else {
                try {
                    float flval = Float.parseFloat(strnum);
                    if (unitType == 14 && flval == 0.0f) {
                        LexicalUnitImpl lu = this.newLexicalUnit((short)13);
                        lu.intValue = (int)flval;
                    } else {
                        LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                        lu.floatValue = flval;
                        if (unit != null) {
                            lu.dimensionUnitText = unit;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (this.functionToken) {
                        return false;
                    }
                    this.newLexicalUnit((short)35).value = s;
                }
            }
            return true;
        }

        private boolean parseHexColor(int buflen) {
            block10: {
                try {
                    if (buflen == 3) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(1, 2, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 3, true);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 6) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 4, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(4, 6, false);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 8) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgba";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 4, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(4, 6, false);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(6, 8, false);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    if (buflen == 4) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgba";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(1, 2, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(2, 3, true);
                        this.newLexicalUnit((short)0);
                        this.parseHexComponent(3, 4, true);
                        if (this.currentlu.ownerLexicalUnit != null) {
                            this.currentlu = this.currentlu.ownerLexicalUnit;
                        }
                        this.functionToken = prevft;
                        break block10;
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        private void parseHexComponent(int start, int end, boolean doubleDigit) {
            int comp;
            String s;
            if (doubleDigit) {
                CharSequence seq = this.buffer.subSequence(start, end);
                s = new StringBuilder(2).append(seq).append(seq).toString();
            } else {
                s = this.buffer.substring(start, end);
            }
            this.newLexicalUnit((short)13).intValue = comp = Integer.parseInt(s, 16);
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            this.processBuffer(index);
            this.newLexicalUnit((short)36).value = ParseHelper.unescapeStringValue(quoted);
            this.prevcp = 65;
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            this.processBuffer(index);
            this.newLexicalUnit((short)36).value = ParseHelper.unescapeStringValue(quoted);
            this.prevcp = 65;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (!this.parseError) {
                if (codepoint >= 48 && codepoint <= 57 || codepoint >= 65 && codepoint <= 70 || codepoint >= 97 && codepoint <= 102) {
                    this.escapedToken = true;
                    this.buffer.append('\\');
                }
                this.buffer.append(Character.toChars(codepoint));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.escapedToken && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                return;
            }
            if (!this.parseError && this.buffer.length() != 0) {
                this.processBuffer(index);
            }
            this.prevcp = 32;
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.propertyName != null) {
                this.processBuffer(len);
                this.endOfPropertyDeclaration(len);
            } else if (this.buffer.length() != 0) {
                this.handleError(len, (byte)9, "Unexpected token: " + this.buffer);
            }
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.lunit = null;
        }
    }

    class PropertyTokenHandler
    extends DeclarationTokenHandler {
        PropertyTokenHandler(InputSource source) {
            super(source);
            this.propertyName = "";
        }

        @Override
        protected void handleFullStop(int index) {
            if (this.prevcp == 65) {
                this.buffer.append('.');
            } else if (this.buffer.length() == 0) {
                this.buffer.append('0').append('.');
            } else {
                this.handleError(index, (byte)4, "Unexpected '.'");
            }
        }

        @Override
        protected void handleAtKeyword(int index) {
            throw this.createException("Unexpected '@'", index);
        }

        @Override
        protected void handleSemicolon(int index) {
            this.handleError(index, (byte)4, "Unexpected ';'");
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.buffer.length() != 0) {
                this.processBuffer(len);
            } else if (this.getLexicalUnit() == null) {
                this.handleError(len, (byte)32, "No value found");
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException("Expected end of file, found " + new String(Character.toChars(this.prevcp)), index);
            }
            throw this.createException(message, index);
        }
    }

    static class SelectorListImpl
    extends LinkedList<Selector>
    implements SelectorList {
        private static final long serialVersionUID = 1L;

        SelectorListImpl() {
        }

        @Override
        public boolean add(Selector sel) {
            if (!this.contains(sel)) {
                return super.add(sel);
            }
            return false;
        }

        @Override
        public void addLast(Selector sel) {
            if (!this.contains(sel)) {
                super.addLast(sel);
            }
        }

        public int getLength() {
            return this.size();
        }

        public Selector item(int index) {
            if (index < 0 || index >= this.size()) {
                return null;
            }
            return (Selector)this.get(index);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            Iterator it = this.iterator();
            buf.append(((Selector)it.next()).toString());
            while (it.hasNext()) {
                buf.append(',').append(((Selector)it.next()).toString());
            }
            return buf.toString();
        }
    }

    class SelectorTokenHandler
    extends CSSTokenHandler {
        NSACSelectorFactory factory;
        SelectorListImpl selist;
        Selector currentsel;
        StringBuilder buffer;
        private boolean escapedToken;
        byte stage;
        private boolean functionToken;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_ARGUMENT = 11;

        SelectorTokenHandler(InputSource source) {
            super(source);
            this.factory = new NSACSelectorFactory();
            this.selist = new SelectorListImpl();
            this.currentsel = null;
            this.buffer = new StringBuilder();
            this.escapedToken = false;
            this.stage = 0;
        }

        SelectorList getSelectorList() {
            return this.selist;
        }

        @Override
        public void word(int index, String word) {
            if (this.buffer.length() != 0 && this.prevcp == 32) {
                this.buffer.append(' ');
            }
            this.buffer.append(word);
            if (this.stage == 0) {
                this.stage = 1;
            } else if (this.stage == 2) {
                this.newDescendantSelector((short)10);
                this.stage = 1;
            } else if (this.stage == 6 && this.prevcp == 32) {
                if ("i".equals(word)) {
                    this.setCaseInsensitiveCondition();
                    this.buffer.setLength(0);
                } else {
                    this.handleError(index, (byte)9, "Expected 'i', found: <" + word + ">");
                }
            } else if (this.stage == 7) {
                this.handleError(index, (byte)9, "Unexpected token: <" + word + ">");
            }
            this.prevcp = 65;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.escapedToken && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                return;
            }
            if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer());
                    this.stage = (byte)6;
                }
            } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                this.processBuffer(index, false);
                if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93) {
                    this.stage = (byte)2;
                }
            } else if (this.stage == 4) {
                this.stage = (byte)7;
                return;
            }
            if (this.prevcp != 44) {
                this.prevcp = 32;
            }
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            this.quotedString(index, quoted, false);
        }

        private void quotedString(int index, String quoted, boolean doubleQuoted) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.prevcp == 32 && this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                if (doubleQuoted) {
                    this.buffer.append('\"').append(quoted).append('\"');
                } else {
                    this.buffer.append('\'').append(quoted).append('\'');
                }
            } else {
                this.handleError(index, (byte)9, "Unexpected: " + quoted);
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int index, String value) {
            NSACSelectorFactory.AttributeConditionImpl attrcond;
            SimpleSelector simple;
            Condition cond = null;
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.ConditionalSelectorImpl) {
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).condition;
            }
            if (cond instanceof NSACSelectorFactory.CombinatorConditionImpl) {
                cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
            }
            if (cond instanceof NSACSelectorFactory.AttributeConditionImpl && (attrcond = (NSACSelectorFactory.AttributeConditionImpl)cond) != null) {
                if (attrcond.value == null) {
                    attrcond.value = value;
                } else {
                    StringBuilder buf = new StringBuilder(attrcond.value.length() + value.length() + 1);
                    buf.append(attrcond.value);
                    if (this.prevcp == 32) {
                        buf.append(' ');
                    }
                    attrcond.value = buf.append(value).toString();
                }
                return;
            }
            this.handleError(index, (byte)9, "Unexpected token in selector: <" + value + ">");
        }

        private void setCaseInsensitiveCondition() {
            Selector simple;
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (simple == null) {
                    throw new IllegalStateException("Descendant selector has no simple selector");
                }
            } else {
                simple = this.currentsel;
            }
            ((NSACSelectorFactory.AttributeConditionImpl)((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition).caseSensitive = false;
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            this.quotedString(index, quoted, true);
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 123) {
                this.handleLeftCurlyBracket(index);
            } else {
                if (this.stage == 11) {
                    this.buffer.append(Character.toChars(codepoint));
                    this.prevcp = codepoint;
                    return;
                }
                if (codepoint == 40) {
                    if (this.prevcp != 65 || this.buffer.length() == 0) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        if (this.stage == 10) {
                            this.newConditionalSelector((short)10);
                            this.stage = (byte)11;
                        }
                        this.functionToken = true;
                    }
                    this.parendepth = (short)(this.parendepth + 1);
                } else if (codepoint == 91) {
                    if (this.prevcp != 65 && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 32 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        this.processBuffer(index, false);
                        this.stage = (byte)4;
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleLeftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.parendepth = (short)(this.parendepth - 1);
                if (this.stage == 11) {
                    Object sel = this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl ? ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector() : (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl ? ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector() : this.currentsel);
                    if (sel.getSelectorType() == 0) {
                        Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)sel).condition;
                        if (this.buffer.length() != 0) {
                            String arg;
                            while (cond.getConditionType() == 0) {
                                cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
                            }
                            if (cond.getConditionType() == 6) {
                                ((NSACSelectorFactory.LangConditionImpl)cond).lang = this.unescapeBuffer();
                            } else if (cond.getConditionType() == 10) {
                                ((NSACSelectorFactory.AttributeConditionImpl)cond).value = this.unescapeBuffer();
                            } else if (cond.getConditionType() == 17) {
                                CSSParser parser = new CSSParser();
                                try {
                                    ((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).arguments = parser.parseSelectors(new InputSource((Reader)new StringReader(this.rawBuffer())));
                                }
                                catch (CSSParseException e) {
                                    CSSParseException ex = this.createException(e.getMessage(), index);
                                    if (CSSParser.this.errorHandler != null) {
                                        CSSParser.this.errorHandler.error(ex);
                                        this.parseError = true;
                                        this.stage = (byte)127;
                                    }
                                    throw ex;
                                }
                                catch (IOException iOException) {}
                            } else if (cond.getConditionType() == 3 && ((NSACSelectorFactory.PositionalConditionImpl)cond).needsArgument && !this.parsePositionalArgument((NSACSelectorFactory.PositionalConditionImpl)cond, arg = this.rawBuffer())) {
                                this.handleError(index, (byte)32, "Wrong subexpression: " + arg);
                            }
                            this.buffer.setLength(0);
                        } else if (cond.getConditionType() == 6 || cond.getConditionType() == 17 || cond.getConditionType() == 3) {
                            this.unexpectedCharError(index, codepoint);
                        }
                        this.stage = 1;
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    this.processBuffer(index, false);
                }
                if (this.functionToken) {
                    this.functionToken = false;
                }
            } else if (codepoint == 125) {
                this.handleRightCurlyBracket(index);
            } else {
                if (this.stage == 11) {
                    this.buffer.append(Character.toChars(codepoint));
                    this.prevcp = codepoint;
                    return;
                }
                if (codepoint == 93) {
                    if (this.stage == 6) {
                        if (this.buffer.length() != 0) {
                            this.setAttributeSelectorValue(index, this.unescapeBuffer());
                        }
                        this.stage = 1;
                    } else if (this.stage == 4 || this.stage == 7) {
                        if (this.buffer.length() != 0) {
                            this.newConditionalSelector((short)4);
                            this.stage = 1;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected ']', expected attribute name");
                        }
                    } else if (this.stage == 5) {
                        if (this.buffer.length() != 0) {
                            this.setAttributeSelectorValue(index, this.unescapeBuffer());
                            this.stage = 1;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected ']', expected attribute value");
                        }
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private String rawBuffer() {
            this.escapedToken = false;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        private String unescapeBuffer() {
            String s = ParseHelper.unescapeStringValue(this.buffer.toString());
            this.buffer.setLength(0);
            this.escapedToken = false;
            return s;
        }

        private void processBuffer(int index, boolean lastStage) {
            if (this.prevcp == 42) {
                this.setSimpleSelector(index, (SimpleSelector)this.factory.getUniversalSelector());
            } else if (this.stage == 2) {
                if (!lastStage) {
                    this.newDescendantSelector((short)10);
                    if (this.buffer.length() != 0) {
                        NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                        sel.localName = this.unescapeBuffer();
                        this.stage = 1;
                    }
                }
            } else if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    sel.localName = this.unescapeBuffer();
                } else if (this.stage == 8) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer());
                    this.stage = 1;
                } else if (this.stage == 10) {
                    this.newConditionalSelector((short)10);
                    this.stage = 1;
                } else if (this.stage == 9) {
                    this.newConditionalSelector((short)18);
                    this.stage = 1;
                } else if (this.stage != 11) {
                    if (this.stage == 6) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer());
                    } else {
                        this.handleError(index, (byte)9, "Unexpected: <" + this.buffer + ">");
                        this.buffer.setLength(0);
                    }
                }
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (!this.parseError) {
                if (this.stage == 11) {
                    if (this.prevcp == 32) {
                        this.buffer.append(' ');
                    }
                    this.buffer.append(Character.toChars(codepoint));
                } else if (codepoint == 42) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 2) {
                        this.newDescendantSelector((short)10);
                        ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector();
                        this.stage = 1;
                    } else if (this.stage != 4 && this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 46) {
                    this.processBuffer(index, false);
                    this.newConditionalSelector((short)9);
                    this.stage = (byte)8;
                } else if (codepoint == 35) {
                    this.newConditionalSelector((short)5);
                    this.stage = (byte)8;
                } else if (codepoint == 58) {
                    if (this.prevcp == 58) {
                        this.stage = (byte)9;
                    } else {
                        this.processBuffer(index, false);
                        this.stage = (byte)10;
                    }
                } else if (codepoint == 62) {
                    if (this.prevcp != 62) {
                        if (this.stage == 2) {
                            this.stage = 1;
                        }
                        this.processBuffer(index, false);
                        this.newDescendantSelector((short)11);
                    } else {
                        ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).setSelectorType((short)10);
                    }
                } else if (codepoint == 43) {
                    if (this.stage == 2) {
                        this.stage = 1;
                    }
                    this.processBuffer(index, false);
                    this.newSiblingSelector((short)12);
                } else if (codepoint == 61) {
                    if ((this.stage == 4 || this.stage == 7) && this.buffer.length() != 0) {
                        if (this.prevcp == 124) {
                            this.newConditionalSelector((short)8);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 126) {
                            this.newConditionalSelector((short)7);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 36) {
                            this.newConditionalSelector((short)15);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 94) {
                            this.newConditionalSelector((short)14);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 42) {
                            this.newConditionalSelector((short)16);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 65) {
                            this.newConditionalSelector((short)4);
                            this.stage = (byte)5;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 126 && this.stage != 4 && this.stage != 7) {
                    if (this.stage == 2) {
                        this.stage = 1;
                    } else {
                        this.processBuffer(index, false);
                    }
                    this.newSiblingSelector((short)13);
                } else if (codepoint == 124) {
                    if (this.prevcp == 124 && this.stage == 1) {
                        this.processBuffer(index, false);
                        this.newDescendantSelector((short)14);
                    } else if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                        this.processBuffer(index, false);
                    } else if (this.stage == 2) {
                        this.stage = 1;
                    } else if (this.stage != 4 && this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 36 || codepoint == 94) {
                    if (this.stage != 4 && this.stage != 7) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 44) {
                    if (this.functionToken) {
                        if (this.prevcp == 44) {
                            this.unexpectedCharError(index, codepoint);
                        } else {
                            this.buffer.append(',');
                        }
                    } else {
                        this.processBuffer(index, true);
                        if (!this.parseError) {
                            if (this.addCurrentSelector()) {
                                this.stage = 0;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        }
                    }
                } else if (codepoint == 64) {
                    this.handleAtKeyword(index);
                } else if (codepoint == 45) {
                    this.buffer.append('-');
                } else if (codepoint == 95) {
                    this.buffer.append('_');
                } else if (codepoint != 126) {
                    this.unexpectedCharError(index, codepoint);
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        private void newConditionalSelector(short condtype) {
            Condition condition;
            String name = this.rawBuffer();
            String lcname = name.toLowerCase(Locale.US).intern();
            if (condtype == 10) {
                if ("lang".equals(lcname)) {
                    condition = this.factory.createCondition((short)6);
                } else if ("first-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                } else if ("nth-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("last-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-last-child".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("first-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                } else if ("last-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("nth-last-of-type".equals(lcname)) {
                    condition = this.factory.createCondition((short)3);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).needsArgument = true;
                } else if ("not".equals(lcname) || "matches".equals(lcname) || "has".equals(lcname)) {
                    condition = this.factory.createCondition((short)17);
                    ((NSACSelectorFactory.SelectorArgumentConditionImpl)condition).setName(lcname);
                } else {
                    if ("first-line".equals(lcname) || "first-letter".equals(lcname) || "before".equals(lcname) || "after".equals(lcname)) {
                        condtype = (short)18;
                    }
                    condition = this.factory.createCondition(condtype);
                }
            } else {
                condition = this.factory.createCondition(condtype);
            }
            if (name.length() != 0 && condition instanceof NSACSelectorFactory.AttributeConditionImpl) {
                switch (condition.getConditionType()) {
                    case 4: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).localName = ParseHelper.unescapeStringValue(name);
                        break;
                    }
                    default: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).value = lcname;
                    }
                }
            }
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector, condition);
                }
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector, condition);
                }
            } else if (this.currentsel != null && this.currentsel.getSelectorType() == 0) {
                NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                andcond.second = condition;
                this.currentsel = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getSimpleSelector(), (Condition)andcond);
            } else {
                this.currentsel = this.factory.createConditionalSelector((SimpleSelector)this.currentsel, condition);
            }
        }

        private boolean parsePositionalArgument(NSACSelectorFactory.PositionalConditionImpl cond, String expression) {
            MyAnBExpression expr = new MyAnBExpression();
            try {
                expr.parse(expression);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            cond.offset = expr.getOffset();
            cond.slope = expr.getStep();
            cond.ofList = expr.getSelectorList();
            return true;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int index) {
            NSACSelectorFactory.ElementSelectorImpl elemsel = this.factory.createElementSelector();
            this.setSimpleSelector(index, (SimpleSelector)elemsel);
            return elemsel;
        }

        private void setSimpleSelector(int index, SimpleSelector simple) {
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = simple;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = simple;
            } else if (this.currentsel != null) {
                this.handleError(index, (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simple.toString());
            } else {
                this.currentsel = simple;
            }
        }

        private void newDescendantSelector(short type) {
            this.currentsel = this.factory.createDescendantSelector(type, this.currentsel);
            this.stage = 0;
        }

        private void newSiblingSelector(short type) {
            this.currentsel = this.factory.createSiblingSelector(type, this.currentsel);
            this.stage = 0;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (codepoint >= 48 && codepoint <= 57 || codepoint >= 65 && codepoint <= 70 || codepoint >= 97 && codepoint <= 102) {
                this.escapedToken = true;
                this.buffer.append('\\');
            }
            this.buffer.append(Character.toChars(codepoint));
            if (this.stage == 0) {
                this.stage = 1;
            }
            this.prevcp = 65;
        }

        @Override
        public void endOfStream(int len) {
            this.processBuffer(len, true);
            if (!this.parseError && !this.addCurrentSelector()) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
            }
        }

        boolean addCurrentSelector() {
            if (this.currentsel == null) {
                return true;
            }
            if (this.isValidCurrentSelector()) {
                this.selist.add(this.currentsel);
                this.currentsel = null;
                return true;
            }
            this.selist.clear();
            this.currentsel = null;
            return false;
        }

        private boolean isValidCurrentSelector() {
            SimpleSelector last = null;
            switch (this.currentsel.getSelectorType()) {
                case 10: 
                case 11: 
                case 14: {
                    last = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                    break;
                }
                case 12: 
                case 13: {
                    last = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                    break;
                }
                case 0: {
                    Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                    short condtype = cond.getConditionType();
                    while (condtype == 0) {
                        if ((cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition()) == null) {
                            return false;
                        }
                        condtype = cond.getConditionType();
                    }
                    switch (condtype) {
                        case 4: 
                        case 10: 
                        case 18: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getLocalName() != null) break;
                            return false;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 15: 
                        case 16: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getValue() != null) break;
                            return false;
                        }
                        case 6: {
                            if (((NSACSelectorFactory.LangConditionImpl)cond).getLang() != null) break;
                            return false;
                        }
                        case 17: {
                            if (((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return last != null;
        }

        protected boolean isValidSelectorList() {
            return !this.selist.isEmpty() && this.currentsel == null;
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.selist.clear();
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException("Expected end of file, found " + new String(Character.toChars(this.prevcp)), index);
            }
            throw this.createException(message, index);
        }
    }

    class SheetTokenHandler
    extends CSSTokenHandler {
        TokenProducer.TokenHandler contextHandler;
        DeclarationTokenHandler declarationHandler;
        SelectorTokenHandler selectorHandler;
        private String ruleFirstPart;
        private String ruleSecondPart;
        private String marginRule;
        private StringBuilder buffer;
        private int curlyBracketDepth;
        private byte ruleType;
        private final byte MEDIA_RULE = 4;
        private final byte FONT_FACE_RULE = 5;
        private final byte PAGE_RULE = 6;
        private final byte MARGIN_RULE = 9;
        private byte stage;
        private SACMediaList medialist;

        SheetTokenHandler(InputSource source) {
            super(source);
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.marginRule = null;
            this.buffer = new StringBuilder(512);
            this.curlyBracketDepth = 0;
            this.ruleType = 0;
            this.MEDIA_RULE = (byte)4;
            this.FONT_FACE_RULE = (byte)5;
            this.PAGE_RULE = (byte)6;
            this.MARGIN_RULE = (byte)9;
            this.stage = 0;
            this.medialist = null;
            this.declarationHandler = this.createDeclarationTokenHandler(source);
            this.selectorHandler = new MySelectorTokenHandler(source);
            this.contextHandler = this.selectorHandler;
        }

        protected DeclarationTokenHandler createDeclarationTokenHandler(InputSource source) {
            return new MyDeclarationTokenHandler(source);
        }

        @Override
        public void word(int index, String word) {
            if (this.contextHandler != null) {
                this.contextHandler.word(index, word);
            } else {
                if (this.prevcp == 64) {
                    String ruleName = word.toLowerCase(Locale.US);
                    if (this.stage == 0) {
                        if ("charset".equals(ruleName)) {
                            this.stage = (byte)32;
                            if (index != 1) {
                                this.handleError(index, (byte)4, "@charset rules must be at the beginning of the sheet");
                            }
                            this.buffer.setLength(0);
                        } else if ("import".equals(ruleName)) {
                            this.stage = (byte)38;
                            this.buffer.setLength(0);
                        } else if ("namespace".equals(ruleName)) {
                            this.stage = (byte)34;
                            this.buffer.setLength(0);
                        } else if ("media".equals(ruleName)) {
                            this.ruleType = (byte)4;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if ("font-face".equals(ruleName)) {
                            this.ruleType = (byte)5;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if ("page".equals(ruleName)) {
                            this.ruleType = (byte)6;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else {
                            this.buffer.append(ruleName);
                            this.stage = (byte)5;
                        }
                    } else if (this.stage == 2 && this.ruleType == 6) {
                        if (this.isMarginRuleName(ruleName)) {
                            this.ruleType = (byte)9;
                            this.marginRule = ruleName;
                            CSSParser.this.handler.startPage(ruleName, null);
                        }
                    } else {
                        this.buffer.append(word);
                    }
                } else if (this.ruleType == 6 && this.buffer.length() != 1 && this.ruleFirstPart != null) {
                    this.handleError(index, (byte)9, "Expecting pseudo-page, got " + word);
                } else {
                    this.buffer.append(word);
                }
                this.prevcp = 65;
            }
        }

        boolean isMarginRuleName(String ruleName) {
            StringTokenizer st = new StringTokenizer(ruleName, "-");
            while (st.hasMoreElements()) {
                String s = st.nextToken();
                if ("top".equals(s) || "left".equals(s) || "center".equals(s) || "right".equals(s) || "corner".equals(s) || "bottom".equals(s) || "middle".equals(s)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.separator(index, codepoint);
            } else {
                if (this.stage == 34) {
                    if (this.ruleFirstPart == null) {
                        if (this.buffer.length() != 0) {
                            this.ruleFirstPart = this.buffer.toString();
                            this.buffer.setLength(0);
                            this.stage = (byte)35;
                        }
                    } else {
                        this.stage = (byte)35;
                    }
                } else {
                    if (this.stage == 2 && this.ruleType == 6) {
                        this.processBufferPageRule(index);
                        if (this.prevcp != 44) {
                            this.prevcp = 32;
                        }
                        return;
                    }
                    if (this.buffer.length() != 0 && this.prevcp != 32) {
                        this.buffer.append(' ');
                    }
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            if (this.contextHandler != null) {
                this.contextHandler.singleQuoted(index, quoted);
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted;
                    if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted;
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            if (this.contextHandler != null) {
                this.contextHandler.doubleQuoted(index, quoted);
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted;
                    if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted;
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.openGroup(index, codepoint);
            } else {
                if (codepoint == 123) {
                    ++this.curlyBracketDepth;
                    if (this.stage == 2) {
                        if (this.curlyBracketDepth == 1) {
                            if (this.ruleType == 4) {
                                if (this.parendepth == 0) {
                                    this.medialist = this.buffer.length() != 0 ? CSSParser.parseMediaList(this.buffer.toString()) : new MySACAllMediaList();
                                    CSSParser.this.handler.startMedia(this.medialist);
                                    this.contextHandler = this.selectorHandler;
                                    this.selectorHandler.prevcp = 32;
                                } else {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Bad media query at @media rule: <" + this.buffer.toString() + ">");
                                    this.ruleType = 0;
                                    this.stage = 0;
                                    this.curlyBracketDepth = 0;
                                    this.parendepth = 0;
                                    this.contextHandler = new IgnoredDeclarationTokenHandler();
                                }
                            } else if (this.ruleType == 5) {
                                if (this.buffer.length() != 0) {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in @font-face rule: " + this.buffer.toString());
                                } else {
                                    CSSParser.this.handler.startFontFace();
                                    this.declarationHandler.curlyBracketDepth = 1;
                                    this.contextHandler = this.declarationHandler;
                                    --this.curlyBracketDepth;
                                }
                            } else if (this.ruleType == 6) {
                                this.processBufferPageRule(index);
                                CSSParser.this.handler.startPage(this.ruleFirstPart, this.ruleSecondPart);
                                this.declarationHandler.curlyBracketDepth = 1;
                                this.contextHandler = this.declarationHandler;
                                --this.curlyBracketDepth;
                            } else if (this.ruleType == 9) {
                                if (this.buffer.length() != 0) {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in margin rule: " + this.buffer.toString());
                                } else {
                                    this.declarationHandler.curlyBracketDepth = 1;
                                    this.contextHandler = this.declarationHandler;
                                }
                                --this.curlyBracketDepth;
                            }
                            this.buffer.setLength(0);
                        }
                    } else {
                        this.buffer.append('{');
                    }
                } else if (codepoint == 40) {
                    this.parendepth = (short)(this.parendepth + 1);
                    if (this.stage == 35) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)36;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else if (this.stage == 38) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)39;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else {
                        this.buffer.append('(');
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.closeGroup(index, codepoint);
            } else {
                if (codepoint == 125) {
                    --this.curlyBracketDepth;
                    this.buffer.append('}');
                    if (this.curlyBracketDepth == 0) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.buffer.setLength(0);
                        this.stage = 0;
                        this.endRuleBody();
                    }
                } else if (codepoint == 41) {
                    this.parendepth = (short)(this.parendepth - 1);
                    if (this.stage == 36) {
                        this.processBuffer(index);
                        this.stage = (byte)37;
                    } else if (this.stage == 39) {
                        this.processBuffer(index);
                        this.stage = (byte)40;
                    } else {
                        this.buffer.append(')');
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        protected void endRuleBody() {
            this.contextHandler = this.selectorHandler;
            this.selectorHandler.prevcp = 32;
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.character(index, codepoint);
            } else {
                if (codepoint == 59) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfAtRule(index);
                    } else {
                        this.buffer.append(';');
                    }
                } else if (this.ruleType == 6) {
                    if (codepoint == 44) {
                        this.processBufferPageRule(index);
                    } else {
                        if (codepoint == 58 && (this.prevcp == 44 || this.prevcp == 32)) {
                            this.buffer.append(':');
                            return;
                        }
                        this.handleError(index, (byte)4, "Unexpected char " + new String(Character.toChars(codepoint)));
                    }
                } else {
                    this.buffer.append(Character.toChars(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        private void endOfAtRule(int index) {
            this.processBuffer(index);
            if (this.buffer.length() != 0) {
                this.handleError(index, (byte)9, "Malformed @-rule, unexpected <" + this.buffer.toString() + ">");
            }
            if (this.stage == 40 || this.stage == 38) {
                this.medialist = this.ruleSecondPart != null ? CSSParser.parseMediaList(this.ruleSecondPart) : null;
                if (this.ruleFirstPart != null) {
                    if (this.medialist == null) {
                        this.medialist = new MySACAllMediaList();
                    }
                    CSSParser.this.handler.importStyle(this.ruleFirstPart, this.medialist, null);
                } else if (!this.parseError) {
                    this.handleError(index, (byte)33, "Malformed @-rule");
                }
            } else if (this.stage == 35 || this.stage == 37) {
                CSSParser.this.handler.namespaceDeclaration(this.ruleFirstPart, this.ruleSecondPart);
            } else if (this.stage == 34) {
                CSSParser.this.handler.namespaceDeclaration("", this.ruleSecondPart);
            } else if (this.stage == 36) {
                this.handleError(index, (byte)33, "Bad URI in namespace rule");
            }
            this.resetRuleState();
        }

        protected void resetRuleState() {
            this.parseError = false;
            this.stage = 0;
            this.medialist = null;
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.prevcp = 32;
            this.buffer.setLength(0);
        }

        private void processBufferPageRule(int index) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.buffer.charAt(0) == ':') {
                    if (buflen == 1) {
                        this.handleError(index - buflen, (byte)4, "Character ':' must always precede an identifier in page rule preludes");
                    } else {
                        this.ruleSecondPart = this.ruleSecondPart == null ? this.buffer.toString() : new StringBuilder(this.ruleSecondPart.length() + buflen).append(this.ruleSecondPart).append(',').append((CharSequence)this.buffer).toString();
                    }
                } else if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                } else {
                    this.handleError(index - buflen, (byte)9, "Unexpected identifier at page rule: " + this.buffer.toString());
                }
                this.buffer.setLength(0);
            }
        }

        private void processBuffer(int index) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
        }

        private void trimBufferTail() {
            if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }

        private boolean bufferEquals(String word) {
            if (word.equals(this.buffer.toString().toLowerCase(Locale.US))) {
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.escaped(index, codepoint);
            } else {
                this.buffer.append(Character.toChars(codepoint));
            }
            this.prevcp = 65;
        }

        @Override
        public void endOfStream(int len) {
            if (this.contextHandler != null) {
                this.contextHandler.endOfStream(len);
            } else {
                if (this.ruleType == 9) {
                    CSSParser.this.handler.endPage(this.marginRule, null);
                    this.ruleType = (byte)6;
                }
                if (this.ruleType == 6) {
                    this.processBufferPageRule(len);
                    CSSParser.this.handler.endPage(this.ruleFirstPart, this.ruleSecondPart);
                } else if (this.stage != 0) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfAtRule(len);
                    } else if (this.buffer.length() != 0) {
                        do {
                            --this.curlyBracketDepth;
                            this.buffer.append('}');
                        } while (this.curlyBracketDepth != 0);
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.handleError(len, (byte)10, "Unexpected end of stream");
                    }
                }
            }
            this.endDocument();
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            super.handleError(index, errCode, message);
            this.buffer.setLength(0);
            this.stage = (byte)127;
        }

        class IgnoredDeclarationTokenHandler
        extends CSSTokenHandler {
            private int curlyBracketDepth;

            IgnoredDeclarationTokenHandler() {
                super(null);
                this.curlyBracketDepth = 1;
            }

            @Override
            public void word(int index, String word) {
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void singleQuoted(int index, String quoted) {
            }

            @Override
            public void doubleQuoted(int index, String quoted) {
            }

            @Override
            public void openGroup(int index, int codePoint) {
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                }
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 0) {
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        SheetTokenHandler.this.selectorHandler.prevcp = 32;
                        SheetTokenHandler.this.selectorHandler.parseError = false;
                        SheetTokenHandler.this.selectorHandler.stage = 0;
                        SheetTokenHandler.this.prevcp = 125;
                    }
                }
            }

            @Override
            public void character(int index, int codePoint) {
            }

            @Override
            public void escaped(int index, int codePoint) {
            }

            @Override
            public void endOfStream(int len) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }
        }

        class MyDeclarationTokenHandler
        extends DeclarationTokenHandler {
            MyDeclarationTokenHandler(InputSource source) {
                super(source);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.selectorHandler.parseError = false;
                SheetTokenHandler.this.selectorHandler.prevcp = 32;
                SheetTokenHandler.this.selectorHandler.stage = 0;
                SheetTokenHandler.this.prevcp = 125;
                if (SheetTokenHandler.this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                } else if (SheetTokenHandler.this.ruleType == 6) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.ruleFirstPart, SheetTokenHandler.this.ruleSecondPart);
                    SheetTokenHandler.this.ruleFirstPart = null;
                    SheetTokenHandler.this.ruleSecondPart = null;
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                } else if (SheetTokenHandler.this.ruleType == 9) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.marginRule, null);
                    SheetTokenHandler.this.ruleType = (byte)6;
                    SheetTokenHandler.this.marginRule = null;
                    SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                    SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 1;
                } else {
                    CSSParser.this.handler.endSelector((SelectorList)SheetTokenHandler.this.selectorHandler.selist);
                }
            }

            @Override
            protected void handleAtKeyword(int index) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.prevcp = 64;
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(String message, int index) {
                return SheetTokenHandler.this.createException(message, index);
            }
        }

        private class MySelectorTokenHandler
        extends SelectorTokenHandler {
            MySelectorTokenHandler(InputSource source) {
                super(source);
            }

            @Override
            protected void handleLeftCurlyBracket(int index) {
                SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 1;
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                SheetTokenHandler.this.selectorHandler.processBuffer(index, true);
                if (!this.parseError) {
                    this.addCurrentSelector();
                    if (this.isValidSelectorList()) {
                        CSSParser.this.handler.startSelector((SelectorList)this.selist);
                        this.selist = new SelectorListImpl();
                    } else {
                        this.unexpectedCharError(index, 123);
                    }
                }
                this.stage = 0;
                if (this.parseError) {
                    SheetTokenHandler.this.contextHandler = new IgnoredDeclarationTokenHandler();
                }
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                if (SheetTokenHandler.this.curlyBracketDepth == 1 && SheetTokenHandler.this.stage == 2) {
                    SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                    SheetTokenHandler.this.selectorHandler.prevcp = 32;
                    byte ruleType = SheetTokenHandler.this.ruleType;
                    if (ruleType == 4) {
                        CSSParser.this.handler.endMedia(SheetTokenHandler.this.medialist);
                        SheetTokenHandler.this.medialist = null;
                    }
                    SheetTokenHandler.this.curlyBracketDepth = 0;
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                } else {
                    this.handleError(index, (byte)4, "Unexpected '}'");
                }
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.stage > 1) {
                    this.unexpectedCharError(index, 64);
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.prevcp = 64;
                SheetTokenHandler.this.buffer.append('@');
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                this.endDocument();
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                this.stage = (byte)127;
                if (!this.parseError) {
                    if (CSSParser.this.errorHandler != null) {
                        if (this.prevcp == this.endcp) {
                            CSSParser.this.errorHandler.error(this.createException("Expected end of file", index));
                        } else {
                            CSSParser.this.errorHandler.error(this.createException(message, index));
                        }
                    }
                    this.parseError = true;
                }
                this.selist.clear();
                this.buffer.setLength(0);
            }

            @Override
            CSSParseException createException(String message, int index) {
                return SheetTokenHandler.this.createException(message, index);
            }
        }
    }

    private class RuleTokenHandler
    extends SheetTokenHandler {
        RuleTokenHandler(InputSource source) {
            super(source);
        }

        @Override
        protected DeclarationTokenHandler createDeclarationTokenHandler(InputSource source) {
            return new RuleDeclarationTokenHandler();
        }

        @Override
        protected void endRuleBody() {
            this.contextHandler = new RuleEndContentHandler();
        }

        @Override
        protected void resetRuleState() {
            super.resetRuleState();
            this.contextHandler = new RuleEndContentHandler();
        }

        private class RuleEndContentHandler
        extends CSSTokenHandler {
            RuleEndContentHandler() {
                super(null);
            }

            @Override
            public void word(int index, String word) {
                this.reportError(index);
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void singleQuoted(int index, String quoted) {
                this.reportError(index);
            }

            @Override
            public void doubleQuoted(int index, String quoted) {
                this.reportError(index);
            }

            @Override
            public void openGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void character(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void escaped(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void control(int index, int codePoint) {
            }

            @Override
            public void commented(int index, int commentType, String comment) {
            }

            @Override
            public void endOfStream(int len) {
            }

            @Override
            public void error(int index, byte errCode, CharSequence context) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            private void reportError(int index) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                if (!this.parseError && CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.fatalError(this.createException(message, index));
                }
                this.parseError = true;
            }
        }

        private class RuleDeclarationTokenHandler
        extends SheetTokenHandler.MyDeclarationTokenHandler {
            RuleDeclarationTokenHandler() {
                super(null);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                super.handleRightCurlyBracket(index);
                RuleTokenHandler.this.contextHandler = new RuleEndContentHandler();
            }
        }
    }

    private static class MySACAllMediaList
    implements SACMediaList {
        MySACAllMediaList() {
        }

        public int getLength() {
            return 1;
        }

        public String item(int index) {
            if (index != 0) {
                return null;
            }
            return "all";
        }

        public String toString() {
            return "all";
        }
    }

    private static class MySACMediaList
    implements SACMediaList {
        String[] list;

        MySACMediaList(String[] list) {
            this.list = list;
        }

        public int getLength() {
            return this.list.length;
        }

        public String item(int index) {
            if (index < 0 || index >= this.list.length) {
                return null;
            }
            return this.list[index].trim();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.list.length != 0) {
                buf.append(this.list[0].trim());
            }
            for (int i = 1; i < this.list.length; ++i) {
                buf.append(',').append(this.list[i].trim());
            }
            return buf.toString();
        }
    }
}

