/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

public class ParseHelper {
    public static final byte ERR_UNEXPECTED_CHAR = 4;
    public static final byte ERR_WRONG_VALUE = 5;
    public static final byte ERR_UNMATCHED_PARENTHESIS = 6;
    public static final byte ERR_UNEXPECTED_TOKEN = 9;
    public static final byte ERR_EXPR_SYNTAX = 32;
    public static final byte ERR_RULE_SYNTAX = 33;
    public static final byte ERR_UNEXPECTED_EOF = 10;

    public static String unescapeStringValue(String value) {
        int iCP = value.indexOf(92);
        if (iCP == -1) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder(len);
        if (iCP > 0) {
            ParseHelper.appendString(buf, value, 0, iCP);
        }
        for (int i = ++iCP; i < len; ++i) {
            char c;
            int cp;
            if (i - iCP > 5) {
                ParseHelper.appendCodePoint(buf, value, iCP, i);
                iCP = value.indexOf(92, i);
                if (iCP == -1) {
                    ParseHelper.appendString(buf, value, i, len);
                    break;
                }
                ParseHelper.appendString(buf, value, i, iCP);
                i = ++iCP;
                if (i >= len) break;
            }
            if ((cp = Character.digit(c = value.charAt(i), 16)) >= 0 && cp <= 15) continue;
            if (i != iCP && ParseHelper.appendCodePoint(buf, value, iCP, i) && c == ' ') {
                ++i;
            }
            if ((iCP = value.indexOf(92, i)) == -1) {
                ParseHelper.appendString(buf, value, i, len);
                break;
            }
            ParseHelper.appendString(buf, value, i, iCP);
            i = ++iCP;
            if (i >= len) break;
        }
        if (iCP != -1 && len != iCP) {
            int cp = Character.digit(value.charAt(iCP), 16);
            if (cp < 0 || cp > 15) {
                ParseHelper.appendString(buf, value, iCP, len);
            } else {
                ParseHelper.appendCodePoint(buf, value, iCP, len);
            }
        }
        return buf.toString();
    }

    private static boolean appendCodePoint(StringBuilder buf, String value, int idx, int endIdx) {
        if (idx + 1 == endIdx) {
            Character c = Character.valueOf(value.charAt(idx));
            int cp = Character.digit(c.charValue(), 16);
            if (cp < 0 || cp > 15) {
                buf.append(c);
                return false;
            }
            if (ParseHelper.appendCodePoint(buf, cp)) {
                return true;
            }
        } else {
            int cp = Integer.parseInt(value.substring(idx, endIdx), 16);
            if (ParseHelper.appendCodePoint(buf, cp)) {
                return true;
            }
        }
        ParseHelper.appendString(buf, value, idx - 1, endIdx);
        return false;
    }

    private static boolean appendCodePoint(StringBuilder buf, int cp) {
        if (Character.isBmpCodePoint(cp)) {
            int type = Character.getType(cp);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 24: 
                case 25: 
                case 26: {
                    buf.append(Character.toChars(cp));
                    return true;
                }
                case 15: {
                    if (cp != 0) {
                        buf.append(Character.toChars(cp));
                    } else {
                        buf.append('\ufffd');
                    }
                    return true;
                }
                case 19: {
                    buf.append('\ufffd');
                    return true;
                }
            }
        }
        return false;
    }

    private static void appendString(StringBuilder buf, CharSequence value, int idx, int endIdx) {
        int prelen = buf.length();
        CharSequence seq = value.subSequence(idx, endIdx);
        buf.append(seq);
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != '\n') continue;
            buf.setCharAt(prelen + i, '\ufffd');
        }
    }

    public static String escapeCssChars(String strval) {
        StringBuilder buf;
        boolean noesc;
        int len = strval.length();
        if (len == 0) {
            return "";
        }
        int i = 0;
        int cp = strval.codePointAt(0);
        boolean bl = noesc = cp < 48 || cp > 57;
        if (noesc) {
            buf = null;
        } else {
            buf = new StringBuilder(len + 24);
            buf.append("\\3").append(Character.toChars(cp)).append(' ');
            i = 1;
        }
        while (i < len) {
            cp = strval.codePointAt(i);
            if (cp >= 33 && cp <= 41 || cp == 42 || cp == 43 || cp == 44 || cp == 46 || cp == 47 || cp >= 58 && cp <= 63 || cp == 64 || cp == 91 || cp == 93 || cp == 94 || cp == 96 || cp >= 123 && cp <= 126) {
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(len + 20);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append(Character.toChars(cp));
            } else if (!noesc) {
                buf.append(Character.toChars(cp));
            }
            ++i;
        }
        if (noesc) {
            return strval;
        }
        return buf.toString();
    }

    public static String escapeBackslash(String strval) {
        boolean noesc = true;
        int lenm1 = strval.length() - 1;
        StringBuilder buf = null;
        for (int i = 0; i <= lenm1; ++i) {
            int cp = strval.codePointAt(i);
            if (cp == 92) {
                int digit;
                if (i < lenm1 && (digit = Character.digit(cp = strval.codePointAt(i + 1), 16)) != -1 && digit < 17) continue;
                if (noesc) {
                    noesc = false;
                    buf = new StringBuilder(lenm1 + 22);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append('\\');
                continue;
            }
            if (noesc) continue;
            buf.append(Character.toChars(cp));
        }
        if (noesc) {
            return strval;
        }
        return buf.toString();
    }

    public static short unitFromString(String unit) {
        if (unit == "%") {
            return 23;
        }
        if (unit == "em") {
            return 15;
        }
        if (unit == "ex") {
            return 16;
        }
        if (unit == "cap") {
            return 50;
        }
        if (unit == "ch") {
            return 51;
        }
        if (unit == "ic") {
            return 52;
        }
        if (unit == "rem") {
            return 53;
        }
        if (unit == "lh") {
            return 54;
        }
        if (unit == "rlh") {
            return 55;
        }
        if (unit == "vw") {
            return 56;
        }
        if (unit == "vh") {
            return 57;
        }
        if (unit == "vi") {
            return 58;
        }
        if (unit == "vb") {
            return 59;
        }
        if (unit == "vmin") {
            return 60;
        }
        if (unit == "vmax") {
            return 61;
        }
        if (unit == "cm") {
            return 19;
        }
        if (unit == "mm") {
            return 20;
        }
        if (unit == "q") {
            return 62;
        }
        if (unit == "in") {
            return 18;
        }
        if (unit == "pt") {
            return 21;
        }
        if (unit == "pc") {
            return 22;
        }
        if (unit == "px") {
            return 17;
        }
        if (unit == "deg") {
            return 28;
        }
        if (unit == "grad") {
            return 29;
        }
        if (unit == "rad") {
            return 30;
        }
        if (unit == "turn") {
            return 63;
        }
        if (unit == "s") {
            return 32;
        }
        if (unit == "ms") {
            return 31;
        }
        if (unit == "hz") {
            return 33;
        }
        if (unit == "khz") {
            return 34;
        }
        if (unit == "dpi") {
            return 64;
        }
        if (unit == "dpcm") {
            return 65;
        }
        if (unit == "dppx") {
            return 66;
        }
        return 42;
    }

    public static boolean isFunctionUnitType(short unitType) {
        switch (unitType) {
            case 25: 
            case 26: 
            case 27: 
            case 38: 
            case 41: {
                return true;
            }
        }
        return false;
    }
}

