/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.OMCSSFunctionValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class GradientValue
extends OMCSSFunctionValue {
    GradientValue() {
    }

    GradientValue(GradientValue copied) {
        super(copied);
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) throws DOMException {
        this.setCSSUnitType((short)3);
        String funcname = lunit.getFunctionName();
        this.setFunctionName(funcname);
        LexicalUnit lu = lunit.getParameters();
        if (lu == null) {
            throw new DOMException(12, "Gradient without arguments");
        }
        if (funcname.endsWith("linear-gradient")) {
            this.setLinearGradient(lu, factory);
        } else if (funcname.endsWith("radial-gradient")) {
            this.setRadialGradient(lu, factory);
        } else if (funcname.endsWith("conic-gradient")) {
            this.setConicGradient(lu, factory);
        } else {
            throw new DOMException(12, "Unknown gradient type");
        }
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    private void setLinearGradient(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit colorStopLU = this.isLinearColorStop(lu) ? lu : this.setAngleArguments(lu, factory);
        if (colorStopLU == null) {
            throw new DOMException(12, "Expected angle, side or color stop, found: " + lu.toString());
        }
        do {
            if ((colorStopLU = this.processLinearColorStop(colorStopLU, factory)) == null) continue;
            if (colorStopLU.getLexicalUnitType() == 0) {
                colorStopLU = colorStopLU.getNextLexicalUnit();
                continue;
            }
            throw new DOMException(12, "Expected color stops, found: " + lu.toString());
        } while (colorStopLU != null);
    }

    private LexicalUnit setAngleArguments(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit finalLU = null;
        if (lu.getLexicalUnitType() == 35) {
            String ident = lu.getStringValue().toLowerCase(Locale.US);
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            if ("to".equals(ident)) {
                list.add(factory.createCSSPrimitiveValue(lu, true));
                lu = lu.getNextLexicalUnit();
            } else {
                if (!this.isSideValue(ident)) {
                    return null;
                }
                if (factory != null) {
                    factory.reportSyntaxWarning("Missing 'to' in side/corner specification in gradient: " + lu.toString());
                }
            }
            if (lu.getLexicalUnitType() == 35 && this.isSideValue(ident = lu.getStringValue().toLowerCase(Locale.US))) {
                list.add(factory.createCSSPrimitiveValue(lu, true));
                finalLU = lu = lu.getNextLexicalUnit();
                if (lu.getLexicalUnitType() == 35 && this.isSideValue(ident = lu.getStringValue().toLowerCase(Locale.US))) {
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                    finalLU = lu.getNextLexicalUnit();
                }
                this.getArguments().add(list);
            }
        } else if (ValueFactory.isAngleSACUnit(lu)) {
            this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
            finalLU = lu.getNextLexicalUnit();
        }
        if (finalLU != null) {
            finalLU = finalLU.getLexicalUnitType() == 0 ? finalLU.getNextLexicalUnit() : null;
        }
        return finalLU;
    }

    private boolean isSideValue(String ident) {
        return "left".equals(ident) || "right".equals(ident) || "top".equals(ident) || "bottom".equals(ident);
    }

    private boolean isLinearColorStop(LexicalUnit lu) {
        LexicalUnit lu2 = lu.getNextLexicalUnit();
        if (BaseCSSStyleDeclaration.testColor(lu)) {
            return true;
        }
        return lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && ValueFactory.isSizeSACUnit(lu);
    }

    private LexicalUnit processLinearColorStop(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit finalLU = null;
        LexicalUnit lu2 = lu.getNextLexicalUnit();
        if (BaseCSSStyleDeclaration.testColor(lu)) {
            AbstractCSSPrimitiveValue color = factory.createCSSPrimitiveValue(lu, true);
            if (lu2 != null && ValueFactory.isSizeSACUnit(lu2)) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                list.add(color);
                list.add(factory.createCSSPrimitiveValue(lu2, true));
                this.getArguments().add(list);
                lu2 = lu2.getNextLexicalUnit();
                if (lu2 != null && ValueFactory.isSizeSACUnit(lu2)) {
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    lu2 = lu2.getNextLexicalUnit();
                }
            } else {
                this.getArguments().add(color);
            }
            finalLU = lu2;
        } else if (lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && ValueFactory.isSizeSACUnit(lu)) {
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            list.add(factory.createCSSPrimitiveValue(lu2, true));
            list.add(factory.createCSSPrimitiveValue(lu, true));
            this.getArguments().add(list);
            finalLU = lu2.getNextLexicalUnit();
        } else if (lu.getLexicalUnitType() == 0) {
            finalLU = lu;
        }
        return finalLU;
    }

    private void setRadialGradient(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit colorStopLU;
        if (!this.isLinearColorStop(lu)) {
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            while (lu != null) {
                if (lu.getLexicalUnitType() == 0) {
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                list.add(factory.createCSSPrimitiveValue(lu, true));
                lu = lu.getNextLexicalUnit();
            }
            if (list.getLength() != 1) {
                this.getArguments().add(list);
            } else {
                this.getArguments().add(list.item(0));
            }
        }
        if ((colorStopLU = lu) == null) {
            throw new DOMException(12, "Expected shape, size or color stop, found: " + lu.toString());
        }
        do {
            if ((colorStopLU = this.processLinearColorStop(colorStopLU, factory)) == null) continue;
            if (colorStopLU.getLexicalUnitType() == 0) {
                colorStopLU = colorStopLU.getNextLexicalUnit();
                continue;
            }
            throw new DOMException(12, "Expected color stops, found: " + lu.toString());
        } while (colorStopLU != null);
    }

    private void setConicGradient(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit colorStopLU;
        if (!this.isAngularColorStop(lu)) {
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            while (lu != null) {
                if (lu.getLexicalUnitType() == 0) {
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                list.add(factory.createCSSPrimitiveValue(lu, true));
                lu = lu.getNextLexicalUnit();
            }
            if (list.getLength() != 1) {
                this.getArguments().add(list);
            } else {
                this.getArguments().add(list.item(0));
            }
        }
        if ((colorStopLU = lu) == null) {
            throw new DOMException(12, "Expected angle, position or color stop, found: " + lu.toString());
        }
        do {
            if ((colorStopLU = this.processAngularColorStop(colorStopLU, factory)) == null) continue;
            if (colorStopLU.getLexicalUnitType() == 0) {
                colorStopLU = colorStopLU.getNextLexicalUnit();
                continue;
            }
            throw new DOMException(12, "Expected color stops, found: " + lu.toString());
        } while (colorStopLU != null);
    }

    private boolean isAngularColorStop(LexicalUnit lu) {
        LexicalUnit lu2 = lu.getNextLexicalUnit();
        if (BaseCSSStyleDeclaration.testColor(lu)) {
            return true;
        }
        return lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23);
    }

    private LexicalUnit processAngularColorStop(LexicalUnit lu, ValueFactory factory) {
        LexicalUnit finalLU = null;
        LexicalUnit lu2 = lu.getNextLexicalUnit();
        if (BaseCSSStyleDeclaration.testColor(lu)) {
            AbstractCSSPrimitiveValue color = factory.createCSSPrimitiveValue(lu, true);
            if (lu2 != null && (ValueFactory.isAngleSACUnit(lu2) || lu2.getLexicalUnitType() == 23)) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                list.add(color);
                list.add(factory.createCSSPrimitiveValue(lu2, true));
                this.getArguments().add(list);
                lu2 = lu2.getNextLexicalUnit();
                if (lu2 != null && (ValueFactory.isAngleSACUnit(lu2) || lu2.getLexicalUnitType() == 23)) {
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    lu2 = lu2.getNextLexicalUnit();
                }
            } else {
                this.getArguments().add(color);
            }
            finalLU = lu2;
        } else if (lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23)) {
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            list.add(factory.createCSSPrimitiveValue(lu2, true));
            list.add(factory.createCSSPrimitiveValue(lu, true));
            this.getArguments().add(list);
            finalLU = lu2.getNextLexicalUnit();
        } else if (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23) {
            this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
            finalLU = lu2;
        } else if (lu.getLexicalUnitType() == 0) {
            finalLU = lu;
        }
        return finalLU;
    }

    @Override
    public GradientValue clone() {
        return new GradientValue(this);
    }
}

