/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class OMCSSCalcValue
extends AbstractCSSPrimitiveValue {
    Expression expression = null;

    public OMCSSCalcValue() {
    }

    protected OMCSSCalcValue(OMCSSCalcValue copied) {
        super(copied);
        this.expression = copied.expression;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Must retrieve individual operands and compute result");
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) throws DOMException {
        this.setCSSUnitType((short)1);
        LexicalUnit lu = lunit.getParameters();
        this.expression = this.fillExpressionLevel(lu, subp, factory);
        if (this.expression == null) {
            throw new DOMException(12, "Void expression");
        }
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    private Expression fillExpressionLevel(LexicalUnit lu, boolean subp, ValueFactory factory) {
        Expression expression = null;
        int lastlutype = -1;
        while (lu != null) {
            boolean inverse = false;
            short lutype = lu.getLexicalUnitType();
            switch (lutype) {
                case 2: {
                    inverse = true;
                }
                case 1: {
                    Expression operation;
                    if (expression == null) {
                        if (inverse) {
                            operation = new SumExpression();
                            operation.nextOperandInverse = true;
                            break;
                        }
                        throw new DOMException(5, "Missing operand");
                    }
                    if (expression.getType() == 0) {
                        operation = new SumExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    if (expression.getType() == 2) {
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    Expression parent = expression.getParentExpression();
                    if (parent == null) {
                        operation = new SumExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    expression = parent;
                    expression.nextOperandInverse = inverse;
                    break;
                }
                case 4: {
                    inverse = true;
                }
                case 3: {
                    Expression operation;
                    if (expression == null) {
                        throw new DOMException(5, "Missing factor");
                    }
                    if (expression.getType() == 0) {
                        operation = new ProductExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    if (expression.getType() == 2) {
                        operation = new ProductExpression();
                        if (lastlutype != 40) {
                            expression.replaceLastExpression(operation);
                        } else {
                            operation.addExpression(expression);
                        }
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    expression.nextOperandInverse = inverse;
                    break;
                }
                case 40: {
                    LexicalUnit subval = lu.getSubValues();
                    if (subval == null) {
                        throw new DOMException(12, "Empty sub-expression");
                    }
                    Expression subexpr = this.fillExpressionLevel(subval, subp, factory);
                    if (subexpr != null) {
                        subexpr.setInverseOperation(inverse);
                        if (expression != null) {
                            expression.addExpression(subexpr);
                            break;
                        }
                        expression = subexpr;
                        break;
                    }
                    throw new DOMException(5, "Bad subexpression");
                }
                default: {
                    AbstractCSSPrimitiveValue primi = factory.createCSSPrimitiveValue(lu, subp);
                    if (primi == null || !(primi instanceof CSSNumberValue) || primi.isNegativeNumber()) {
                        throw new DOMException(5, "Bad operands");
                    }
                    OperandExpression operand = new OperandExpression();
                    operand.setOperand(primi);
                    if (expression == null) {
                        expression = operand;
                    } else {
                        if (expression.getType() == 0) {
                            throw new DOMException(5, "Bad expression");
                        }
                        expression.addExpression(operand);
                    }
                    if (this.getPrimitiveType() == 18 || !ValueFactory.isPositiveSizeSACUnit(lu)) break;
                    this.setCSSUnitType((short)18);
                }
            }
            lastlutype = lutype;
            lu = lu.getNextLexicalUnit();
        }
        if (expression.getType() == 1 && expression.getParentExpression() != null) {
            expression = expression.getParentExpression();
        }
        return expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public OMCSSCalcValue clone() {
        return new OMCSSCalcValue(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSCalcValue other = (OMCSSCalcValue)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    @Override
    public String getCssText() {
        String s = this.expression.toString();
        StringBuilder buf = new StringBuilder(s.length() + 7);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        String s = this.expression.toString();
        StringBuilder buf = new StringBuilder(s.length() + 6);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    public static class OperandExpression
    extends Expression {
        CSSPrimitiveValue operand = null;

        @Override
        void addExpression(Expression expr) {
        }

        public CSSPrimitiveValue getOperand() {
            return this.operand;
        }

        public void setOperand(CSSPrimitiveValue operand) {
            this.operand = operand;
        }

        @Override
        public byte getType() {
            return 0;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.operand == null ? 0 : this.operand.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperandExpression other = (OperandExpression)obj;
            return !(this.operand == null ? other.operand != null : !this.operand.equals(other.operand));
        }

        public String toString() {
            return this.operand == null ? "" : this.operand.getCssText();
        }
    }

    static class ProductExpression
    extends Expression
    implements AlgebraicExpression {
        LinkedList<Expression> operands = new LinkedList();

        ProductExpression() {
        }

        @Override
        void addExpression(Expression expr) {
            this.operands.add(expr);
            expr.setParentExpression(this);
            if (this.nextOperandInverse) {
                expr.setInverseOperation(true);
                this.nextOperandInverse = false;
            }
        }

        @Override
        public List<Expression> getOperands() {
            return this.operands;
        }

        @Override
        public byte getType() {
            return 1;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.operands == null ? 0 : this.operands.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProductExpression other = (ProductExpression)obj;
            return !(this.operands == null ? other.operands != null : !this.operands.equals(other.operands));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            Iterator it = this.operands.iterator();
            if (!it.hasNext()) {
                return "";
            }
            Expression expr = (Expression)it.next();
            if (expr.getType() == 2) {
                buf.append('(').append(expr.toString()).append(')');
            } else {
                buf.append(expr.toString());
            }
            while (it.hasNext()) {
                expr = (Expression)it.next();
                if (expr.isInverseOperation()) {
                    buf.append('/');
                } else {
                    buf.append('*');
                }
                if (expr.getType() == 2) {
                    buf.append('(').append(expr.toString()).append(')');
                    continue;
                }
                buf.append(expr.toString());
            }
            return buf.toString();
        }
    }

    static class SumExpression
    extends Expression
    implements AlgebraicExpression {
        LinkedList<Expression> operands = new LinkedList();

        SumExpression() {
        }

        @Override
        void addExpression(Expression expr) {
            this.operands.add(expr);
            expr.setParentExpression(this);
            if (this.nextOperandInverse) {
                expr.setInverseOperation(true);
                this.nextOperandInverse = false;
            }
        }

        @Override
        void replaceLastExpression(Expression operation) {
            Expression lastexpr = this.operands.removeLast();
            if (lastexpr.isInverseOperation()) {
                lastexpr.setInverseOperation(false);
                operation.setInverseOperation(true);
            }
            operation.addExpression(lastexpr);
            operation.setParentExpression(this);
            this.operands.addLast(operation);
        }

        @Override
        public List<Expression> getOperands() {
            return this.operands;
        }

        @Override
        public byte getType() {
            return 2;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.operands == null ? 0 : this.operands.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SumExpression other = (SumExpression)obj;
            return !(this.operands == null ? other.operands != null : !this.operands.equals(other.operands));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            Iterator it = this.operands.iterator();
            if (!it.hasNext()) {
                return "";
            }
            Expression expr = (Expression)it.next();
            if (expr.getType() != 2 && expr.isInverseOperation()) {
                buf.append(' ').append('-').append(' ');
            }
            buf.append(expr.toString());
            while (it.hasNext()) {
                boolean parens = false;
                expr = (Expression)it.next();
                if (expr.getType() == 2 && expr.isInverseOperation()) {
                    buf.append(' ').append('-').append(' ').append('(');
                    parens = true;
                } else if (expr.getType() != 2 && expr.isInverseOperation()) {
                    buf.append(' ').append('-').append(' ');
                } else {
                    buf.append(' ').append('+').append(' ');
                }
                buf.append(expr.toString());
                if (!parens) continue;
                buf.append(')');
            }
            return buf.toString();
        }
    }

    public static interface AlgebraicExpression {
        public List<Expression> getOperands();
    }

    public static abstract class Expression {
        public static final byte CALC_SUM = 2;
        public static final byte CALC_PRODUCT = 1;
        public static final byte CALC_OPERAND = 0;
        Expression parent = null;
        boolean inverseOperation = false;
        transient boolean nextOperandInverse = false;

        public Expression getParentExpression() {
            return this.parent;
        }

        void replaceLastExpression(Expression operation) {
            throw new IllegalStateException();
        }

        void setParentExpression(Expression parent) {
            this.parent = parent;
        }

        abstract void addExpression(Expression var1);

        void setInverseOperation(boolean inverse) {
            this.inverseOperation = inverse;
        }

        boolean isInverseOperation() {
            return this.inverseOperation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inverseOperation ? 1231 : 1237);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(this instanceof Expression)) {
                return false;
            }
            Expression other = (Expression)obj;
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.inverseOperation != other.inverseOperation) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : other.parent == null);
        }

        public abstract byte getType();
    }
}

