/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OMCSSRatioValue
extends AbstractCSSPrimitiveValue
implements CSSRatioValue {
    private int antecedentValue;
    private int consequentValue;

    OMCSSRatioValue() {
    }

    protected OMCSSRatioValue(OMCSSRatioValue copied) {
        super(copied);
        this.antecedentValue = copied.antecedentValue;
        this.consequentValue = copied.consequentValue;
    }

    @Override
    public String getCssText() {
        return this.antecedentValue + "/" + this.consequentValue;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value is read-only");
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        super.setLexicalUnit(lunit, subp, factory);
        this.setAntecedentValue(lunit.getIntegerValue());
        this.setConsequentValue(lunit.getNextLexicalUnit().getNextLexicalUnit().getIntegerValue());
        this.setSubproperty(subp);
    }

    @Override
    public int getAntecedentValue() {
        return this.antecedentValue;
    }

    @Override
    public int getConsequentValue() {
        return this.consequentValue;
    }

    public void setAntecedentValue(int antecedentValue) {
        if (antecedentValue < 0) {
            throw new DOMException(5, "Value must be positive");
        }
        this.antecedentValue = antecedentValue;
    }

    public void setConsequentValue(int consequentValue) {
        if (consequentValue < 0) {
            throw new DOMException(5, "Value must be positive");
        }
        this.consequentValue = consequentValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.antecedentValue;
        result = 31 * result + this.consequentValue;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSRatioValue other = (OMCSSRatioValue)obj;
        if (this.antecedentValue != other.antecedentValue) {
            return false;
        }
        return this.consequentValue == other.consequentValue;
    }

    @Override
    public OMCSSRatioValue clone() {
        return new OMCSSRatioValue(this);
    }
}

