/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;

public abstract class HTMLElement
extends DOMNode
implements CSSElement,
ElementCSSInlineStyle,
ParentNode {
    private final String localName;
    DOMNode.MyNamedNodeMap<Attr> nodeMap;
    ClassList classList = null;
    WeakReference<ElementList> childElementRef = null;
    WeakReference<SelectorMatcher> selectorMatcherRef = null;
    Map<String, WeakReference<ElementNodeList>> tagListMap;
    Map<String, WeakReference<ElementNodeList>> classListMap;
    private TypeInfo schemaTypeInfo = null;
    private Map<String, CSSStyleDeclaration> overrideStyleSet = null;

    HTMLElement(String tagName) {
        this(tagName, "http://www.w3.org/1999/xhtml");
    }

    HTMLElement(String localName, String namespaceUri) {
        super((short)1, namespaceUri);
        this.localName = localName;
        this.nodeMap = new DOMNode.MyNamedNodeMap(this, 2);
        this.tagListMap = null;
    }

    @Override
    protected DOMNode.DOMNodeList createChildNodeList() {
        return new DOMNode.ChildNodeList();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public DOMTokenList getClassList() {
        if (this.classList == null) {
            HTMLDocument.MyAttr attr = (HTMLDocument.MyAttr)this.nodeMap.getNodeMap().get("class");
            this.classList = new QuirksClassList();
            if (attr != null && attr.value != null) {
                this.classList.setValue(attr.value);
            }
        }
        return this.classList;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.nodeMap;
    }

    @Override
    public boolean hasAttributes() {
        return !this.nodeMap.getNodeMap().isEmpty();
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.nodeMap.getNodeMap().get(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr;
        String prefix;
        if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals("http://www.w3.org/1999/xhtml") && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        if ((attr = this.nodeMap.getNodeMap().get(localName)) == null || !attr.getNamespaceURI().equals(namespaceURI)) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        return this.nodeMap.getNodeMap().get(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr;
        String prefix;
        if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals("http://www.w3.org/1999/xhtml") && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        if ((attr = this.nodeMap.getNodeMap().get(localName)) == null || !attr.getNamespaceURI().equals(namespaceURI)) {
            return null;
        }
        return attr;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String nsuri = super.lookupNamespaceURI(prefix);
        if (nsuri == null && this.hasAttributes()) {
            for (Attr attr : this.nodeMap.getNodeMap().values()) {
                if (!"xmlns".equals(attr.getName()) || !prefix.equals(attr.getLocalName())) continue;
                String value = attr.getValue();
                if (value.length() == 0) {
                    nsuri = null;
                    break;
                }
                nsuri = value;
                break;
            }
        }
        return nsuri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals("http://www.w3.org/1999/xhtml")) {
            String qname;
            namespaceURI = namespaceURI.intern();
            boolean matchAll = "*".equals(localName = localName.intern());
            if (matchAll) {
                qname = namespaceURI;
            } else {
                qname = namespaceURI + ":" + localName;
                qname = qname.intern();
            }
            ElementNodeList list = this.findList(qname);
            if (list == null) {
                list = new ElementNodeList();
                HTMLElement.buildElementsByTagList(localName, this, list, namespaceURI, matchAll);
                Map<String, WeakReference<ElementNodeList>> map = this.tagListMap;
                synchronized (map) {
                    this.tagListMap.put(qname, new WeakReference<ElementNodeList>(list));
                }
            }
            return list;
        }
        return this.getElementsByTagName(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementNodeList findList(String qname) {
        if (this.tagListMap == null) {
            this.tagListMap = new HashMap<String, WeakReference<ElementNodeList>>(3);
        } else {
            Map<String, WeakReference<ElementNodeList>> map = this.tagListMap;
            synchronized (map) {
                WeakReference<ElementNodeList> ref = this.tagListMap.get(qname);
                if (ref != null) {
                    ElementNodeList list = (ElementNodeList)ref.get();
                    if (list == null) {
                        this.tagListMap.remove(qname);
                    } else {
                        return list;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementList getElementsByTagName(String name) {
        ElementNodeList list = this.findList(name = name.toLowerCase(Locale.US).intern());
        if (list != null) {
            return list;
        }
        list = new ElementNodeList();
        HTMLElement.buildElementsByTagList(name, this, list, "http://www.w3.org/1999/xhtml", "*".equals(name));
        Map<String, WeakReference<ElementNodeList>> map = this.tagListMap;
        synchronized (map) {
            this.tagListMap.put(name, new WeakReference<ElementNodeList>(list));
        }
        return list;
    }

    static void buildElementsByTagList(String localName, DOMNode elm, ElementNodeList list, String namespaceURI, boolean matchAll) {
        DOMNode.DOMNodeList nl = elm.child;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            CSSElement element = (CSSElement)node;
            if ((matchAll || element.getLocalName() == localName) && namespaceURI == element.getNamespaceURI()) {
                list.add(element);
            }
            HTMLElement.buildElementsByTagList(localName, (DOMNode)((Object)element), list, namespaceURI, matchAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementList getElementsByClassName(String names) {
        ElementNodeList list;
        boolean hasSpace;
        names = names.trim().toLowerCase(Locale.US);
        TreeSet<String> sorted = new TreeSet<String>();
        boolean bl = hasSpace = names.indexOf(32) != -1;
        if (hasSpace) {
            names = this.sortClassNames(names, sorted);
        }
        if ((list = this.findClassList(names)) != null) {
            return list;
        }
        if (!hasSpace) {
            sorted.add(names);
        }
        list = new ElementNodeList();
        this.buildElementsByClassList(sorted, this, list);
        Map<String, WeakReference<ElementNodeList>> map = this.classListMap;
        synchronized (map) {
            this.classListMap.put(names, new WeakReference<ElementNodeList>(list));
        }
        return list;
    }

    private String sortClassNames(String names, SortedSet<String> sorted) {
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            sorted.add(st.nextToken());
        }
        StringBuilder buf = new StringBuilder(names.length());
        Iterator it = sorted.iterator();
        buf.append((String)it.next());
        while (it.hasNext()) {
            buf.append(' ').append((String)it.next());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementNodeList findClassList(String names) {
        if (this.classListMap == null) {
            this.classListMap = new HashMap<String, WeakReference<ElementNodeList>>(3);
        } else {
            Map<String, WeakReference<ElementNodeList>> map = this.classListMap;
            synchronized (map) {
                WeakReference<ElementNodeList> ref = this.classListMap.get(names);
                if (ref != null) {
                    ElementNodeList list = (ElementNodeList)ref.get();
                    if (list == null) {
                        this.classListMap.remove(names);
                    } else {
                        return list;
                    }
                }
            }
        }
        return null;
    }

    private void buildElementsByClassList(SortedSet<String> sorted, HTMLElement contextElement, ElementNodeList list) {
        DOMNode.DOMNodeList nl = contextElement.child;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            HTMLElement element = (HTMLElement)node;
            if (element.hasAttribute("class") && element.getClassList().containsAll(sorted)) {
                list.add(element);
            }
            this.buildElementsByClassList(sorted, element, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateTaglistsOnInsert(CSSElement newChild) {
        if (this.tagListMap != null) {
            String newtag = newChild.getLocalName();
            if (newChild.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
                newtag = newChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(newChild);
            Map<String, WeakReference<ElementNodeList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    ElementNodeList list = (ElementNodeList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnInsert(newChild);
                }
            }
        }
        super.updateTaglistsOnInsert(newChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateTaglistsOnRemove(CSSElement oldChild) {
        if (this.tagListMap != null) {
            String newtag = oldChild.getLocalName();
            if (oldChild.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
                newtag = oldChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(oldChild);
            Map<String, WeakReference<ElementNodeList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    ElementNodeList list = (ElementNodeList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }
        super.updateTaglistsOnRemove(oldChild);
    }

    private String allTagsName(CSSElement element) {
        if (element.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
            return element.getNamespaceURI();
        }
        return "*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateClasslists(HTMLElement owner) {
        DOMNode parent;
        boolean hasSpace;
        String ownerNames;
        DOMTokenList ownerClasses;
        boolean hasClasses = owner.hasAttribute("class");
        if (hasClasses) {
            ownerClasses = owner.getClassList();
            ownerNames = ownerClasses.getSortedValue();
            hasSpace = ownerNames.indexOf(32) != -1;
        } else {
            ownerClasses = null;
            ownerNames = "";
            hasSpace = false;
        }
        if (this.classListMap != null) {
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<ElementNodeList>> map = this.classListMap;
            synchronized (map) {
                Iterator<Map.Entry<String, WeakReference<ElementNodeList>>> it = this.classListMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, WeakReference<ElementNodeList>> entry = it.next();
                    String classNames = entry.getKey();
                    ElementNodeList list = (ElementNodeList)entry.getValue().get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    boolean hasOwner = list.contains(owner);
                    if (!hasClasses) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (!classNames.equals(ownerNames) && !hasSpace) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!ownerClasses.containsAll(sorted)) {
                            if (!hasOwner) continue;
                            list.updateOnRemove(owner);
                            continue;
                        }
                    }
                    if (hasOwner) continue;
                    list.updateOnInsert(owner);
                }
            }
        }
        if ((parent = (DOMNode)this.getParentNode()) != null) {
            parent.updateClasslists(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateClasslistsOnRemove(HTMLElement oldChild) {
        DOMNode parent;
        boolean hasSpace;
        DOMTokenList oldClasses = oldChild.getClassList();
        String oldNames = oldClasses.getSortedValue();
        boolean bl = hasSpace = oldNames.indexOf(32) != -1;
        if (this.classListMap != null) {
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<ElementNodeList>> map = this.classListMap;
            synchronized (map) {
                Iterator<String> it = this.classListMap.keySet().iterator();
                while (it.hasNext()) {
                    ElementNodeList list;
                    String classNames = it.next();
                    if (!classNames.equals(oldNames) && !hasSpace) continue;
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!oldClasses.containsAll(sorted)) continue;
                    }
                    if ((list = (ElementNodeList)this.classListMap.get(classNames).get()) == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }
        if ((parent = (DOMNode)this.getParentNode()) != null) {
            parent.updateClasslistsOnRemove(oldChild);
        }
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new ElementTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    @Override
    public String getTagName() {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return this.localName;
        }
        StringBuilder buf = new StringBuilder(this.localName.length() + prefix.length() + 1);
        buf.append(prefix).append(':').append(this.localName);
        return buf.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.nodeMap.getNodeMap().containsKey(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        DOMNode attr;
        if (namespaceURI == null || namespaceURI.length() == 0) {
            namespaceURI = "http://www.w3.org/1999/xhtml";
        }
        return (attr = (DOMNode)((Object)this.nodeMap.getNodeMap().get(localName))) != null && attr.getNamespaceURI().equals(namespaceURI);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        DOMNode oldAttr = (DOMNode)this.nodeMap.getNodeMap().remove(name);
        if (oldAttr != null) {
            oldAttr.setParentNode(null);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        DOMNode oldAttr;
        if (namespaceURI == null || namespaceURI.length() == 0) {
            namespaceURI = "http://www.w3.org/1999/xhtml";
        }
        if ((oldAttr = (DOMNode)((Object)this.nodeMap.getNodeMap().get(localName))) != null && oldAttr.getNamespaceURI().equals(namespaceURI)) {
            this.removeAttribute(localName);
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        boolean removed = false;
        Iterator<Map.Entry<String, Attr>> it = this.nodeMap.getNodeMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Attr> entry = it.next();
            if (!entry.getValue().equals(oldAttr)) continue;
            it.remove();
            removed = true;
            ((DOMNode)((Object)oldAttr)).setParentNode(null);
        }
        if (!removed) {
            throw new DOMException(8, "Attribute not in this element");
        }
        return oldAttr;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        this.setAttributeNS("http://www.w3.org/1999/xhtml", name, value);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attr attr;
        if (namespaceURI == null || namespaceURI.length() == 0) {
            namespaceURI = "http://www.w3.org/1999/xhtml";
        }
        if ((attr = this.nodeMap.getNodeMap().get(qualifiedName)) == null || !attr.getNamespaceURI().equals(namespaceURI)) {
            attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            ((DOMNode)((Object)attr)).setParentNode(this);
            this.nodeMap.getNodeMap().put(qualifiedName, attr);
        }
        attr.setValue(value);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.getOwnerDocument() != newAttr.getOwnerDocument()) {
            throw new DOMException(4, "Attribute was created by different document.");
        }
        ((DOMNode)((Object)newAttr)).setParentNode(this);
        return this.nodeMap.getNodeMap().put(newAttr.getName(), newAttr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
        return super.appendChild(newChild);
    }

    @Override
    public ElementList getChildren() {
        ElementList list = null;
        if (this.childElementRef != null) {
            list = (ElementList)this.childElementRef.get();
        }
        if (list == null) {
            list = new DOMNode.ChildElementList(this);
            this.childElementRef = new WeakReference<ElementList>(list);
        }
        return list;
    }

    @Override
    public HTMLElement getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    public HTMLElement getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    public ElementList querySelectorAll(String selectors) {
        return HTMLElement.querySelectorAll(selectors, this.child);
    }

    static ElementList querySelectorAll(String selectors, NodeList nl) {
        SelectorList selist;
        ElementNodeList list = new ElementNodeList();
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectors));
        try {
            selist = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectors);
        }
        HTMLElement.buildQuerySelectorList(selist, nl, list);
        return list;
    }

    private static void buildQuerySelectorList(SelectorList selist, NodeList nl, ElementNodeList list) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            HTMLElement element = (HTMLElement)node;
            if (element.matches(selist, null)) {
                list.add(element);
            }
            HTMLElement.buildQuerySelectorList(selist, element.child, list);
        }
    }

    @Override
    public abstract HTMLDocument getOwnerDocument();

    @Override
    public SelectorMatcher getSelectorMatcher() {
        SelectorMatcher matcher = null;
        if (this.selectorMatcherRef != null) {
            matcher = (SelectorMatcher)this.selectorMatcherRef.get();
        }
        if (matcher == null) {
            matcher = new DOMSelectorMatcher(this);
            this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
        }
        return matcher;
    }

    @Override
    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        SelectorList list;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectorString));
        try {
            list = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        return this.matches(list, pseudoElement);
    }

    @Override
    public boolean matches(SelectorList selist, String pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        InlineStyle styledecl = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
        String st = this.getAttribute("style");
        if (st.length() > 0) {
            try {
                styledecl.setCssText(st);
            }
            catch (DOMException e) {
                this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
            }
        }
        return styledecl;
    }

    boolean hasOverrideStyle(String pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        CSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, CSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    public String getStartTag() {
        StringBuilder buf = new StringBuilder(128);
        buf.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes()) {
            buf.append('>');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    public String toString() {
        int bufsz = 32;
        if (this.hasChildNodes()) {
            bufsz = 720;
        } else if (this.hasAttributes()) {
            bufsz = 128;
        }
        StringBuilder buf = new StringBuilder(bufsz);
        buf.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes()) {
            buf.append('>');
            NodeList list = this.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                buf.append(list.item(i).toString());
            }
            buf.append("</").append(this.getTagName()).append('>').append('\n');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    protected abstract CSSStyleSheetFactory getStyleSheetFactory();

    class ElementTypeInfo
    implements TypeInfo {
        ElementTypeInfo() {
        }

        @Override
        public String getTypeName() {
            return null;
        }

        @Override
        public String getTypeNamespace() {
            return "";
        }

        @Override
        public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
            return false;
        }
    }

    static class ElementNodeList
    extends LinkedList<CSSElement>
    implements ElementList {
        private static final long serialVersionUID = 1L;

        ElementNodeList() {
        }

        @Override
        public CSSElement item(int index) {
            if (index < 0 || index >= this.size()) {
                return null;
            }
            return (CSSElement)this.get(index);
        }

        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(this.size() * 32 + 40);
            Iterator it = this.iterator();
            while (it.hasNext()) {
                buf.append(((CSSElement)it.next()).toString());
            }
            return buf.toString();
        }

        public void updateOnInsert(CSSElement newChild) {
            CSSElement elm;
            int i;
            int sz = this.size();
            for (i = 0; i < sz && ((elm = (CSSElement)this.get(i)).compareDocumentPosition(newChild) & 4) != 4; ++i) {
            }
            this.add(i, newChild);
        }

        public void updateOnRemove(CSSElement oldChild) {
            this.remove(oldChild);
        }
    }

    class QuirksClassList
    extends ClassList {
        QuirksClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value != null && value.length() == 0) {
                value = value.toLowerCase(Locale.US);
            }
            super.setValue(value);
        }

        @Override
        public boolean contains(String token) {
            if (token == null) {
                return false;
            }
            token = token.toLowerCase(Locale.US);
            return super.contains(token);
        }

        @Override
        public void add(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            this.addUnchecked(token);
        }

        @Override
        public void remove(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            this.removeUnchecked(token);
        }

        @Override
        public boolean toggle(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            return this.toggleUnchecked(token);
        }

        @Override
        public void replace(String oldToken, String newToken) throws DOMException {
            this.argumentCheckVoidSpaces(oldToken);
            this.argumentCheckVoidSpaces(newToken);
            oldToken = oldToken.toLowerCase(Locale.US);
            newToken = newToken.toLowerCase(Locale.US);
            this.replaceUnchecked(oldToken, newToken);
        }
    }

    class ClassList
    extends DOMTokenSetImpl {
        ClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value == null || value.length() == 0) {
                this.clear();
                value = "";
            }
            super.setValue(value);
            this.updateClassLists();
        }

        @Override
        protected void addUnchecked(String token) throws DOMException {
            super.addUnchecked(token);
            this.updateClassLists();
        }

        @Override
        protected void removeUnchecked(String token) throws DOMException {
            super.removeUnchecked(token);
            this.updateClassLists();
        }

        @Override
        protected boolean toggleUnchecked(String token) throws DOMException {
            boolean result = super.toggleUnchecked(token);
            this.updateClassLists();
            return result;
        }

        @Override
        protected void replaceUnchecked(String oldToken, String newToken) throws DOMException {
            super.replaceUnchecked(oldToken, newToken);
            this.updateClassLists();
        }

        @Override
        public void clear() {
            super.clear();
            this.updateClassLists();
        }

        private void updateClassLists() {
            CSSNode parent = HTMLElement.this.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                ((HTMLElement)parent).updateClasslists(HTMLElement.this);
            }
        }
    }
}

