/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition2;
import io.sf.carte.doc.style.css.nsac.PositionalCondition2;
import io.sf.carte.doc.style.css.om.OMCSSStyleRule;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public abstract class AbstractSelectorMatcher
implements SelectorMatcher {
    private String localName = null;
    private String pseudoElt = null;

    public String getLocalName() {
        return this.localName;
    }

    protected void setLocalName(String localname) {
        this.localName = localname;
    }

    protected String getClassAttribute() {
        String classAttr = this.getAttributeValue("class");
        if (classAttr.length() == 0 && (classAttr = this.getAttributeValue("CLASS")).length() == 0) {
            classAttr = this.getAttributeValue("Class");
        }
        if (classAttr.length() != 0) {
            classAttr = classAttr.toLowerCase(Locale.US);
        }
        return classAttr;
    }

    @Override
    public String getPseudoElement() {
        return this.pseudoElt;
    }

    @Override
    public void setPseudoElement(String pseudoElt) {
        this.pseudoElt = pseudoElt;
    }

    protected boolean isActivePseudoClass(String pseudoclassName) {
        return false;
    }

    @Override
    public int matches(SelectorList selist) {
        int sz = selist.getLength();
        OMCSSStyleRule.Specifity matchedsp = null;
        int matchedIdx = -1;
        for (int i = 0; i < sz; ++i) {
            Selector sel = selist.item(i);
            if (!this.matches(sel)) continue;
            OMCSSStyleRule.Specifity sp = new OMCSSStyleRule.Specifity(sel);
            if (matchedsp != null && OMCSSStyleRule.Specifity.selectorCompare(matchedsp, sp) >= 0) continue;
            matchedsp = sp;
            matchedIdx = i;
        }
        return matchedIdx;
    }

    @Override
    public boolean matches(Selector selector) {
        switch (selector.getSelectorType()) {
            case 4: {
                String elname = ((ElementSelector)selector).getLocalName();
                String nsuri = ((ElementSelector)selector).getNamespaceURI();
                if (nsuri == null || nsuri.equals(this.getNamespaceURI())) {
                    return elname == null || this.localName.equals(elname.toLowerCase(Locale.US)) || elname.equals("*");
                }
                if (nsuri.length() != 0 || this.getNamespaceURI() != null) break;
                return true;
            }
            case 0: {
                ConditionalSelector condsel = (ConditionalSelector)selector;
                return this.matchCondition(condsel.getCondition(), condsel.getSimpleSelector());
            }
            case 11: {
                SimpleSelector desc = ((DescendantSelector)selector).getSimpleSelector();
                if (!this.matches((Selector)desc)) break;
                Selector ancestor = ((DescendantSelector)selector).getAncestorSelector();
                if (desc.getSelectorType() == 9) {
                    return this.matches(ancestor);
                }
                AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher();
                if (parentSM == null || !parentSM.matches(ancestor)) break;
                return true;
            }
            case 10: {
                SimpleSelector desc = ((DescendantSelector)selector).getSimpleSelector();
                if (!this.matches((Selector)desc)) break;
                Selector ancestor = ((DescendantSelector)selector).getAncestorSelector();
                if (desc.getSelectorType() == 9) {
                    return this.matches(ancestor);
                }
                for (AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher(); parentSM != null; parentSM = parentSM.getParentSelectorMatcher()) {
                    if (!parentSM.matches(ancestor)) continue;
                    return true;
                }
                break;
            }
            case 9: {
                if (this.pseudoElt == null || !this.pseudoElt.equalsIgnoreCase(((ElementSelector)selector).getLocalName())) break;
                return true;
            }
            case 12: {
                if (!this.matches((Selector)((SiblingSelector)selector).getSiblingSelector())) break;
                Selector sel = ((SiblingSelector)selector).getSelector();
                AbstractSelectorMatcher siblingSM = this.getPreviousSiblingSelectorMatcher();
                return siblingSM == null ? false : siblingSM.matches(sel);
            }
            case 1: {
                return true;
            }
            case 13: {
                SiblingSelector sibling = (SiblingSelector)selector;
                if (!this.matches((Selector)sibling.getSiblingSelector())) break;
                Selector sel = sibling.getSelector();
                for (AbstractSelectorMatcher siblingSM = this.getPreviousSiblingSelectorMatcher(); siblingSM != null; siblingSM = siblingSM.getPreviousSiblingSelectorMatcher()) {
                    if (!siblingSM.matches(sel)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean matchCondition(Condition cond, SimpleSelector simple) {
        switch (cond.getConditionType()) {
            case 9: {
                String cond_value = ((AttributeCondition)cond).getValue();
                return this.matchesClass(cond_value) && this.matches((Selector)simple);
            }
            case 5: {
                String idAttr = this.getId();
                if (!((AttributeCondition)cond).getValue().equals(idAttr)) break;
                return true;
            }
            case 4: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                String cond_value = ((AttributeCondition)cond).getValue();
                if (((AttributeCondition)cond).getSpecified() || cond_value != null) {
                    String attribValue = this.getAttributeValue(attrName);
                    if (cond instanceof AttributeCondition2 && !((AttributeCondition2)cond).isCaseSensitive()) {
                        return attribValue.equalsIgnoreCase(cond_value);
                    }
                    return attribValue.equals(cond_value);
                }
                return true;
            }
            case 7: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                String attrValue = this.getAttributeValue(attrName);
                StringTokenizer tok = new StringTokenizer(attrValue, " ");
                while (tok.hasMoreElements()) {
                    String token = tok.nextToken();
                    if (!token.equals(((AttributeCondition)cond).getValue())) continue;
                    return true;
                }
                break;
            }
            case 8: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                String attrValue = this.getAttributeValue(attrName);
                int attrlen = attrValue.length();
                String condstr = ((AttributeCondition)cond).getValue();
                int condlen = condstr.length();
                if (condlen == attrlen) {
                    return attrValue.equals(condstr);
                }
                if (condlen >= attrlen) break;
                return attrValue.startsWith(condstr) && attrValue.charAt(condlen) == '-';
            }
            case 14: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                return this.getAttributeValue(attrName).startsWith(((AttributeCondition)cond).getValue());
            }
            case 15: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                return this.getAttributeValue(attrName).endsWith(((AttributeCondition)cond).getValue());
            }
            case 16: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                return this.getAttributeValue(attrName).contains(((AttributeCondition)cond).getValue());
            }
            case 6: {
                String attrName = ((LangCondition)cond).getLang();
                String lang = this.getLanguage();
                return lang.startsWith(attrName);
            }
            case 2: {
                return !this.matchCondition(((NegativeCondition)cond).getCondition(), simple);
            }
            case 10: {
                if (!this.matches((Selector)simple)) break;
                String pseudoClassName = ((AttributeCondition)cond).getLocalName();
                String cond_value = ((AttributeCondition)cond).getValue();
                String argument = null;
                if (pseudoClassName == null) {
                    int idxparen = cond_value.indexOf(40);
                    if (idxparen != -1) {
                        int idxp1;
                        int lm1 = cond_value.length() - 1;
                        if (lm1 <= (idxp1 = idxparen + 1) || cond_value.charAt(lm1) != ')') break;
                        pseudoClassName = cond_value.substring(0, idxparen);
                        argument = cond_value.substring(idxp1, lm1);
                    } else {
                        pseudoClassName = cond_value;
                    }
                } else if (cond_value != null) {
                    argument = cond_value;
                }
                pseudoClassName = pseudoClassName.toLowerCase(Locale.US).intern();
                if ("first-child".equals(pseudoClassName)) {
                    return this.isFirstChild();
                }
                if ("last-child".equals(pseudoClassName)) {
                    return this.isLastChild();
                }
                if ("only-child".equals(pseudoClassName)) {
                    return this.isOnlyChild();
                }
                if ("first-of-type".equals(pseudoClassName)) {
                    return this.isFirstOfType();
                }
                if ("last-of-type".equals(pseudoClassName)) {
                    return this.isLastOfType();
                }
                if ("only-of-type".equals(pseudoClassName)) {
                    return this.isOnlyOfType();
                }
                if ("link".equals(pseudoClassName)) {
                    return this.isNotVisitedLink();
                }
                if ("visited".equals(pseudoClassName)) {
                    return this.isVisitedLink();
                }
                if ("target".equals(pseudoClassName)) {
                    return this.isTarget();
                }
                if ("root".equals(pseudoClassName)) {
                    return this.isRoot();
                }
                if ("empty".equals(pseudoClassName)) {
                    return this.isEmpty();
                }
                if ("blank".equals(pseudoClassName)) {
                    return this.isBlank();
                }
                if ("disabled".equals(pseudoClassName)) {
                    return this.isDisabled();
                }
                if ("enabled".equals(pseudoClassName)) {
                    return this.isEnabled();
                }
                if ("read-write".equals(pseudoClassName)) {
                    return this.isReadWrite();
                }
                if ("read-only".equals(pseudoClassName)) {
                    return !this.isReadWrite();
                }
                if ("placeholder-shown".equals(pseudoClassName)) {
                    return this.isPlaceholderShown();
                }
                if ("default".equals(pseudoClassName)) {
                    return this.isUIDefault();
                }
                if ("checked".equals(pseudoClassName)) {
                    return this.isChecked();
                }
                if ("indeterminate".equals(pseudoClassName)) {
                    return this.isIndeterminate();
                }
                if (pseudoClassName.equals("matches")) {
                    return this.matches(AbstractSelectorMatcher.parseSelector(argument)) >= 0;
                }
                if (pseudoClassName.equals("not")) {
                    return this.matches(AbstractSelectorMatcher.parseSelector(argument)) < 0;
                }
                if (pseudoClassName.equals("has")) {
                    return this.scopeMatch(argument, simple) >= 0;
                }
                if (pseudoClassName.equals("nth-child")) {
                    return this.isNthChild(argument);
                }
                if (pseudoClassName.equals("nth-last-child")) {
                    return this.isNthLastChild(argument);
                }
                if (pseudoClassName.equals("nth-of-type")) {
                    return this.isNthOfType(argument);
                }
                if (pseudoClassName.equals("nth-last-of-type")) {
                    return this.isNthLastOfType(argument);
                }
                return this.isActivePseudoClass(pseudoClassName);
            }
            case 18: {
                if (!this.matches((Selector)simple)) break;
                return ((AttributeCondition)cond).getLocalName().equals(this.getPseudoElement());
            }
            case 0: {
                CombinatorCondition comb = (CombinatorCondition)cond;
                return this.matchCondition(comb.getFirstCondition(), simple) && this.matchCondition(comb.getSecondCondition(), simple);
            }
            case 11: {
                return this.matches((Selector)simple) && this.isOnlyChild();
            }
            case 12: {
                return this.matches((Selector)simple) && this.isOnlyOfType();
            }
            case 3: {
                if (!this.matches((Selector)simple)) break;
                PositionalCondition2 pcond = (PositionalCondition2)cond;
                int pos = pcond.getOffset();
                int factor = pcond.getFactor();
                if (pcond.getType()) {
                    if (pcond.isForwardCondition()) {
                        return this.isNthOfType(factor, pos);
                    }
                    return this.isNthLastOfType(factor, pos);
                }
                int idx = pcond.isForwardCondition() ? this.indexOf(pcond.getOfList()) : this.reverseIndexOf(pcond.getOfList());
                if (idx == -1) {
                    return false;
                }
                return factor == 0 ? idx == 0 : Math.floorMod(idx -= pos, factor) == 0;
            }
            case 17: {
                if (!this.matches((Selector)simple)) break;
                String name = ((ArgumentCondition)cond).getName();
                SelectorList selist = ((ArgumentCondition)cond).getSelectors();
                if ("not".equals(name)) {
                    for (int i = 0; i < selist.getLength(); ++i) {
                        if (!this.matches(selist.item(i))) continue;
                        return false;
                    }
                    return true;
                }
                if ("has".equals(name)) {
                    for (int i = 0; i < selist.getLength(); ++i) {
                        if (!this.scopeMatch(selist.item(i), simple)) continue;
                        return true;
                    }
                    return false;
                }
                if (!"matches".equals(name)) break;
                return this.matches(selist) >= 0;
            }
            case 1: {
                CombinatorCondition comb = (CombinatorCondition)cond;
                return this.matchCondition(comb.getFirstCondition(), simple) || this.matchCondition(comb.getSecondCondition(), simple);
            }
        }
        return false;
    }

    protected boolean matchesClass(String cond_value) {
        String classAttr = this.getClassAttribute();
        if (!DOMTokenSetImpl.checkMultipleValue(classAttr)) {
            return classAttr.trim().equalsIgnoreCase(cond_value);
        }
        StringTokenizer st = new StringTokenizer(classAttr);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(cond_value)) continue;
            return true;
        }
        return false;
    }

    private int scopeMatch(String subselector, SimpleSelector scope) {
        SelectorList selist = AbstractSelectorMatcher.parseSelector(scope.toString() + subselector);
        if (selist == null) {
            return -1;
        }
        int sz = selist.getLength();
        OMCSSStyleRule.Specifity matchedsp = null;
        int matchedIdx = -1;
        for (int i = 0; i < sz; ++i) {
            Selector sel = selist.item(i);
            if (!this.scopeMatch(sel, scope)) continue;
            OMCSSStyleRule.Specifity sp = new OMCSSStyleRule.Specifity(sel);
            if (matchedsp != null && OMCSSStyleRule.Specifity.selectorCompare(matchedsp, sp) >= 0) continue;
            matchedsp = sp;
            matchedIdx = i;
        }
        return matchedIdx;
    }

    private boolean scopeMatch(Selector selector, SimpleSelector scope) {
        switch (selector.getSelectorType()) {
            case 0: 
            case 4: {
                return this.scopeMatch((Selector)new DescendantSelectorImpl((Selector)scope, (SimpleSelector)selector), scope);
            }
            case 11: {
                return this.scopeMatchChild((DescendantSelector)selector);
            }
            case 12: {
                return this.scopeMatchDirectAdjacent((SiblingSelector)selector);
            }
        }
        return false;
    }

    protected abstract boolean scopeMatchChild(DescendantSelector var1);

    protected abstract boolean scopeMatchDirectAdjacent(SiblingSelector var1);

    protected boolean isFormElement() {
        String tagname = this.getLocalName();
        return tagname.equals("input") || tagname.equals("button") || tagname.equals("select") || tagname.equals("optgroup") || tagname.equals("option") || tagname.equals("textarea") || tagname.equals("keygen") || tagname.equals("fieldset");
    }

    protected abstract boolean isNotVisitedLink();

    protected abstract boolean isVisitedLink();

    protected abstract boolean isTarget();

    protected abstract boolean isRoot();

    protected abstract boolean isEmpty();

    protected abstract boolean isBlank();

    protected abstract boolean isDisabled();

    protected boolean isReadWrite() {
        if ("true".equals(this.getAttributeValue("contenteditable").toLowerCase(Locale.US))) {
            return true;
        }
        return this.isEnabled();
    }

    protected boolean isPlaceholderShown() {
        return this.hasAttribute("placeholder");
    }

    protected boolean isUIDefault() {
        String tagname = this.getLocalName();
        if ("button".equals(tagname)) {
            return "submit".equals(this.getAttributeValue("type").toLowerCase(Locale.US)) && this.isDefaultButton();
        }
        if ("option".equals(tagname)) {
            return this.hasAttribute("selected");
        }
        if ("input".equals(tagname)) {
            if (this.hasAttribute("checked")) {
                return true;
            }
            String type = this.getAttributeValue("type").toLowerCase(Locale.US);
            if ("submit".equals(type) || "image".equals(type)) {
                return this.isDefaultButton();
            }
        }
        return false;
    }

    protected boolean isChecked() {
        String tagname = this.getLocalName();
        if ("input".equals(tagname)) {
            String type = this.getAttributeValue("type").toLowerCase(Locale.US);
            return ("checkbox".equals(type) || "radio".equals(type)) && this.hasAttribute("checked");
        }
        if ("option".equals(tagname)) {
            return this.hasAttribute("selected");
        }
        return false;
    }

    protected boolean isIndeterminate() {
        String s = this.getAttributeValue("indeterminate").toLowerCase(Locale.US);
        return s.length() != 0 && !s.equals("false");
    }

    protected abstract AbstractSelectorMatcher getParentSelectorMatcher();

    protected abstract AbstractSelectorMatcher getPreviousSiblingSelectorMatcher();

    protected abstract boolean isFirstChild();

    protected abstract boolean isLastChild();

    protected boolean isOnlyChild() {
        return this.isFirstChild() && this.isLastChild();
    }

    protected abstract boolean isFirstOfType();

    protected abstract boolean isLastOfType();

    protected boolean isOnlyOfType() {
        return this.isFirstOfType() && this.isLastOfType();
    }

    private boolean isNthChild(String expression) {
        MyAnBExpression expr = new MyAnBExpression();
        try {
            expr.parse(expression);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int idx = this.indexOf(expr.getSelectorList());
        if (idx == -1) {
            return false;
        }
        int step = expr.getStep();
        return step == 0 ? idx == 0 : Math.floorMod(idx -= expr.getOffset(), step) == 0;
    }

    private boolean isNthLastChild(String expression) {
        MyAnBExpression expr = new MyAnBExpression();
        try {
            expr.parse(expression);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int idx = this.reverseIndexOf(expr.getSelectorList());
        if (idx == -1) {
            return false;
        }
        int step = expr.getStep();
        return step == 0 ? idx == 0 : Math.floorMod(idx -= expr.getOffset(), step) == 0;
    }

    private boolean isNthOfType(String expression) {
        MyAnBExpression expr = new MyAnBExpression();
        try {
            expr.parse(expression);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return this.isNthOfType(expr.getStep(), expr.getOffset());
    }

    private boolean isNthLastOfType(String expression) {
        MyAnBExpression expr = new MyAnBExpression();
        try {
            expr.parse(expression);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return this.isNthLastOfType(expr.getStep(), expr.getOffset());
    }

    private static SelectorList parseSelector(String selText) {
        SelectorList list;
        if (selText.length() == 0) {
            return null;
        }
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selText));
        try {
            list = parser.parseSelectors(source);
        }
        catch (IOException e) {
            list = null;
        }
        catch (RuntimeException e) {
            list = null;
        }
        return list;
    }

    protected boolean isEnabled() {
        return this.isFormElement() && !this.isDisabled();
    }

    protected abstract int indexOf(SelectorList var1);

    protected abstract int reverseIndexOf(SelectorList var1);

    protected abstract boolean isNthOfType(int var1, int var2);

    protected abstract boolean isNthLastOfType(int var1, int var2);

    protected abstract boolean isDefaultButton();

    protected abstract String getNamespaceURI();

    protected abstract String getAttributeValue(String var1);

    protected abstract boolean hasAttribute(String var1);

    protected String getId() {
        String idAttr = this.getAttributeValue("id");
        if (idAttr.length() == 0 && (idAttr = this.getAttributeValue("ID")).length() == 0) {
            idAttr = this.getAttributeValue("Id");
        }
        return idAttr;
    }

    protected abstract String getLanguage();

    public static void findStatePseudoClasses(Selector selector, List<String> statePseudoClasses) {
        switch (selector.getSelectorType()) {
            case 0: {
                Condition condition = ((ConditionalSelector)selector).getCondition();
                if (condition.getConditionType() == 10) {
                    int idxp;
                    String pseudoClass = ((AttributeCondition)condition).getLocalName();
                    if (pseudoClass == null) {
                        pseudoClass = ((AttributeCondition)condition).getValue();
                    }
                    if ((idxp = pseudoClass.indexOf(40)) != -1) {
                        pseudoClass = pseudoClass.substring(0, idxp);
                    }
                    if ((pseudoClass = pseudoClass.toLowerCase(Locale.US).intern()) != "first-child" && pseudoClass != "last-child" && pseudoClass != "only-child" && pseudoClass != "link" && pseudoClass != "visited" && pseudoClass != "target" && pseudoClass != "root" && pseudoClass != "empty" && pseudoClass != "blank" && pseudoClass != "matches" && pseudoClass != "not" && pseudoClass != "has" && pseudoClass != "dir" && pseudoClass != "lang" && pseudoClass != "any-link" && pseudoClass != "scope" && pseudoClass != "empty" && pseudoClass != "blank" && pseudoClass != "nth-child" && pseudoClass != "nth-last-child" && pseudoClass != "nth-of-type" && pseudoClass != "nth-last-of-type" && pseudoClass != "disabled" && pseudoClass != "enabled" && pseudoClass != "read-write" && pseudoClass != "read-only" && pseudoClass != "placeholder-shown" && pseudoClass != "default" && pseudoClass != "checked" && pseudoClass != "indeterminate" && pseudoClass != "nth-column" && pseudoClass != "nth-last-column") {
                        statePseudoClasses.add(pseudoClass);
                        break;
                    }
                }
                AbstractSelectorMatcher.findStatePseudoClasses((Selector)((ConditionalSelector)selector).getSimpleSelector(), statePseudoClasses);
                break;
            }
            case 10: 
            case 11: {
                AbstractSelectorMatcher.findStatePseudoClasses((Selector)((DescendantSelector)selector).getSimpleSelector(), statePseudoClasses);
                AbstractSelectorMatcher.findStatePseudoClasses(((DescendantSelector)selector).getAncestorSelector(), statePseudoClasses);
                break;
            }
            case 12: {
                AbstractSelectorMatcher.findStatePseudoClasses((Selector)((SiblingSelector)selector).getSiblingSelector(), statePseudoClasses);
            }
        }
    }

    public String toString() {
        String classAttr;
        StringBuilder sb = new StringBuilder();
        AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher();
        if (parentSM != null) {
            sb.append(parentSM.getLocalName()).append(' ').append('>').append(' ');
        }
        if (this.localName != null) {
            sb.append(this.localName);
        }
        if ((classAttr = this.getClassAttribute()).length() != 0) {
            sb.append('.').append(classAttr);
        } else if (this.getId().length() != 0) {
            sb.append('#').append(this.getId());
        }
        if (this.pseudoElt != null) {
            sb.append(':').append(this.pseudoElt);
        }
        return sb.toString();
    }

    static class ArraySelectorList
    implements SelectorList {
        Selector[] array;

        ArraySelectorList(Selector[] array) {
            this.array = array;
        }

        public int getLength() {
            return this.array.length;
        }

        public Selector item(int index) {
            if (index < 0 || index >= this.array.length) {
                return null;
            }
            return this.array[index];
        }
    }

    protected static class MyAnBExpression
    extends AnBExpression {
        protected MyAnBExpression() {
        }

        @Override
        protected SelectorList parseSelector(String selText) {
            return AbstractSelectorMatcher.parseSelector(selText);
        }
    }

    private class DescendantSelectorImpl
    implements DescendantSelector {
        SimpleSelector simpleSelector;
        Selector scope;

        DescendantSelectorImpl(Selector scope, SimpleSelector simpleSelector) {
            this.scope = scope;
            this.simpleSelector = simpleSelector;
        }

        public short getSelectorType() {
            return 10;
        }

        public Selector getAncestorSelector() {
            return this.scope;
        }

        public SimpleSelector getSimpleSelector() {
            return this.simpleSelector;
        }
    }
}

