/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.LexicalPropertyListener;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public abstract class BaseCSSDeclarationRule
extends BaseCSSRule
implements CSSDeclarationRule {
    private AbstractCSSStyleDeclaration declaration = null;
    StyleDeclarationErrorHandler sdErrorHandler = null;

    protected BaseCSSDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, short origin) {
        super(parentSheet, type, origin);
        this.declaration = parentSheet.createCSSStyleDeclaration(this);
    }

    protected BaseCSSDeclarationRule() {
        super(null, (short)1, (short)0);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.clear();
        Parser parser = this.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        PropertyDocumentHandler handler = this.createPropertyDocumentHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
    }

    void clear() {
        this.declaration.clear();
    }

    PropertyDocumentHandler createPropertyDocumentHandler() {
        return new DeclarationPropertyDocumentHandler();
    }

    LexicalPropertyListener getLexicalPropertyListener() {
        return this.declaration;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseCSSDeclarationRule other = (BaseCSSDeclarationRule)obj;
        return !(this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration));
    }

    @Override
    public BaseCSSDeclarationRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        BaseCSSDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Short.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (BaseCSSDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        return rule;
    }

    void setWrappedStyle(BaseCSSStyleDeclaration style) {
        this.declaration = new StyleWrapper(style);
    }

    class DeclarationPropertyDocumentHandler
    extends PropertyDocumentHandler {
        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }
    }

    private class StyleWrapper
    extends BaseCSSStyleDeclaration {
        private StyleWrapper(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }
}

