/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.DOMCSSStyleDeclaration;
import java.util.Iterator;
import org.w3c.dom.css.CSSRule;

public abstract class DOMCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    private CSSNode ownerNode = null;

    public DOMCSSStyleSheet(String title, CSSNode ownerNode, MediaQueryList media, CSSRule ownerRule, short origin) {
        super(title, media, ownerRule, origin);
        this.ownerNode = ownerNode;
    }

    @Override
    public CSSNode getOwnerNode() {
        return this.ownerNode;
    }

    @Override
    public String getHref() {
        String href = super.getHref();
        if (href == null && this.ownerNode != null) {
            return this.ownerNode.getOwnerDocument().getBaseURL().toExternalForm();
        }
        return href;
    }

    public abstract DOMCSSStyleDeclaration createComputedCSSStyle();

    public abstract DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet var1);

    protected abstract DOMCSSStyleSheet createCSSStyleSheet(String var1, CSSNode var2, MediaQueryList var3, CSSRule var4, short var5);

    @Override
    public DOMCSSStyleSheet clone() {
        DOMCSSStyleSheet myClone = this.createCSSStyleSheet(this.getTitle(), this.getOwnerNode(), this.getMedia(), this.getOwnerRule(), this.getOrigin());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone));
        }
        return myClone;
    }
}

