/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCounterStyleRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import org.w3c.dom.DOMException;

public class OMCSSCounterStyleRule
extends BaseCSSDeclarationRule
implements CSSCounterStyleRule {
    private String name = null;

    public OMCSSCounterStyleRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)11, origin);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) throws DOMException {
        if (name == null || "none".equalsIgnoreCase(name)) {
            throw new DOMException(12, "Bad counter-style name: " + name);
        }
        this.name = name;
    }

    @Override
    public String getCssText() {
        return "@counter-style " + this.getName() + " {" + this.getStyle().getCssText() + '}';
    }

    @Override
    public String getMinifiedCssText() {
        return "@counter-style " + this.getName() + " {" + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int lenm1 = cssText.length() - 1;
        int endIdx = cssText.lastIndexOf(125);
        int idx = cssText.indexOf(123);
        if (idx < 2 || endIdx != lenm1 || idx == endIdx) {
            throw new DOMException(12, "Bad counter-style rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@counter-style ")) {
            throw new DOMException(12, "Not a @counter-style rule: " + cssText);
        }
        String name = cssText.substring(15, idx).trim();
        String declaration = cssText.substring(idx + 1, lenm1);
        super.setCssText(declaration);
        this.setName(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getType();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSCounterStyleRule other = (OMCSSCounterStyleRule)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public OMCSSCounterStyleRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSCounterStyleRule rule = new OMCSSCounterStyleRule(parentSheet, this.getOrigin());
        rule.setName(this.getName());
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        return rule;
    }
}

