/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSFontFeatureValuesMap;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.FontFeatureValuesHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;

public class OMCSSFontFeatureValuesRule
extends BaseCSSRule
implements CSSFontFeatureValuesRule {
    String[] fontFamily = null;
    private CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
    private HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;

    protected OMCSSFontFeatureValuesRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)14, origin);
    }

    @Override
    public String[] getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public CSSFontFeatureValuesMap getAnnotation() {
        return this.annotation;
    }

    @Override
    public CSSFontFeatureValuesMap getOrnaments() {
        return this.ornaments;
    }

    @Override
    public CSSFontFeatureValuesMap getStylistic() {
        return this.stylistic;
    }

    @Override
    public CSSFontFeatureValuesMap getSwash() {
        return this.swash;
    }

    @Override
    public CSSFontFeatureValuesMap getCharacterVariant() {
        return this.characterVariant;
    }

    @Override
    public CSSFontFeatureValuesMap getStyleset() {
        return this.styleset;
    }

    @Override
    public void enableMap(String featureValueName) {
        if (!((featureValueName = featureValueName.toLowerCase(Locale.US)).equals("annotation") || featureValueName.equals("ornaments") || featureValueName.equals("stylistic") || featureValueName.equals("swash") || featureValueName.equals("character-variant") || featureValueName.equals("styleset"))) {
            if (this.mapmap == null) {
                this.mapmap = new HashMap();
            }
            this.mapmap.put(featureValueName, new CSSFontFeatureValuesMapImpl());
        }
    }

    @Override
    public CSSFontFeatureValuesMap getFeatureValuesMap(String featureValueName) {
        Object map = (featureValueName = featureValueName.toLowerCase(Locale.US)).equals("annotation") ? this.annotation : (featureValueName.equals("ornaments") ? this.ornaments : (featureValueName.equals("stylistic") ? this.stylistic : (featureValueName.equals("swash") ? this.swash : (featureValueName.equals("character-variant") ? this.characterVariant : (featureValueName.equals("styleset") ? this.styleset : (this.mapmap == null ? null : (CSSFontFeatureValuesMap)this.mapmap.get(featureValueName)))))));
        return map;
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("@font-feature-values ");
        buf.append(this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            buf.append(',').append(' ').append(this.fontFamily[i]);
        }
        buf.append(" {\n");
        if (!this.swash.isEmpty()) {
            buf.append("@swash {\n");
            this.appendFeatureString(buf, this.swash);
            buf.append('}').append('\n');
        }
        if (!this.annotation.isEmpty()) {
            buf.append("@annotation {\n");
            this.appendFeatureString(buf, this.annotation);
            buf.append('}').append('\n');
        }
        if (!this.ornaments.isEmpty()) {
            buf.append("@ornaments {\n");
            this.appendFeatureString(buf, this.ornaments);
            buf.append('}').append('\n');
        }
        if (!this.stylistic.isEmpty()) {
            buf.append("@stylistic {\n");
            this.appendFeatureString(buf, this.stylistic);
            buf.append('}').append('\n');
        }
        if (!this.styleset.isEmpty()) {
            buf.append("@styleset {\n");
            this.appendFeatureString(buf, this.styleset);
            buf.append('}');
        }
        if (!this.characterVariant.isEmpty()) {
            buf.append("@character-variant {\n");
            this.appendFeatureString(buf, this.characterVariant);
            buf.append('}').append('\n');
        }
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> me : this.mapmap.entrySet()) {
                buf.append('@').append(me.getKey()).append(" {\n");
                this.appendFeatureString(buf, me.getValue());
                buf.append('}').append('\n');
            }
        }
        buf.append('}').append('\n');
        return buf.toString();
    }

    private void appendFeatureString(StringBuilder buf, CSSFontFeatureValuesMapImpl featureMap) {
        for (Map.Entry me : featureMap.featureMap.entrySet()) {
            buf.append((String)me.getKey()).append(':').append(' ');
            int[] values = (int[])me.getValue();
            buf.append(values[0]);
            for (int i = 1; i < values.length; ++i) {
                buf.append(' ').append(values[i]);
            }
            buf.append(';').append('\n');
        }
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("@font-feature-values ");
        buf.append(this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            buf.append(',').append(this.fontFamily[i]);
        }
        buf.append('{');
        if (!this.swash.isEmpty()) {
            buf.append("@swash{");
            this.appendMinifiedFeatureString(buf, this.swash);
            buf.append('}');
        }
        if (!this.annotation.isEmpty()) {
            buf.append("@annotation{");
            this.appendMinifiedFeatureString(buf, this.annotation);
            buf.append('}');
        }
        if (!this.ornaments.isEmpty()) {
            buf.append("@ornaments{");
            this.appendMinifiedFeatureString(buf, this.ornaments);
            buf.append('}');
        }
        if (!this.stylistic.isEmpty()) {
            buf.append("@stylistic{");
            this.appendMinifiedFeatureString(buf, this.stylistic);
            buf.append('}');
        }
        if (!this.styleset.isEmpty()) {
            buf.append("@styleset{");
            this.appendMinifiedFeatureString(buf, this.styleset);
            buf.append('}');
        }
        if (!this.characterVariant.isEmpty()) {
            buf.append("@character-variant{");
            this.appendMinifiedFeatureString(buf, this.characterVariant);
            buf.append('}');
        }
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> me : this.mapmap.entrySet()) {
                buf.append('@').append(me.getKey()).append('{');
                this.appendMinifiedFeatureString(buf, me.getValue());
                buf.append('}');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    private void appendMinifiedFeatureString(StringBuilder buf, CSSFontFeatureValuesMapImpl featureMap) {
        int szm1 = featureMap.featureMap.size() - 1;
        String[] names = featureMap.featureMap.keySet().toArray(new String[0]);
        for (int i = 0; i <= szm1; ++i) {
            String name = names[i];
            buf.append(name).append(':');
            int[] values = (int[])featureMap.featureMap.get(name);
            buf.append(values[0]);
            for (int j = 1; j < values.length; ++j) {
                buf.append(' ').append(values[j]);
            }
            if (i == szm1) continue;
            buf.append(';');
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        int len = (cssText = cssText.trim()).length();
        if (len < 21 || cssText.charAt(len - 1) != '}') {
            throw new DOMException(12, "Invalid @font-feature-values rule: " + cssText);
        }
        CharSequence atkeyword = cssText.subSequence(0, 21);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@font-feature-values ")) {
            throw new DOMException(12, "Not a @font-feature-values rule: " + cssText);
        }
        String body = cssText.substring(21, len);
        MyFontFeatureValuesHandler handler = new MyFontFeatureValuesHandler();
        CSSParser parser = new CSSParser();
        parser.setDocumentHandler(handler);
        parser.parseFontFeatureValuesBody(body);
    }

    @Override
    public OMCSSFontFeatureValuesRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSFontFeatureValuesRule rule = new OMCSSFontFeatureValuesRule(parentSheet, this.getOrigin());
        rule.fontFamily = this.fontFamily;
        rule.annotation = this.annotation;
        rule.ornaments = this.ornaments;
        rule.stylistic = this.stylistic;
        rule.swash = this.swash;
        rule.styleset = this.styleset;
        rule.characterVariant = this.characterVariant;
        return rule;
    }

    static class CSSFontFeatureValuesMapImpl
    implements CSSFontFeatureValuesMap {
        private LinkedHashMap<String, int[]> featureMap = new LinkedHashMap();

        CSSFontFeatureValuesMapImpl() {
        }

        @Override
        public int[] get(String featureValueName) {
            return this.featureMap.get(featureValueName);
        }

        @Override
        public void set(String featureValueName, int ... values) {
            if (values == null) {
                throw new DOMException(12, "Must provide at least one value");
            }
            this.featureMap.put(featureValueName, values);
        }

        public boolean isEmpty() {
            return this.featureMap.isEmpty();
        }
    }

    private class MyFontFeatureValuesHandler
    implements FontFeatureValuesHandler {
        private CSSFontFeatureValuesMap currentMap = null;

        MyFontFeatureValuesHandler() {
        }

        @Override
        public void startFontFeatures(String name) {
            OMCSSFontFeatureValuesRule.this.fontFamily = name.split("\\s*,\\s*");
        }

        @Override
        public void endFontFeatures() {
        }

        @Override
        public void startFeatureMap(String mapname) {
            OMCSSFontFeatureValuesRule.this.enableMap(mapname);
            this.currentMap = OMCSSFontFeatureValuesRule.this.getFeatureValuesMap(mapname);
        }

        @Override
        public void endFeatureMap() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            LinkedList<Integer> values = new LinkedList<Integer>();
            while (value != null) {
                if (value.getLexicalUnitType() != 13) {
                    throw new CSSException("Found non-integer value: " + value.toString());
                }
                values.add(value.getIntegerValue());
                value = value.getNextLexicalUnit();
            }
            int[] intvals = new int[values.size()];
            for (int i = 0; i < intvals.length; ++i) {
                intvals[i] = (Integer)values.get(i);
            }
            this.currentMap.set(name, intvals);
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
        }

        public void endMedia(SACMediaList media) throws CSSException {
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
        }

        public void endFontFace() throws CSSException {
        }

        public void startSelector(SelectorList selectors) throws CSSException {
        }

        public void endSelector(SelectorList selectors) throws CSSException {
        }
    }
}

