/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSFontFaceRule;
import io.sf.carte.doc.style.css.om.OMCSSPageRule;
import io.sf.carte.doc.style.css.om.OMCSSStyleRule;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;

public abstract class OMCSSGroupingRule
extends BaseCSSRule {
    private CSSRuleArrayList cssRules;

    protected OMCSSGroupingRule(AbstractCSSStyleSheet parentSheet, short type, short origin) {
        super(parentSheet, type, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    OMCSSGroupingRule(AbstractCSSStyleSheet parentSheet, OMCSSGroupingRule copyfrom) {
        super(parentSheet, copyfrom.getType(), copyfrom.getOrigin());
        this.cssRules = new CSSRuleArrayList(copyfrom.getCssRules().getLength());
        Iterator it = copyfrom.getCssRules().iterator();
        while (it.hasNext()) {
            AbstractCSSRule cloned = ((AbstractCSSRule)it.next()).clone(parentSheet);
            cloned.setParentRule(this);
            this.cssRules.add(cloned);
        }
    }

    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in rule list");
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        RuleDocumentHandler handler = new RuleDocumentHandler();
        handler.setCurrentInsertionIndex(index);
        Parser parser = this.createSACParser();
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(15, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return index;
    }

    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in rule list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    public int insertRule(AbstractCSSRule cssrule, int index) {
        cssrule.setParentRule(this);
        return this.cssRules.insertRule(cssrule, index);
    }

    public int addRule(AbstractCSSRule cssrule) {
        int len = this.cssRules.getLength();
        this.cssRules.add(cssrule);
        return len;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (parentSS == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        AbstractCSSStyleSheet css = (AbstractCSSStyleSheet)parentSS.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        StringReader re = new StringReader(cssText);
        InputSource source = new InputSource((Reader)re);
        try {
            css.parseCSSStyleSheet(source);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        this.cssRules.clear();
        this.cssRules.addAll(css.getCssRules());
    }

    class RuleDocumentHandler
    implements DocumentHandler {
        private AbstractCSSRule currentRule = null;
        private int currentInsertionIndex = 0;
        private boolean active = true;

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.active = true;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.active = false;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.active = true;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentRule = new OMCSSPageRule(OMCSSGroupingRule.this.getParentStyleSheet(), OMCSSGroupingRule.this.getOrigin());
                if (name != null) {
                    ((OMCSSPageRule)this.currentRule).setSelectorText(name);
                }
                if (pseudo_page != null) {
                    Parser parser = OMCSSGroupingRule.this.createSACParser();
                    InputSource source = new InputSource((Reader)new StringReader(pseudo_page));
                    try {
                        ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(parser.parseSelectors(source));
                    }
                    catch (IOException iOException) {}
                } else {
                    ((CSSStyleDeclarationRule)this.currentRule).setSelectorText("");
                }
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = OMCSSGroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            if (this.active) {
                this.currentRule = new OMCSSFontFaceRule(OMCSSGroupingRule.this.getParentStyleSheet(), OMCSSGroupingRule.this.getOrigin());
            }
        }

        public void endFontFace() throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = OMCSSGroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            if (this.active) {
                if (this.currentRule == null) {
                    this.currentRule = OMCSSGroupingRule.this.getParentStyleSheet().createCSSStyleRule();
                }
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (this.active && this.currentRule instanceof OMCSSStyleRule) {
                OMCSSGroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.active) {
                String importantString = null;
                if (important) {
                    importantString = "important";
                }
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }
    }
}

