/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSGroupingRule;
import org.w3c.dom.DOMException;

public class OMCSSNamespaceRule
extends BaseCSSRule
implements CSSNamespaceRule {
    private String namespaceURI = null;
    private String prefix = null;

    OMCSSNamespaceRule(AbstractCSSStyleSheet parentSheet, short origin, String prefix, String namespaceURI) {
        super(parentSheet, (short)10, origin);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        AbstractCSSStyleSheet parentSheet = this.getParentStyleSheet();
        if (parentSheet != null) {
            parentSheet.unregisterNamespace(this.namespaceURI);
            parentSheet.registerNamespace(this);
            this.updateSelectorText(parentSheet.getCssRules());
        }
    }

    private void updateSelectorText(CSSRuleArrayList rules) {
        for (AbstractCSSRule rule : rules) {
            short type = rule.getType();
            if (type == 1) {
                ((CSSStyleDeclarationRule)rule).updateSelectorText();
                continue;
            }
            if (!(rule instanceof OMCSSGroupingRule)) continue;
            this.updateSelectorText(((OMCSSGroupingRule)rule).getCssRules());
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "Cannot modify a namespace rule");
    }

    @Override
    public String getCssText() {
        if (this.namespaceURI == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(this.namespaceURI.length() + 32);
        buf.append("@namespace ");
        if (this.prefix != null) {
            buf.append(this.prefix).append(' ');
        }
        buf.append("url('").append(this.namespaceURI).append("');");
        return buf.toString();
    }

    @Override
    public OMCSSNamespaceRule clone(AbstractCSSStyleSheet parentSheet) {
        return new OMCSSNamespaceRule(parentSheet, this.getOrigin(), this.prefix, this.namespaceURI);
    }
}

