/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.w3c.CSSMarginRule;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;

public class OMCSSPageRule
extends CSSStyleDeclarationRule
implements CSSPageRule,
ExtendedCSSRule {
    LinkedList<CSSMarginRule> marginRules = null;

    public OMCSSPageRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("@page");
        if (this.getSelectorText().length() > 0) {
            buf.append(' ').append(this.getSelectorText());
        }
        buf.append(' ').append('{').append(this.getStyle().getCssText());
        if (this.marginRules != null) {
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                buf.append(((CSSMarginRule)it.next()).getCssText()).append('\n');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("@page");
        if (this.getSelectorText().length() > 0) {
            buf.append(' ').append(this.getSelectorText());
        }
        buf.append('{').append(this.getStyle().getMinifiedCssText());
        if (this.marginRules != null) {
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                buf.append(((AbstractCSSRule)it.next()).getMinifiedCssText()).append('\n');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String getSelectorText() {
        return super.getSelectorText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 10 || idx == -1) {
            throw new DOMException(12, "Invalid @page rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@page")) {
            throw new DOMException(12, "Not a @page rule: " + cssText);
        }
        String body = cssText.substring(5, len);
        super.setCssText(body);
    }

    void addMarginRule(CSSMarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new LinkedList();
        }
        this.marginRules.add(marginRule);
    }

    public LinkedList<CSSMarginRule> getMarginRules() {
        return this.marginRules;
    }

    @Override
    public OMCSSPageRule clone(AbstractCSSStyleSheet parentSheet) {
        return (OMCSSPageRule)super.clone(parentSheet);
    }
}

