/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import org.w3c.dom.DOMException;

public class OMCSSViewportRule
extends BaseCSSDeclarationRule {
    public OMCSSViewportRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)15, origin);
    }

    @Override
    public String getCssText() {
        return "@viewport {\n" + this.getStyle().getCssText() + "\n}\n";
    }

    @Override
    public String getMinifiedCssText() {
        return "@viewport{" + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        if (len < 15 || cssText.charAt(len - 1) != '}' || idx == -1) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@viewport")) {
            throw new DOMException(12, "Not a @viewport rule: " + cssText);
        }
        String empty = cssText.substring(9, idx).trim();
        if (empty.length() != 0) {
            throw new DOMException(12, "Invalid @viewport rule: " + cssText);
        }
        String body = cssText.substring(idx + 1, len - 1);
        super.setCssText(body);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getType();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSViewportRule other = (OMCSSViewportRule)obj;
        return super.equals(other);
    }

    @Override
    public OMCSSViewportRule clone(AbstractCSSStyleSheet parentSheet) {
        OMCSSViewportRule rule = new OMCSSViewportRule(parentSheet, this.getOrigin());
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        return rule;
    }
}

