/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSAttrValue
extends CSSStringValue {
    private String typeval = null;

    public CSSAttrValue() {
        this.setCSSUnitType((short)22);
    }

    protected CSSAttrValue(CSSAttrValue copied) {
        super(copied);
        this.typeval = copied.typeval;
    }

    @Override
    public String getCssText() {
        String attr = this.getStringValue();
        StringBuilder buf = new StringBuilder(attr.length() + 6);
        buf = this.typeval != null ? new StringBuilder(attr.length() + this.typeval.length() + 7) : new StringBuilder(attr.length() + 6);
        buf.append("attr(").append(this.getStringValue());
        if (this.typeval != null) {
            buf.append(' ').append(this.typeval);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        super.setLexicalUnit(lunit, subp, factory);
        this.typeval = this.nextLexicalUnit != null && (this.nextLexicalUnit.getLexicalUnitType() == 36 || this.nextLexicalUnit.getLexicalUnitType() == 35) ? this.nextLexicalUnit.getStringValue() : null;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        ValueFactory factory = new ValueFactory();
        AbstractCSSValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 22) {
            throw new DOMException(5, "Wrong attr value.");
        }
        this.setPlainCssText(cssval.getCssText());
        this.setStringValue(((CSSPrimitiveValue)((Object)cssval)).getStringValue());
        this.typeval = ((CSSAttrValue)cssval).typeval;
    }

    @Override
    protected void setUnescapedCssText(String css) throws DOMException {
        this.setPlainCssText(css);
    }

    public String getAttributeType() {
        return this.typeval;
    }

    @Override
    public CSSAttrValue clone() {
        return new CSSAttrValue(this);
    }
}

