/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSUnknownValue
extends AbstractCSSPrimitiveValue {
    public CSSUnknownValue() {
        this.setCSSUnitType((short)0);
    }

    protected CSSUnknownValue(CSSUnknownValue copied) {
        super(copied);
        this.setCssText(copied.getCssText());
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        String text;
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
        switch (lunit.getLexicalUnitType()) {
            case 0: {
                text = ",";
                break;
            }
            case 6: {
                text = "^";
                break;
            }
            case 10: {
                text = ">=";
                break;
            }
            case 8: {
                text = ">";
                break;
            }
            case 9: {
                text = "<=";
                break;
            }
            case 7: {
                text = "<";
                break;
            }
            case 2: {
                text = "-";
                break;
            }
            case 5: {
                text = "%";
                break;
            }
            case 3: {
                text = "*";
                break;
            }
            case 1: {
                text = "+";
                break;
            }
            case 4: {
                text = "/";
                break;
            }
            case 11: {
                text = "~";
                break;
            }
            default: {
                try {
                    float fv = lunit.getFloatValue();
                    text = Float.toString(fv);
                }
                catch (DOMException e) {
                    int iv = lunit.getIntegerValue();
                    text = Integer.toString(iv);
                }
                try {
                    String unittext = lunit.getDimensionUnitText();
                    text = text + unittext;
                    break;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
        this.setPlainCssText(text);
    }

    @Override
    public CSSUnknownValue clone() {
        return new CSSUnknownValue(this);
    }
}

