/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class OMCSSColorValue
extends AbstractCSSPrimitiveValue {
    public static final CSSNumberValue opaqueAlpha;
    private CSSRGBColor color = null;
    private boolean setAsHsl = false;

    OMCSSColorValue() {
        super((short)25);
        this.color = new CSSRGBColor();
    }

    protected OMCSSColorValue(OMCSSColorValue copied) {
        super(copied);
        this.color = copied.color.clone();
        this.setAsHsl = copied.setAsHsl;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        ValueFactory factory = new ValueFactory();
        AbstractCSSValue value = factory.parseProperty(cssText);
        if (value.getCssValueType() == 1) {
            short ptype = ((CSSPrimitiveValue)((Object)value)).getPrimitiveType();
            if (ptype == 21) {
                String ident = ((CSSPrimitiveValue)((Object)value)).getStringValue();
                String colorspec = ColorIdentifiers.getInstance().getColor(ident);
                if (colorspec != null) {
                    value = factory.parseProperty(colorspec);
                } else if ("transparent".equals(ident)) {
                    value = factory.parseProperty("rgba(0,0,0,0)");
                } else {
                    this.failSetCssText();
                }
            } else if (ptype != 25) {
                this.failSetCssText();
            }
            super.setCssText(cssText);
            this.set((OMCSSColorValue)value);
        } else {
            this.failSetCssText();
        }
    }

    private void failSetCssText() {
        throw new DOMException(13, "This property can only be set to a color value");
    }

    private void set(OMCSSColorValue setfrom) {
        this.color = setfrom.color;
        this.setAsHsl = setfrom.setAsHsl;
    }

    @Override
    public String getCssText() {
        String css;
        if (this.setAsHsl && (css = this.color.toHSLString()) != null) {
            return css;
        }
        return this.getRGBColorValue().toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return ((CSSRGBColor)this.getRGBColorValue()).toMinifiedString();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.getCssText();
    }

    @Override
    public RGBAColor getRGBColorValue() throws DOMException {
        if (this.color.red == null || this.color.green == null || this.color.blue == null) {
            throw new DOMException(11, "Color not set");
        }
        return this.color;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        LexicalUnit lu = lunit.getParameters();
        String func = lunit.getFunctionName();
        try {
            if ("rgb".equals(func) || "rgba".equals(func)) {
                AbstractCSSPrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                this.color.setRed(basiccolor);
                lu = lu.getNextLexicalUnit();
                boolean commaSyntax = lu.getLexicalUnitType() == 0;
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                this.color.setGreen(basiccolor);
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                lu = lu.getNextLexicalUnit();
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                this.color.setBlue(basiccolor);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    lu = lu.getNextLexicalUnit();
                    this.color.setAlpha(factory.createCSSPrimitiveValue(lu, subp));
                    lu = lu.getNextLexicalUnit();
                }
                this.setAsHsl = false;
            } else if ("hsl".equals(func) || "hsla".equals(func)) {
                AbstractCSSPrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float hue = basiccolor.getFloatValue((short)11) / 360.0f;
                boolean commaSyntax = (lu = lu.getNextLexicalUnit()).getLexicalUnitType() == 0;
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float sat = basiccolor.getFloatValue((short)2) / 100.0f;
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                lu = lu.getNextLexicalUnit();
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float light = basiccolor.getFloatValue((short)2) / 100.0f;
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    lu = lu.getNextLexicalUnit();
                    this.color.setAlpha(factory.createCSSPrimitiveValue(lu, subp));
                    lu = lu.getNextLexicalUnit();
                }
                this.translateHSL(hue, sat, light);
                this.setAsHsl = true;
            } else if ("hwb".equals(func)) {
                AbstractCSSPrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float hue = basiccolor.getFloatValue((short)11) / 360.0f;
                boolean commaSyntax = (lu = lu.getNextLexicalUnit()).getLexicalUnitType() == 0;
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float whiteness = basiccolor.getFloatValue((short)2) / 100.0f;
                if (commaSyntax) {
                    lu = lu.getNextLexicalUnit();
                }
                lu = lu.getNextLexicalUnit();
                basiccolor = factory.createCSSPrimitiveValue(lu, subp);
                float blackness = basiccolor.getFloatValue((short)2) / 100.0f;
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    lu = lu.getNextLexicalUnit();
                    this.color.setAlpha(factory.createCSSPrimitiveValue(lu, subp));
                    lu = lu.getNextLexicalUnit();
                }
                this.translateHWB(hue, whiteness, blackness);
            }
        }
        catch (RuntimeException e) {
            throw new DOMException(12, "Bad value: " + lunit.toString());
        }
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    void translateHSL(float hue, float sat, float light) {
        if (hue > 1.0f) {
            hue -= (float)Math.floor(hue);
        } else if (hue < 0.0f) {
            hue = hue - (float)Math.floor(hue) + 1.0f;
        }
        float m2 = light <= 0.5f ? light * (sat + 1.0f) : light + sat - light * sat;
        float m1 = light * 2.0f - m2;
        CSSNumberValue red = new CSSNumberValue();
        red.setFloatValue((short)2, this.hueToRgb(m1, m2, hue + 0.33333334f));
        CSSNumberValue green = new CSSNumberValue();
        green.setFloatValue((short)2, this.hueToRgb(m1, m2, hue));
        CSSNumberValue blue = new CSSNumberValue();
        blue.setFloatValue((short)2, this.hueToRgb(m1, m2, hue - 0.33333334f));
        this.color.red = red;
        this.color.green = green;
        this.color.blue = blue;
    }

    private float hueToRgb(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        } else if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return (m1 + (m2 - m1) * h * 6.0f) * 100.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2 * 100.0f;
        }
        if (h * 3.0f < 2.0f) {
            return (m1 + (m2 - m1) * (0.6666667f - h) * 6.0f) * 100.0f;
        }
        return m1 * 100.0f;
    }

    void translateHWB(float hue, float whiteness, float blackness) {
        float b;
        float g;
        float r;
        if (hue > 1.0f) {
            hue -= (float)Math.floor(hue);
        } else if (hue < 0.0f) {
            hue = hue - (float)Math.floor(hue) + 1.0f;
        }
        float fh = (float)Math.floor(hue *= 6.0f);
        float f = hue - fh;
        int ifh = (int)fh;
        if (ifh % 2 == 1) {
            f = 1.0f - f;
        }
        float value = 1.0f - blackness;
        float wv = whiteness + f * (value - whiteness);
        switch (ifh) {
            case 1: {
                r = wv;
                g = value;
                b = whiteness;
                break;
            }
            case 2: {
                r = whiteness;
                g = value;
                b = wv;
                break;
            }
            case 3: {
                r = whiteness;
                g = wv;
                b = value;
                break;
            }
            case 4: {
                r = wv;
                g = whiteness;
                b = value;
                break;
            }
            case 5: {
                r = value;
                g = whiteness;
                b = wv;
                break;
            }
            default: {
                r = value;
                g = wv;
                b = whiteness;
            }
        }
        CSSNumberValue red = new CSSNumberValue();
        red.setFloatValue((short)1, Math.round(r * 255.0f));
        CSSNumberValue green = new CSSNumberValue();
        green.setFloatValue((short)1, Math.round(g * 255.0f));
        CSSNumberValue blue = new CSSNumberValue();
        blue.setFloatValue((short)1, Math.round(b * 255.0f));
        this.color.red = red;
        this.color.green = green;
        this.color.blue = blue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OMCSSColorValue)) {
            return false;
        }
        OMCSSColorValue other = (OMCSSColorValue)obj;
        return !(this.color == null ? other.color != null : !this.color.equals(other.color));
    }

    @Override
    public OMCSSColorValue clone() {
        return new OMCSSColorValue(this);
    }

    static {
        CSSNumberValue alpha = new CSSNumberValue();
        alpha.setFloatValue((short)1, 1.0f);
        opaqueAlpha = alpha.immutable();
    }

    static class CSSRGBColor
    implements RGBAColor {
        private AbstractCSSPrimitiveValue red = null;
        private AbstractCSSPrimitiveValue green = null;
        private AbstractCSSPrimitiveValue blue = null;
        private AbstractCSSPrimitiveValue alpha = opaqueAlpha;

        CSSRGBColor() {
        }

        public void setRed(AbstractCSSPrimitiveValue red) {
            this.red = red;
        }

        @Override
        public AbstractCSSPrimitiveValue getRed() {
            return this.red;
        }

        public void setGreen(AbstractCSSPrimitiveValue green) {
            this.green = green;
        }

        @Override
        public AbstractCSSPrimitiveValue getGreen() {
            return this.green;
        }

        public void setBlue(AbstractCSSPrimitiveValue blue) {
            this.blue = blue;
        }

        @Override
        public AbstractCSSPrimitiveValue getBlue() {
            return this.blue;
        }

        public void setAlpha(AbstractCSSPrimitiveValue alpha) {
            this.alpha = alpha;
        }

        @Override
        public AbstractCSSPrimitiveValue getAlpha() {
            return this.alpha;
        }

        public String toString() {
            return this.toString(false);
        }

        String toMinifiedString() {
            return this.toString(true);
        }

        String toString(boolean minify) {
            StringBuilder buf;
            boolean nonOpaque;
            int r = this.red.getPrimitiveType() == 2 ? Math.round(this.red.getFloatValue((short)2) * 2.55f) : Math.round(this.red.getFloatValue((short)1));
            int g = this.green.getPrimitiveType() == 2 ? Math.round(this.green.getFloatValue((short)2) * 2.55f) : Math.round(this.green.getFloatValue((short)1));
            int b = this.blue.getPrimitiveType() == 2 ? Math.round(this.blue.getFloatValue((short)2) * 2.55f) : Math.round(this.blue.getFloatValue((short)1));
            boolean bl = nonOpaque = this.getAlpha().getFloatValue((short)1) != 1.0f;
            if (nonOpaque || r > 255 || g > 255 || b > 255) {
                StringBuilder buf2;
                if (minify) {
                    buf2 = new StringBuilder(21);
                    buf2.append("rgb(").append(this.red.getCssText()).append(',').append(this.green.getCssText()).append(',').append(this.blue.getCssText());
                    if (nonOpaque) {
                        buf2.append('/').append(this.getAlpha().getCssText());
                    }
                    buf2.append(')');
                } else {
                    buf2 = new StringBuilder(23);
                    buf2.append("rgb(").append(this.red.getCssText()).append(", ").append(this.green.getCssText()).append(", ").append(this.blue.getCssText());
                    if (nonOpaque) {
                        buf2.append(" / ").append(this.getAlpha().getCssText());
                    }
                    buf2.append(')');
                }
                return buf2.toString();
            }
            String hexr = Integer.toHexString(r);
            String hexg = Integer.toHexString(g);
            String hexb = Integer.toHexString(b);
            if (r != 0 && this.notSameChar(hexr) || g != 0 && this.notSameChar(hexg) || b != 0 && this.notSameChar(hexb)) {
                buf = new StringBuilder(7);
                buf.append('#');
                if (hexr.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexr);
                if (hexg.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexg);
                if (hexb.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexb);
            } else {
                buf = new StringBuilder(4);
                buf.append('#');
                buf.append(hexr.charAt(0));
                buf.append(hexg.charAt(0));
                buf.append(hexb.charAt(0));
            }
            return buf.toString();
        }

        private boolean notSameChar(String hexr) {
            return hexr.length() == 1 || hexr.charAt(0) != hexr.charAt(1);
        }

        Hsl toHSL() {
            float h;
            float max;
            float b;
            float g;
            float r;
            if (this.red.getPrimitiveType() == 2) {
                r = this.red.getFloatValue((short)2) * 0.01f;
            } else {
                r = this.red.getFloatValue((short)1);
                r /= 255.0f;
            }
            if (this.green.getPrimitiveType() == 2) {
                g = this.green.getFloatValue((short)2) * 0.01f;
            } else {
                g = this.green.getFloatValue((short)1);
                g /= 255.0f;
            }
            if (this.blue.getPrimitiveType() == 2) {
                b = this.blue.getFloatValue((short)2) * 0.01f;
            } else {
                b = this.blue.getFloatValue((short)1);
                b /= 255.0f;
            }
            if (r > 1.0f || g > 1.0f || b > 1.0f) {
                return null;
            }
            boolean maxr = false;
            boolean maxg = false;
            if (g > r) {
                max = g;
                maxg = true;
            } else {
                max = r;
                maxr = true;
            }
            if (b > max) {
                max = b;
                maxr = false;
                maxg = false;
            }
            float min = Math.min(r, g);
            if (max == (min = Math.min(min, b))) {
                h = 0.0f;
            } else if (maxr) {
                h = (g - b) / (max - min) * 60.0f + 360.0f;
                if ((h = (float)Math.IEEEremainder(h, 360.0)) < 0.0f) {
                    h += 360.0f;
                }
            } else if (maxg) {
                h = (b - r) / (max - min) * 60.0f + 120.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            } else {
                h = (r - g) / (max - min) * 60.0f + 240.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            }
            float l = (max + min) * 0.5f;
            Hsl hsl = new Hsl();
            hsl.s = max != min ? (l <= 0.5f ? Math.round((max - min) / l * 50.0f) : Math.round((max - min) / (1.0f - l) * 50.0f)) : 0;
            hsl.h = Math.round(h);
            if (hsl.h == 360) {
                hsl.h = 0;
            }
            hsl.l = Math.round(l * 100.0f);
            return hsl;
        }

        String toHSLString() {
            Hsl hsl = this.toHSL();
            if (hsl == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder(20);
            buf.append("hsl(").append(Integer.toString(hsl.h)).append(',').append(' ').append(Integer.toString(hsl.s)).append('%').append(',').append(' ').append(Integer.toString(hsl.l)).append('%');
            if (this.getFloatAlpha() != 1.0f) {
                buf.append(" / ").append(this.getAlpha().getCssText());
            }
            buf.append(')');
            return buf.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.blue == null ? 0 : this.colorComponentHashCode(this.blue));
            result = 31 * result + (this.green == null ? 0 : this.colorComponentHashCode(this.green));
            result = 31 * result + (this.red == null ? 0 : this.colorComponentHashCode(this.red));
            result = 31 * result + this.alpha.hashCode();
            return result * 31;
        }

        private int colorComponentHashCode(AbstractCSSPrimitiveValue comp) {
            float value = comp.getPrimitiveType() == 2 ? comp.getFloatValue((short)2) * 2.55f : comp.getFloatValue((short)1);
            return Float.floatToIntBits(value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CSSRGBColor)) {
                return false;
            }
            CSSRGBColor other = (CSSRGBColor)obj;
            if (this.blue == null ? other.blue != null : !this.blue.equals(other.blue)) {
                return false;
            }
            if (this.green == null ? other.green != null : !this.green.equals(other.green)) {
                return false;
            }
            if (this.red == null ? other.red != null : !this.red.equals(other.red)) {
                return false;
            }
            return Float.floatToIntBits(other.getFloatAlpha()) == Float.floatToIntBits(this.getFloatAlpha());
        }

        private float getFloatAlpha() {
            return this.alpha.getFloatValue((short)1);
        }

        public CSSRGBColor clone() {
            CSSRGBColor clon = new CSSRGBColor();
            clon.red = this.red.clone();
            clon.green = this.green.clone();
            clon.blue = this.blue.clone();
            clon.setAlpha(this.alpha.clone());
            return clon;
        }
    }

    private static class Hsl {
        int h;
        int s;
        int l;

        private Hsl() {
        }
    }

    public static interface RGBAColor
    extends RGBColor {
        public CSSPrimitiveValue getAlpha();
    }
}

