/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class OMCSSFunctionValue
extends AbstractCSSPrimitiveValue {
    private String functionName = null;
    private List<CSSValue> arguments = new LinkedList<CSSValue>();

    public OMCSSFunctionValue() {
    }

    protected OMCSSFunctionValue(OMCSSFunctionValue copied) {
        super(copied);
        this.functionName = copied.functionName;
        this.arguments = copied.arguments;
    }

    public List<CSSValue> getArguments() {
        return this.arguments;
    }

    void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    String getFunctionName() {
        return this.functionName;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        super.setLexicalUnit(lunit, subp, factory);
        this.functionName = lunit.getFunctionName();
        LexicalUnit lu = lunit.getParameters();
        boolean commaSep = false;
        OMCSSValueList list = null;
        while (lu != null) {
            AbstractCSSPrimitiveValue newval = factory.createCSSPrimitiveValue(lu, subp);
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() == 0) {
                    lu = lu.getNextLexicalUnit();
                    if (!commaSep && !this.arguments.isEmpty()) {
                        list = OMCSSValueList.createWSValueList();
                        Iterator<CSSValue> it = this.arguments.iterator();
                        while (it.hasNext()) {
                            list.add((AbstractCSSValue)it.next());
                        }
                        list.add(newval);
                        this.arguments.clear();
                        this.arguments.add(list);
                        list = null;
                    } else if (list == null) {
                        this.arguments.add(newval);
                    } else {
                        list.add(newval);
                        list = null;
                    }
                    commaSep = true;
                    continue;
                }
                if (list == null) {
                    list = OMCSSValueList.createWSValueList();
                    list.add(newval);
                    this.arguments.add(list);
                    continue;
                }
                list.add(newval);
                continue;
            }
            if (list == null) {
                this.arguments.add(newval);
                continue;
            }
            list.add(newval);
        }
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 6 + 8);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(this.arguments.get(0).getCssText());
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(' ').append(this.arguments.get(i).getCssText());
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 6 + 8);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(this.arguments.get(0));
            for (int i = 0; i < sz; ++i) {
                buf.append(',').append(((AbstractCSSPrimitiveValue)this.arguments.get(i)).getMinifiedCssText(pname));
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.getCssText();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSFunctionValue other = (OMCSSFunctionValue)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    @Override
    public OMCSSFunctionValue clone() {
        return new OMCSSFunctionValue(this);
    }
}

