/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.util;

import java.io.IOException;
import java.io.Reader;

public class TokenProducer {
    public static final byte ERR_UNEXPECTED_END_QUOTED = 1;
    public static final byte ERR_LASTCHAR_BACKSLASH = 2;
    public static final byte ERR_UNEXPECTED_END_COMMENTED = 3;
    public static final int CHAR_EXCLAMATION = 33;
    public static final int CHAR_NUMBER_SIGN = 35;
    public static final int CHAR_DOLLAR = 36;
    public static final int CHAR_PERCENT_SIGN = 37;
    public static final int CHAR_LEFT_PAREN = 40;
    public static final int CHAR_RIGHT_PAREN = 41;
    public static final int CHAR_ASTERISK = 42;
    public static final int CHAR_PLUS = 43;
    public static final int CHAR_COMMA = 44;
    public static final int CHAR_HYPHEN_MINUS = 45;
    public static final int CHAR_FULL_STOP = 46;
    public static final int CHAR_SLASH = 47;
    public static final int CHAR_COLON = 58;
    public static final int CHAR_SEMICOLON = 59;
    public static final int CHAR_LESS_THAN = 60;
    public static final int CHAR_EQUALS = 61;
    public static final int CHAR_GREATER_THAN = 62;
    public static final int CHAR_COMMERCIAL_AT = 64;
    public static final int CHAR_LEFT_SQ_BRACKET = 91;
    public static final int CHAR_RIGHT_SQ_BRACKET = 93;
    public static final int CHAR_CIRCUMFLEX_ACCENT = 94;
    public static final int CHAR_LEFT_CURLY_BRACKET = 123;
    public static final int CHAR_VERTICAL_LINE = 124;
    public static final int CHAR_RIGHT_CURLY_BRACKET = 125;
    public static final int CHAR_TILDE = 126;
    private TokenHandler handler;
    private final int[] allowInWords;
    private int[] commentStart;
    private int[] commentEnd;
    private boolean handleAllSeparators = false;

    public TokenProducer(TokenHandler handler, int[] allowInWords) {
        this.handler = handler;
        if (allowInWords == null) {
            allowInWords = new int[]{};
        }
        this.allowInWords = allowInWords;
        this.setCommentDelimiters("/*", "*/");
    }

    public void setCommentDelimiters(String start, String end) {
        int i;
        int slen = start.length();
        int elen = end.length();
        int[] commentStart = new int[slen];
        int[] commentEnd = new int[elen];
        for (i = 0; i < slen; ++i) {
            commentStart[i] = start.codePointAt(i);
            if (commentStart[i] != 92) continue;
            throw new IllegalArgumentException("Not an allowed comment delimiter");
        }
        for (i = 0; i < elen; ++i) {
            commentEnd[i] = end.codePointAt(i);
            if (commentEnd[i] != 92) continue;
            throw new IllegalArgumentException("Not an allowed comment delimiter");
        }
        this.commentStart = commentStart;
        this.commentEnd = commentEnd;
    }

    public void setHandleAllSeparators(boolean handleAllSeparators) {
        this.handleAllSeparators = handleAllSeparators;
    }

    public void parse(String string) {
        StringParser sp = new StringParser(string);
        try {
            ((SequenceParser)sp).parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(Reader reader) throws IOException {
        ReaderParser sp = new ReaderParser(reader);
        sp.parse();
    }

    public void parse(Reader reader, int bufferCapacity) throws IOException {
        ReaderParser sp = new ReaderParser(reader, bufferCapacity);
        sp.parse();
    }

    private boolean isAllowedInWords(int cp) {
        for (int i = 0; i < this.allowInWords.length; ++i) {
            if (cp != this.allowInWords[i]) continue;
            return true;
        }
        return false;
    }

    public static interface TokenHandler {
        public void word(int var1, String var2);

        public void separator(int var1, int var2);

        public void singleQuoted(int var1, String var2);

        public void doubleQuoted(int var1, String var2);

        public void openGroup(int var1, int var2);

        public void closeGroup(int var1, int var2);

        public void character(int var1, int var2);

        public void escaped(int var1, int var2);

        public void control(int var1, int var2);

        public void commented(int var1, int var2, String var3);

        public void endOfStream(int var1);

        public void error(int var1, byte var2, CharSequence var3);
    }

    class ReaderParser
    extends SequenceParser {
        Reader reader;
        StringBuilder buffer;

        ReaderParser(Reader reader) {
            this(reader, 256);
        }

        ReaderParser(Reader reader, int bufferCapacity) {
            this.reader = reader;
            this.buffer = new StringBuilder(bufferCapacity);
        }

        @Override
        public void parse() throws IOException {
            int unprocessedIdx = -1;
            int[] unprocessed = new int[TokenProducer.this.commentStart.length];
            this.rootIndex = 0;
            int cp = 0;
            while ((cp = this.reader.read()) != -1) {
                int ret;
                if (unprocessedIdx == -2) {
                    unprocessedIdx = -1;
                    if (cp == 10) continue;
                }
                if ((ret = this.processCodePoint(cp, false)) == 0) {
                    unprocessed[++unprocessedIdx] = cp;
                } else if (ret == -1) {
                    for (int j = 0; j <= unprocessedIdx; ++j) {
                        this.processCodePoint(unprocessed[j], true);
                    }
                    this.processCodePoint(cp, true);
                    unprocessedIdx = -1;
                    if (this.prevtype == 2 || this.prevtype == 1) {
                        this.buffer.append(Character.toChars(cp));
                    }
                } else if (ret == 2) {
                    unprocessedIdx = TokenProducer.this.commentEnd[TokenProducer.this.commentEnd.length - 1] == 13 ? -2 : -1;
                } else if (this.prevtype == 2 || this.prevtype == 1) {
                    this.buffer.append(Character.toChars(cp));
                }
                ++this.rootIndex;
            }
            if (this.buffer.length() != 0) {
                TokenProducer.this.handler.word(this.previdx, this.currentSequence().toString());
            }
            TokenProducer.this.handler.endOfStream(this.rootIndex);
        }

        @Override
        protected CharSequence currentSequence() {
            return this.buffer;
        }

        @Override
        protected void resetCurrentSequence() {
            this.buffer.setLength(0);
        }

        @Override
        protected int nextCodepoint() throws IOException {
            int ncp = this.reader.read();
            ++this.rootIndex;
            return ncp;
        }

        @Override
        protected String quotedSequence(int qcp) throws IOException {
            int ncp;
            boolean lastCpEscaped13 = false;
            int idx = this.rootIndex;
            int prevcp = -1;
            while ((ncp = this.nextCodepoint()) != -1) {
                if (ncp == qcp) {
                    if (prevcp != 92) {
                        return this.buffer.toString();
                    }
                    ++idx;
                    this.buffer.append(Character.toChars(qcp));
                } else {
                    if (ncp == 10 || ncp == 12 || ncp == 13) {
                        if (prevcp != 92) {
                            if (ncp != 10 || !lastCpEscaped13) {
                                TokenProducer.this.handler.error(this.rootIndex, (byte)1, this.buffer.toString());
                                TokenProducer.this.handler.control(idx, ncp);
                                this.buffer.setLength(0);
                                return null;
                            }
                        } else {
                            this.buffer.setLength(this.buffer.length() - 1);
                        }
                        if (!lastCpEscaped13) {
                            this.buffer.append('\n');
                        }
                        lastCpEscaped13 = ncp == 13;
                        prevcp = ncp;
                        continue;
                    }
                    ++idx;
                    this.buffer.append(Character.toChars(ncp));
                }
                prevcp = ncp;
                lastCpEscaped13 = false;
            }
            this.error(this.rootIndex, (byte)1);
            return this.buffer.toString();
        }

        @Override
        protected String commentedSequence(int commentType) throws IOException {
            int ncp;
            boolean lastCp13 = false;
            int endIndex = 0;
            while ((ncp = this.nextCodepoint()) != -1) {
                if (ncp == 10 || ncp == 12 || ncp == 13) {
                    if (ncp != 10 || !lastCp13) {
                        TokenProducer.this.handler.control(this.rootIndex, ncp);
                    }
                    lastCp13 = ncp == 13;
                } else {
                    lastCp13 = false;
                }
                if (TokenProducer.this.commentEnd[endIndex] == ncp) {
                    if (++endIndex != TokenProducer.this.commentEnd.length) continue;
                    return this.buffer.toString();
                }
                if (endIndex != 0) {
                    for (int j = 0; j <= endIndex; ++j) {
                        this.buffer.append(TokenProducer.this.commentEnd[j]);
                    }
                    endIndex = 0;
                }
                this.buffer.append(Character.toChars(ncp));
            }
            this.error(this.rootIndex, (byte)3);
            return this.buffer.toString();
        }

        @Override
        protected void word() {
            super.word();
            this.buffer.setLength(0);
        }

        @Override
        protected boolean singleQuoted() throws IOException {
            boolean result = super.singleQuoted();
            this.buffer.setLength(0);
            return result;
        }

        @Override
        protected boolean doubleQuoted() throws IOException {
            boolean result = super.doubleQuoted();
            this.buffer.setLength(0);
            return result;
        }

        @Override
        protected void error(int index, byte errCode) {
            TokenProducer.this.handler.error(index, errCode, this.buffer);
        }
    }

    class StringParser
    extends SequenceParser {
        String string;
        int len;

        StringParser(String string) {
            this.string = string;
            this.len = string.length();
        }

        @Override
        public void parse() throws IOException {
            int unprocessedIdx = -1;
            int[] unprocessed = new int[TokenProducer.this.commentStart.length];
            this.rootIndex = 0;
            while (this.rootIndex < this.len) {
                block12: {
                    int ret;
                    int cp;
                    block11: {
                        cp = this.string.codePointAt(this.rootIndex);
                        if (unprocessedIdx != -2) break block11;
                        unprocessedIdx = -1;
                        if (cp == 10) break block12;
                    }
                    if ((ret = this.processCodePoint(cp, false)) == 0) {
                        unprocessed[++unprocessedIdx] = cp;
                    } else if (ret == -1) {
                        this.rootIndex = this.rootIndex - unprocessedIdx - 1;
                        for (int j = 0; j <= unprocessedIdx; ++j) {
                            this.processCodePoint(unprocessed[j], true);
                            ++this.rootIndex;
                        }
                        this.processCodePoint(cp, true);
                        unprocessedIdx = -1;
                    } else if (ret == 2) {
                        unprocessedIdx = TokenProducer.this.commentEnd[TokenProducer.this.commentEnd.length - 1] == 13 ? -2 : -1;
                    }
                }
                ++this.rootIndex;
            }
            if (this.previdx < this.len) {
                TokenProducer.this.handler.word(this.previdx, this.currentSequence().toString());
            }
            TokenProducer.this.handler.endOfStream(this.len);
        }

        @Override
        protected CharSequence currentSequence() {
            return this.string.subSequence(this.previdx, this.rootIndex);
        }

        @Override
        protected void resetCurrentSequence() {
            this.previdx = this.rootIndex;
        }

        @Override
        protected int nextCodepoint() throws IOException {
            ++this.rootIndex;
            if (this.rootIndex < this.len) {
                return this.string.codePointAt(this.rootIndex);
            }
            return -1;
        }

        @Override
        protected String quotedSequence(int qcp) {
            boolean lastCpEscaped13 = false;
            int initial = this.rootIndex + 1;
            int prevcp = -1;
            StringBuilder buffer = new StringBuilder(this.len - initial);
            for (int idx = initial; idx < this.len; ++idx) {
                int cp = this.string.codePointAt(idx);
                if (cp == qcp) {
                    if (prevcp != 92) {
                        this.rootIndex = idx;
                        return buffer.toString();
                    }
                    buffer.append(Character.toChars(qcp));
                } else {
                    if (cp == 10 || cp == 12 || cp == 13) {
                        if (prevcp != 92) {
                            if (cp != 10 || !lastCpEscaped13) {
                                TokenProducer.this.handler.error(this.rootIndex, (byte)1, buffer.toString());
                                TokenProducer.this.handler.control(idx, cp);
                                this.rootIndex = idx;
                                return null;
                            }
                        } else {
                            buffer.setLength(buffer.length() - 1);
                        }
                        if (!lastCpEscaped13) {
                            buffer.append('\n');
                        }
                        lastCpEscaped13 = cp == 13;
                        prevcp = cp;
                        continue;
                    }
                    buffer.append(Character.toChars(cp));
                }
                prevcp = cp;
                lastCpEscaped13 = false;
            }
            this.rootIndex = this.len;
            this.error(initial, (byte)1);
            return buffer.toString();
        }

        @Override
        protected String commentedSequence(int commentType) throws IOException {
            boolean lastCp13 = false;
            int endIndex = 0;
            StringBuilder buffer = new StringBuilder(this.len - this.rootIndex);
            for (int idx = this.rootIndex; idx < this.len; ++idx) {
                int cp = this.string.codePointAt(idx);
                if (cp == 10 || cp == 12 || cp == 13) {
                    if (cp != 10 || !lastCp13) {
                        TokenProducer.this.handler.control(this.rootIndex, cp);
                    }
                    lastCp13 = cp == 13;
                } else {
                    lastCp13 = false;
                }
                if (TokenProducer.this.commentEnd[endIndex] == cp) {
                    if (++endIndex != TokenProducer.this.commentEnd.length) continue;
                    this.rootIndex = idx;
                    return buffer.toString();
                }
                if (endIndex != 0) {
                    for (int j = 0; j <= endIndex; ++j) {
                        buffer.append(TokenProducer.this.commentEnd[j]);
                    }
                    endIndex = 0;
                }
                buffer.append(Character.toChars(cp));
            }
            this.rootIndex = this.len;
            this.error(this.rootIndex, (byte)3);
            return buffer.toString();
        }

        @Override
        protected void error(int index, byte errCode) {
            int endIndex;
            int beginIndex = index - 16;
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            if ((endIndex = index + 16) > this.string.length()) {
                endIndex = this.string.length();
            }
            TokenProducer.this.handler.error(index, errCode, this.string.substring(beginIndex, endIndex));
        }
    }

    abstract class SequenceParser {
        int prevtype = 12;
        int rootIndex = 0;
        int previdx = 0;
        int commentIndex = 0;
        int commentprevtype = 0;

        SequenceParser() {
        }

        /*
         * Enabled aggressive block sorting
         */
        int processCodePoint(int cp, boolean nocomment) throws IOException {
            if (!nocomment) {
                if (TokenProducer.this.commentStart[this.commentIndex] == cp) {
                    if (this.commentIndex == 0) {
                        this.commentprevtype = this.prevtype;
                    }
                    ++this.commentIndex;
                    if (this.commentIndex != TokenProducer.this.commentStart.length) return 0;
                    this.prevtype = this.commentprevtype;
                    if (this.isWordPreviousCodepoint()) {
                        this.word();
                    }
                    this.commentIndex = 0;
                    ++this.rootIndex;
                    this.previdx = this.rootIndex;
                    String comment = this.commentedSequence(0);
                    TokenProducer.this.handler.commented(this.previdx, 0, comment);
                    this.resetCurrentSequence();
                    return 2;
                }
                if (this.commentIndex != 0) {
                    this.commentIndex = 0;
                    this.commentprevtype = 0;
                    return -1;
                }
            }
            int type = Character.getType(cp);
            switch (type) {
                case 12: 
                case 13: 
                case 14: {
                    if (TokenProducer.this.handleAllSeparators || this.prevtype != 12) {
                        if (this.isWordPreviousCodepoint()) {
                            this.word();
                        }
                        TokenProducer.this.handler.separator(this.rootIndex, cp);
                        this.prevtype = 12;
                    }
                    this.previdx = this.rootIndex + 1;
                    return 1;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 23: 
                case 28: {
                    this.prevtype = 2;
                    return 1;
                }
                case 15: {
                    if (this.isWordPreviousCodepoint()) {
                        this.word();
                    }
                    this.prevtype = 15;
                    TokenProducer.this.handler.control(this.rootIndex, cp);
                    return 1;
                }
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: {
                    if (TokenProducer.this.isAllowedInWords(cp)) {
                        this.prevtype = 1;
                        return 1;
                    }
                    if (this.isWordPreviousCodepoint()) {
                        this.word();
                    }
                    if (cp == 34) {
                        if (this.doubleQuoted()) break;
                        this.prevtype = 15;
                        break;
                    }
                    if (cp == 39) {
                        if (this.singleQuoted()) break;
                        this.prevtype = 15;
                        break;
                    }
                    if (cp == 40 || cp == 91 || cp == 123) {
                        TokenProducer.this.handler.openGroup(this.rootIndex, cp);
                        break;
                    }
                    if (cp == 41 || cp == 93 || cp == 125) {
                        TokenProducer.this.handler.closeGroup(this.rootIndex, cp);
                        break;
                    }
                    if (cp == 92) {
                        int ncp = this.nextCodepoint();
                        if (ncp != -1) {
                            TokenProducer.this.handler.escaped(this.rootIndex, ncp);
                            break;
                        }
                        this.error(this.rootIndex - 1, (byte)2);
                        break;
                    }
                    TokenProducer.this.handler.character(this.rootIndex, cp);
                }
            }
            this.previdx = this.rootIndex + 1;
            this.prevtype = 24;
            return 1;
        }

        boolean isWordPreviousCodepoint() {
            if (this.prevtype == 2) {
                return true;
            }
            if (this.prevtype == 1) {
                if (this.currentSequence().length() == 1) {
                    TokenProducer.this.handler.character(this.rootIndex, Character.codePointAt(this.currentSequence(), 0));
                    this.resetCurrentSequence();
                } else {
                    return true;
                }
            }
            return false;
        }

        protected void word() {
            TokenProducer.this.handler.word(this.previdx, this.currentSequence().toString());
        }

        protected boolean singleQuoted() throws IOException {
            String seq = this.quotedSequence(39);
            if (seq == null) {
                return false;
            }
            TokenProducer.this.handler.singleQuoted(this.rootIndex, seq);
            return true;
        }

        protected boolean doubleQuoted() throws IOException {
            String seq = this.quotedSequence(34);
            if (seq == null) {
                return false;
            }
            TokenProducer.this.handler.doubleQuoted(this.rootIndex, seq);
            return true;
        }

        public abstract void parse() throws IOException;

        protected abstract CharSequence currentSequence();

        protected abstract void resetCurrentSequence();

        protected abstract int nextCodepoint() throws IOException;

        protected abstract String quotedSequence(int var1) throws IOException;

        protected abstract String commentedSequence(int var1) throws IOException;

        protected abstract void error(int var1, byte var2);
    }
}

