/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.OMCSSColorValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractStyleDatabase
implements StyleDatabase {
    protected final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    private static final AbstractCSSPrimitiveValue DEFAULT_INITIAL_COLOR = (AbstractCSSPrimitiveValue)new ValueFactory().parseProperty("#000000");
    private CSSPrimitiveValue initialColor = DEFAULT_INITIAL_COLOR;

    @Override
    public int getExSizeInPt(String familyName, int size) {
        return Math.round(0.5f * (float)size);
    }

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType, short destUnitType) throws DOMException {
        return CSSNumberValue.floatValueConversion(initialValue, initialUnitType, destUnitType);
    }

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType) throws DOMException {
        return CSSNumberValue.floatValueConversion(initialValue, initialUnitType, this.getNaturalUnit());
    }

    @Override
    public CSSPrimitiveValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String initialColor) {
        this.initialColor = (AbstractCSSPrimitiveValue)new ValueFactory().parseProperty(initialColor);
        ((OMCSSColorValue)this.initialColor).setSystemDefault();
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }

    @Override
    public String getSystemFontDeclaration(String systemFontName) {
        return null;
    }

    static {
        ((OMCSSColorValue)DEFAULT_INITIAL_COLOR).setSystemDefault();
    }
}

