/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.w3c.css.sac.LexicalUnit;

class AnimationShorthandSetter
extends ShorthandSetter {
    private StringBuilder layerBuffer = null;
    private int layerCount = 0;
    private OMCSSValueList lstDuration = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstTimingFunction = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstDelay = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstIterationCount = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstDirection = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstFillMode = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstPlayState = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstName = OMCSSValueList.createCSValueList();

    AnimationShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "animation");
    }

    @Override
    public void init(LexicalUnit shorthandValue, String priority) {
        this.currentValue = shorthandValue;
        this.setPriority(priority);
        this.countLayers(shorthandValue);
    }

    protected void countLayers(LexicalUnit shorthandValue) {
        this.layerCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == 0) {
                if (valueCount <= 0) continue;
                ++this.layerCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    public boolean assignSubproperties() {
        this.layerBuffer = new StringBuilder(40);
        String[] subparray = this.getShorthandSubproperties();
        int i = 0;
        block0: while (i < this.layerCount && this.currentValue != null) {
            boolean validLayer = false;
            HashSet<String> subp = new HashSet<String>(subparray.length);
            subp.addAll(Arrays.asList((Object[])subparray.clone()));
            while (this.currentValue != null) {
                String sv;
                if (this.currentValue.getLexicalUnitType() == 0) {
                    if (!validLayer) break;
                    this.appendToValueBuffer(this.layerBuffer);
                    this.layerBuffer.setLength(0);
                    if (++i != this.layerCount) {
                        this.layerBuffer.append(',');
                    }
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    break;
                }
                if (this.currentValue.getLexicalUnitType() == 12) {
                    while (this.currentValue != null) {
                        boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (!commaFound) continue;
                        break;
                    }
                    this.clearLayer(subp, ++i);
                    CSSInheritValue inherit = CSSInheritValue.getValue().asSubproperty();
                    this.addSingleValueLayer(inherit);
                    this.layerBuffer.setLength(0);
                    if (i != 1) {
                        this.layerBuffer.append(',');
                    }
                    this.appendValueItemString(inherit);
                    this.appendToValueBuffer(this.layerBuffer);
                    this.layerBuffer.setLength(0);
                    if (i == this.layerCount) continue block0;
                    this.layerBuffer.append(',');
                    continue block0;
                }
                if (this.currentValue.getLexicalUnitType() == 35 && ("initial".equals(sv = this.currentValue.getStringValue().toLowerCase(Locale.US)) || "unset".equals(sv))) {
                    AbstractCSSValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    while (this.currentValue != null) {
                        boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (!commaFound) continue;
                        break;
                    }
                    this.clearLayer(subp, ++i);
                    this.addSingleValueLayer(keyword);
                    this.layerBuffer.setLength(0);
                    if (i != 1) {
                        this.layerBuffer.append(',');
                    }
                    this.appendValueItemString(keyword);
                    this.appendToValueBuffer(this.layerBuffer);
                    this.layerBuffer.setLength(0);
                    if (i == this.layerCount) continue block0;
                    this.layerBuffer.append(',');
                    continue block0;
                }
                if (this.assignLayerValue(subp)) {
                    validLayer = true;
                    continue;
                }
                this.reportUnknownValue(subp, this.currentValue);
                validLayer = false;
                break;
            }
            if (!validLayer) {
                this.layerBuffer.setLength(0);
                StringBuilder msgbuf = new StringBuilder(64);
                msgbuf.append("Invalid layer found: ").append(i);
                if (this.currentValue != null) {
                    msgbuf.append(' ').append(this.currentValue.toString());
                }
                this.reportDeclarationError("animation", msgbuf.toString());
                return false;
            }
            if (subp.size() <= 0) continue;
            this.resetUnsetProperties(subp);
        }
        this.appendToValueBuffer(this.layerBuffer);
        this.setListSubpropertyValue("animation-duration", this.lstDuration);
        this.setListSubpropertyValue("animation-timing-function", this.lstTimingFunction);
        this.setListSubpropertyValue("animation-delay", this.lstDelay);
        this.setListSubpropertyValue("animation-iteration-count", this.lstIterationCount);
        this.setListSubpropertyValue("animation-direction", this.lstDirection);
        this.setListSubpropertyValue("animation-fill-mode", this.lstFillMode);
        this.setListSubpropertyValue("animation-play-state", this.lstPlayState);
        this.setListSubpropertyValue("animation-name", this.lstName);
        this.flush();
        return true;
    }

    private void clearLayer(Set<String> subp, int i) {
        if (!subp.contains("animation-duration") && this.lstDuration.getLength() == i) {
            this.lstDuration.remove(i - 1);
        }
        if (!subp.contains("animation-timing-function") && this.lstTimingFunction.getLength() == i) {
            this.lstTimingFunction.remove(i - 1);
        }
        if (!subp.contains("animation-delay") && this.lstDelay.getLength() == i) {
            this.lstDelay.remove(i - 1);
        }
        if (!subp.contains("animation-iteration-count") && this.lstIterationCount.getLength() == i) {
            this.lstIterationCount.remove(i - 1);
        }
        if (!subp.contains("animation-direction") && this.lstDirection.getLength() == i) {
            this.lstDirection.remove(i - 1);
        }
        if (!subp.contains("animation-fill-mode") && this.lstFillMode.getLength() == i) {
            this.lstFillMode.remove(i - 1);
        }
        if (!subp.contains("animation-play-state") && this.lstPlayState.getLength() == i) {
            this.lstPlayState.remove(i - 1);
        }
        if (!subp.contains("animation-name") && this.lstName.getLength() == i) {
            this.lstName.remove(i - 1);
        }
    }

    private void addSingleValueLayer(AbstractCSSValue keyword) {
        this.lstDuration.add(keyword);
        this.lstTimingFunction.add(keyword);
        this.lstDelay.add(keyword);
        this.lstIterationCount.add(keyword);
        this.lstDirection.add(keyword);
        this.lstFillMode.add(keyword);
        this.lstPlayState.add(keyword);
        this.lstName.add(keyword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean assignLayerValue(Set<String> subp) {
        short type = this.currentValue.getLexicalUnitType();
        if (type == 32 || type == 31) {
            OMCSSValueList list;
            String property = "animation-duration";
            if (!subp.contains(property)) {
                property = "animation-delay";
                if (!subp.contains(property)) {
                    return false;
                }
                list = this.lstDelay;
            } else {
                list = this.lstDuration;
            }
            list.add(this.createCSSValue(property, this.currentValue));
            subp.remove(property);
            this.nextCurrentValue();
            return true;
        } else {
            if (type == 13) {
                int ivalue = this.currentValue.getIntegerValue();
                if (ivalue < 0) {
                    return false;
                }
                if (this.setIterationCountValue(subp)) return true;
                return false;
            }
            if (type == 14) {
                float fvalue = this.currentValue.getFloatValue();
                if (fvalue < 0.0f) {
                    return false;
                }
                if (this.setIterationCountValue(subp)) return true;
                return false;
            }
            if (type == 41) {
                if (!subp.contains("animation-timing-function")) {
                    return false;
                }
                this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
                subp.remove("animation-timing-function");
                this.nextCurrentValue();
                return true;
            } else if (type == 35) {
                if (subp.contains("animation-timing-function") && this.testIdentifiers("transition-timing-function")) {
                    this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-timing-function");
                    return true;
                } else if (subp.contains("animation-iteration-count") && this.testIdentifiers("animation-iteration-count")) {
                    this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-iteration-count");
                    return true;
                } else if (subp.contains("animation-direction") && this.testIdentifiers("animation-direction")) {
                    this.lstDirection.add(this.createCSSValue("animation-direction", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-direction");
                    return true;
                } else if (subp.contains("animation-fill-mode") && this.testIdentifiers("animation-fill-mode")) {
                    this.lstFillMode.add(this.createCSSValue("animation-fill-mode", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-fill-mode");
                    return true;
                } else if (subp.contains("animation-play-state") && this.testIdentifiers("animation-play-state")) {
                    this.lstPlayState.add(this.createCSSValue("animation-play-state", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-play-state");
                    return true;
                } else {
                    if (!subp.contains("animation-name")) return false;
                    this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
                    this.nextCurrentValue();
                    subp.remove("animation-name");
                }
                return true;
            } else {
                if (type != 36) return false;
                if (!subp.contains("animation-name")) {
                    return false;
                }
                this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
                this.nextCurrentValue();
                subp.remove("animation-name");
            }
        }
        return true;
    }

    private boolean setIterationCountValue(Set<String> subp) {
        if (!subp.contains("animation-iteration-count")) {
            return false;
        }
        this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
        subp.remove("animation-iteration-count");
        this.nextCurrentValue();
        return true;
    }

    private void reportUnknownValue(Set<String> subp, LexicalUnit unknownValue) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
            if (unknownValue.getLexicalUnitType() == 35) {
                eh.unknownIdentifier("animation", unknownValue.getStringValue());
            } else {
                eh.unassignedShorthandValues("animation", subp.toArray(new String[0]), new LexicalUnit[]{unknownValue});
            }
        }
    }

    private void resetUnsetProperties(Set<String> subp) {
        for (String pname : subp) {
            AbstractCSSValue cssVal = this.defaultPropertyValue(pname);
            if ("animation-duration".equals(pname)) {
                this.lstDuration.add(cssVal);
                continue;
            }
            if ("animation-timing-function".equals(pname)) {
                this.lstTimingFunction.add(cssVal);
                continue;
            }
            if ("animation-delay".equals(pname)) {
                this.lstDelay.add(cssVal);
                continue;
            }
            if ("animation-iteration-count".equals(pname)) {
                this.lstIterationCount.add(cssVal);
                continue;
            }
            if ("animation-direction".equals(pname)) {
                this.lstDirection.add(cssVal);
                continue;
            }
            if ("animation-fill-mode".equals(pname)) {
                this.lstFillMode.add(cssVal);
                continue;
            }
            if ("animation-play-state".equals(pname)) {
                this.lstPlayState.add(cssVal);
                continue;
            }
            if (!"animation-name".equals(pname)) continue;
            this.lstName.add(cssVal);
        }
    }

    private void setListSubpropertyValue(String pname, OMCSSValueList list) {
        if (list.getLength() == 1) {
            AbstractCSSValue val = list.item(0);
            if (val.getCssValueType() == 1) {
                ((AbstractCSSPrimitiveValue)val).setSubproperty(true);
            } else if (val.getCssValueType() == 0) {
                val = ((CSSInheritValue)val).asSubproperty();
            } else if (val.getCssValueType() == 2) {
                ((OMCSSValueList)val).setSubproperty(true);
            }
            this.setSubpropertyValue(pname, val);
        } else {
            list.setSubproperty(true);
            this.setSubpropertyValue(pname, list);
        }
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }
}

