/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class BoxShorthandSetter
extends ShorthandSetter {
    boolean nonmixed = true;

    BoxShorthandSetter(BaseCSSStyleDeclaration style, String shorthand) {
        super(style, shorthand);
    }

    boolean scanForInherited(LexicalUnit lunit) {
        while (lunit != null) {
            if (lunit.getLexicalUnitType() != 12) {
                return false;
            }
            lunit = lunit.getNextLexicalUnit();
        }
        CSSInheritValue inherit = CSSInheritValue.getValue().asSubproperty();
        this.setSubpropertiesInherit(inherit);
        this.initValueString();
        this.appendValueItemString(inherit);
        return true;
    }

    @Override
    public boolean assignSubproperties() {
        if (this.scanForInherited(this.currentValue)) {
            return true;
        }
        String[] subparray = this.getShorthandSubproperties();
        short vcount = this.boxValueCount(this.currentValue);
        if (vcount == 0 || vcount > 4) {
            StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null) {
                errHandler.wrongSubpropertyCount(this.getShorthandName(), vcount);
            }
            return false;
        }
        switch (vcount) {
            case 1: {
                AbstractCSSValue cssValue = this.createCSSValue(this.getShorthandName(), this.currentValue);
                for (int i = 0; i < subparray.length; ++i) {
                    this.setSubpropertyValue(subparray[i], cssValue);
                }
                break;
            }
            case 2: {
                AbstractCSSValue top = this.createCSSValue(subparray[0], this.currentValue);
                this.nextCurrentValue();
                AbstractCSSValue right_left = this.createCSSValue(subparray[1], this.currentValue);
                this.setSubpropertyValue(subparray[0], top);
                this.setSubpropertyValue(subparray[1], right_left);
                this.setSubpropertyValue(subparray[2], top);
                this.setSubpropertyValue(subparray[3], right_left);
                break;
            }
            case 3: {
                AbstractCSSValue top = this.createCSSValue(subparray[0], this.currentValue);
                this.nextCurrentValue();
                AbstractCSSValue right_left = this.createCSSValue(subparray[1], this.currentValue);
                this.nextCurrentValue();
                AbstractCSSValue bottom = this.createCSSValue(subparray[2], this.currentValue);
                this.setSubpropertyValue(subparray[0], top);
                this.setSubpropertyValue(subparray[1], right_left);
                this.setSubpropertyValue(subparray[2], bottom);
                this.setSubpropertyValue(subparray[3], right_left);
                break;
            }
            case 4: {
                for (int i = 0; i < subparray.length; ++i) {
                    AbstractCSSValue cssValue = this.createCSSValue(subparray[i], this.currentValue);
                    this.setSubpropertyValue(subparray[i], cssValue);
                    this.nextCurrentValue();
                }
                break;
            }
        }
        if (!this.nonmixed) {
            this.initValueString();
        }
        return true;
    }

    protected short boxValueCount(LexicalUnit topLevelUnit) {
        short valueCount = 0;
        for (LexicalUnit value = topLevelUnit; value != null; value = value.getNextLexicalUnit()) {
            if (this.isValueOfType(value)) {
                valueCount = (short)(valueCount + 1);
                continue;
            }
            if (value.getLexicalUnitType() == 35) {
                String sv = value.getStringValue();
                if (sv == null) break;
                String lcsv = sv.toLowerCase(Locale.US).intern();
                if (this.isIdentifierValue(lcsv)) {
                    valueCount = (short)(valueCount + 1);
                    continue;
                }
                if (!"unset".equals(lcsv) && !"initial".equals(lcsv)) break;
                this.nonmixed = false;
                valueCount = (short)(valueCount + 1);
                continue;
            }
            if (value.getLexicalUnitType() != 12) break;
            this.nonmixed = false;
            valueCount = (short)(valueCount + 1);
        }
        if (!this.nonmixed && valueCount == 1) {
            this.nonmixed = true;
        }
        return valueCount;
    }

    boolean isValueOfType(LexicalUnit value) {
        return ValueFactory.isSizeSACUnit(value);
    }

    boolean isIdentifierValue(String lcIdent) {
        return "auto".equals(lcIdent);
    }

    @Override
    AbstractCSSValue createCSSValue(String propertyName, LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(propertyName, lunit, this.nonmixed);
    }

    @Override
    protected void setSubpropertyValue(String subproperty, AbstractCSSValue cssValue) {
        this.styleDeclaration.setProperty(subproperty, cssValue, this.getPriority());
    }
}

