/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class FlexShorthandSetter
extends ShorthandSetter {
    FlexShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "flex");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        this.setPropertyToDefault("flex-grow");
        this.setPropertyToDefault("flex-shrink");
        this.setPropertyToDefault("flex-basis");
        boolean flexGrowUnset = true;
        boolean flexBasisUnset = true;
        int count = 0;
        while (this.currentValue != null) {
            if (count == 2) {
                return false;
            }
            short lut = this.currentValue.getLexicalUnitType();
            if (flexGrowUnset) {
                if (lut == 13) {
                    int intValue = this.currentValue.getIntegerValue();
                    if (intValue < 0) {
                        return false;
                    }
                    this.setFlexGrow(intValue);
                    flexGrowUnset = false;
                    count = (byte)(count + 1);
                    byte ret = this.checkFlexShrink();
                    if (ret != -1) continue;
                    return false;
                }
                if (lut == 14) {
                    float floatValue = this.currentValue.getFloatValue();
                    if (floatValue < 0.0f) {
                        return false;
                    }
                    this.setFlexGrow(floatValue);
                    flexGrowUnset = false;
                    count = (byte)(count + 1);
                    byte ret = this.checkFlexShrink();
                    if (ret != -1) continue;
                    return false;
                }
            }
            if (flexBasisUnset && ValueFactory.isSizeSACUnit(this.currentValue)) {
                AbstractCSSPrimitiveValue value = (AbstractCSSPrimitiveValue)this.createCSSValue("flex-basis", this.currentValue);
                if (value.isNumberZero()) {
                    CSSNumberValue number = new CSSNumberValue();
                    number.setSubproperty(true);
                    number.setIntegerValue(0);
                    value = number;
                }
                this.setSubpropertyValue("flex-basis", value);
                count = (byte)(count + 1);
                flexBasisUnset = false;
            } else {
                if (lut != 35) return false;
                String ident = this.currentValue.getStringValue();
                if ("none".equalsIgnoreCase(ident)) {
                    if (flexGrowUnset) {
                        this.setFlexGrow(0);
                        this.setFlexShrink(0);
                    }
                    this.setFlexBasisToAuto();
                    count = (byte)(count + 2);
                    flexBasisUnset = false;
                } else if ("auto".equalsIgnoreCase(ident)) {
                    if (flexGrowUnset) {
                        this.setFlexGrow(1);
                        this.setFlexShrink(1);
                    }
                    this.setFlexBasisToAuto();
                    count = (byte)(count + 2);
                    flexBasisUnset = false;
                } else {
                    if (!"content".equalsIgnoreCase(ident)) return false;
                    this.setSubpropertyValue("flex-basis", this.createCSSValue("flex-basis", this.currentValue));
                    count = (byte)(count + 1);
                    flexBasisUnset = false;
                }
            }
            this.nextCurrentValue();
        }
        this.flush();
        return true;
    }

    private void setFlexGrow(int grow) {
        CSSNumberValue number = new CSSNumberValue();
        number.setIntegerValue(grow);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", number);
    }

    private void setFlexGrow(float grow) {
        CSSNumberValue number = new CSSNumberValue();
        number.setFloatValue((short)1, grow);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", number);
    }

    private byte checkFlexShrink() {
        this.nextCurrentValue();
        if (this.currentValue != null) {
            short lut = this.currentValue.getLexicalUnitType();
            if (lut == 13) {
                int intValue = this.currentValue.getIntegerValue();
                if (intValue >= 0) {
                    this.setFlexShrink(intValue);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
            if (lut == 14) {
                float floatValue = this.currentValue.getFloatValue();
                if (floatValue >= 0.0f) {
                    this.setFlexShrink(floatValue);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void setFlexShrink(int shrink) {
        CSSNumberValue number = new CSSNumberValue();
        number.setIntegerValue(shrink);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", number);
    }

    private void setFlexShrink(float shrink) {
        CSSNumberValue number = new CSSNumberValue();
        number.setFloatValue((short)1, shrink);
        number.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", number);
    }

    private void setFlexBasisToAuto() {
        CSSIdentifierValue ident = new CSSIdentifierValue("auto");
        ident.setSubproperty(true);
        this.setSubpropertyValue("flex-basis", ident);
    }
}

