/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseGridShorthandSetter;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;

class GridShorthandSetter
extends BaseGridShorthandSetter {
    private final String[] subproperties = new String[]{"grid-template-columns", "grid-template-rows", "grid-template-areas", "grid-auto-rows", "grid-auto-columns", "grid-auto-flow"};

    GridShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "grid");
    }

    @Override
    String[] getShorthandSubproperties() {
        return this.subproperties;
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        this.setSubpropertiesToDefault();
        if (this.isNoneDeclaration()) {
            this.getValueItemBuffer().append("none");
            this.flush();
        } else if (this.fullSyntax()) {
            this.flush();
        } else {
            return false;
        }
        return true;
    }

    @Override
    void setSubpropertiesToDefault() {
        String[] subp;
        for (String pname : subp = this.getShorthandSubproperties()) {
            this.setPropertyToDefault(pname);
        }
    }

    boolean fullSyntax() {
        AbstractCSSValue value;
        boolean setTemplateAreas = false;
        boolean gridAutoRows = false;
        LexicalUnit fullValue = this.currentValue;
        OMCSSValueList gridTemplateRows = OMCSSValueList.createWSValueList();
        OMCSSValueList gridTemplateAreas = OMCSSValueList.createWSValueList();
        OMCSSValueList lineNames = null;
        byte ret = this.isAutoflowOrDenseKeyword();
        if (ret == -1) {
            return false;
        }
        if (ret != 0) {
            gridAutoRows = true;
            if (ret == 2) {
                this.setGridAutoFlow("row", true);
            } else {
                this.setGridAutoFlow("row", false);
            }
        }
        int lasttype = -1;
        block5: do {
            short type = this.currentValue.getLexicalUnitType();
            switch (type) {
                case 68: {
                    if (lasttype == 36) {
                        gridTemplateRows.add(GridAreaShorthandSetter.createAutoValue());
                    }
                    ValueFactory.ListValueItem item = this.valueFactory.parseBracketList(this.currentValue.getNextLexicalUnit(), this.styleDeclaration.getParentRule(), true);
                    OMCSSValueList newLineNames = item.getCSSValue();
                    if (lineNames == null) {
                        lineNames = newLineNames;
                        gridTemplateRows.add(lineNames);
                    } else {
                        lineNames.addAll(newLineNames);
                    }
                    this.appendValueItemString(newLineNames);
                    this.currentValue = item.getNextLexicalUnit();
                    lasttype = type;
                    break;
                }
                case 36: {
                    if (lasttype == 36) {
                        gridTemplateRows.add(GridAreaShorthandSetter.createAutoValue());
                    }
                    setTemplateAreas = true;
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateAreas.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                    break;
                }
                case 4: {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    if (this.currentValue != null) {
                        String property;
                        this.getValueItemBuffer().append(" /");
                        ret = this.isAutoflowOrDenseKeyword();
                        if (ret == -1) {
                            return false;
                        }
                        if (ret != 0) {
                            property = "grid-auto-columns";
                            if (ret == 2) {
                                this.setGridAutoFlow("column", true);
                            } else {
                                this.setGridAutoFlow("column", false);
                            }
                            if (gridAutoRows) {
                                BaseCSSDeclarationRule rule = this.styleDeclaration.getParentRule();
                                if (rule != null) {
                                    rule.getStyleDeclarationErrorHandler().shorthandSyntaxError(this.getShorthandName(), "Found two auto-flow declarations: " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                                }
                                return false;
                            }
                        } else {
                            property = "grid-template-columns";
                        }
                        value = this.valueFactory.createCSSValue(this.currentValue, this.styleDeclaration.getParentRule());
                        value = this.subpropertyValue(value);
                        this.setSubpropertyValue(property, value);
                        this.appendValueItemString(value);
                        break block5;
                    }
                    BaseCSSDeclarationRule rule = this.styleDeclaration.getParentRule();
                    if (rule != null) {
                        rule.getStyleDeclarationErrorHandler().shorthandSyntaxError(this.getShorthandName(), "Unexpected end of declaration after slash '/' in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    }
                    return false;
                }
                default: {
                    CSSPrimitiveValue2 primi;
                    lineNames = null;
                    value = this.createCSSValue();
                    if (setTemplateAreas && value.getCssValueType() == 1 && (primi = (CSSPrimitiveValue2)((Object)value)).getPrimitiveType() == 127 && "repeat".equalsIgnoreCase(primi.getStringValue())) {
                        BaseCSSDeclarationRule rule = this.styleDeclaration.getParentRule();
                        if (rule != null) {
                            rule.getStyleDeclarationErrorHandler().shorthandSyntaxError(this.getShorthandName(), "This syntax does not allow repeat(): " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                        }
                        return false;
                    }
                    gridTemplateRows.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                }
            }
        } while (this.currentValue != null);
        if (gridTemplateRows.getLength() != 0 && !GridShorthandSetter.isAutoOnly(gridTemplateRows)) {
            String property = gridAutoRows ? "grid-auto-rows" : "grid-template-rows";
            value = gridTemplateRows.getLength() != 1 ? gridTemplateRows : gridTemplateRows.item(0);
            this.setSubpropertyValue(property, value);
        }
        if (gridTemplateAreas.getLength() != 0) {
            value = gridTemplateAreas.getLength() != 1 ? gridTemplateAreas : gridTemplateAreas.item(0);
            this.setSubpropertyValue("grid-template-areas", value);
        }
        return true;
    }

    private void setGridAutoFlow(String ident, boolean dense) {
        AbstractCSSValue value;
        CSSIdentifierValue cssident = new CSSIdentifierValue(ident);
        cssident.setSubproperty(true);
        if (!dense) {
            value = cssident;
        } else {
            CSSIdentifierValue cssdense = new CSSIdentifierValue("dense");
            cssdense.setSubproperty(true);
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            list.add(cssident);
            list.add(cssdense);
            value = list;
        }
        this.setSubpropertyValue("grid-auto-flow", value);
    }

    private byte isAutoflowOrDenseKeyword() {
        int ret = 0;
        if (this.currentValue.getLexicalUnitType() == 35) {
            StringBuilder buf;
            String sv = this.currentValue.getStringValue();
            if ("auto-flow".equalsIgnoreCase(sv)) {
                buf = this.getValueItemBuffer();
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 35 && "dense".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    buf.append("auto-flow dense");
                    ret = 2;
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                } else {
                    buf.append("auto-flow");
                    ret = 1;
                }
            }
            if ("dense".equalsIgnoreCase(sv)) {
                buf = this.getValueItemBuffer();
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 35 && "auto-flow".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    buf.append("auto-flow dense");
                    ret = 2;
                } else {
                    ret = -1;
                }
            }
        }
        return (byte)ret;
    }
}

