/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import java.util.Comparator;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSStyleRule;

public class OMCSSStyleRule
extends CSSStyleDeclarationRule
implements CSSStyleRule,
ExtendedCSSRule {
    public OMCSSStyleRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)1, origin);
    }

    public OMCSSStyleRule() {
    }

    RuleSpecifity getSpecifity(int index) {
        return new RuleSpecifity(this.getSelectorList().item(index));
    }

    static class SpecificityComparator
    implements Comparator<RuleSpecifity> {
        SpecificityComparator() {
        }

        @Override
        public int compare(RuleSpecifity o1, RuleSpecifity o2) {
            return (o2.getCSSStyleRule().getOrigin() - o1.getCSSStyleRule().getOrigin()) * 131071 + Specifity.selectorCompare(o1, o2);
        }
    }

    class RuleSpecifity
    extends Specifity {
        public RuleSpecifity(Selector selector) {
            super(selector);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getCSSStyleRule().getOrigin();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.getCSSStyleRule().getOrigin() == ((RuleSpecifity)obj).getCSSStyleRule().getOrigin();
        }

        public OMCSSStyleRule getCSSStyleRule() {
            return OMCSSStyleRule.this;
        }
    }

    static class Specifity {
        short id_count = 0;
        short attrib_classes_count = 0;
        short names_pseudoelements_count = 0;

        public Specifity(Selector selector) {
            this.specifity(selector);
        }

        private void specifity(Selector selector) {
            switch (selector.getSelectorType()) {
                case 4: {
                    String elname = ((ElementSelector)selector).getLocalName();
                    if (elname == null || elname.equals("*")) break;
                }
                case 2: 
                case 9: {
                    this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + 1);
                    break;
                }
                case 0: {
                    ConditionalSelector condsel = (ConditionalSelector)selector;
                    Specifity.conditionSpecificity(condsel.getCondition(), condsel.getSimpleSelector(), this);
                    break;
                }
                case 10: 
                case 11: {
                    this.specifity((Selector)((DescendantSelector)selector).getSimpleSelector());
                    this.specifity(((DescendantSelector)selector).getAncestorSelector());
                    break;
                }
                case 12: {
                    this.specifity((Selector)((SiblingSelector)selector).getSiblingSelector());
                    this.specifity(((SiblingSelector)selector).getSelector());
                    break;
                }
                case 1: {
                    if (!(selector instanceof SiblingSelector)) break;
                    this.specifity((Selector)((SiblingSelector)selector).getSiblingSelector());
                    this.specifity(((SiblingSelector)selector).getSelector());
                }
            }
        }

        private static void conditionSpecificity(Condition cond, SimpleSelector selector, Specifity sp) {
            switch (cond.getConditionType()) {
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    sp.attrib_classes_count = (short)(sp.attrib_classes_count + 1);
                    break;
                }
                case 5: {
                    sp.id_count = (short)(sp.id_count + 1);
                    break;
                }
                case 2: {
                    Specifity.conditionSpecificity(((NegativeCondition)cond).getCondition(), selector, sp);
                    return;
                }
                case 0: {
                    CombinatorCondition comb = (CombinatorCondition)cond;
                    Specifity firstsp = new Specifity((Selector)selector);
                    Specifity.conditionSpecificity(comb.getFirstCondition(), selector, firstsp);
                    Specifity secondsp = new Specifity((Selector)selector);
                    Specifity.conditionSpecificity(comb.getSecondCondition(), selector, secondsp);
                    if (firstsp.id_count > secondsp.id_count) {
                        sp.id_count = (short)(sp.id_count + firstsp.id_count);
                        sp.attrib_classes_count = (short)(sp.attrib_classes_count + firstsp.attrib_classes_count);
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + firstsp.names_pseudoelements_count);
                    } else if (firstsp.id_count < secondsp.id_count) {
                        sp.id_count = (short)(sp.id_count + secondsp.id_count);
                        sp.attrib_classes_count = (short)(sp.attrib_classes_count + secondsp.attrib_classes_count);
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + secondsp.names_pseudoelements_count);
                    } else if (firstsp.attrib_classes_count > secondsp.attrib_classes_count) {
                        sp.attrib_classes_count = (short)(sp.attrib_classes_count + firstsp.attrib_classes_count);
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + firstsp.names_pseudoelements_count);
                    } else if (firstsp.attrib_classes_count < secondsp.attrib_classes_count) {
                        sp.attrib_classes_count = (short)(sp.attrib_classes_count + secondsp.attrib_classes_count);
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + secondsp.names_pseudoelements_count);
                    } else if (firstsp.names_pseudoelements_count > secondsp.names_pseudoelements_count) {
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + firstsp.names_pseudoelements_count);
                    } else if (firstsp.names_pseudoelements_count < secondsp.names_pseudoelements_count) {
                        sp.names_pseudoelements_count = (short)(sp.names_pseudoelements_count + secondsp.names_pseudoelements_count);
                    }
                    return;
                }
            }
            sp.specifity((Selector)selector);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.attrib_classes_count;
            result = 31 * result + this.id_count;
            result = 31 * result + this.names_pseudoelements_count;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Specifity)) {
                return false;
            }
            Specifity other = (Specifity)obj;
            if (this.attrib_classes_count != other.attrib_classes_count) {
                return false;
            }
            if (this.id_count != other.id_count) {
                return false;
            }
            return this.names_pseudoelements_count == other.names_pseudoelements_count;
        }

        static int selectorCompare(Specifity o1, Specifity o2) {
            return (o1.id_count - o2.id_count) * 16384 + (o1.attrib_classes_count - o2.attrib_classes_count) * 128 + (o1.names_pseudoelements_count - o2.names_pseudoelements_count);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(82);
            buf.append("id: ").append(this.id_count).append(", attributes and pseudo-classes: ").append(this.attrib_classes_count).append(", element names and pseudo-elements: ").append(this.names_pseudoelements_count);
            return buf.toString();
        }
    }
}

