/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;

class LexicalUnitImpl
implements LexicalUnit {
    private short unitType;
    int intValue = 0;
    float floatValue = 0.0f;
    String dimensionUnitText = "";
    String value = null;
    LexicalUnit previousLexicalUnit = null;
    LexicalUnit nextLexicalUnit = null;
    LexicalUnitImpl parameters = null;
    LexicalUnitImpl ownerLexicalUnit = null;

    public LexicalUnitImpl(short unitType) {
        this.unitType = unitType;
    }

    public short getLexicalUnitType() {
        return this.unitType;
    }

    void setUnitType(short unitType) {
        this.unitType = unitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public int getIntegerValue() {
        return this.intValue;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    public String getFunctionName() {
        return this.value;
    }

    public LexicalUnit getParameters() {
        return this.parameters;
    }

    public String getStringValue() {
        if (this.unitType == 37) {
            StringBuilder buf = new StringBuilder();
            LexicalUnitImpl lu = this.parameters;
            if (lu != null) {
                buf.append(((Object)lu).toString());
            }
            return buf.toString();
        }
        return this.value;
    }

    public LexicalUnit getSubValues() {
        if (this.unitType == 40) {
            return this.parameters;
        }
        return null;
    }

    void addFunctionParameter(LexicalUnitImpl paramUnit) {
        paramUnit.ownerLexicalUnit = this;
        if (this.parameters == null) {
            this.parameters = paramUnit;
        } else {
            LexicalUnitImpl lu = this.parameters;
            while (lu.getNextLexicalUnit() != null) {
                lu = lu.getNextLexicalUnit();
            }
            lu.nextLexicalUnit = paramUnit;
            paramUnit.previousLexicalUnit = lu;
        }
    }

    public String toString() {
        CharSequence s = this.currentToString();
        if (this.nextLexicalUnit == null) {
            return s.toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(s);
        boolean needSpaces = true;
        for (LexicalUnitImpl lu = (LexicalUnitImpl)this.nextLexicalUnit; lu != null; lu = (LexicalUnitImpl)lu.getNextLexicalUnit()) {
            switch (lu.getLexicalUnitType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 68: 
                case 69: {
                    needSpaces = false;
                }
                case 0: {
                    break;
                }
                default: {
                    if (needSpaces) {
                        buf.append(' ');
                        break;
                    }
                    needSpaces = true;
                }
            }
            buf.append(lu.currentToString());
        }
        return buf.toString();
    }

    private CharSequence currentToString() {
        switch (this.unitType) {
            case 13: {
                return Integer.toString(this.intValue);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                StringBuilder buf = new StringBuilder();
                if (this.floatValue % 1.0f != 0.0f) {
                    buf.append(String.format(Locale.US, "%s", Float.valueOf(this.floatValue)));
                } else {
                    buf.append(String.format(Locale.US, "%.0f", Float.valueOf(this.floatValue)));
                }
                if (this.dimensionUnitText != null) {
                    buf.append(this.dimensionUnitText);
                }
                return buf.toString();
            }
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 41: {
                StringBuilder buf = new StringBuilder();
                buf.append(this.value).append('(');
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    buf.append(((Object)lu).toString());
                }
                buf.append(')');
                return buf.toString();
            }
            case 40: {
                StringBuilder buf = new StringBuilder();
                buf.append('(');
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    buf.append(((Object)lu).toString());
                }
                buf.append(')');
                return buf.toString();
            }
            case 35: {
                String cssescaped = ParseHelper.escapeControl(this.value);
                cssescaped = ParseHelper.escapeCssChars(cssescaped);
                return cssescaped;
            }
            case 36: {
                return "'" + this.value + "'";
            }
            case 24: {
                return "url('" + this.value + "')";
            }
            case 0: {
                return ",";
            }
            case 6: {
                return "^";
            }
            case 10: {
                return ">=";
            }
            case 8: {
                return ">";
            }
            case 9: {
                return "<=";
            }
            case 7: {
                return "<";
            }
            case 2: {
                return "-";
            }
            case 5: {
                return "%";
            }
            case 3: {
                return "*";
            }
            case 1: {
                return "+";
            }
            case 4: {
                return "/";
            }
            case 11: {
                return "~";
            }
            case 68: {
                return "[";
            }
            case 69: {
                return "]";
            }
        }
        return "";
    }
}

