/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.SupportsCondition;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class SupportsConditionImpl
implements SupportsCondition {
    public SupportsCondition parent = null;

    @Override
    public void setParentCondition(SupportsCondition parent) {
        this.parent = parent;
    }

    @Override
    public SupportsCondition getParentCondition() {
        return this.parent;
    }

    @Override
    public SupportsCondition getParent(int depth) {
        SupportsCondition cond;
        int totaldepth = 1;
        for (cond = this.getParentCondition(); cond != null; cond = cond.getParentCondition()) {
            ++totaldepth;
        }
        cond = this;
        for (int i = 0; i < totaldepth - depth; ++i) {
            cond = cond.getParentCondition();
        }
        return cond;
    }

    @Override
    public abstract SupportsCondition.ConditionType getType();

    @Override
    public abstract String getMinifiedText();

    @Override
    public abstract void addCondition(SupportsCondition var1);

    @Override
    public abstract SupportsCondition replaceLast(SupportsCondition var1);

    @Override
    public abstract boolean supports(CSSCanvas var1);

    public static SupportsCondition createBooleanCondition(SupportsCondition.ConditionType type) {
        switch (type) {
            case AND_CONDITION: {
                return new AndCondition();
            }
            case OR_CONDITION: {
                return new OrCondition();
            }
            case NOT_CONDITION: {
                return new NotCondition();
            }
        }
        return null;
    }

    public static SupportsCondition createDeclarationCondition(String propertyName) {
        return new DeclarationCondition(propertyName);
    }

    static class DeclarationCondition
    extends SupportsConditionImpl
    implements SupportsCondition.DeclarationCondition<AbstractCSSValue> {
        String propertyName;
        AbstractCSSValue value = null;

        public DeclarationCondition(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void addCondition(SupportsCondition nestedCondition) {
        }

        @Override
        public SupportsConditionImpl replaceLast(SupportsCondition newCondition) {
            return this;
        }

        @Override
        public void setValue(AbstractCSSValue value) {
            this.value = value;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            return canvas.supports(this.propertyName, this.value);
        }

        @Override
        public SupportsCondition.ConditionType getType() {
            return SupportsCondition.ConditionType.DECLARATION_CONDITION;
        }

        @Override
        public String getMinifiedText() {
            return "(" + this.propertyName + ':' + this.value.getMinifiedCssText(this.propertyName) + ')';
        }

        public String toString() {
            return "(" + this.propertyName + ": " + this.value.getCssText() + ")";
        }
    }

    static class OrCondition
    extends SupportsConditionImpl {
        LinkedList<SupportsCondition> nestedConditions = new LinkedList();

        OrCondition() {
        }

        @Override
        public void addCondition(SupportsCondition condition) {
            condition.setParentCondition(this);
            this.nestedConditions.add(condition);
        }

        @Override
        public SupportsCondition replaceLast(SupportsCondition newCondition) {
            SupportsCondition last = this.nestedConditions.removeLast();
            last.setParentCondition(null);
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            Iterator it = this.nestedConditions.iterator();
            while (it.hasNext()) {
                if (!((SupportsCondition)it.next()).supports(canvas)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SupportsCondition.ConditionType getType() {
            return SupportsCondition.ConditionType.OR_CONDITION;
        }

        @Override
        public String getMinifiedText() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(((SupportsCondition)it.next()).getMinifiedText());
            while (it.hasNext()) {
                if (buf.charAt(buf.length() - 1) != ')') {
                    buf.append(' ');
                }
                buf.append("or");
                String nested = ((SupportsCondition)it.next()).getMinifiedText();
                if (nested.length() != 0 && nested.charAt(0) != '(') {
                    buf.append(' ');
                }
                buf.append(nested);
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(" or ").append(((SupportsCondition)it.next()).toString());
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    static class AndCondition
    extends SupportsConditionImpl {
        LinkedList<SupportsCondition> nestedConditions = new LinkedList();

        AndCondition() {
        }

        @Override
        public void addCondition(SupportsCondition condition) {
            condition.setParentCondition(this);
            this.nestedConditions.add(condition);
        }

        @Override
        public SupportsCondition replaceLast(SupportsCondition newCondition) {
            SupportsCondition last = this.nestedConditions.removeLast();
            last.setParentCondition(null);
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            Iterator it = this.nestedConditions.iterator();
            while (it.hasNext()) {
                if (((SupportsCondition)it.next()).supports(canvas)) continue;
                return false;
            }
            return true;
        }

        @Override
        public SupportsCondition.ConditionType getType() {
            return SupportsCondition.ConditionType.AND_CONDITION;
        }

        @Override
        public String getMinifiedText() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(((SupportsCondition)it.next()).getMinifiedText());
            while (it.hasNext()) {
                if (buf.charAt(buf.length() - 1) != ')') {
                    buf.append(' ');
                }
                buf.append("and");
                String nested = ((SupportsCondition)it.next()).getMinifiedText();
                if (nested.length() != 0 && nested.charAt(0) != '(') {
                    buf.append(' ');
                }
                buf.append(nested);
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            Iterator it = this.nestedConditions.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(" and ").append(it.next());
            }
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    static class NotCondition
    extends SupportsConditionImpl {
        SupportsCondition nestedCondition;

        NotCondition() {
        }

        @Override
        public void addCondition(SupportsCondition nestedCondition) {
            nestedCondition.setParentCondition(this);
            this.nestedCondition = nestedCondition;
        }

        @Override
        public SupportsCondition replaceLast(SupportsCondition newCondition) {
            SupportsCondition last = this.nestedCondition;
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public boolean supports(CSSCanvas canvas) {
            return !this.nestedCondition.supports(canvas);
        }

        @Override
        public SupportsCondition.ConditionType getType() {
            return SupportsCondition.ConditionType.NOT_CONDITION;
        }

        @Override
        public String getMinifiedText() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            buf.append("not");
            String nested = this.nestedCondition.getMinifiedText();
            if (nested.length() != 0 && nested.charAt(0) != '(') {
                buf.append(' ');
            }
            buf.append(nested);
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }

        public String toString() {
            boolean hasparent;
            StringBuilder buf = new StringBuilder();
            boolean bl = hasparent = this.getParentCondition() != null;
            if (hasparent) {
                buf.append('(');
            }
            buf.append("not ").append(this.nestedCondition.toString());
            if (hasparent) {
                buf.append(')');
            }
            return buf.toString();
        }
    }
}

