/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.ExtendedCSSValue;
import org.w3c.dom.DOMException;

public abstract class AbstractCSSValue
implements ExtendedCSSValue {
    private final short valueType;
    private String cssText = null;

    protected AbstractCSSValue(short valueType) {
        this.valueType = valueType;
    }

    protected AbstractCSSValue(AbstractCSSValue copied) {
        this(copied.valueType);
        this.cssText = copied.cssText;
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        this.setPlainCssText(cssText);
    }

    void setPlainCssText(String cssText) {
        this.cssText = cssText;
    }

    @Override
    public short getCssValueType() {
        return this.valueType;
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getCssText();
    }

    public boolean isSubproperty() {
        return false;
    }

    public boolean isSystemDefault() {
        return false;
    }

    public int hashCode() {
        return this.valueType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractCSSValue)) {
            return false;
        }
        AbstractCSSValue other = (AbstractCSSValue)obj;
        return this.valueType == other.valueType;
    }

    public abstract AbstractCSSValue clone();

    public String toString() {
        return this.getCssText();
    }
}

