/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSURIValue
extends CSSStringValue {
    public CSSURIValue() {
        this.setCSSUnitType((short)20);
    }

    protected CSSURIValue(CSSURIValue copied) {
        super(copied);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        ValueFactory factory;
        AbstractCSSValue cssval;
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        if (cssText.indexOf(40) == -1 && cssText.indexOf(41) == -1) {
            cssText = "url(" + cssText + ")";
        }
        if ((cssval = (factory = new ValueFactory()).parseProperty(cssText)) == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 20) {
            throw new DOMException(5, "Wrong URI value.");
        }
        this.setPlainCssText(cssval.getCssText());
        this.setStringValue(((CSSPrimitiveValue)((Object)cssval)).getStringValue());
    }

    @Override
    protected void setUnescapedCssText(String css) throws DOMException {
        int idx = (css = ParseHelper.escapeBackslash(css)).indexOf(39);
        if (idx != -1) {
            int len = css.length();
            StringBuilder buf = new StringBuilder(len + 8);
            buf.append(css.subSequence(0, idx));
            for (int i = idx; i < len; ++i) {
                char c = css.charAt(i);
                if (c == '\'') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            css = buf.toString();
        }
        this.setPlainCssText("url('" + css + "')");
    }

    public URL getURLValue() {
        URL url;
        String sv = this.getStringValue();
        try {
            url = new URL(sv);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    @Override
    public CSSURIValue clone() {
        return new CSSURIValue(this);
    }
}

