/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.ExtendedCSSValueList;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSURIValueWrapper;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class OMCSSValueList
extends AbstractCSSValue
implements CSSValueList,
ExtendedCSSValueList<AbstractCSSValue> {
    protected final List<AbstractCSSValue> valueList;

    private OMCSSValueList() {
        super((short)2);
        this.valueList = new ArrayList<AbstractCSSValue>();
    }

    private OMCSSValueList(OMCSSValueList copy) {
        super((short)2);
        this.valueList = new ArrayList<AbstractCSSValue>(copy.valueList);
    }

    @Override
    public int getLength() {
        return this.valueList.size();
    }

    @Override
    public AbstractCSSValue item(int index) {
        if (index < 0 || index >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public Iterator<AbstractCSSValue> iterator() {
        return this.valueList.iterator();
    }

    @Override
    public boolean add(AbstractCSSValue value) {
        if (value == null) {
            throw new NullPointerException("Null value added to CSSValueList");
        }
        return this.valueList.add(value);
    }

    public boolean addAll(OMCSSValueList list) {
        if (list == null) {
            throw new NullPointerException("Null list added to CSSValueList");
        }
        if (this.isCommaSeparated() != list.isCommaSeparated() || this.isBracketList() != list.isBracketList()) {
            throw new DOMException(13, "Attempted to add lists of different types");
        }
        return this.valueList.addAll(list.valueList);
    }

    @Override
    public AbstractCSSValue remove(int index) {
        return this.valueList.remove(index);
    }

    @Override
    public AbstractCSSValue set(int index, AbstractCSSValue value) {
        if (value == null) {
            throw new NullPointerException("Null value set to CSSValueList");
        }
        return this.valueList.set(index, value);
    }

    @Override
    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Override
    public void clear() {
        this.valueList.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * 31;
        if (this.valueList != null) {
            for (ExtendedCSSValue extendedCSSValue : this.valueList) {
                result = 31 * result + (extendedCSSValue == null ? 0 : extendedCSSValue.hashCode());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OMCSSValueList other = (OMCSSValueList)obj;
        if (this.valueList.isEmpty()) {
            if (!other.valueList.isEmpty()) {
                return false;
            }
        } else {
            if (this.valueList.size() != other.valueList.size()) {
                return false;
            }
            int sz = this.valueList.size();
            for (int i = 0; i < sz; ++i) {
                ExtendedCSSValue item = this.valueList.get(i);
                ExtendedCSSValue oitem = other.valueList.get(i);
                if (!(item == null ? oitem != null : !item.equals(oitem))) continue;
                return false;
            }
        }
        return true;
    }

    public void setSubproperty(boolean subp) {
        if (this.valueList != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                AbstractCSSValue val = this.item(i);
                if (val.getCssValueType() == 1) {
                    ((AbstractCSSPrimitiveValue)val).setSubproperty(true);
                    continue;
                }
                if (val.getCssValueType() == 0) {
                    this.set(i, ((CSSInheritValue)val).asSubproperty());
                    continue;
                }
                if (val.getCssValueType() != 2) continue;
                ((OMCSSValueList)val).setSubproperty(true);
            }
        }
    }

    @Override
    public boolean isSubproperty() {
        if (this.valueList != null) {
            Iterator<AbstractCSSValue> it = this.valueList.iterator();
            while (it.hasNext()) {
                if (it.next().isSubproperty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    public abstract boolean isCommaSeparated();

    public boolean isBracketList() {
        return false;
    }

    @Override
    public abstract OMCSSValueList clone();

    public static OMCSSValueList createCSValueList() {
        return new CSValueList();
    }

    public static OMCSSValueList createWSValueList() {
        return new WSValueList();
    }

    public static OMCSSValueList createBracketValueList() {
        return new BracketValueList();
    }

    public abstract OMCSSValueList wrap(String var1);

    private static class BracketValueList
    extends OMCSSValueList {
        private BracketValueList() {
        }

        private BracketValueList(BracketValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 18);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append('[').append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((AbstractCSSValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            buf.append(']');
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                wri.write('[');
                ((AbstractCSSValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(' ');
                    ((AbstractCSSValue)this.valueList.get(i)).writeCssText(wri);
                }
                wri.write(']');
            } else {
                wri.write("[]");
            }
        }

        @Override
        public boolean isBracketList() {
            return true;
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public OMCSSValueList clone() {
            return new BracketValueList(this);
        }

        @Override
        public OMCSSValueList wrap(String parentSheetHref) {
            return new BracketValueListWrapper((OMCSSValueList)this, parentSheetHref);
        }

        public static class BracketValueListWrapper
        extends WSValueList.WSValueListWrapper {
            BracketValueListWrapper(OMCSSValueList copy, String parentSheetHref) {
                super(copy, parentSheetHref);
            }

            @Override
            public OMCSSValueList clone() {
                return new BracketValueListWrapper(super.clone(), this.getParentSheetHref());
            }
        }
    }

    private static class WSValueList
    extends OMCSSValueList {
        private WSValueList() {
        }

        private WSValueList(OMCSSValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((AbstractCSSValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((AbstractCSSValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(' ');
                    ((AbstractCSSValue)this.valueList.get(i)).writeCssText(wri);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public OMCSSValueList clone() {
            return new WSValueList(this);
        }

        @Override
        public OMCSSValueList wrap(String parentSheetHref) {
            return new WSValueListWrapper((OMCSSValueList)this, parentSheetHref);
        }

        public static class WSValueListWrapper
        extends WSValueList
        implements WrappedValue {
            private String parentSheetHref;

            WSValueListWrapper(OMCSSValueList copy, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public AbstractCSSValue item(int index) {
                CSSValue val = super.item(index);
                if (val != null && ((AbstractCSSValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)val).getPrimitiveType() == 20) {
                    return new CSSURIValueWrapper((CSSURIValue)val, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public OMCSSValueList clone() {
                return new WSValueListWrapper(super.clone(), this.parentSheetHref);
            }
        }
    }

    private static class CSValueList
    extends OMCSSValueList {
        private CSValueList() {
        }

        private CSValueList(OMCSSValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getMinifiedCssText(propertyName));
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((AbstractCSSValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((AbstractCSSValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(',');
                    wri.write(' ');
                    ((AbstractCSSValue)this.valueList.get(i)).writeCssText(wri);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return true;
        }

        @Override
        public OMCSSValueList clone() {
            return new CSValueList(this);
        }

        @Override
        public OMCSSValueList wrap(String parentSheetHref) {
            return new CSValueListWrapper((OMCSSValueList)this, parentSheetHref);
        }

        public static class CSValueListWrapper
        extends CSValueList
        implements WrappedValue {
            private String parentSheetHref;

            CSValueListWrapper(OMCSSValueList copy, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public AbstractCSSValue item(int index) {
                CSSValue val = super.item(index);
                if (val != null && ((AbstractCSSValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)val).getPrimitiveType() == 20) {
                    return new CSSURIValueWrapper((CSSURIValue)val, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public OMCSSValueList clone() {
                return new CSValueListWrapper(super.clone(), this.parentSheetHref);
            }
        }
    }
}

