/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.DOMTokenList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class DOMTokenListImpl
implements DOMTokenList {
    private final LinkedList<String> tokenset = new LinkedList();

    @Override
    public int getLength() {
        return this.tokenset.size();
    }

    @Override
    public String getValue() {
        int sz = this.tokenset.size();
        if (sz == 0) {
            return "";
        }
        if (sz == 1) {
            return this.tokenset.getFirst();
        }
        StringBuilder buf = new StringBuilder(32 + 12 * this.tokenset.size());
        Iterator it = this.tokenset.iterator();
        buf.append((String)it.next());
        while (it.hasNext()) {
            buf.append(' ').append((String)it.next());
        }
        return buf.toString();
    }

    @Override
    public String getSortedValue() {
        int sz = this.tokenset.size();
        if (sz == 0) {
            return "";
        }
        if (sz == 1) {
            return this.tokenset.getFirst();
        }
        TreeSet<String> set = new TreeSet<String>(this.tokenset);
        StringBuilder buf = new StringBuilder(32 + 12 * this.tokenset.size());
        Iterator<String> it = set.iterator();
        buf.append(it.next());
        while (it.hasNext()) {
            buf.append(' ').append(it.next());
        }
        return buf.toString();
    }

    public void setValue(String value) throws DOMException {
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            this.tokenset.add(st.nextToken());
        }
    }

    @Override
    public String item(int index) {
        if (index < 0 || index >= this.tokenset.size()) {
            return null;
        }
        return this.tokenset.get(index);
    }

    @Override
    public boolean contains(String token) {
        return this.tokenset.contains(token);
    }

    @Override
    public boolean containsAll(Collection<String> tokenSet) {
        return this.tokenset.containsAll(tokenSet);
    }

    @Override
    public void add(String token) throws DOMException {
        if (token == null || token.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (token.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        if (this.tokenset.contains(token)) {
            this.tokenset.remove(token);
        }
        this.tokenset.add(token);
    }

    @Override
    public void remove(String token) throws DOMException {
        if (token == null || token.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (token.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        this.tokenset.remove(token);
    }

    @Override
    public boolean toggle(String token) throws DOMException {
        if (token == null || token.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (token.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        if (!this.tokenset.remove(token)) {
            return this.tokenset.add(token);
        }
        return false;
    }

    @Override
    public void replace(String oldToken, String newToken) throws DOMException {
        if (oldToken == null || newToken == null || oldToken.length() == 0 || newToken.length() == 0) {
            throw new DOMException(12, "Tokens cannot be empty");
        }
        if (oldToken.indexOf(32) != -1 || newToken.indexOf(32) != -1) {
            throw new DOMException(5, "Tokens cannot contain spaces");
        }
        int idx = this.tokenset.indexOf(oldToken);
        if (idx != -1) {
            this.tokenset.set(idx, newToken);
        }
    }
}

