/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

abstract class AbstractDOMNode
implements Node {
    private final short nodeType;
    private Node parentNode = null;
    final Map<String, Object> userData = new HashMap<String, Object>(1);
    final Map<String, UserDataHandler> userDataHandler = new HashMap<String, UserDataHandler>(1);
    static final DOMNodeList emptyNodeList = new EmptyNodeList();
    final DOMNodeList child;

    protected AbstractDOMNode(short nodeType) {
        this.nodeType = nodeType;
        this.child = this.createChildNodeList();
    }

    protected DOMNodeList createChildNodeList() {
        return emptyNodeList;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(15, "Node has no value");
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public NodeList getChildNodes() {
        return this.child;
    }

    @Override
    public Node getFirstChild() {
        if (this.child.isEmpty()) {
            return null;
        }
        return this.child.getFirst();
    }

    @Override
    public Node getLastChild() {
        if (this.child.isEmpty()) {
            return null;
        }
        return this.child.getLast();
    }

    @Override
    public Node getPreviousSibling() {
        AbstractDOMNode parent = (AbstractDOMNode)this.getParentNode();
        if (parent == null) {
            return null;
        }
        int index = parent.child.indexOf(this);
        if (index == 0) {
            return null;
        }
        return parent.child.get(index - 1);
    }

    @Override
    public Node getNextSibling() {
        AbstractDOMNode parent = (AbstractDOMNode)this.getParentNode();
        if (parent == null) {
            return null;
        }
        int index = parent.child.indexOf(this);
        if (index == parent.child.getLength() - 1) {
            return null;
        }
        return parent.child.get(index + 1);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        int index;
        Node node;
        if (newChild.getNodeType() == 2) {
            throw new DOMException(3, "Use setAttributeNode to add attribute nodes.");
        }
        for (node = this; node != null; node = node.getParentNode()) {
            if (!node.isSameNode(newChild)) continue;
            throw new DOMException(3, "Cannot insert itself or an ancestor.");
        }
        if (refChild == null) {
            index = this.child.getLength();
        } else {
            index = this.child.indexOf(refChild);
            if (index == -1) {
                throw new DOMException(8, "Not a child of this node.");
            }
            if (newChild.getOwnerDocument() != refChild.getOwnerDocument()) {
                throw new DOMException(4, "Different document owners.");
            }
            if (newChild.getNodeType() == 11) {
                DocumentFragment fragment = (DocumentFragment)newChild;
                NodeList nlist = fragment.getChildNodes();
                int count = nlist.getLength();
                for (int i = 0; i < count; ++i) {
                    node = nlist.item(i);
                    this.child.add(index + i, node);
                    ((AbstractDOMNode)node).setParentNode(this);
                    if (node.getNodeType() != 1) continue;
                    this.updateTaglistsOnInsert((DOMElement)node);
                }
                return newChild;
            }
        }
        this.child.add(index, newChild);
        ((AbstractDOMNode)newChild).setParentNode(this);
        if (newChild.getNodeType() == 1) {
            this.updateTaglistsOnInsert((DOMElement)newChild);
        }
        return newChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Node node;
        if (newChild.getOwnerDocument() != oldChild.getOwnerDocument()) {
            throw new DOMException(4, "Different document owners.");
        }
        if (newChild.getNodeType() == 2) {
            throw new DOMException(3, "Use setAttributeNode to add attribute nodes.");
        }
        for (node = this; node != null; node = node.getParentNode()) {
            if (!node.isSameNode(newChild)) continue;
            throw new DOMException(3, "Cannot append to itself or an ancestor.");
        }
        int index = this.child.indexOf(oldChild);
        if (index == -1) {
            throw new DOMException(8, "Not a child of this node.");
        }
        if (newChild.getNodeType() == 11) {
            DocumentFragment fragment = (DocumentFragment)newChild;
            NodeList nlist = fragment.getChildNodes();
            int count = nlist.getLength();
            if (count > 0) {
                node = nlist.item(0);
                oldChild = this.child.set(index, node);
                ((AbstractDOMNode)node).setParentNode(this);
                if (newChild.getNodeType() == 1) {
                    this.updateTaglistsOnInsert((DOMElement)newChild);
                }
                if (node.getNodeType() == 1) {
                    this.updateTaglistsOnRemove((DOMElement)node);
                }
                for (int i = 1; i < count; ++i) {
                    node = nlist.item(i);
                    this.child.add(index + i, node);
                    ((AbstractDOMNode)node).setParentNode(this);
                    if (node.getNodeType() != 1) continue;
                    this.updateTaglistsOnInsert((DOMElement)node);
                }
            }
        } else {
            oldChild = this.child.set(index, newChild);
            ((AbstractDOMNode)newChild).setParentNode(this);
            if (oldChild.getNodeType() == 1) {
                this.updateTaglistsOnRemove((DOMElement)oldChild);
            }
            if (newChild.getNodeType() == 1) {
                this.updateTaglistsOnInsert((DOMElement)newChild);
            }
        }
        ((AbstractDOMNode)oldChild).setParentNode(null);
        return oldChild;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (!this.child.remove(oldChild)) {
            throw new DOMException(8, "Not a child");
        }
        ((AbstractDOMNode)oldChild).setParentNode(null);
        if (oldChild.getNodeType() == 1) {
            this.updateTaglistsOnRemove((DOMElement)oldChild);
        }
        this.callUserHandlers((short)3, (AbstractDOMNode)oldChild, null);
        return oldChild;
    }

    void callUserHandlers(short operation, AbstractDOMNode child, Node destNode) {
        if (!child.userDataHandler.isEmpty()) {
            for (Map.Entry<String, UserDataHandler> entry : child.userDataHandler.entrySet()) {
                String key = entry.getKey();
                UserDataHandler handler = entry.getValue();
                if (handler == null) continue;
                handler.handle(operation, key, child.userData.get(key), child, destNode);
            }
        }
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        Object old_data = this.userData.get(key);
        this.userData.put(key, data);
        this.userDataHandler.put(key, handler);
        return old_data;
    }

    @Override
    public Object getUserData(String key) {
        return this.userData.get(key);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.checkAppendNode(newChild);
        Node node = newChild.getParentNode();
        if (node != null) {
            node.removeChild(newChild);
        }
        this.child.add(newChild);
        ((AbstractDOMNode)newChild).setParentNode(this);
        if (newChild.getNodeType() == 1) {
            DOMElement newElm = (DOMElement)newChild;
            this.updateTaglistsOnInsert(newElm);
            if (newElm.hasAttribute("class")) {
                this.updateClasslists(newElm);
            }
        }
        return newChild;
    }

    void checkAppendNode(Node newChild) {
        if (newChild.getNodeType() == 9) {
            throw new DOMException(3, "Cannot append a document.");
        }
        this.checkAppendNodeHierarchy(newChild);
        if (!this.checkDocumentOwner(newChild)) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    void checkAppendNodeHierarchy(Node newChild) {
        if (newChild.getNodeType() == 2) {
            throw new DOMException(3, "Use setAttributeNode to add attribute nodes.");
        }
        if (this.isSameNode(newChild)) {
            throw new DOMException(3, "Cannot append to itself.");
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!node.isSameNode(newChild)) continue;
            throw new DOMException(3, "Cannot append an ancestor.");
        }
    }

    boolean checkDocumentOwner(Node newChild) {
        return newChild.getOwnerDocument() == this.getOwnerDocument();
    }

    void updateTaglistsOnInsert(DOMElement newChild) {
        AbstractDOMNode node = (AbstractDOMNode)this.getParentNode();
        if (node != null) {
            node.updateTaglistsOnInsert(newChild);
        }
    }

    void updateTaglistsOnRemove(DOMElement oldChild) {
        AbstractDOMNode node = (AbstractDOMNode)this.getParentNode();
        if (node != null) {
            node.updateTaglistsOnRemove(oldChild);
        }
    }

    void updateClasslists(DOMElement owner) {
        AbstractDOMNode node = (AbstractDOMNode)this.getParentNode();
        if (node != null) {
            node.updateClasslists(owner);
        }
    }

    void updateClasslistsOnRemove(DOMElement oldChild) {
        AbstractDOMNode node = (AbstractDOMNode)this.getParentNode();
        if (node != null) {
            node.updateClasslistsOnRemove(oldChild);
        }
    }

    @Override
    public boolean hasChildNodes() {
        return !this.child.isEmpty();
    }

    @Override
    public void normalize() {
        Iterator<Node> it = this.child.iterator();
        short lasttype = 1;
        Node lastnode = null;
        while (it.hasNext()) {
            Node node = it.next();
            short type = node.getNodeType();
            if (type == 3) {
                String data = node.getNodeValue();
                if (data == null || data.length() == 0 || ((Text)node).isElementContentWhitespace()) {
                    ((AbstractDOMNode)node).setParentNode(null);
                    it.remove();
                    this.callUserHandlers((short)3, (AbstractDOMNode)node, null);
                    continue;
                }
                if (type == lasttype) {
                    ((Text)lastnode).setData(((Text)lastnode).getData() + " " + ((Text)node).getData());
                    ((AbstractDOMNode)node).setParentNode(null);
                    it.remove();
                    this.callUserHandlers((short)3, (AbstractDOMNode)node, null);
                }
            }
            lasttype = type;
            lastnode = node;
        }
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return "HTML".equals(feature);
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Node node;
        if (other == this) {
            return 0;
        }
        if (this.getOwnerDocument() != other.getOwnerDocument()) {
            return 1;
        }
        short mask = 0;
        int mydepth = 1;
        int otherdepth = 1;
        for (node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.equals(other)) {
                mask = (short)(mask + 16);
                mask = (short)(mask + 4);
                break;
            }
            mydepth = (short)(mydepth + 1);
        }
        if (mask == 0) {
            for (node = other.getParentNode(); node != null; node = node.getParentNode()) {
                if (node.equals(this)) {
                    mask = (short)(mask + 8);
                    mask = (short)(mask + 2);
                    break;
                }
                otherdepth = (short)(otherdepth + 1);
            }
        }
        if (mask == 0) {
            int depth = mydepth > otherdepth ? otherdepth : mydepth;
            int[] myindex = new int[depth];
            int[] otherindex = new int[depth];
            this.computeIndexArray(this, myindex);
            this.computeIndexArray((AbstractDOMNode)other, otherindex);
            for (int k = 0; k < depth; k = (int)((short)(k + 1))) {
                if (myindex[k] == otherindex[k]) continue;
                if (myindex[k] > otherindex[k]) {
                    return 4;
                }
                return 2;
            }
        }
        return mask;
    }

    private void computeIndexArray(AbstractDOMNode node, int[] myindex) {
        AbstractDOMNode parent = (AbstractDOMNode)node.getParentNode();
        int i = myindex.length - 1;
        while (parent != null) {
            myindex[i] = parent.child.indexOf(node);
            node = parent;
            parent = (AbstractDOMNode)node.getParentNode();
            --i;
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        String text;
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                int sz = this.child.getLength();
                if (sz == 0) {
                    text = "";
                    break;
                }
                if (sz == 1) {
                    text = this.child.getFirst().getTextContent();
                    break;
                }
                StringBuilder buf = new StringBuilder(32 + sz * 20);
                Iterator<Node> it = this.child.iterator();
                while (it.hasNext()) {
                    String tc;
                    Node node = it.next();
                    short type = node.getNodeType();
                    if (type == 8 || type == 7 || (tc = node.getTextContent()) == null) continue;
                    buf.append(tc);
                }
                text = buf.toString();
                break;
            }
            case 3: {
                if (((Text)((Object)this)).isElementContentWhitespace()) {
                    text = "";
                    break;
                }
                text = this.getNodeValue();
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                text = this.getNodeValue();
                break;
            }
            default: {
                text = null;
            }
        }
        return text;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.child.clear();
        if (textContent != null && textContent.length() > 0) {
            AbstractDOMNode text = (AbstractDOMNode)((Object)this.getOwnerDocument().createTextNode(textContent));
            this.child.add(text);
            text.setParentNode(this);
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        Document owner = this.getOwnerDocument();
        if (owner != null) {
            return owner.isDefaultNamespace(namespaceURI);
        }
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        int sz;
        if (arg != null && this.getNodeType() == arg.getNodeType() && this.getNodeName().equals(arg.getNodeName()) && this.stringEquals(this.getLocalName(), arg.getLocalName()) && this.stringEquals(this.getNamespaceURI(), arg.getNamespaceURI()) && this.stringEquals(this.getPrefix(), arg.getPrefix()) && this.stringEquals(this.getNodeValue(), arg.getNodeValue()) && (sz = this.child.getLength()) == arg.getChildNodes().getLength()) {
            this.normalize();
            arg.normalize();
            NodeList otherchild = arg.getChildNodes();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).isEqualNode(otherchild.item(i))) continue;
                return false;
            }
            NamedNodeMap nmap = this.getAttributes();
            NamedNodeMap othernmap = arg.getAttributes();
            if (nmap == null) {
                if (othernmap == null) {
                    return true;
                }
            } else {
                sz = nmap.getLength();
                if (sz == othernmap.getLength()) {
                    block1: for (int i = 0; i < sz; ++i) {
                        Node attr = nmap.item(i);
                        for (int j = 0; j < sz; ++j) {
                            if (attr.isEqualNode(othernmap.item(j))) continue block1;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean stringEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    Node getFirstElementChild() {
        Iterator<Node> it = this.child.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    Node getLastElementChild() {
        Iterator<Node> it = this.child.descendingIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    int getChildElementCount() {
        int count = 0;
        Iterator<Node> it = this.child.iterator();
        while (it.hasNext()) {
            if (it.next().getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    class ChildElementList
    implements DOMElementList {
        ChildElementList() {
        }

        @Override
        public DOMElement item(int index) {
            int idx = 0;
            Iterator<Node> it = AbstractDOMNode.this.child.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (node.getNodeType() != 1) continue;
                if (idx == index) {
                    return (DOMElement)node;
                }
                ++idx;
            }
            return null;
        }

        @Override
        public int getLength() {
            return AbstractDOMNode.this.getChildElementCount();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.getLength() * 32 + 40);
            Iterator<Node> it = AbstractDOMNode.this.child.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (node.getNodeType() != 1) continue;
                buf.append(node.toString());
            }
            return buf.toString();
        }
    }

    static class NVEmptyNodeList
    extends EmptyNodeList {
        NVEmptyNodeList() {
        }

        @Override
        public boolean add(Node node) {
            return false;
        }
    }

    static class EmptyNodeList
    implements DOMNodeList {
        EmptyNodeList() {
        }

        @Override
        public boolean add(Node node) throws DOMException {
            throw new DOMException(3, "Cannot add children to this node");
        }

        @Override
        public void add(int index, Node node) throws DOMException {
            throw new DOMException(3, "Cannot add children to this node");
        }

        @Override
        public void clear() {
        }

        @Override
        public Node get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Node getFirst() {
            return null;
        }

        @Override
        public Node getLast() {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public int indexOf(Object node) {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public Iterator<Node> iterator() {
            return new EmptyIterator();
        }

        @Override
        public Iterator<Node> descendingIterator() {
            return new EmptyIterator();
        }

        @Override
        public boolean remove(Object node) {
            return false;
        }

        @Override
        public Node set(int index, Node node) {
            throw new DOMException(15, "Cannot add children to this node");
        }

        public String toString() {
            return "";
        }

        class EmptyIterator
        implements Iterator<Node> {
            EmptyIterator() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Node next() {
                throw new NoSuchElementException();
            }
        }
    }

    static interface DOMNodeList
    extends NodeList {
        public boolean add(Node var1) throws DOMException;

        public void add(int var1, Node var2) throws DOMException;

        public void clear();

        public Node get(int var1);

        public Node getFirst();

        public Node getLast();

        public int indexOf(Object var1);

        public boolean isEmpty();

        public Iterator<Node> iterator();

        public Iterator<Node> descendingIterator();

        public boolean remove(Object var1);

        public Node set(int var1, Node var2);
    }
}

