/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LogErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;

public class CSSDOMImplementation
extends BaseCSSStyleSheetFactory
implements DOMImplementation {
    private BaseDocumentCSSStyleSheet defStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaStyleSheet = null;
    private final ErrorHandler errorHandler = this.createErrorHandler();

    public CSSDOMImplementation(CSSStyleSheetFactory.ComplianceMode complianceMode) {
        super(complianceMode);
    }

    public CSSDOMImplementation() {
        this(CSSStyleSheetFactory.ComplianceMode.LENIENT);
    }

    @Override
    public DOMDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        DOMDocument document = namespaceURI == null || namespaceURI.equals("http://www.w3.org/1999/xhtml") || doctype != null && "html".equalsIgnoreCase(doctype.getName()) ? new MyHTMLDocument(doctype) : new MyXMLDocument(doctype);
        if (qualifiedName != null && qualifiedName.length() != 0) {
            document.appendChild(document.createElementNS(namespaceURI, qualifiedName));
        }
        return document;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        return new DocumentTypeImpl(qualifiedName, publicId, systemId);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        return !"svg".equalsIgnoreCase(feature);
    }

    @Override
    public BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
        return new MyDocumentCSSStyleSheet(null, origin);
    }

    @Override
    public BaseCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
        return new MyCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
    }

    @Override
    public BaseCSSStyleSheet createLinkedStyleSheet(Node ownerNode, String title, MediaQueryList mediaList) {
        Node titleattr;
        NamedNodeMap nnm;
        if (title == null && ownerNode != null && (nnm = ownerNode.getAttributes()) != null && (titleattr = nnm.getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new MyCSSStyleSheet(title, ownerNode, mediaList, null, 8);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSElement parent) {
        MyDOMCSSStyleDeclaration style = new MyDOMCSSStyleDeclaration();
        style.setOwnerNode(node);
        return style;
    }

    private void setUserAgentStyleSheet(BaseDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    @Override
    public BaseDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        try {
            this.setUserAgentStyleSheet((DOMDocumentCSSStyleSheet)this.htmlDefaultSheet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    @Override
    protected BaseDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.getUserNormalStyleSheet() != null) {
            this.defStyleSheet.addStyleSheet(this.getUserNormalStyleSheet());
        }
    }

    @Override
    protected ErrorHandler createErrorHandler() {
        return new LogErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    protected InlineStyle createInlineStyle(Node owner) {
        MyInlineStyle style = new MyInlineStyle();
        style.setOwnerNode(owner);
        return style;
    }

    class MyXMLDocument
    extends DOMDocument {
        public MyXMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return url.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyHTMLDocument
    extends HTMLDocument {
        public MyHTMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return url.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyDOMCSSStyleDeclaration
    extends DOMCSSStyleDeclaration {
        public MyDOMCSSStyleDeclaration() {
        }

        public MyDOMCSSStyleDeclaration(BaseCSSStyleSheet parentSheet) {
            super(parentSheet);
        }

        MyDOMCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        protected CSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        protected void setOwnerNode(Node node) {
            super.setOwnerNode(node);
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMCSSStyleDeclaration styleClone = new MyDOMCSSStyleDeclaration(this);
            styleClone.setOwnerNode(this.getOwnerNode());
            return styleClone;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        public MyInlineStyle() {
        }

        public MyInlineStyle(InlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected void setOwnerNode(Node node) {
            super.setOwnerNode(node);
        }

        @Override
        public boolean hasOverrideStyle(String pseudoElt) {
            Node node = this.getOwnerNode();
            if (node != null) {
                return ((DOMElement)node).hasOverrideStyle(pseudoElt);
            }
            return false;
        }

        @Override
        protected CSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public InlineStyle clone() {
            MyInlineStyle styleClone = new MyInlineStyle(this);
            styleClone.setOwnerNode(this.getOwnerNode());
            return styleClone;
        }
    }

    class MyDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        MyDocumentCSSStyleSheet(String medium, byte origin) {
            super(medium, origin);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String medium, byte origin) {
            return new MyDocumentCSSStyleSheet(medium, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyCSSStyleSheet
    extends DOMCSSStyleSheet {
        MyCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, CSSRule ownerRule, byte origin) {
            super(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, CSSRule ownerRule, byte origin) {
            return new MyCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle() {
            return new MyDOMCSSStyleDeclaration();
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }
}

