/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMStringListImpl;
import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.ChildNodeList;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleSheetList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.doc.style.css.om.OMStyleSheetList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.LinkStyle;

public abstract class DOMDocument
extends DOMNode
implements CSSDocument,
ParentNode,
CSSRuleListener {
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private DOMConfiguration domConfig = new MyDOMConfiguration();
    private boolean xmlStandalone = false;
    private boolean strictErrorChecking = true;
    public DOMErrorHandler errorHandler = null;
    private String documentURI = null;
    static final AbstractDOMNode.DOMNodeList nvemptyNodeList = new AbstractDOMNode.NVEmptyNodeList();
    final Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    final Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public DOMDocument(DocumentType documentType) {
        super((short)9);
        if (documentType != null && documentType.getOwnerDocument() == null) {
            this.child.add(documentType);
        }
    }

    @Override
    protected AbstractDOMNode.DOMNodeList createChildNodeList() {
        return new ChildNodeList();
    }

    @Override
    public DOMElement getDocumentElement() {
        int sz = this.child.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = this.child.get(i);
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        int sz = this.child.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = this.child.get(i);
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return null;
    }

    @Override
    public CSSNode getParentNode() {
        return null;
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    @Override
    public DOMDocument cloneNode(boolean deep) {
        DOMDocument doc = this.getImplementation().createDocument(null, null, this.getDoctype());
        if (deep) {
            doc.appendChild(doc.adoptNode(this.getDocumentElement()));
        }
        this.callUserHandlers((short)1, this, doc);
        return doc;
    }

    @Override
    public abstract CSSDOMImplementation getImplementation();

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    MediaQueryList parseMediaList(String media) {
        MediaQueryList mediaList;
        if (media.length() == 0) {
            mediaList = OMMediaList.createMediaList();
        } else {
            mediaList = MediaQueryFactory.createMediaList(media);
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                return null;
            }
        }
        return mediaList;
    }

    BaseCSSStyleSheet loadStyleSheet(String href, String title, MediaQueryList media, Node ownerNode) {
        BaseCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        String referrerPolicy = this.getReferrerpolicyAttribute(ownerNode);
        try {
            URL url = this.getURL(href);
            sheet.setHref(url.toExternalForm());
            sheet.loadStyleSheet(url, referrerPolicy);
        }
        catch (Exception e) {
            this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
        }
        return sheet;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node rp;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (rp = nnm.getNamedItem("referrerpolicy")) != null) {
            return rp.getNodeValue();
        }
        return "";
    }

    BaseCSSStyleSheet parseEmbeddedStyleSheet(String styleText, String title, MediaQueryList media, Node ownerNode) {
        BaseCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        if (styleText.length() != 0) {
            sheet.setHref(this.getBaseURI());
            InputSource source = new InputSource();
            StringReader re = new StringReader(styleText);
            source.setCharacterStream((Reader)re);
            try {
                sheet.parseCSSStyleSheet(source);
            }
            catch (Exception e) {
                this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
            }
        }
        return sheet;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement element) {
        if (element != null) {
            return this.getEmbeddedStyleDefiner(element.getId());
        }
        return null;
    }

    protected boolean isRawTextElementName(String localName) {
        return false;
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (DOMDocument.isValidCharacter(name.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCharacter(int cp) {
        return cp >= 45 && cp != 58 && cp != 60 && cp != 61 && cp != 62 && cp != 63 && cp != 92 && cp != 34 && cp != 39 && cp != 47;
    }

    static String escapeCloseTag(String tagname, String data) {
        int idx = data.indexOf(60);
        if (idx == -1) {
            return data;
        }
        int tnidx = data.indexOf(tagname, 2);
        if (tnidx == -1) {
            return data;
        }
        StringBuilder buf = null;
        int tnlen = tagname.length();
        int lenm1 = data.length() - 1;
        while (idx < lenm1) {
            int i;
            char d;
            char c = data.charAt(idx);
            if (c == '<' && (d = data.charAt(i = idx + 1)) == '/' && lenm1 - i > tnlen) {
                ++i;
                if ((i = DOMDocument.skipIgnorableChars(i, data, lenm1)) < lenm1 && data.regionMatches(true, i, tagname, 0, tnlen) && (i = DOMDocument.skipIgnorableChars(i + tnlen, data, lenm1)) <= lenm1 && data.charAt(i) == '>') {
                    if (buf == null) {
                        buf = new StringBuilder(lenm1 + 4);
                        buf.append(data.subSequence(0, idx));
                    }
                    buf.append("&lt;");
                    buf.append(data.subSequence(idx + 1, i + 1));
                    idx = i + 1;
                    continue;
                }
            }
            if (buf != null) {
                buf.append(c);
            }
            ++idx;
        }
        if (buf != null && idx == lenm1) {
            buf.append(data.charAt(idx));
        }
        return buf == null ? data : buf.toString();
    }

    private static int skipIgnorableChars(int idx, String text, int lenm1) {
        while (idx < lenm1) {
            char c = text.charAt(idx);
            if (c != ' ' && c != '\t' && c != '\n') {
                if (c != '\r') break;
                int i = idx + 1;
                if (text.charAt(i) == '\n') {
                    idx = i;
                }
            }
            ++idx;
        }
        return idx;
    }

    private static String escapeLtGtEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    static StringBuilder appendEntityToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length() + 2);
            buf.append(text.subSequence(0, index));
        }
        buf.append('&').append(string).append(';');
        return buf;
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(null, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() == 0) {
                namespaceURI = null;
                localName = qualifiedName.toLowerCase(Locale.US);
            } else {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                    localName = qualifiedName;
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            }
        } else {
            if (qualifiedName.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            localName = qualifiedName.toLowerCase(Locale.US);
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        localName = localName.intern();
        MyXMLElement myelem = new MyXMLElement(localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public DOMDocumentFragment createDocumentFragment() {
        return new DOMDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyText text = new MyText();
        text.setData(data);
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyComment my = new MyComment();
        my.setData(data);
        return my;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection my = new MyCDATASection();
        my.setData(data);
        return my;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null) {
            throw new DOMException(5, "null target");
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "An xml declaration is not a processing instruction");
        }
        if (target.indexOf(58) != -1) {
            throw new DOMException(5, "A processing instruction target cannot contain a ':'");
        }
        if (data.contains("?>")) {
            throw new DOMException(5, "A processing instruction data cannot contain a '?>'");
        }
        if ("xml-stylesheet".equals(target)) {
            return new MyStyleProcessingInstruction(data);
        }
        return new MyProcessingInstruction(target, data);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(name);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null name");
        }
        return this.createAttributeNS(null, name.toLowerCase(Locale.US));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            } else {
                if (qualifiedName.indexOf(58) != -1) {
                    throw new DOMException(14, "Prefix with null namespace");
                }
                namespaceURI = null;
            }
        } else if (qualifiedName.indexOf(58) != -1) {
            throw new DOMException(14, "Prefix with null namespace");
        }
        localName = localName.intern();
        Attr my = this.createAttributeNS(namespaceURI, prefix, localName);
        return my;
    }

    Attr createAttributeNS(String namespaceURI, String prefix, String localName) throws DOMException {
        MyAttr my;
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        if (localName == "xmlns") {
            if (!XMLNS_NAMESPACE_URI.equals(namespaceURI)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            my = new XmlnsAttr();
        } else {
            my = localName == "class" ? new ClassAttr(namespaceURI) : (localName == "base" && "xml".equals(prefix) ? new StyleEventAttr(localName, namespaceURI) : new MyAttr(localName, namespaceURI));
        }
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    public DOMElementList getElementsByTagName(String tagname) {
        return this.getDocumentElement().getElementsByTagName(tagname);
    }

    public DOMElementList getElementsByClassName(String names) {
        return this.getDocumentElement().getElementsByClassName(names);
    }

    @Override
    public DOMElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getDocumentElement().getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        DOMElement html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        return this.lookupPrefix(html, namespaceURI);
    }

    private String lookupPrefix(Node node, String namespaceURI) {
        if (node.getNamespaceURI() == namespaceURI) {
            String prefix = node.getPrefix();
            if (prefix != null) {
                return prefix;
            }
            return null;
        }
        NodeList list = node.getChildNodes();
        int sz = list.getLength();
        for (int i = 0; i < sz; ++i) {
            String prefix;
            Node cnode = list.item(i);
            if (cnode.getNodeType() != 1 || (prefix = this.lookupPrefix(cnode, namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public DOMElement getElementById(String elementId) {
        return this.findElementById(this.getChildNodes(), elementId);
    }

    private DOMElement findElementById(NodeList nl, String elementId) {
        int sz = nl.getLength();
        for (int i = 0; i < sz; ++i) {
            DOMElement elm;
            String idValue;
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && (idValue = (elm = (DOMElement)node).getId()).equals(elementId)) {
                return elm;
            }
            elm = this.findElementById(node.getChildNodes(), elementId);
            if (elm == null) continue;
            return elm;
        }
        return null;
    }

    @Override
    public DOMElementList querySelectorAll(String selectors) {
        return DOMElement.querySelectorAll(selectors, this.getChildNodes());
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr importedAttr = (Attr)importedNode;
                Attr attr = importedAttr.getLocalName() != null ? this.createAttributeNS(importedAttr.getNamespaceURI(), importedAttr.getLocalName()) : this.createAttribute(importedNode.getNodeName());
                attr.setValue(importedNode.getNodeValue());
                if (importedAttr.getPrefix() != null) {
                    attr.setPrefix(importedAttr.getPrefix());
                }
                ((DOMAttr)attr).specified = importedAttr.getSpecified();
                return attr;
            }
            case 1: {
                Element foreignElm = (Element)importedNode;
                DOMElement elm = foreignElm.getLocalName() != null ? this.createElementNS(foreignElm.getNamespaceURI(), foreignElm.getLocalName()) : this.createElement(importedNode.getNodeName());
                NamedNodeMap attributes = foreignElm.getAttributes();
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    Attr importedAttr = (Attr)attributes.item(i);
                    Attr attr = (Attr)this.importNode(importedAttr, true);
                    elm.setAttributeNode(attr);
                    if (!importedAttr.isId()) continue;
                    elm.setIdAttributeNode(attr, true);
                }
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        elm.appendChild(this.importNode(list.item(i), true));
                    }
                }
                return elm;
            }
            case 3: {
                return this.createTextNode(importedNode.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(importedNode.getNodeValue());
            }
            case 8: {
                return this.createComment(importedNode.getNodeValue());
            }
            case 11: {
                DOMDocumentFragment df = this.createDocumentFragment();
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        df.appendChild(this.importNode(list.item(i), true));
                    }
                }
            }
            case 5: {
                return this.createEntityReference(importedNode.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "Node adoption not supported");
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        short newType = newChild.getNodeType();
        if (refChild != null && newType != refChild.getNodeType()) {
            if (newType == 1) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
            } else if (newType == 10) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
            }
        }
        if (newType == 10) {
            if (newChild instanceof DocumentTypeImpl) {
                ((DocumentTypeImpl)newChild).setOwnerDocument(this);
            } else {
                throw new DOMException(9, "Inserting foreign doctypes not supported.");
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        short newType = newChild.getNodeType();
        if (newType != oldChild.getNodeType()) {
            if (newType == 1) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
            } else if (newType == 10) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
            }
        }
        if (newType == 10) {
            if (newChild instanceof DocumentTypeImpl) {
                ((DocumentTypeImpl)newChild).setOwnerDocument(oldChild.getOwnerDocument());
            } else {
                throw new DOMException(9, "Replacement with foreign doctypes not supported.");
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        block3: {
            block2: {
                if (newChild.getNodeType() != 1) break block2;
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newChild.getNodeType() != 10) break block3;
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.appendChild(newChild);
    }

    @Override
    protected boolean checkDocumentOwner(Node newChild) {
        return newChild.getNodeType() == 10 || newChild.getOwnerDocument() == this;
    }

    @Override
    public DOMElementList getChildren() {
        return this.getDocumentElement().getChildren();
    }

    @Override
    public DOMElement getFirstElementChild() {
        return this.getDocumentElement().getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return this.getDocumentElement().getLastElementChild();
    }

    @Override
    public int getChildElementCount() {
        return this.getDocumentElement().getChildElementCount();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public void normalizeDocument() {
        this.getDocumentElement().normalize();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getDocumentElement().lookupNamespaceURI(prefix);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        int i;
        this.linkedStyle.clear();
        NodeList nl = this.getLinkedStyleNodeList();
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            LinkStyleDefiner link = (LinkStyleDefiner)nl.item(i);
            if (link.getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        this.embeddedStyle.clear();
        nl = this.getEmbeddedStyleNodeList();
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            this.embeddedStyle.add((LinkStyleDefiner)nl.item(i));
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<LinkStyleDefiner> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(CSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    protected NodeList getLinkedStyleNodeList() {
        return this.getLinkedStyleNodeList(true);
    }

    protected NodeList getEmbeddedStyleNodeList() {
        return this.getLinkedStyleNodeList(false);
    }

    private AbstractDOMNode.DOMNodeList getLinkedStyleNodeList(boolean external) {
        AbstractDOMNode.DOMNodeList list = null;
        Iterator<Node> it = this.child.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1) continue;
                if (href.charAt(0) == '#') {
                    if (external) continue;
                    if (list == null) {
                        list = new ChildNodeList();
                    }
                    list.add(node);
                    continue;
                }
                if (!external) continue;
                if (list == null) {
                    list = new ChildNodeList();
                }
                list.add(node);
                continue;
            }
            if (type != 1) continue;
            break;
        }
        return list == null ? AbstractDOMNode.emptyNodeList : list;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(String id) {
        Iterator<Node> it = this.child.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1 || href.charAt(0) != '#') continue;
                return pi;
            }
            if (type != 1) continue;
            break;
        }
        return null;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        this.mergedStyleSheet = this.targetMedium == null ? this.getStyleSheetFactory().getDefaultStyleSheet().clone() : this.getStyleSheetFactory().getDefaultStyleSheet().clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<CSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        String selectedSetName = "";
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onStyleModify() {
        this.mergedStyleSheet = null;
        this.sheets.setNeedsUpdate(true);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return ((DOMElement)elt).getOverrideStyle(pseudoElt);
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = this.getStyleSheetFactory().getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = this.getStyleSheetFactory().getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings();
    }

    @Override
    public void onFontFaceRule(CSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(CSSPageRule rule) {
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        } else if ("referrer".equals(name)) {
            this.metaReferrerPolicy = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        } else if ("referrer".equals(name)) {
            this.metaReferrerPolicy = "";
        }
    }

    @Override
    public URL getBaseURL() {
        URL baseURL = null;
        String buri = this.getBaseURI();
        if (buri != null) {
            try {
                baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return baseURL;
    }

    @Override
    public String getBaseURI() {
        String attr;
        String buri = this.getDocumentURI();
        DOMElement elm = this.getDocumentElement();
        if (elm != null && (attr = elm.getAttribute("xml:base")).length() != 0) {
            if (buri != null && attr.startsWith("//")) {
                try {
                    URL url = new URL(buri);
                    url = new URL(url, attr);
                    buri = url.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                buri = attr;
            }
        }
        return buri;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    @Override
    public String getReferrerPolicy() {
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = policy;
        }
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    private static InputStream openResourceStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return DOMDocument.class.getResourceAsStream(fileName);
            }
        });
    }

    class MyOMStyleSheetList
    extends OMStyleSheetList {
        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<CSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = (AbstractCSSStyleSheet)it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected Iterator<CSSStyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            DOMDocument.this.updateStyleLists();
        }
    }

    class MyDOMConfiguration
    implements DOMConfiguration {
        private final Properties parameters = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyDOMConfiguration() {
            BufferedReader re = null;
            try {
                re = new BufferedReader(new InputStreamReader(DOMDocument.openResourceStream("/io/sf/carte/doc/dom/domconfig.properties"), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.parameters.load(re);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    re.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public boolean canSetParameter(String name, Object value) {
            return name.equals("error-handler") && value instanceof DOMErrorHandler;
        }

        @Override
        public Object getParameter(String name) throws DOMException {
            return this.parameters.getProperty(name);
        }

        @Override
        public DOMStringList getParameterNames() {
            String[] names = this.parameters.keySet().toArray(new String[0]);
            return new DOMStringListImpl(names);
        }

        @Override
        public void setParameter(String name, Object value) throws DOMException {
            if (name.equals("error-handler") && value instanceof DOMErrorHandler) {
                DOMDocument.this.errorHandler = (DOMErrorHandler)value;
            } else if (this.canSetParameter(name, value)) {
                this.parameters.setProperty(name, value.toString());
            }
        }
    }

    class MyXMLElement
    extends DOMElement {
        private HashMap<String, String> idAttrNameMap;

        MyXMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
            this.idAttrNameMap = new HashMap();
        }

        @Override
        public String getId() {
            Attr attr = (Attr)this.nodeMap.getNodeMap().get(this.idAttrNameMap.get(null));
            return attr == null ? "" : attr.getNodeValue();
        }

        @Override
        boolean isIdAttributeNS(String namespaceURI, String localName) {
            return localName.equals(this.idAttrNameMap.get(namespaceURI));
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (!this.hasAttribute(name)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setNamespaceIdAttr(null, name, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            if (!this.hasAttributeNS(namespaceURI, localName)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setNamespaceIdAttr(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            if (idAttr == null || !this.nodeMap.getNodeMap().containsValue(idAttr)) {
                throw new DOMException(8, "Not an attribute of this element");
            }
            this.setNamespaceIdAttr(idAttr.getNamespaceURI(), idAttr.getLocalName(), isId);
        }

        private void setNamespaceIdAttr(String namespaceURI, String localName, boolean isId) {
            if (isId) {
                this.idAttrNameMap.put(namespaceURI, localName);
            } else if (localName.equals(this.idAttrNameMap.get(namespaceURI))) {
                this.idAttrNameMap.remove(namespaceURI);
            }
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyXMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        DOMElement cloneElementNode(MyXMLElement my, boolean deep) {
            for (Attr attr : this.nodeMap.attributes.values()) {
                MyAttr myattr = new MyAttr(attr.getLocalName(), attr.getNamespaceURI());
                myattr.setValue(attr.getValue());
                myattr.setPrefix(attr.getPrefix());
                myattr.specified = attr.getSpecified();
                my.setAttributeNode(myattr);
                if (!attr.isId()) continue;
                my.setIdAttributeNode(myattr, true);
            }
            if (deep && this.hasChildNodes()) {
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class ClassAttr
    extends MyAttr {
        ClassAttr(String namespaceURI) {
            super("class", namespaceURI);
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            CSSNode parent;
            DOMElement owner;
            if (parentNode == null && (owner = this.getOwnerElement()) != null && this.isSameNamespace(owner.getNamespaceURI())) {
                parent = owner.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    ((DOMElement)parent).updateClasslistsOnRemove(owner);
                }
                if (owner.classList != null) {
                    this.value = owner.classList.getValue();
                    owner.classList.clear();
                }
            }
            super.setParentNode(parentNode);
            if (parentNode != null && this.isSameNamespace((owner = (DOMElement)parentNode).getNamespaceURI())) {
                if (owner.classList != null) {
                    owner.classList.setValue(this.value);
                }
                if ((parent = owner.getParentNode()) != null && parent.getNodeType() == 1) {
                    ((DOMElement)parent).updateClasslists(owner);
                }
            }
        }

        private boolean isSameNamespace(String ownerNamespaceURI) {
            String namespaceURI = this.getNamespaceURI();
            if (namespaceURI == null) {
                return ownerNamespaceURI == null || this.isDefaultNamespace(ownerNamespaceURI);
            }
            return namespaceURI.equals(ownerNamespaceURI);
        }

        @Override
        public String getValue() {
            DOMElement.ClassList list = this.getListValue();
            if (list == null) {
                return super.getValue();
            }
            return list.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement.ClassList list = this.getListValue();
            if (list != null) {
                list.setValue(value);
            }
        }

        DOMElement.ClassList getListValue() {
            DOMElement owner = this.getOwnerElement();
            if (owner == null || !this.isSameNamespace(owner.getNamespaceURI())) {
                return null;
            }
            return (DOMElement.ClassList)owner.getClassList();
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(String name, String namespaceURI) {
            super(name, namespaceURI);
        }

        @Override
        void setParentNode(Node parentNode) {
            super.setParentNode(parentNode);
            this.onDOMChange(parentNode);
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node ownerNode) {
            if (ownerNode != null && ownerNode instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)ownerNode).resetLinkedSheet();
            }
        }
    }

    class XmlnsAttr
    extends MyAttr {
        XmlnsAttr() {
            super("xmlns", null);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }
    }

    class MyAttr
    extends DOMAttr {
        MyAttr(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public boolean isId() {
            DOMElement owner = this.getOwnerElement();
            return owner != null && owner.isIdAttributeNS(this.getNamespaceURI(), this.getLocalName());
        }

        @Override
        public Attr cloneNode(boolean deep) {
            MyAttr my = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getNamespaceURI(), this.getName());
            my.setValue(this.getValue());
            my.specified = true;
            this.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public CDATASection cloneNode(boolean deep) {
            MyCDATASection my = new MyCDATASection();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short nodeType) {
            super(nodeType);
            this.elementContentWhitespace = false;
        }

        @Override
        void setParentNode(Node parentNode) {
            if (parentNode == null) {
                this.onDOMChange((DOMElement)this.getParentNode());
                super.setParentNode(parentNode);
            } else {
                this.onDOMChange((DOMElement)this.getParentNode());
                super.setParentNode(parentNode);
                this.onDOMChange((DOMElement)parentNode);
            }
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            this.onDOMChange((DOMElement)this.getParentNode());
        }

        void onDOMChange(DOMElement container) {
            LinkStyleDefiner definer = DOMDocument.this.getEmbeddedStyleDefiner(container);
            if (definer != null) {
                definer.resetLinkedSheet();
            }
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            Text newnode;
            CSSNode parent = this.getParentNode();
            try {
                String newdata = this.data.substring(0, offset);
                newnode = this.getOwnerDocument().createTextNode(this.data.substring(offset, this.data.length()));
                if (parent != null) {
                    parent.insertBefore(newnode, this.getNextSibling());
                }
                this.setData(newdata);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            return newnode;
        }

        @Override
        public boolean isElementContentWhitespace() {
            if (this.data != null) {
                int dl = this.data.length();
                for (int i = 0; i < dl; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getWholeText() {
            short type;
            short type2;
            Node node;
            Node firstnode = this;
            for (node = this.getPreviousSibling(); node != null && ((type2 = node.getNodeType()) == 3 || type2 == 5); node = node.getPreviousSibling()) {
                firstnode = node;
            }
            Node lastnode = this;
            for (node = this.getNextSibling(); node != null && ((type = node.getNodeType()) == 3 || type == 5); node = node.getNextSibling()) {
                lastnode = node;
            }
            if (firstnode == lastnode) {
                return this.getData();
            }
            StringBuilder buf = new StringBuilder(this.data.length() * 2);
            for (node = firstnode; node != lastnode; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            buf.append(lastnode.toString());
            return buf.toString();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            if (content == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            CSSNode parent = this.getParentNode();
            if (parent != null) {
                Node sibling;
                short type;
                Node node = this.getPreviousSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getPreviousSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
                node = this.getNextSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getNextSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
            }
            this.setData(content);
            if (content.length() == 0) {
                if (parent != null) {
                    parent.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean deep) {
            MyText my = new MyText();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            String parentLName;
            CSSNode node = this.getParentNode();
            String text = node != null && node.getNodeType() == 1 && DOMDocument.this.isRawTextElementName(parentLName = ((DOMElement)node).getLocalName()) ? DOMDocument.escapeCloseTag(parentLName, this.getData()) : DOMDocument.escapeLtGtEntities(this.getData());
            return text;
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("-->")) {
                throw new DOMException(5, "Comment cannot contain '--'");
            }
            super.setData(data);
        }

        @Override
        public Comment cloneNode(boolean deep) {
            MyComment my = new MyComment();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        String data;

        MyCharacterData(short nodeType) {
            super(nodeType);
            this.data = null;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            try {
                return this.data.substring(offset, offset + count);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }

        @Override
        public void appendData(String arg) throws DOMException {
            StringBuilder buf = new StringBuilder(this.data.length() + arg.length());
            buf.append(this.data).append(arg);
            this.setData(buf.toString());
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || offset > dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            StringBuilder buf = new StringBuilder(dl + arg.length());
            buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset, dl));
            this.setData(buf.toString());
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || count < 0 || offset >= dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            int begin2 = offset + count;
            if (begin2 > dl) {
                begin2 = dl;
                count = dl - offset;
            }
            StringBuilder buf = new StringBuilder(dl - count);
            buf.append(this.data.subSequence(0, offset)).append(this.data.subSequence(begin2, dl));
            this.setData(buf.toString());
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length() - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset + count, dl));
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            this.setData(buf.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }
    }

    class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        MyStyleProcessingInstruction(String data) {
            super("xml-stylesheet", data);
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            this.parseData();
            this.resetLinkedSheet();
            if (this.getParentNode() != null) {
                DOMDocument.this.onStyleModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        void setParentNode(Node parentNode) throws DOMException {
            super.setParentNode(parentNode);
            DOMDocument.this.onStyleModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                boolean alternate;
                String type = this.getPseudoAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                MediaQueryList media = DOMDocument.this.parseMediaList(this.getPseudoAttribute("media").trim());
                if (media == null) {
                    return null;
                }
                String title = this.getPseudoAttribute("title");
                if (title.length() == 0) {
                    title = null;
                }
                if ((alternate = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && title == null) {
                    DOMDocument.this.getImplementation().getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                String href = this.getPseudoAttribute("href");
                int hreflen = href.length();
                if (hreflen > 1) {
                    if (href.charAt(0) != '#') {
                        this.linkedSheet = DOMDocument.this.loadStyleSheet(href, title, media, this);
                    } else {
                        String id = href.substring(1);
                        DOMElement elm = DOMDocument.this.getElementById(id);
                        if (elm != null) {
                            String text = elm.getTextContent().trim();
                            this.linkedSheet = DOMDocument.this.parseEmbeddedStyleSheet(text, title, media, this);
                        } else {
                            DOMDocument.this.getImplementation().getErrorHandler().linkedStyleWarning(this, "Could not find element with id: " + id);
                        }
                    }
                    if (alternate && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String attrname) {
            String value = this.pseudoAttrs.get(attrname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            this.getOwnerDocument().onStyleModify();
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyStyleProcessingInstruction my = new MyStyleProcessingInstruction(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);
    }

    static interface LinkStyleDefiner
    extends LinkStyle,
    Node {
        @Override
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        String data;
        private final String target;

        MyProcessingInstruction(String target, String data) {
            super((short)7);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyProcessingInstruction my = new MyProcessingInstruction(this.getTarget(), this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + "?>";
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private final String name;

        MyEntityReference(String name) {
            super((short)5);
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            this.checkAppendNode(newChild);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            super.checkAppendNodeHierarchy(newChild);
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Cannot append a document type here.");
            }
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    public class DOMDocumentFragment
    extends MyNode
    implements DocumentFragment,
    ParentNode {
        WeakReference<DOMElementList> childElementRef;

        DOMDocumentFragment() {
            super((short)11);
            this.childElementRef = null;
        }

        @Override
        protected AbstractDOMNode.DOMNodeList createChildNodeList() {
            return new ChildNodeList();
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public DOMElementList getChildren() {
            DOMElementList list = null;
            if (this.childElementRef != null) {
                list = (DOMElementList)this.childElementRef.get();
            }
            if (list == null) {
                list = new AbstractDOMNode.ChildElementList(this);
                this.childElementRef = new WeakReference<DOMElementList>(list);
            }
            return list;
        }

        @Override
        public DOMElement getFirstElementChild() {
            return (DOMElement)super.getFirstElementChild();
        }

        @Override
        public DOMElement getLastElementChild() {
            return (DOMElement)super.getLastElementChild();
        }

        @Override
        public int getChildElementCount() {
            return super.getChildElementCount();
        }

        @Override
        public DOMElementList querySelectorAll(String selectors) {
            return DOMElement.querySelectorAll(selectors, this.getChildNodes());
        }

        @Override
        public DOMDocumentFragment cloneNode(boolean deep) {
            DOMDocumentFragment my = new DOMDocumentFragment();
            if (deep && my.hasChildNodes()) {
                NodeList list = my.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            NodeList list = this.getChildNodes();
            int sz = list.getLength();
            StringBuilder buf = new StringBuilder(64 + sz * 32);
            for (int i = 0; i < sz; ++i) {
                buf.append(list.item(i).toString());
            }
            return buf.toString();
        }
    }

    abstract class MyNode
    extends DOMNode {
        MyNode(short nodeType) {
            super(nodeType);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
            return super.appendChild(newChild);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this;
        }
    }
}

