/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.ChildNodeList;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElementLinkedList;
import io.sf.carte.doc.dom.DOMElementList;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class DOMElement
extends NamespacedNode
implements CSSElement,
ParentNode {
    final String localName;
    final DOMNamedNodeMap<Attr> nodeMap;
    Map<String, WeakReference<DOMElementLinkedList>> tagListMap = null;
    ClassList classList = null;
    Map<String, WeakReference<DOMElementLinkedList>> classListMap = null;
    WeakReference<DOMElementList> childElementRef = null;
    private TypeInfo schemaTypeInfo = null;
    private WeakReference<SelectorMatcher> selectorMatcherRef = null;
    private Map<String, CSSStyleDeclaration> overrideStyleSet = null;

    DOMElement(String localName, String namespaceUri) {
        super((short)1, namespaceUri);
        this.localName = localName;
        this.nodeMap = new MyNamedNodeMap();
    }

    @Override
    protected AbstractDOMNode.DOMNodeList createChildNodeList() {
        return new ChildNodeList();
    }

    boolean isVoid() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.nodeMap;
    }

    @Override
    public boolean hasAttributes() {
        return !this.nodeMap.getNodeMap().isEmpty();
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.nodeMap.getNodeMap().get(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr;
        String prefix;
        if (namespaceURI != null && !this.isDefaultNamespace(namespaceURI) && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        if ((attr = this.nodeMap.getNodeMap().get(localName)) == null || !this.isSameNamespace(attr.getNamespaceURI(), namespaceURI)) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        return this.nodeMap.getNodeMap().get(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr;
        String prefix;
        if (namespaceURI != null && !this.isDefaultNamespace(namespaceURI) && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        if ((attr = this.nodeMap.getNodeMap().get(localName)) == null || !this.isSameNamespace(attr.getNamespaceURI(), namespaceURI)) {
            return null;
        }
        return attr;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.nodeMap.getNodeMap().containsKey(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr;
        String prefix;
        if (namespaceURI != null && !this.isDefaultNamespace(namespaceURI) && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        return (attr = this.nodeMap.getNodeMap().get(localName)) != null && this.isSameNamespace(attr.getNamespaceURI(), namespaceURI);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        DOMNode oldAttr = (DOMNode)this.nodeMap.getNodeMap().remove(name);
        if (oldAttr != null) {
            oldAttr.setParentNode(null);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr oldAttr;
        String prefix;
        if (namespaceURI != null && !this.isDefaultNamespace(namespaceURI) && (prefix = this.lookupPrefix(namespaceURI)) != null) {
            localName = prefix + ":" + localName;
        }
        if ((oldAttr = this.nodeMap.getNodeMap().get(localName)) != null && this.isSameNamespace(oldAttr.getNamespaceURI(), namespaceURI)) {
            this.removeAttribute(localName);
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        boolean removed = false;
        Iterator<Map.Entry<String, Attr>> it = this.nodeMap.getNodeMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Attr> entry = it.next();
            Attr attr = entry.getValue();
            if (attr != oldAttr) continue;
            it.remove();
            removed = true;
            ((DOMNode)((Object)oldAttr)).setParentNode(null);
            break;
        }
        if (!removed) {
            throw new DOMException(8, "Attribute not in this element");
        }
        return oldAttr;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        this.setAttributeNS(null, name, value);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        LinkedHashMap<String, Attr> map = this.nodeMap.getNodeMap();
        if (!map.isEmpty()) {
            String localName = qualifiedName;
            String prefix = null;
            if (namespaceURI != null) {
                int idx = qualifiedName.indexOf(58);
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                if (idx != -1) {
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            }
            for (Map.Entry<String, Attr> entry : map.entrySet()) {
                Attr attr = entry.getValue();
                if (!this.isSameAttr(attr, namespaceURI, localName)) continue;
                String oldQName = entry.getKey();
                if (!qualifiedName.equals(oldQName)) {
                    if (map.containsKey(qualifiedName)) {
                        this.badPrefixException(qualifiedName);
                    }
                    map.remove(oldQName);
                    map.put(qualifiedName, attr);
                }
                attr.setPrefix(prefix);
                attr.setValue(value);
                return;
            }
        }
        if (map.containsKey(qualifiedName)) {
            this.badPrefixException(qualifiedName);
        }
        Attr attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
        attr.setValue(value);
        map.put(qualifiedName, attr);
        ((DOMNode)((Object)attr)).setParentNode(this);
    }

    private boolean isSameAttr(Attr attr, String namespaceURI, String localName) {
        if (attr.getLocalName().equals(localName)) {
            return this.isSameNamespace(attr.getNamespaceURI(), namespaceURI);
        }
        return false;
    }

    private boolean isSameAttr(Attr attr, Attr attr2) {
        if (attr.getLocalName().equals(attr2.getLocalName())) {
            return this.isSameNamespace(attr.getNamespaceURI(), attr2.getNamespaceURI());
        }
        return false;
    }

    private boolean isSameNamespace(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || this.isDefaultNamespace(ns2);
        }
        return ns1.equals(ns2) || ns2 == null && this.isDefaultNamespace(ns1);
    }

    private void badPrefixException(String newName) throws DOMException {
        throw new DOMException(14, "Bad prefix in " + newName);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.getOwnerDocument() != newAttr.getOwnerDocument()) {
            throw new DOMException(4, "Attribute was created by different document.");
        }
        Element owner = newAttr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, "Attribute is already in use.");
        }
        boolean replaced = false;
        Attr oldAttr = null;
        String newName = newAttr.getName();
        LinkedHashMap<String, Attr> map = this.nodeMap.getNodeMap();
        for (Map.Entry<String, Attr> entry : map.entrySet()) {
            Attr attr = entry.getValue();
            if (!this.isSameAttr(attr, newAttr)) continue;
            String oldQName = entry.getKey();
            if (oldQName.equals(newName)) {
                oldAttr = map.replace(oldQName, newAttr);
                replaced = true;
            } else {
                if (map.containsKey(newName)) {
                    this.badPrefixException(newName);
                }
                oldAttr = (Attr)map.remove(oldQName);
            }
            ((DOMNode)((Object)oldAttr)).setParentNode(null);
            break;
        }
        if (!replaced) {
            if (map.containsKey(newName)) {
                this.badPrefixException(newName);
            }
            map.put(newName, newAttr);
        }
        ((DOMNode)((Object)newAttr)).setParentNode(this);
        return oldAttr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public String getId() {
        if (!this.nodeMap.isEmpty()) {
            for (Attr attr : this.nodeMap.getNodeMap().values()) {
                if (!attr.isId()) continue;
                return attr.getValue();
            }
        }
        return "";
    }

    abstract boolean isIdAttributeNS(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOMElementList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() > 0 && !this.isDefaultNamespace(namespaceURI)) {
            String qname;
            namespaceURI = namespaceURI.intern();
            boolean matchAll = "*".equals(localName = localName.intern());
            if (matchAll) {
                qname = namespaceURI;
            } else {
                qname = namespaceURI + ":" + localName;
                qname = qname.intern();
            }
            DOMElementLinkedList list = this.findList(qname);
            if (list == null) {
                list = DOMElement.createElementNodeList();
                list.fillByTagList(localName, this, namespaceURI, matchAll);
                Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
                synchronized (map) {
                    this.tagListMap.put(qname, new WeakReference<DOMElementLinkedList>(list));
                }
            }
            return list;
        }
        return this.getElementsByTagName(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DOMElementLinkedList findList(String qname) {
        if (this.tagListMap == null) {
            this.tagListMap = new HashMap<String, WeakReference<DOMElementLinkedList>>(3);
        } else {
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                WeakReference<DOMElementLinkedList> ref = this.tagListMap.get(qname);
                if (ref != null) {
                    DOMElementLinkedList list = (DOMElementLinkedList)ref.get();
                    if (list == null) {
                        this.tagListMap.remove(qname);
                    } else {
                        return list;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOMElementList getElementsByTagName(String name) {
        DOMElementLinkedList list = this.findList(name = name.toLowerCase(Locale.US).intern());
        if (list != null) {
            return list;
        }
        list = DOMElement.createElementNodeList();
        list.fillByTagList(name, this, this.getNamespaceURI(), "*".equals(name));
        Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
        synchronized (map) {
            this.tagListMap.put(name, new WeakReference<DOMElementLinkedList>(list));
        }
        return list;
    }

    static DOMElementLinkedList createElementNodeList() {
        return new DOMElementLinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateTaglistsOnInsert(DOMElement newChild) {
        if (this.tagListMap != null) {
            String newtag = newChild.getLocalName();
            if (!this.isNullOrDefaultNamespaceURI(newChild.getNamespaceURI())) {
                newtag = newChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(newChild);
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    DOMElementLinkedList list = (DOMElementLinkedList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnInsert(newChild);
                }
            }
        }
        super.updateTaglistsOnInsert(newChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateTaglistsOnRemove(DOMElement oldChild) {
        if (this.tagListMap != null) {
            String newtag = oldChild.getLocalName();
            if (!this.isNullOrDefaultNamespaceURI(oldChild.getNamespaceURI())) {
                newtag = oldChild.getNamespaceURI() + ":" + newtag;
                newtag = newtag.intern();
            }
            String allTags = this.allTagsName(oldChild);
            Map<String, WeakReference<DOMElementLinkedList>> map = this.tagListMap;
            synchronized (map) {
                Iterator<String> it = this.tagListMap.keySet().iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!newtag.equals(tag) && !allTags.equals(tag)) continue;
                    DOMElementLinkedList list = (DOMElementLinkedList)this.tagListMap.get(tag).get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }
        super.updateTaglistsOnRemove(oldChild);
    }

    String allTagsName(CSSElement element) {
        if (!this.isNullOrDefaultNamespaceURI(element.getNamespaceURI())) {
            return element.getNamespaceURI();
        }
        return "*";
    }

    private boolean isNullOrDefaultNamespaceURI(String namespaceURI) {
        return namespaceURI == null || this.isDefaultNamespace(namespaceURI);
    }

    public DOMTokenList getClassList() {
        if (this.classList == null) {
            DOMAttr attr = (DOMAttr)this.nodeMap.getNodeMap().get("class");
            this.classList = new QuirksClassList();
            if (attr != null && attr.value != null) {
                this.classList.setValue(attr.value);
            }
        }
        return this.classList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMElementList getElementsByClassName(String names) {
        DOMElementLinkedList list;
        boolean hasSpace;
        names = names.trim().toLowerCase(Locale.US);
        TreeSet<String> sorted = new TreeSet<String>();
        boolean bl = hasSpace = names.indexOf(32) != -1;
        if (hasSpace) {
            names = this.sortClassNames(names, sorted);
        }
        if ((list = this.findClassList(names)) != null) {
            return list;
        }
        if (!hasSpace) {
            sorted.add(names);
        }
        list = new DOMElementLinkedList();
        list.fillByClassList(sorted, this);
        Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
        synchronized (map) {
            this.classListMap.put(names, new WeakReference<DOMElementLinkedList>(list));
        }
        return list;
    }

    private String sortClassNames(String names, SortedSet<String> sorted) {
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            sorted.add(st.nextToken());
        }
        StringBuilder buf = new StringBuilder(names.length());
        Iterator it = sorted.iterator();
        buf.append((String)it.next());
        while (it.hasNext()) {
            buf.append(' ').append((String)it.next());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DOMElementLinkedList findClassList(String names) {
        if (this.classListMap == null) {
            this.classListMap = new HashMap<String, WeakReference<DOMElementLinkedList>>(3);
        } else {
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                WeakReference<DOMElementLinkedList> ref = this.classListMap.get(names);
                if (ref != null) {
                    DOMElementLinkedList list = (DOMElementLinkedList)ref.get();
                    if (list == null) {
                        this.classListMap.remove(names);
                    } else {
                        return list;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateClasslists(DOMElement owner) {
        DOMNode parent;
        boolean hasSpace;
        String ownerNames;
        DOMTokenList ownerClasses;
        boolean hasClasses = owner.hasAttribute("class");
        if (hasClasses) {
            ownerClasses = owner.getClassList();
            ownerNames = ownerClasses.getSortedValue();
            hasSpace = ownerNames.indexOf(32) != -1;
        } else {
            ownerClasses = null;
            ownerNames = "";
            hasSpace = false;
        }
        if (this.classListMap != null) {
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                Iterator<Map.Entry<String, WeakReference<DOMElementLinkedList>>> it = this.classListMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, WeakReference<DOMElementLinkedList>> entry = it.next();
                    String classNames = entry.getKey();
                    DOMElementLinkedList list = (DOMElementLinkedList)entry.getValue().get();
                    if (list == null) {
                        it.remove();
                        continue;
                    }
                    boolean hasOwner = list.contains(owner);
                    if (!hasClasses) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (!classNames.equals(ownerNames) && !hasSpace) {
                        if (!hasOwner) continue;
                        list.updateOnRemove(owner);
                        continue;
                    }
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!ownerClasses.containsAll(sorted)) {
                            if (!hasOwner) continue;
                            list.updateOnRemove(owner);
                            continue;
                        }
                    }
                    if (hasOwner) continue;
                    list.updateOnInsert(owner);
                }
            }
        }
        if ((parent = (DOMNode)this.getParentNode()) != null) {
            parent.updateClasslists(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateClasslistsOnRemove(DOMElement oldChild) {
        DOMNode parent;
        boolean hasSpace;
        DOMTokenList oldClasses = oldChild.getClassList();
        String oldNames = oldClasses.getSortedValue();
        boolean bl = hasSpace = oldNames.indexOf(32) != -1;
        if (this.classListMap != null) {
            TreeSet<String> sorted = new TreeSet<String>();
            Map<String, WeakReference<DOMElementLinkedList>> map = this.classListMap;
            synchronized (map) {
                Iterator<String> it = this.classListMap.keySet().iterator();
                while (it.hasNext()) {
                    DOMElementLinkedList list;
                    String classNames = it.next();
                    if (!classNames.equals(oldNames) && !hasSpace) continue;
                    if (hasSpace) {
                        sorted.clear();
                        StringTokenizer st = new StringTokenizer(classNames);
                        while (st.hasMoreTokens()) {
                            sorted.add(st.nextToken());
                        }
                        if (!oldClasses.containsAll(sorted)) continue;
                    }
                    if ((list = (DOMElementLinkedList)this.classListMap.get(classNames).get()) == null) {
                        it.remove();
                        continue;
                    }
                    list.updateOnRemove(oldChild);
                }
            }
        }
        if ((parent = (DOMNode)this.getParentNode()) != null) {
            parent.updateClasslistsOnRemove(oldChild);
        }
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public DOMElementList querySelectorAll(String selectors) {
        return DOMElement.querySelectorAll(selectors, this.child);
    }

    static DOMElementList querySelectorAll(String selectors, NodeList nl) {
        SelectorList selist;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectors));
        try {
            selist = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectors);
        }
        DOMElementLinkedList list = new DOMElementLinkedList();
        list.fillQuerySelectorList(selist, nl);
        return list;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getTagName() {
        String tagname = this.localName;
        String prefix = this.getPrefix();
        if (prefix == null) {
            return tagname;
        }
        StringBuilder buf = new StringBuilder(tagname.length() + prefix.length() + 1);
        buf.append(prefix).append(':').append(tagname);
        return buf.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String namespaceURI = super.lookupNamespaceURI(prefix);
        if (namespaceURI == null) {
            LinkedHashMap<String, Attr> map = this.nodeMap.getNodeMap();
            if (!map.isEmpty()) {
                for (Attr attr : map.values()) {
                    String localName = attr.getLocalName();
                    String pre = attr.getPrefix();
                    if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                    if ("xmlns".equals(localName) && prefix.equals(pre)) {
                        return attr.getValue();
                    }
                    if (!"xmlns".equals(pre) || !pre.equals(localName)) continue;
                    return attr.getValue();
                }
            }
            Node pnode = this;
            while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
            }
            if (pnode != null) {
                namespaceURI = pnode.lookupNamespaceURI(namespaceURI);
            }
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        LinkedHashMap<String, Attr> map = this.nodeMap.getNodeMap();
        if (!map.isEmpty()) {
            for (Attr attr : map.values()) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !namespaceURI.equals(attr.getValue())) continue;
                String localName = attr.getLocalName();
                String prefix = attr.getPrefix();
                if ("xmlns".equals(localName)) {
                    return prefix;
                }
                if (!"xmlns".equals(prefix)) continue;
                return localName;
            }
        }
        Node pnode = this;
        while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
        }
        if (pnode != null) {
            return pnode.lookupPrefix(namespaceURI);
        }
        return null;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
        return super.appendChild(newChild);
    }

    @Override
    public DOMElement getFirstElementChild() {
        return (DOMElement)super.getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return (DOMElement)super.getLastElementChild();
    }

    @Override
    public DOMElementList getChildren() {
        DOMElementList list = null;
        if (this.childElementRef != null) {
            list = (DOMElementList)this.childElementRef.get();
        }
        if (list == null) {
            list = new AbstractDOMNode.ChildElementList(this);
            this.childElementRef = new WeakReference<DOMElementList>(list);
        }
        return list;
    }

    @Override
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    public SelectorMatcher getSelectorMatcher() {
        SelectorMatcher matcher = null;
        if (this.selectorMatcherRef != null) {
            matcher = (SelectorMatcher)this.selectorMatcherRef.get();
        }
        if (matcher == null) {
            matcher = new DOMSelectorMatcher(this);
            this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
        }
        return matcher;
    }

    @Override
    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        SelectorList list;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource((Reader)new StringReader(selectorString));
        try {
            list = parser.parseSelectors(source);
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        return this.matches(list, pseudoElement);
    }

    @Override
    public boolean matches(SelectorList selist, String pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        InlineStyle styledecl = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
        String st = this.getInlineStyle();
        if (st.length() > 0) {
            try {
                styledecl.setCssText(st);
            }
            catch (DOMException e) {
                this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
            }
        }
        return styledecl;
    }

    String getInlineStyle() {
        return this.getAttribute("style");
    }

    boolean hasOverrideStyle(String pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        CSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, CSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    @Override
    public boolean hasPresentationalHints() {
        return false;
    }

    @Override
    public void exportHintsToStyle(CSSStyleDeclaration style) {
    }

    protected abstract CSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new ElementTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    public String getStartTag() {
        StringBuilder buf = new StringBuilder(128);
        buf.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes()) {
            buf.append('>');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    public String toString() {
        int bufsz = 32;
        if (this.hasChildNodes()) {
            bufsz = 720;
        } else if (this.hasAttributes()) {
            bufsz = 128;
        }
        String tagname = this.getTagName();
        StringBuilder buf = new StringBuilder(bufsz);
        buf.append('<').append(tagname);
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (!this.isVoid()) {
            buf.append('>');
            if (this.hasChildNodes()) {
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    buf.append(list.item(i).toString());
                }
            }
            buf.append("</").append(tagname).append('>').append('\n');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    static class ElementTypeInfo
    extends DOMTypeInfo {
        ElementTypeInfo() {
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }
    }

    class QuirksClassList
    extends ClassList {
        QuirksClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value != null && value.length() == 0) {
                value = value.toLowerCase(Locale.US);
            }
            super.setValue(value);
        }

        @Override
        public boolean contains(String token) {
            if (token == null) {
                return false;
            }
            token = token.toLowerCase(Locale.US);
            return super.contains(token);
        }

        @Override
        public void add(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            this.addUnchecked(token);
        }

        @Override
        public void remove(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            this.removeUnchecked(token);
        }

        @Override
        public boolean toggle(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.US);
            return this.toggleUnchecked(token);
        }

        @Override
        public void replace(String oldToken, String newToken) throws DOMException {
            this.argumentCheckVoidSpaces(oldToken);
            this.argumentCheckVoidSpaces(newToken);
            oldToken = oldToken.toLowerCase(Locale.US);
            newToken = newToken.toLowerCase(Locale.US);
            this.replaceUnchecked(oldToken, newToken);
        }
    }

    class ClassList
    extends DOMTokenSetImpl {
        ClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value == null || value.length() == 0) {
                this.clear();
                value = "";
            }
            super.setValue(value);
            this.updateClassLists();
        }

        @Override
        protected void addUnchecked(String token) throws DOMException {
            super.addUnchecked(token);
            this.updateClassLists();
        }

        @Override
        protected void removeUnchecked(String token) throws DOMException {
            super.removeUnchecked(token);
            this.updateClassLists();
        }

        @Override
        protected boolean toggleUnchecked(String token) throws DOMException {
            boolean result = super.toggleUnchecked(token);
            this.updateClassLists();
            return result;
        }

        @Override
        protected void replaceUnchecked(String oldToken, String newToken) throws DOMException {
            super.replaceUnchecked(oldToken, newToken);
            this.updateClassLists();
        }

        @Override
        public void clear() {
            super.clear();
            this.updateClassLists();
        }

        private void updateClassLists() {
            CSSNode parent = DOMElement.this.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                ((DOMElement)parent).updateClasslists(DOMElement.this);
            }
        }
    }

    class MyNamedNodeMap
    extends DOMNamedNodeMap<Attr> {
        MyNamedNodeMap() {
            super((short)2);
        }

        @Override
        void registerNode(Attr arg) {
            ((DOMNode)((Object)arg)).setParentNode(DOMElement.this);
        }

        @Override
        void unregisterNode(Attr removedItem) {
            ((DOMNode)((Object)removedItem)).setParentNode(null);
        }
    }
}

