/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.style.css.CSSElement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DOMElementLinkedList
extends LinkedList<DOMElement>
implements DOMElementList {
    private static final long serialVersionUID = 1L;

    DOMElementLinkedList() {
    }

    @Override
    public DOMElement item(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (DOMElement)this.get(index);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.size() * 32 + 40);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            buf.append(((DOMElement)it.next()).toString());
        }
        return buf.toString();
    }

    void fillQuerySelectorList(SelectorList selist, NodeList nl) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (element.matches(selist, null)) {
                this.add(element);
            }
            this.fillQuerySelectorList(selist, element.child);
        }
    }

    synchronized void fillByTagList(String localName, DOMNode elm, String namespaceURI, boolean matchAll) {
        AbstractDOMNode.DOMNodeList nl = elm.child;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if ((matchAll || element.getLocalName() == localName) && DOMElementLinkedList.isSameNamespace(element, namespaceURI)) {
                this.add(element);
            }
            this.fillByTagList(localName, element, namespaceURI, matchAll);
        }
    }

    private static boolean isSameNamespace(DOMElement element, String ns2) {
        String ns1 = element.getNamespaceURI();
        if (ns1 == null) {
            return ns2 == null || element.isDefaultNamespace(ns2);
        }
        return ns1.equals(ns2) || ns2 == null && element.isDefaultNamespace(ns1);
    }

    synchronized void fillByClassList(SortedSet<String> sorted, DOMElement contextElement) {
        AbstractDOMNode.DOMNodeList nl = contextElement.child;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (element.hasAttribute("class") && element.getClassList().containsAll(sorted)) {
                this.add(element);
            }
            this.fillByClassList(sorted, element);
        }
    }

    void updateOnInsert(DOMElement newChild) {
        CSSElement elm;
        int i;
        int sz = this.size();
        for (i = 0; i < sz && ((elm = (CSSElement)this.get(i)).compareDocumentPosition(newChild) & 4) != 4; ++i) {
        }
        this.add(i, newChild);
    }

    void updateOnRemove(DOMElement oldChild) {
        this.remove(oldChild);
    }
}

