/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMNamedNodeMap<T extends Node>
implements NamedNodeMap {
    private short nodeType;
    LinkedHashMap<String, T> attributes;

    DOMNamedNodeMap(short nodeType) {
        this.nodeType = nodeType;
        this.attributes = new LinkedHashMap();
    }

    LinkedHashMap<String, T> getNodeMap() {
        return this.attributes;
    }

    public T getNamedItem(String name) {
        return (T)((Node)this.attributes.get(name));
    }

    public T setNamedItem(Node arg) throws DOMException {
        this.verifyNodeType(arg);
        if (this.attributes.containsValue(arg)) {
            return (T)arg;
        }
        String name = arg.getNodeName();
        Node node = arg;
        Node oldItem = this.attributes.put(name, node);
        this.registerNode(node);
        return (T)oldItem;
    }

    void registerNode(T arg) {
    }

    private void verifyNodeType(Node arg) throws DOMException {
        if (arg.getNodeType() != this.nodeType) {
            throw new DOMException(3, "Not an appropriate node type.");
        }
    }

    public T removeNamedItem(String name) throws DOMException {
        if (!this.getNodeMap().containsKey(name)) {
            throw new DOMException(8, "No attribute with that name.");
        }
        Node removedItem = (Node)this.attributes.remove(name);
        if (removedItem != null) {
            this.unregisterNode(removedItem);
        }
        return (T)removedItem;
    }

    void unregisterNode(T removedItem) {
    }

    public T item(int index) {
        int i = 0;
        Node at = null;
        for (Node value : this.attributes.values()) {
            if (i == index) {
                at = value;
                break;
            }
            ++i;
        }
        return (T)at;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public int getLength() {
        return this.attributes.size();
    }

    public T getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        for (Node node : this.attributes.values()) {
            if (!node.getLocalName().equals(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            return (T)node;
        }
        return null;
    }

    public T setNamedItemNS(Node arg) throws DOMException {
        return this.setNamedItem(arg);
    }

    public T removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        Iterator<T> it = this.attributes.values().iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getLocalName().equals(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            it.remove();
            this.unregisterNode(node);
            return (T)node;
        }
        return null;
    }

    private boolean isSameNamespace(String namespaceURI, Node node) {
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI == null) {
            return namespaceURI == null || node.isDefaultNamespace(namespaceURI);
        }
        if (namespaceURI == null) {
            return node.isDefaultNamespace(nodeNamespaceURI);
        }
        return nodeNamespaceURI.equals(namespaceURI);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.nodeType;
        TreeSet<String> sorted = new TreeSet<String>(this.attributes.keySet());
        for (String key : sorted) {
            result = 31 * result + key.hashCode();
            result = 31 * result + ((Node)this.attributes.get(key)).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMNamedNodeMap other = (DOMNamedNodeMap)obj;
        if (this.nodeType != other.nodeType) {
            return false;
        }
        return !(this.attributes == null ? other.attributes != null : !this.sameNodes(other.attributes));
    }

    private boolean sameNodes(LinkedHashMap<String, ?> otherAttr) {
        if (this.attributes.size() != otherAttr.size()) {
            return false;
        }
        for (Map.Entry<String, T> me : this.attributes.entrySet()) {
            Node otherNode;
            String key = me.getKey();
            Node node = (Node)me.getValue();
            if (node.isEqualNode(otherNode = (Node)otherAttr.get(key))) continue;
            return false;
        }
        return true;
    }

    public void appendTo(StringBuilder buf) {
        Iterator<T> it = this.attributes.values().iterator();
        if (it.hasNext()) {
            Node val = (Node)it.next();
            buf.append(val.toString());
            while (it.hasNext()) {
                val = (Node)it.next();
                buf.append(' ').append(val.toString());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.attributes.size() * 24);
        this.appendTo(buf);
        return buf.toString();
    }
}

