/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NamespacedNode
extends DOMNode {
    private final String namespaceUri;
    private String prefix = null;

    public NamespacedNode(short nodeType, String namespaceUri) {
        super(nodeType);
        this.namespaceUri = namespaceUri;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
        return super.appendChild(newChild);
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        String nsUri = this.getNamespaceURI();
        if (nsUri != null && !this.isDefaultNamespace(nsUri)) {
            if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace" != this.getNamespaceURI()) {
                throw new DOMException(14, "Wrong namespace for prefix xml");
            }
            if (!DOMDocument.isValidName(prefix)) {
                throw new DOMException(5, "Invalid prefix");
            }
            this.prefix = prefix;
        } else if (prefix != null && prefix.length() != 0) {
            throw new DOMException(14, "Cannot put a prefix to default namespace.");
        }
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (prefix == null ? this.getPrefix() == null : prefix.equals(this.getPrefix())) {
            return this.getNamespaceURI();
        }
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        return null;
    }
}

