/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.ExtendedCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSImportRule;
import io.sf.carte.doc.style.css.om.OMCSSMediaRule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSUnknownRule;

public abstract class AbstractCSSStyleSheet
extends AbstractStyleSheet
implements ExtendedCSSStyleSheet,
Cloneable {
    protected AbstractCSSStyleSheet(String title) {
        super(title);
    }

    @Override
    public abstract CSSRuleArrayList getCssRules();

    @Override
    public abstract boolean parseCSSStyleSheet(InputSource var1) throws DOMException, IOException;

    @Override
    public abstract boolean parseCSSStyleSheet(InputSource var1, boolean var2) throws DOMException, IOException;

    @Override
    public abstract void addStyleSheet(AbstractCSSStyleSheet var1);

    @Override
    public abstract CSSStyleDeclarationRule createCSSStyleRule();

    @Override
    public abstract CSSFontFaceRule createCSSFontFaceRule();

    @Override
    public abstract OMCSSImportRule createCSSImportRule(MediaQueryList var1);

    @Override
    public abstract OMCSSMediaRule createCSSMediaRule(MediaQueryList var1);

    @Override
    public abstract CSSPageRule createCSSPageRule();

    public abstract CSSUnknownRule createCSSUnknownRule();

    @Override
    public abstract AbstractCSSStyleDeclaration createCSSStyleDeclaration();

    protected abstract AbstractCSSStyleDeclaration createCSSStyleDeclaration(BaseCSSDeclarationRule var1);

    protected abstract void registerNamespace(CSSNamespaceRule var1);

    protected abstract void unregisterNamespace(String var1);

    protected abstract String getNamespacePrefix(String var1);

    protected abstract boolean hasDefaultNamespace();

    public abstract void setHref(String var1);

    public abstract byte getOrigin();

    public abstract boolean hasRuleErrorsOrWarnings();

    @Override
    public abstract ExtendedCSSStyleSheet clone();

    @Override
    public URLConnection openConnection(URL url, String referrerPolicy) throws IOException {
        URLConnection ucon;
        Node node;
        CSSStyleSheet pss;
        CSSDocument doc = null;
        if (this.getOwnerNode() != null) {
            doc = (CSSDocument)this.getOwnerNode().getOwnerDocument();
        } else if (this.getOwnerRule() != null && (pss = this.getOwnerRule().getParentStyleSheet()) != null && (node = pss.getOwnerNode()) != null) {
            doc = (CSSDocument)node.getOwnerDocument();
        }
        if (doc != null) {
            ucon = doc.openConnection(url);
            String docuri = doc.getDocumentURI();
            if (docuri != null) {
                String referrer;
                if ("".equals(referrerPolicy)) {
                    referrerPolicy = doc.getReferrerPolicy();
                }
                if ((referrer = this.getReferrer(docuri, url, referrerPolicy)) != null) {
                    ucon.setRequestProperty("Referer", referrer);
                }
            }
        } else {
            ucon = url.openConnection();
        }
        ucon.setAllowUserInteraction(false);
        return ucon;
    }

    private String getReferrer(String referrer, URL destinationUrl, String referrerPolicy) {
        if ("no-referrer".equals(referrerPolicy)) {
            referrer = null;
        } else if ("origin".equals(referrerPolicy)) {
            referrer = this.getOrigin(referrer);
        } else if ("same-origin".equals(referrerPolicy)) {
            referrer = this.getSameOrigin(referrer, destinationUrl);
        } else if ("strict-origin".equals(referrerPolicy)) {
            referrer = this.getStrictOrigin(referrer, destinationUrl);
        } else if (!"unsafe-url".equals(referrerPolicy)) {
            referrer = this.getNoReferrerWhenDowngrade(referrer, destinationUrl);
        }
        return referrer;
    }

    private String getOrigin(String referrer) {
        try {
            URL url = new URL(referrer);
            URL refUrl = new URL(url.getProtocol(), url.getHost(), "/");
            return refUrl.toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String getSameOrigin(String referrer, URL destinationUrl) {
        try {
            URL url = new URL(referrer);
            String desthost = destinationUrl.getHost();
            if (desthost != null && desthost.equalsIgnoreCase(url.getHost())) {
                URL refUrl = new URL(url.getProtocol(), url.getHost(), url.getFile());
                return refUrl.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private String getStrictOrigin(String referrer, URL destinationUrl) {
        try {
            URL url = new URL(referrer);
            String destproto = destinationUrl.getProtocol();
            String desthost = destinationUrl.getHost();
            if (!"https".equals(url.getProtocol()) || "https".equals(destproto) && desthost != null && desthost.equalsIgnoreCase(url.getHost())) {
                URL refUrl = new URL(url.getProtocol(), url.getHost(), url.getFile());
                return refUrl.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private String getNoReferrerWhenDowngrade(String referrer, URL destinationUrl) {
        try {
            URL url = new URL(referrer);
            String destproto = destinationUrl.getProtocol();
            if (!"https".equals(url.getProtocol()) || "https".equals(destproto)) {
                URL refUrl = new URL(url.getProtocol(), url.getHost(), url.getFile());
                return refUrl.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

