/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AnimationShorthandBuilder;
import io.sf.carte.doc.style.css.om.AnimationShorthandSetter;
import io.sf.carte.doc.style.css.om.BackgroundBuilder;
import io.sf.carte.doc.style.css.om.BackgroundShorthandSetter;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BorderBuilder;
import io.sf.carte.doc.style.css.om.BorderColorShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.om.BorderImageShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderRadiusBuilder;
import io.sf.carte.doc.style.css.om.BorderRadiusShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderSideShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderWidthShorthandSetter;
import io.sf.carte.doc.style.css.om.BoxShorthandSetter;
import io.sf.carte.doc.style.css.om.CSSShorthandValue;
import io.sf.carte.doc.style.css.om.ColumnRuleShorthandSetter;
import io.sf.carte.doc.style.css.om.ColumnsShorthandSetter;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.FlexShorthandBuilder;
import io.sf.carte.doc.style.css.om.FlexShorthandSetter;
import io.sf.carte.doc.style.css.om.FontBuilder;
import io.sf.carte.doc.style.css.om.FontShorthandSetter;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.FontVariantShorthandSetter;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandSetter;
import io.sf.carte.doc.style.css.om.GridShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridShorthandSetter;
import io.sf.carte.doc.style.css.om.GridTemplateShorthandSetter;
import io.sf.carte.doc.style.css.om.ListStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.MarginBuilder;
import io.sf.carte.doc.style.css.om.MarginShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedShorthandBuilder;
import io.sf.carte.doc.style.css.om.OrderedTwoIdentifierShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoLPIShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoValueShorthandBuilder;
import io.sf.carte.doc.style.css.om.PaddingBuilder;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.om.SequenceShorthandBuilder;
import io.sf.carte.doc.style.css.om.SequenceShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.om.TransitionShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.Diff;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeSet;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class BaseCSSStyleDeclaration
extends AbstractCSSStyleDeclaration
implements CSS2Properties,
Cloneable {
    private BaseCSSDeclarationRule parentRule;
    private HashMap<String, AbstractCSSValue> propValue;
    private ArrayList<String> propertyList;
    private ArrayList<String> priorities;
    private LinkedList<String> shorthandSet;
    private StyleDatabase styleDb = null;

    protected BaseCSSStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new LinkedList();
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new LinkedList();
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = copiedObject.getParentRule();
        this.setProperties(copiedObject);
    }

    void setProperties(BaseCSSStyleDeclaration other) {
        this.priorities = (ArrayList)other.priorities.clone();
        this.propertyList = (ArrayList)other.propertyList.clone();
        this.propValue = (HashMap)other.propValue.clone();
        this.shorthandSet = (LinkedList)other.shorthandSet.clone();
    }

    @Override
    public String getMinifiedCssText() {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            short type = cssVal.getCssValueType();
            if ((type == 1 || type == 2 || type == 0) && ((AbstractCSSValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    it.remove();
                    this.appendShorthandMinifiedCssText(sb, sh);
                }
                continue;
            }
            String prio = this.priorities.get(i);
            sb.append(ptyname).append(':').append(this.getCSSValue(ptyname).getMinifiedCssText(ptyname));
            if (prio != null && "important".equals(prio)) {
                sb.append("!important");
            }
            if (i == sz - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public String getCssText() {
        AbstractCSSStyleSheet sheet;
        StyleFormattingContext context = null;
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null && (sheet = prule.getParentStyleSheet()) != null) {
            context = sheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        }
        if (context == null) {
            context = new DefaultStyleFormattingContext();
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.propertyList.size() * 16);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    private void appendShorthandMinifiedCssText(StringBuilder sb, String shorthandName) {
        CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthandName);
        sb.append(shorthandName).append(':').append(shval.getCssText());
        if (shval.isImportant()) {
            sb.append("!important");
        }
        sb.append(';');
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            short type = cssVal.getCssValueType();
            if ((type == 1 || type == 2 || type == 0) && ((AbstractCSSValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    it.remove();
                    this.appendShorthandCssText(wri, context, sh);
                }
                continue;
            }
            context.startPropertyDeclaration(wri);
            String prio = this.priorities.get(i);
            wri.write(ptyname);
            context.writeColon(wri);
            context.writeValue(wri, ptyname, this.getCSSValue(ptyname));
            if (prio != null && "important".equals(prio)) {
                context.writeImportantPriority(wri);
            }
            context.writeSemiColon(wri);
            context.endPropertyDeclaration(wri);
        }
    }

    private void appendShorthandCssText(SimpleWriter wri, StyleFormattingContext context, String shorthandName) throws IOException {
        context.startPropertyDeclaration(wri);
        CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthandName);
        wri.write(shorthandName);
        context.writeColon(wri);
        wri.write(shval.getCssText());
        if (shval.isImportant()) {
            context.writeImportantPriority(wri);
        }
        context.writeSemiColon(wri);
        context.endPropertyDeclaration(wri);
    }

    String getPlainCssText() {
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 18);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            String prio = this.priorities.get(i);
            sb.append(ptyname).append(':').append(' ');
            BaseCSSStyleDeclaration.appendCssText(sb, this.getCSSValue(ptyname));
            if (prio != null && "important".equals(prio)) {
                sb.append(" ! important");
            }
            sb.append(';').append(' ');
        }
        return sb.toString();
    }

    void writeComputedCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        int sz = this.propertyList.size();
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            String prio = this.priorities.get(i);
            wri.write(ptyname);
            wri.write(':');
            wri.write(' ');
            context.writeValue(wri, ptyname, this.getCSSValue(ptyname));
            if (prio != null && "important".equals(prio)) {
                context.writeImportantPriority(wri);
            }
            wri.write(';');
            wri.write(' ');
        }
    }

    String getOptimizedCssText() {
        String ptyname;
        int i;
        int sz = this.propertyList.size();
        ArrayList<String> ptyList = new ArrayList<String>(sz);
        HashSet<String> prioSet = new HashSet<String>(sz);
        HashMap<String, ShorthandBuilder> builders = new HashMap<String, ShorthandBuilder>();
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        StringBuilder sb = new StringBuilder(50 + sz * 24);
        for (i = 0; i < sz; ++i) {
            boolean isimportant;
            ptyname = this.propertyList.get(i);
            String shorthand = pdb.getShorthand(ptyname);
            String prio = this.priorities.get(i);
            boolean bl = isimportant = prio != null && "important".equals(prio);
            if (shorthand != null) {
                String prefShorthand;
                ShorthandBuilder builder;
                String topsh = pdb.getShorthand(shorthand);
                if (topsh != null) {
                    shorthand = topsh;
                }
                if ((builder = (ShorthandBuilder)builders.get(prefShorthand = '&' + shorthand)) == null) {
                    builder = this.createBuilder(shorthand);
                    if (builder == null) {
                        ptyList.add(ptyname);
                        if (!isimportant) continue;
                        prioSet.add(ptyname);
                        continue;
                    }
                    builders.put(prefShorthand, builder);
                    ptyList.add(prefShorthand);
                }
                builder.addAssignedProperty(ptyname, isimportant);
                continue;
            }
            ptyList.add(ptyname);
            if (!isimportant) continue;
            prioSet.add(ptyname);
        }
        if (ptyList.contains("&border-image") && ptyList.contains("&border")) {
            ptyList.remove("&border-image");
            builders.remove("&border-image");
        }
        if (ptyList.contains("&font-variant") && ptyList.contains("&font")) {
            ptyList.remove("&font-variant");
            builders.remove("&font-variant");
        }
        if (ptyList.contains("&grid-row") && ptyList.contains("&grid-column")) {
            ptyList.remove("&grid-row");
            ptyList.remove("&grid-column");
            if (!ptyList.contains("&grid-area")) {
                ptyList.add("&grid-area");
                builders.put("&grid-area", this.createBuilder("grid-area"));
            }
            builders.remove("&grid-row");
            builders.remove("&grid-column");
        } else if (ptyList.contains("&grid-row") && ptyList.contains("&grid-area")) {
            ptyList.remove("&grid-row");
            builders.remove("&grid-row");
        } else if (ptyList.contains("&grid-column") && ptyList.contains("&grid-area")) {
            ptyList.remove("&grid-column");
            builders.remove("&grid-column");
        }
        sz = ptyList.size();
        for (i = 0; i < sz; ++i) {
            ptyname = (String)ptyList.get(i);
            if (ptyname.charAt(0) == '&') {
                ((ShorthandBuilder)builders.get(ptyname)).appendMinifiedCssText(sb);
                continue;
            }
            sb.append(ptyname).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(sb, this.getCSSValue(ptyname), ptyname);
            if (prioSet.contains(ptyname)) {
                sb.append("!important");
            }
            sb.append(';');
        }
        return sb.toString();
    }

    static void appendCssText(StringBuilder buf, AbstractCSSValue value) {
        String text = !value.isSystemDefault() ? value.getCssText() : "initial";
        buf.append(text);
    }

    static void appendMinifiedCssText(StringBuilder buf, AbstractCSSValue value, String ptyname) {
        String text = !value.isSystemDefault() ? value.getMinifiedCssText(ptyname) : "initial";
        buf.append(text);
    }

    private ShorthandBuilder createBuilder(String shorthand) {
        if ("border".equals(shorthand)) {
            return new BorderBuilder(this);
        }
        if ("background".equals(shorthand)) {
            return new BackgroundBuilder(this);
        }
        if ("border-image".equals(shorthand)) {
            return new BorderImageBuilder(this);
        }
        if ("margin".equals(shorthand)) {
            return new MarginBuilder(this);
        }
        if ("padding".equals(shorthand)) {
            return new PaddingBuilder(this);
        }
        if ("font".equals(shorthand)) {
            return new FontBuilder(this);
        }
        if ("font-variant".equals(shorthand)) {
            return new FontVariantBuilder(this);
        }
        if ("border-radius".equals(shorthand)) {
            return new BorderRadiusBuilder(this);
        }
        if ("list-style".equals(shorthand)) {
            return new OrderedShorthandBuilder(shorthand, this, "disc", "list-style-type");
        }
        if ("text-decoration".equals(shorthand) || "outline".equals(shorthand) || "text-emphasis".equals(shorthand) || "column-rule".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "none");
        }
        if ("flex".equals(shorthand)) {
            return new FlexShorthandBuilder(this);
        }
        if ("flex-flow".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "row");
        }
        if ("columns".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "auto");
        }
        if ("grid-column".equals(shorthand) || "grid-row".equals(shorthand)) {
            return new GridPlacementShorthandBuilder(shorthand, this);
        }
        if ("grid-area".equals(shorthand)) {
            return new GridAreaShorthandBuilder(this);
        }
        if ("grid".equals(shorthand)) {
            return new GridShorthandBuilder(this);
        }
        if ("animation".equals(shorthand)) {
            return new AnimationShorthandBuilder(this);
        }
        if ("cue".equals(shorthand) || "pause".equals(shorthand) || "rest".equals(shorthand)) {
            return new SequenceShorthandBuilder(shorthand, this);
        }
        if ("place-content".equals(shorthand) || "place-items".equals(shorthand) || "place-self".equals(shorthand) || "gap".equals(shorthand)) {
            return new OrderedTwoValueShorthandBuilder(shorthand, this, "normal");
        }
        return null;
    }

    StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            return prule.getStyleDeclarationErrorHandler();
        }
        return null;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        Parser parser = this.createSACParser();
        StyleDeclarationDocumentHandler handler = this.getStyleDeclarationDocumentHandler();
        parser.setErrorHandler((ErrorHandler)handler);
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        this.clear();
        handler.setLexicalPropertyListener(this);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    private Parser createSACParser() throws DOMException {
        CSSStyleSheetFactory factory;
        Parser parser = SACParserFactory.createSACParser();
        if (parser instanceof Parser2 && (factory = this.getStyleSheetFactory()) != null && factory.getComplianceMode() == CSSStyleSheetFactory.ComplianceMode.LENIENT) {
            ((Parser2)parser).setFlag(Parser2.Flag.STARHACK);
        }
        return parser;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        AbstractCSSValue value = this.getCSSValue(propertyName = this.getCanonicalPropertyName(propertyName));
        if (value != null) {
            short ptype;
            if (value.getCssValueType() == 1 && ((ptype = ((CSSPrimitiveValue)((Object)value)).getPrimitiveType()) == 19 || ptype == 21)) {
                return ((CSSPrimitiveValue)((Object)value)).getStringValue();
            }
            try {
                return value.getCssText();
            }
            catch (StyleDatabaseRequiredException e) {
                e.setValueText(propertyName);
                throw e;
            }
        }
        return "";
    }

    @Override
    public AbstractCSSValue getPropertyCSSValue(String propertyName) {
        propertyName = this.getCanonicalPropertyName(propertyName);
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    private String getCanonicalPropertyName(String propertyName) {
        if (propertyName.length() > 2 && (propertyName.charAt(0) != '-' || propertyName.charAt(1) != '-')) {
            propertyName = propertyName.toLowerCase(Locale.US);
        }
        return propertyName;
    }

    protected AbstractCSSValue getCSSValue(String propertyName) {
        return this.getDeclaredCSSValue(propertyName);
    }

    protected AbstractCSSValue getDeclaredCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    public AbstractCSSValue computeBoundProperty(String masterProperty, String propertyName, AbstractCSSValue value) {
        OMCSSValueList list;
        AbstractCSSValue bimg = this.getCSSValue(masterProperty);
        if (bimg == null) {
            return null;
        }
        int layers = 1;
        if (bimg.getCssValueType() == 2 && (list = (OMCSSValueList)bimg).isCommaSeparated()) {
            layers = list.getLength();
        }
        if (layers == 1) {
            if (value == null) {
                value = PropertyDatabase.getInstance().getInitialValue(propertyName);
            }
        } else {
            value = this.computeSubpropertyList(value, layers);
        }
        return value;
    }

    OMCSSValueList computeSubpropertyList(AbstractCSSValue value, int layers) {
        OMCSSValueList list;
        block6: {
            int items;
            if (value.getCssValueType() == 2 && ((OMCSSValueList)value).isCommaSeparated()) {
                list = (OMCSSValueList)value.clone();
                items = list.getLength();
            } else {
                list = OMCSSValueList.createCSValueList();
                list.add(value);
                value = list;
                items = 1;
            }
            if (layers == items) break block6;
            if (layers < items) {
                while (items > layers) {
                    list.remove(--items);
                }
            } else {
                int j = 0;
                while (items++ < layers) {
                    list.add(list.item(j++));
                }
            }
        }
        return list;
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        int idx = this.propertyList.indexOf(propertyName = this.getCanonicalPropertyName(propertyName));
        if (idx >= 0 && !this.propValue.get(propertyName).isSubproperty()) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            CSSValue oldvalue = this.propValue.remove(propertyName);
            PropertyDatabase pdb = PropertyDatabase.getInstance();
            if (!this.shorthandSet.isEmpty() && pdb.isShorthandSubproperty(propertyName)) {
                String shorthand = propertyName;
                boolean hasShorthand = false;
                while (!(hasShorthand = this.shorthandSet.contains(shorthand = pdb.getShorthand(shorthand))) && pdb.isShorthandSubproperty(shorthand)) {
                }
                if (hasShorthand) {
                    CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthand);
                    this.setSubproperties(shorthand, shval.getLexicalUnit(), shval.isImportant() ? "important" : null);
                }
            }
            return oldvalue.getCssText();
        }
        if (this.shorthandSet.contains(propertyName)) {
            String text = this.propValue.get(propertyName).getCssText();
            this.removeSubproperties(PropertyDatabase.getInstance(), propertyName);
            return text;
        }
        return "";
    }

    private void removeSubproperties(PropertyDatabase pdb, String shorthandName) {
        this.shorthandSet.remove(shorthandName);
        String[] subp = pdb.getShorthandSubproperties(shorthandName);
        for (int i = 0; i < subp.length; ++i) {
            int idx = this.propertyList.indexOf(subp[i]);
            if (idx == -1) {
                this.removeSubproperties(pdb, subp[i]);
                continue;
            }
            if (!this.propValue.get(subp[i]).isSubproperty()) continue;
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.propValue.remove(subp[i]);
        }
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx < 0) {
            if (this.shorthandSet.contains(propertyName) && ((CSSShorthandValue)this.propValue.get(propertyName)).isImportant()) {
                return "important";
            }
            return "";
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit value, String priority) throws DOMException {
        propertyName = this.getCanonicalPropertyName(propertyName);
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            boolean important = priority == "important";
            CSSShorthandValue shVal = (CSSShorthandValue)this.propValue.get(propertyName);
            if (shVal == null || important || !shVal.isImportant()) {
                LinkedList<String> shadowedShorthands = null;
                if (!this.shorthandSet.isEmpty()) {
                    if (this.shorthandSet.contains(propertyName)) {
                        shadowedShorthands = new LinkedList<String>();
                        shadowedShorthands.add(propertyName);
                    }
                    for (String sh : this.shorthandSet) {
                        if (pdb.isShorthandSubpropertyOf(propertyName, sh)) {
                            if (!important && ((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                            if (shadowedShorthands == null) {
                                shadowedShorthands = new LinkedList();
                            }
                            shadowedShorthands.add(sh);
                            continue;
                        }
                        if (!pdb.isShorthandSubpropertyOf(sh, propertyName) || important || !((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                        return;
                    }
                }
                shVal = new CSSShorthandValue(value, important);
                try {
                    String shorthandText = this.setSubproperties(propertyName, value, priority);
                    if (shorthandText.length() != 0) {
                        shVal.setShorthandText(shorthandText);
                        if (shadowedShorthands != null) {
                            for (String shadowed : shadowedShorthands) {
                                this.shorthandSet.remove(shadowed);
                                this.propValue.remove(shadowed);
                            }
                        }
                        this.propValue.put(propertyName, shVal);
                        this.shorthandSet.add(propertyName);
                    } else {
                        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                        if (errHandler != null) {
                            errHandler.shorthandWarning(propertyName, BaseCSSStyleDeclaration.lexicalUnitToString(value));
                        }
                    }
                }
                catch (DOMException e) {
                    StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName);
                        ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
                        errHandler.wrongValue(propertyName, ex);
                    }
                }
            }
        } else {
            AbstractCSSValue cssvalue;
            ValueFactory factory = new ValueFactory();
            try {
                cssvalue = factory.createCSSValue(value, this.getParentRule());
            }
            catch (DOMException e) {
                StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName);
                    ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
                    errHandler.wrongValue(propertyName, ex);
                }
                throw e;
            }
            if (propertyName.equals("font-family") || propertyName.equals("content")) {
                if (cssvalue.getCssValueType() == 2) {
                    OMCSSValueList list = (OMCSSValueList)cssvalue;
                    if (list.isCommaSeparated()) {
                        int sz = list.getLength();
                        for (int i = 0; i < sz; ++i) {
                            if (list.item(i).getCssValueType() != 2) continue;
                            list.set(i, this.listToString((OMCSSValueList)list.item(i)));
                        }
                    } else {
                        cssvalue = this.listToString(list);
                    }
                }
            } else if (propertyName.equals("background-position") && cssvalue.getCssValueType() == 2) {
                OMCSSValueList list = (OMCSSValueList)cssvalue;
                if (list.isCommaSeparated()) {
                    int sz = list.getLength();
                    for (int i = 0; i < sz; ++i) {
                        AbstractCSSValue item = list.item(i);
                        if (item.getCssValueType() != 2 || BaseCSSStyleDeclaration.checkBackgroundPosition((OMCSSValueList)item)) continue;
                        list.remove(i--);
                        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                        if (errHandler == null) continue;
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(item.getCssText());
                        errHandler.wrongValue("background-position", ex);
                    }
                    if (list.getLength() == 0) {
                        return;
                    }
                } else if (!BaseCSSStyleDeclaration.checkBackgroundPosition(list)) {
                    StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(list.getCssText());
                        errHandler.wrongValue("background-position", ex);
                    }
                    return;
                }
            }
            this.setProperty(propertyName, cssvalue, priority);
        }
    }

    private AbstractCSSValue listToString(OMCSSValueList list) {
        int len = list.getLength();
        boolean allItemsAreIdent = true;
        for (int i = 1; i < len; ++i) {
            AbstractCSSValue cssval = list.item(i);
            if (cssval.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() == 21) continue;
            allItemsAreIdent = false;
            break;
        }
        if (allItemsAreIdent) {
            StringBuilder buf = new StringBuilder(len * 7 + 8);
            buf.append(list.item(0).getCssText());
            for (int i = 1; i < len; ++i) {
                buf.append(' ').append(list.item(i).getCssText());
            }
            CSSStringValue csstr = new CSSStringValue();
            csstr.setStringValue((short)19, buf.toString());
            return csstr;
        }
        return list;
    }

    private static boolean checkBackgroundPosition(OMCSSValueList list) {
        int count = list.getLength();
        if (count < 3) {
            return true;
        }
        if (count == 4) {
            return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
        }
        if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
            return false;
        }
        if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
            return true;
        }
        return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        LexicalUnit lunit;
        Parser parser;
        if (value.length() == 0) {
            this.removeProperty(propertyName);
            return;
        }
        try {
            parser = this.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        if (priority != null) {
            priority = priority.toLowerCase(Locale.US).intern();
        }
        this.setProperty(propertyName, lunit, priority);
    }

    boolean setProperty(String propertyName, AbstractCSSValue cssValue, String priority) {
        if (!this.propertyList.contains(propertyName = propertyName.intern())) {
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        int idx = this.propertyList.indexOf(propertyName);
        if (!"important".equals(this.priorities.get(idx)) || "important".equals(priority)) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        return false;
    }

    @Override
    void addProperty(String propertyName, AbstractCSSValue cssValue, String priority) {
        if (cssValue instanceof CSSShorthandValue) {
            this.addShorthandName(propertyName);
        } else {
            this.propertyList.add(propertyName);
            this.priorities.add(priority);
        }
        this.propValue.put(propertyName, cssValue);
    }

    private void addShorthandName(String shorthand) {
        if (this.shorthandSet.contains(shorthand)) {
            this.shorthandSet.remove(shorthand);
        }
        this.shorthandSet.add(shorthand);
    }

    boolean isPropertySet(String propertyName) {
        return this.propertyList.contains(propertyName);
    }

    boolean isPropertyImportant(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx != -1) {
            String prio = this.priorities.get(idx);
            return prio != null && prio.length() != 0;
        }
        return false;
    }

    boolean isPropertySet(String propertyName, boolean important) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx != -1) {
            String prio = this.priorities.get(idx);
            boolean prioImportant = prio != null && prio.length() != 0;
            return prioImportant == important;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.propertyList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    @Override
    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
        this.shorthandSet.clear();
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().reset();
        }
    }

    @Override
    public BaseCSSDeclarationRule getParentRule() {
        return this.parentRule;
    }

    public Node getOwnerNode() {
        AbstractCSSStyleSheet sheet;
        if (this.parentRule != null && (sheet = this.parentRule.getParentStyleSheet()) != null) {
            return sheet.getOwnerNode();
        }
        return null;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        HashSet<String> addedShorthands = new HashSet<String>(style.shorthandSet.size());
        Iterator<String> it = style.propertyList.iterator();
        int i = -1;
        while (it.hasNext()) {
            String shorthand;
            ++i;
            String propertyName = it.next();
            int pIndex = this.propertyList.indexOf(propertyName);
            if (pIndex == -1) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else if (!"important".equals(this.priorities.get(pIndex))) {
                this.priorities.set(pIndex, style.priorities.get(i));
            } else if (!"important".equals(style.priorities.get(i))) continue;
            AbstractCSSValue value = style.getCSSValue(propertyName);
            if (value.isSubproperty() && !addedShorthands.contains(shorthand = pdb.getShorthand(propertyName))) {
                AbstractCSSValue shvalue;
                String bigshorthand = pdb.getShorthand(shorthand);
                if (bigshorthand != null && style.shorthandSet.contains(bigshorthand)) {
                    addedShorthands.add(bigshorthand);
                    this.addShorthandName(bigshorthand);
                    shvalue = style.propValue.get(bigshorthand);
                    this.setPropertyCSSValue(bigshorthand, shvalue, null);
                }
                if ((shvalue = style.propValue.get(shorthand)) != null) {
                    addedShorthands.add(shorthand);
                    this.addShorthandName(shorthand);
                    this.setPropertyCSSValue(shorthand, shvalue, null);
                }
            }
            String href = null;
            if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
                href = style.getParentRule() != null ? style.getParentRule().getParentStyleSheet().getHref() : ((NodeStyleDeclaration)((Object)style)).getOwnerNode().getOwnerDocument().getBaseURI();
            }
            this.setPropertyCSSValue(propertyName, value, href);
        }
    }

    protected void setPropertyCSSValue(String propertyName, AbstractCSSValue value, String hrefcontext) {
        this.propValue.put(propertyName, value);
    }

    @Override
    protected void prioritySplit(AbstractCSSStyleDeclaration importantDecl, AbstractCSSStyleDeclaration normalDecl) {
        AbstractCSSValue value;
        int psz = this.propertyList.size();
        for (int i = 0; i < psz; ++i) {
            String propertyName = this.propertyList.get(i);
            value = this.propValue.get(propertyName);
            String priority = this.priorities.get(i);
            if ("important".equals(priority)) {
                importantDecl.addProperty(propertyName, value, priority);
                continue;
            }
            normalDecl.addProperty(propertyName, value, priority);
        }
        for (String sh : this.shorthandSet) {
            value = (CSSShorthandValue)this.propValue.get(sh);
            if (((CSSShorthandValue)value).isImportant()) {
                importantDecl.addProperty(sh, value, "important");
                continue;
            }
            normalDecl.addProperty(sh, value, null);
        }
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    protected AbstractCSSValue defaultPropertyValue(String propertyName, PropertyDatabase pdb) {
        AbstractCSSValue defval = pdb.getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                if (this.getStyleDatabase() == null) {
                    if (this.getStyleSheetFactory() != null) {
                        return this.getStyleSheetFactory().getSystemDefaultValue(propertyName);
                    }
                    return SystemDefaultValue.getInstance();
                }
                defval = (AbstractCSSValue)((Object)this.getStyleDatabase().getInitialColor());
            } else if (propertyName.equals("font-family")) {
                if (this.getStyleDatabase() == null) {
                    if (this.getStyleSheetFactory() != null) {
                        return this.getStyleSheetFactory().getSystemDefaultValue(propertyName);
                    }
                    return SystemDefaultValue.getInstance();
                }
                defval = new ValueFactory().parseProperty(this.getStyleDatabase().getDefaultGenericFontFamily());
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new CSSIdentifierValue("right") : new CSSIdentifierValue("left");
            } else if (propertyName.endsWith("-color")) {
                defval = this.getCurrentColor();
            } else if (propertyName.equals("quotes")) {
                defval = new ValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    protected AbstractCSSPrimitiveValue getCurrentColor() {
        return new CSSIdentifierValue("currentcolor");
    }

    public AbstractCSSPrimitiveValue getCSSColor() {
        AbstractCSSPrimitiveValue color;
        AbstractCSSValue cssvalue = this.getCSSValue("color");
        if (cssvalue == null || cssvalue.getCssValueType() != 1) {
            StyleDatabase sdb = this.getStyleDatabase();
            if (sdb != null) {
                color = (AbstractCSSPrimitiveValue)this.getStyleDatabase().getInitialColor();
            } else {
                CSSStyleSheetFactory factory = this.getStyleSheetFactory();
                if (factory != null) {
                    return factory.getSystemDefaultValue("color");
                }
                color = SystemDefaultValue.getInstance();
            }
        } else {
            color = (AbstractCSSPrimitiveValue)cssvalue;
        }
        return color;
    }

    LinkedList<String> getShorthandSet() {
        return this.shorthandSet;
    }

    protected String setSubproperties(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            ShorthandSetter setter;
            if ("font".equals(propertyName)) {
                String decl;
                if (this.getStyleDatabase() != null && value.getLexicalUnitType() == 35 && (decl = this.getStyleDatabase().getSystemFontDeclaration(value.getStringValue())) != null) {
                    InputSource source = new InputSource();
                    StringReader re = new StringReader(decl);
                    source.setCharacterStream((Reader)re);
                    LexicalUnit lunit = null;
                    try {
                        lunit = this.createSACParser().parsePropertyValue(source);
                    }
                    catch (CSSException e) {
                        DOMException ex = new DOMException(12, e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (IOException e) {
                        throw new DOMException(11, e.getMessage());
                    }
                    return this.setSubproperties(propertyName, lunit, priority);
                }
                setter = new FontShorthandSetter(this);
            } else {
                setter = "margin".equals(propertyName) ? new MarginShorthandSetter(this) : ("padding".equals(propertyName) ? new BoxShorthandSetter(this, "padding") : ("border".equals(propertyName) ? new BorderShorthandSetter(this) : ("border-width".equals(propertyName) ? new BorderWidthShorthandSetter(this) : ("border-style".equals(propertyName) ? new BorderStyleShorthandSetter(this) : ("border-color".equals(propertyName) ? new BorderColorShorthandSetter(this) : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "left") : ("background".equals(propertyName) ? new BackgroundShorthandSetter(this) : ("transition".equals(propertyName) ? new TransitionShorthandSetter(this) : ("border-image".equals(propertyName) ? new BorderImageShorthandSetter(this) : ("font-variant".equals(propertyName) ? new FontVariantShorthandSetter(this) : ("border-radius".equals(propertyName) ? new BorderRadiusShorthandSetter(this) : ("cue".equals(propertyName) || "pause".equals(propertyName) || "rest".equals(propertyName) ? new SequenceShorthandSetter(this, propertyName) : ("list-style".equals(propertyName) ? new ListStyleShorthandSetter(this) : ("animation".equals(propertyName) ? new AnimationShorthandSetter(this) : ("flex".equals(propertyName) ? new FlexShorthandSetter(this) : ("grid".equals(propertyName) ? new GridShorthandSetter(this) : ("grid-template".equals(propertyName) ? new GridTemplateShorthandSetter(this) : ("grid-area".equals(propertyName) ? new GridAreaShorthandSetter(this) : ("grid-column".equals(propertyName) || "grid-row".equals(propertyName) ? new GridPlacementShorthandSetter(this, propertyName) : ("columns".equals(propertyName) ? new ColumnsShorthandSetter(this) : ("column-rule".equals(propertyName) ? new ColumnRuleShorthandSetter(this) : ("place-content".equals(propertyName) || "place-items".equals(propertyName) || "place-self".equals(propertyName) ? new OrderedTwoIdentifierShorthandSetter(this, propertyName) : ("gap".equals(propertyName) ? new OrderedTwoLPIShorthandSetter(this, propertyName) : new ShorthandSetter(this, propertyName)))))))))))))))))))))))))));
            }
            setter.init(value, priority);
            if (!setter.assignSubproperties()) {
                throw new DOMException(12, "Invalid property declaration: " + value.toString());
            }
            return setter.getCssText();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        TreeSet<String> propertyNames = new TreeSet<String>(this.propertyList);
        for (String property : propertyNames) {
            result = 31 * result + property.hashCode();
            result = 31 * result + this.propValue.get(property).hashCode();
            String prio = this.priorities.get(this.propertyList.indexOf(property));
            result = 31 * result + (prio == null ? 0 : prio.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCSSStyleDeclaration)) {
            return false;
        }
        BaseCSSStyleDeclaration other = (BaseCSSStyleDeclaration)obj;
        if (this.propertyList.size() != other.propertyList.size()) {
            return false;
        }
        for (String property : this.propertyList) {
            if (!other.propertyList.contains(property)) {
                return false;
            }
            AbstractCSSValue value = this.propValue.get(property);
            if (!value.equals(other.propValue.get(property))) {
                return false;
            }
            int idx = this.propertyList.indexOf(property);
            int idxo = other.propertyList.indexOf(property);
            String prio = this.priorities.get(idx);
            String prioo = other.priorities.get(idxo);
            if (!(prio == null ? prioo != null : !prio.equals(prioo))) continue;
            return false;
        }
        return true;
    }

    public Diff<String> diff(BaseCSSStyleDeclaration other) {
        PropertyDiff diff = new PropertyDiff();
        for (String property : this.propertyList) {
            if (!other.propertyList.contains(property)) {
                diff.leftSide.add(property);
                continue;
            }
            AbstractCSSValue value = this.getCSSValue(property);
            if (value.equals(other.getCSSValue(property))) {
                int idx = this.propertyList.indexOf(property);
                int idxo = other.propertyList.indexOf(property);
                String prio = this.priorities.get(idx);
                String prioo = other.priorities.get(idxo);
                if (prio == null ? prioo == null : prio.equals(prioo)) continue;
            }
            diff.differentValues.add(property);
        }
        for (String property : other.propertyList) {
            if (this.propertyList.contains(property)) continue;
            diff.rightSide.add(property);
        }
        return diff;
    }

    public String toString() {
        return this.getCssText();
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    @Override
    protected CSSStyleSheetFactory getStyleSheetFactory() {
        AbstractCSSStyleSheet sheet;
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null && (sheet = prule.getParentStyleSheet()) != null) {
            return sheet.getStyleSheetFactory();
        }
        return null;
    }

    static String lexicalUnitToString(LexicalUnit value) {
        if (value == null) {
            return "";
        }
        String s = null;
        switch (value.getLexicalUnitType()) {
            case 35: 
            case 36: {
                s = value.getStringValue();
                break;
            }
            case 24: {
                s = "url('" + value.getStringValue() + "')";
                break;
            }
            case 37: {
                s = "attr('" + value.getStringValue() + "')";
                break;
            }
            case 12: {
                s = "inherit";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 38: 
            case 41: {
                s = value.getFunctionName();
                s = s + "(" + BaseCSSStyleDeclaration.lexicalUnitToString(value.getParameters()) + ")";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                s = Float.toString(value.getFloatValue()) + value.getDimensionUnitText();
                break;
            }
            case 13: {
                s = Integer.toString(value.getIntegerValue());
                break;
            }
            case 40: {
                s = BaseCSSStyleDeclaration.lexicalUnitToString(value.getSubValues());
                break;
            }
            case 0: {
                s = ",";
                break;
            }
            case 6: {
                s = "^";
                break;
            }
            case 10: {
                s = ">=";
                break;
            }
            case 8: {
                s = ">";
                break;
            }
            case 9: {
                s = "<=";
                break;
            }
            case 7: {
                s = "<";
                break;
            }
            case 2: {
                s = "-";
                break;
            }
            case 5: {
                s = "%";
                break;
            }
            case 3: {
                s = "*";
                break;
            }
            case 1: {
                s = "+";
                break;
            }
            case 4: {
                s = "/";
                break;
            }
            case 11: {
                s = "~";
                break;
            }
            case 68: {
                s = "[";
                break;
            }
            case 69: {
                s = "]";
                break;
            }
            default: {
                s = value.toString();
            }
        }
        value = value.getNextLexicalUnit();
        if (value != null) {
            if (value.getLexicalUnitType() != 0) {
                s = s + " ";
            }
            s = s + BaseCSSStyleDeclaration.lexicalUnitToString(value);
        }
        return s;
    }

    StyleDeclarationDocumentHandler getStyleDeclarationDocumentHandler() {
        return new StyleDeclarationDocumentHandler();
    }

    public static boolean testColor(LexicalUnit lunit) {
        String func;
        short utype = lunit.getLexicalUnitType();
        if (27 == utype) {
            return true;
        }
        if (36 == utype && lunit.getStringValue().charAt(0) == '#') {
            return true;
        }
        if (35 == utype) {
            String sv = lunit.getStringValue();
            if (sv == null) {
                return false;
            }
            sv = sv.toLowerCase(Locale.US);
            ColorIdentifiers colorids = ColorIdentifiers.getInstance();
            return colorids.getColor(sv) != null || "transparent".equals(sv) || "currentcolor".equals(sv) || colorids.isSystemColor(sv);
        }
        return 41 == utype && ("rgba".equals(func = lunit.getFunctionName().toLowerCase(Locale.US)) || "hsla".equals(func) || "hsl".equals(func) || "hwb".equals(func) || "color".equals(func));
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue("azimuth");
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.getPropertyCSSValue("azimuth").setCssText(azimuth);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue("background");
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.getPropertyCSSValue("background").setCssText(background);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue("background-attachment");
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue("background-color");
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue("background-image");
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue("background-position");
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue("background-repeat");
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue("border");
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.getPropertyCSSValue("border").setCssText(border);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue("border-collapse");
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue("border-color");
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.getPropertyCSSValue("border-color").setCssText(borderColor);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue("border-spacing");
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue("border-style");
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.getPropertyCSSValue("border-style").setCssText(borderStyle);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue("border-top");
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.getPropertyCSSValue("border-top").setCssText(borderTop);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue("border-right");
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.getPropertyCSSValue("border-right").setCssText(borderRight);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue("border-bottom");
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue("border-left");
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.getPropertyCSSValue("border-left").setCssText(borderLeft);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue("border-top-color");
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue("border-right-color");
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue("border-bottom-color");
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue("border-left-color");
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue("border-top-style");
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue("border-right-style");
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue("border-bottom-style");
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue("border-left-style");
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue("border-top-width");
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue("border-right-width");
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue("border-bottom-width");
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue("border-left-width");
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue("border-width");
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.getPropertyCSSValue("border-width").setCssText(borderWidth);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue("bottom");
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.getPropertyCSSValue("bottom").setCssText(bottom);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue("caption-side");
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.getPropertyCSSValue("caption-side").setCssText(captionSide);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue("clear");
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.getPropertyCSSValue("clear").setCssText(clear);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue("clip");
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.getPropertyCSSValue("clip").setCssText(clip);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue("color");
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.getPropertyCSSValue("color").setCssText(color);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue("content");
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.getPropertyCSSValue("content").setCssText(content);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue("counter-increment");
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue("counter-reset");
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue("cue");
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.getPropertyCSSValue("cue").setCssText(cue);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue("cue-after");
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue("cue-before");
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue("cursor");
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.getPropertyCSSValue("cursor").setCssText(cursor);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue("direction");
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.getPropertyCSSValue("direction").setCssText(direction);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue("display");
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.getPropertyCSSValue("display").setCssText(display);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue("elevation");
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.getPropertyCSSValue("elevation").setCssText(elevation);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue("empty-cells");
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue("css-float");
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.getPropertyCSSValue("css-float").setCssText(cssFloat);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue("font");
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.getPropertyCSSValue("font").setCssText(font);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue("font-family");
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.getPropertyCSSValue("font-family").setCssText(fontFamily);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue("font-size");
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.getPropertyCSSValue("font-size").setCssText(fontSize);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue("font-size-adjust");
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue("font-stretch");
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue("font-style");
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.getPropertyCSSValue("font-style").setCssText(fontStyle);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue("font-variant");
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue("font-weight");
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue("height");
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.getPropertyCSSValue("height").setCssText(height);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue("left");
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.getPropertyCSSValue("left").setCssText(left);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue("letter-spacing");
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue("line-height");
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.getPropertyCSSValue("line-height").setCssText(lineHeight);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue("list-style");
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.getPropertyCSSValue("list-style").setCssText(listStyle);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue("list-style-image");
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue("list-style-position");
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue("list-style-type");
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue("margin");
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.getPropertyCSSValue("margin").setCssText(margin);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue("margin-top");
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.getPropertyCSSValue("margin-top").setCssText(marginTop);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue("margin-right");
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.getPropertyCSSValue("margin-right").setCssText(marginRight);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue("margin-bottom");
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue("margin-left");
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue("marker-offset");
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue("marks");
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.getPropertyCSSValue("marks").setCssText(marks);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue("max-height");
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.getPropertyCSSValue("max-height").setCssText(maxHeight);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue("max-width");
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.getPropertyCSSValue("max-width").setCssText(maxWidth);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue("min-height");
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.getPropertyCSSValue("min-height").setCssText(minHeight);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue("min-width");
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.getPropertyCSSValue("min-width").setCssText(minWidth);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue("orphans");
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.getPropertyCSSValue("orphans").setCssText(orphans);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue("outline");
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.getPropertyCSSValue("outline").setCssText(outline);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue("outline-color");
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue("outline-style");
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue("outline-width");
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue("overflow");
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.getPropertyCSSValue("overflow").setCssText(overflow);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue("padding");
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.getPropertyCSSValue("padding").setCssText(padding);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue("padding-top");
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue("padding-right");
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue("padding-bottom");
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue("padding-left");
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue("page");
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.getPropertyCSSValue("page").setCssText(page);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue("page-break-after");
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue("page-break-before");
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue("page-break-inside");
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue("pause");
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.getPropertyCSSValue("pause").setCssText(pause);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue("pause-after");
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue("pause-before");
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue("pitch");
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.getPropertyCSSValue("pitch").setCssText(pitch);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue("pitch-range");
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue("play-during");
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.getPropertyCSSValue("play-during").setCssText(playDuring);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue("position");
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.getPropertyCSSValue("position").setCssText(position);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue("quotes");
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.getPropertyCSSValue("quotes").setCssText(quotes);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue("richness");
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.getPropertyCSSValue("richness").setCssText(richness);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue("right");
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.getPropertyCSSValue("right").setCssText(right);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue("size");
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.getPropertyCSSValue("size").setCssText(size);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue("speak");
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.getPropertyCSSValue("speak").setCssText(speak);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue("speak-header");
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue("speak-numeral");
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue("speak-punctuation");
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue("speech-rate");
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue("stress");
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.getPropertyCSSValue("stress").setCssText(stress);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue("table-layout");
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue("text-align");
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.getPropertyCSSValue("text-align").setCssText(textAlign);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue("text-decoration");
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue("text-indent");
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.getPropertyCSSValue("text-indent").setCssText(textIndent);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue("text-shadow");
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue("text-transform");
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.getPropertyCSSValue("text-transform").setCssText(textTransform);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue("top");
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.getPropertyCSSValue("top").setCssText(top);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue("vertical-align");
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.getPropertyCSSValue("visibility").setCssText(visibility);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue("voice-family");
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue("volume");
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.getPropertyCSSValue("volume").setCssText(volume);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue("white-space");
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
    }

    @Override
    public String getWidows() {
        return null;
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.getPropertyCSSValue("widows").setCssText(widows);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue("width");
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.getPropertyCSSValue("width").setCssText(width);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue("word-spacing");
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue("z-index");
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.getPropertyCSSValue("z-index").setCssText(zIndex);
    }

    static interface SubpropertySetter {
        public void init(LexicalUnit var1, String var2);

        public boolean assignSubproperties();

        public String getCssText();
    }

    class StyleDeclarationDocumentHandler
    extends PropertyDocumentHandler {
        StyleDeclarationDocumentHandler() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (BaseCSSStyleDeclaration.this.getParentRule() == null || BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        @Override
        public void warning(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacWarning(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        @Override
        public void fatalError(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacFatalError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }
    }

    class PropertyDiff
    implements Diff<String> {
        LinkedList<String> leftSide = new LinkedList();
        LinkedList<String> rightSide = new LinkedList();
        LinkedList<String> differentValues = new LinkedList();

        PropertyDiff() {
        }

        @Override
        public boolean hasDifferences() {
            return !this.leftSide.isEmpty() || !this.rightSide.isEmpty() || !this.differentValues.isEmpty();
        }

        public String[] getLeftSide() {
            if (this.leftSide.isEmpty()) {
                return null;
            }
            return this.leftSide.toArray(new String[0]);
        }

        public String[] getRightSide() {
            if (this.rightSide.isEmpty()) {
                return null;
            }
            return this.rightSide.toArray(new String[0]);
        }

        public String[] getDifferent() {
            if (this.differentValues.isEmpty()) {
                return null;
            }
            return this.differentValues.toArray(new String[0]);
        }
    }
}

