/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;

class BorderImageShorthandSetter
extends ShorthandSetter {
    BorderImageShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border-image");
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        boolean errorFound = false;
        boolean bisourceUnset = true;
        boolean bisliceUnset = true;
        boolean biwidthUnset = true;
        boolean bioutsetUnset = true;
        boolean birepeatUnset = true;
        while (this.currentValue != null) {
            StyleDeclarationErrorHandler errHandler;
            block29: {
                block28: {
                    int c;
                    OMCSSValueList list;
                    short lut;
                    block30: {
                        lut = this.currentValue.getLexicalUnitType();
                        if (lut == 24 || this.isGradientValue()) {
                            this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                            bisourceUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                        if (lut == 35) {
                            if (this.testIdentifiers("border-image-repeat")) {
                                this.setSubpropertyValue("border-image-repeat", this.createCSSValue("border-image-repeat", this.currentValue));
                                birepeatUnset = false;
                            } else if ("none".equalsIgnoreCase(this.currentValue.getStringValue())) {
                                this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                                bisourceUnset = false;
                            } else if ("auto".equalsIgnoreCase(this.currentValue.getStringValue())) {
                                this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                                biwidthUnset = false;
                            } else {
                                errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                                if (errHandler != null) {
                                    errHandler.unknownIdentifier("border-image", this.currentValue.getStringValue());
                                }
                                errorFound = true;
                            }
                            this.nextCurrentValue();
                            continue;
                        }
                        if (!ValueFactory.isPlainNumberOrPercentSACUnit(this.currentValue)) break block28;
                        list = OMCSSValueList.createWSValueList();
                        do {
                            list.add(this.createCSSValue("border-image-slice", this.currentValue));
                            this.nextCurrentValue();
                        } while (this.currentValue != null && (lut = this.currentValue.getLexicalUnitType()) != 4 && lut != 35);
                        this.setSubpropertyValue("border-image-slice", list);
                        bisliceUnset = false;
                        if (this.currentValue == null) break block29;
                        if (lut == 35) {
                            if (!"fill".equals(this.currentValue.getStringValue().toLowerCase(Locale.US))) continue;
                            list.add(this.createCSSValue("border-image-slice", this.currentValue));
                            this.nextCurrentValue();
                            if (this.currentValue == null) break;
                            lut = this.currentValue.getLexicalUnitType();
                        }
                        if (lut != 4) break block29;
                        this.nextCurrentValue();
                        lut = this.currentValue.getLexicalUnitType();
                        if (lut == 4) {
                            this.nextCurrentValue();
                            if (!ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                                StyleDeclarationErrorHandler errHandler2 = this.styleDeclaration.getStyleDeclarationErrorHandler();
                                if (errHandler2 == null) break;
                                CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for border-image: expected width / outset");
                                ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(this.currentValue));
                                errHandler2.wrongValue("border-image", ex);
                                errorFound = true;
                                break;
                            }
                            list = OMCSSValueList.createWSValueList();
                            c = 0;
                            while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                                list.add(this.createCSSValue("border-image-outset", this.currentValue));
                                this.nextCurrentValue();
                                c = (byte)(c + 1);
                                if (this.currentValue != null && c < 4) continue;
                            }
                            if (list.getLength() == 0) continue;
                            this.setSubpropertyValue("border-image-outset", list);
                            bioutsetUnset = false;
                            continue;
                        }
                        if (lut != 35) break block30;
                        if (!"auto".equalsIgnoreCase(this.currentValue.getStringValue())) continue;
                        this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                        biwidthUnset = false;
                        this.nextCurrentValue();
                        break block29;
                    }
                    c = 0;
                    list = OMCSSValueList.createWSValueList();
                    while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                        list.add(this.createCSSValue("border-image-width", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        lut = this.currentValue.getLexicalUnitType();
                        c = (byte)(c + 1);
                        if (lut != 4 && lut != 35 && c < 4) continue;
                    }
                    if (list.getLength() != 0) {
                        this.setSubpropertyValue("border-image-width", list);
                        biwidthUnset = false;
                    }
                    if (lut != 4) break block29;
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    list = OMCSSValueList.createWSValueList();
                    while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue) && c < 4) {
                        list.add(this.createCSSValue("border-image-outset", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        c = (byte)(c + 1);
                    }
                    if (list.getLength() == 0) break block29;
                    this.setSubpropertyValue("border-image-outset", list);
                    bioutsetUnset = false;
                    break block29;
                }
                errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    errHandler.unassignedShorthandValue("border-image", this.currentValue.toString());
                }
                errorFound = true;
                break;
            }
            if (bisourceUnset || bisliceUnset || biwidthUnset || bioutsetUnset || birepeatUnset || this.currentValue == null) continue;
            errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null) {
                errHandler.shorthandError("border-image", "Unexpected value: " + this.currentValue.toString());
            }
            errorFound = true;
            break;
        }
        if (errorFound) {
            return false;
        }
        if (bisourceUnset) {
            this.setSubpropertyValue("border-image-source", this.defaultPropertyValue("border-image-source"));
        }
        if (bisliceUnset) {
            this.setSubpropertyValue("border-image-slice", this.defaultPropertyValue("border-image-slice"));
        }
        if (biwidthUnset) {
            this.setSubpropertyValue("border-image-width", this.defaultPropertyValue("border-image-width"));
        }
        if (bioutsetUnset) {
            this.setSubpropertyValue("border-image-outset", this.defaultPropertyValue("border-image-outset"));
        }
        if (birepeatUnset) {
            this.setSubpropertyValue("border-image-repeat", this.defaultPropertyValue("border-image-repeat"));
        }
        this.flush();
        return true;
    }
}

