/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.property.AbstractCSSExpression;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSURIValueWrapper;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ExpressionContainerValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.OMCSSFunctionValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSSComputedProperties {
    private Node node = null;

    protected ComputedCSSStyle() {
    }

    protected ComputedCSSStyle(BaseCSSStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    protected void setOwnerNode(Node node) {
        this.node = node;
    }

    @Override
    public Node getOwnerNode() {
        return this.node;
    }

    @Override
    protected void setPropertyCSSValue(String propertyName, AbstractCSSValue value, String hrefcontext) {
        if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
            if (value.getCssValueType() == 2) {
                if (hrefcontext != null) {
                    value = ((OMCSSValueList)value).wrap(hrefcontext);
                }
            } else if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 20 && hrefcontext != null) {
                value = new CSSURIValueWrapper((CSSURIValue)value, hrefcontext);
            }
        }
        super.setPropertyCSSValue(propertyName, value, hrefcontext);
    }

    @Override
    public AbstractCSSValue getCSSValue(String property) throws StyleDatabaseRequiredException {
        AbstractCSSValue value = super.getCSSValue(property);
        PropertyDatabase propertydb = PropertyDatabase.getInstance();
        boolean inherited = propertydb.isInherited(property);
        if (value != null && this.isCSSIdentifier(value, "unset")) {
            value = inherited ? CSSInheritValue.getValue() : this.defaultPropertyValue(property, propertydb);
        }
        CSSComputedProperties ancStyle = this;
        while ((value == null ? inherited : value.getCssValueType() == 0) && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
            value = (AbstractCSSValue)ancStyle.getPropertyCSSValue(property);
        }
        if (value != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null || value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 21 && value.getCssText().equalsIgnoreCase("initial")) {
            value = this.defaultPropertyValue(property, propertydb);
        }
        if (value != null) {
            if (value.isSystemDefault() && value instanceof SystemDefaultValue) {
                return value;
            }
            if ("display".equals(property)) {
                value = this.applyDisplayConstrains(value);
            } else if (property.endsWith("-width")) {
                value = this.applyBorderWidthConstrains(property, value);
            } else if ("background-repeat".equals(property)) {
                value = this.computeBackgroundRepeat(value);
            } else if (property.endsWith("color") && value.getCssValueType() == 1) {
                CSSPrimitiveValue prival = (CSSPrimitiveValue)((Object)value);
                if (prival.getPrimitiveType() == 21) {
                    String s = prival.getStringValue().toLowerCase(Locale.US);
                    if ("currentcolor".equals(s)) {
                        if (!"color".equals(property)) {
                            value = this.getCSSColor();
                        }
                    } else {
                        String spec = "transparent".equals(s) ? "rgba(0,0,0/0)" : ColorIdentifiers.getInstance().getColor(s);
                        if (spec != null) {
                            try {
                                value = new ValueFactory().parseProperty(spec);
                            }
                            catch (DOMException dOMException) {
                                // empty catch block
                            }
                        }
                    }
                }
                return value;
            }
            if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 128) {
                value = this.getCSSValue(((CSSPrimitiveValue)((Object)value)).getStringValue());
            } else if (!property.equals("font-size")) {
                value = this.absoluteValue(value);
            }
        }
        return value;
    }

    private boolean isCSSIdentifier(CSSValue value, String ident) {
        return value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 21 && ident.equalsIgnoreCase(value.getCssText());
    }

    private AbstractCSSValue absoluteValue(AbstractCSSValue value) {
        short type = value.getCssValueType();
        if (type == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            int lstlen = list.getLength();
            for (int i = 0; i < lstlen; ++i) {
                list.set(i, this.absoluteValue(list.item(i)));
            }
        } else if (type == 1) {
            value = this.absolutePrimitiveValue((AbstractCSSPrimitiveValue)value);
        }
        return value;
    }

    private AbstractCSSPrimitiveValue absolutePrimitiveValue(AbstractCSSPrimitiveValue pri) {
        if (this.isRelativeUnit(pri)) {
            pri = this.absoluteNumberValue((CSSNumberValue)pri);
        } else {
            short type = pri.getPrimitiveType();
            if (type == 101) {
                pri = pri.clone();
                AbstractCSSExpression expr = ((ExpressionContainerValue)pri).getExpression();
                this.absoluteExpressionValue(expr);
            } else if (type == 127) {
                pri = pri.clone();
                LinkedCSSValueList args = ((OMCSSFunctionValue)pri).getArguments();
                int sz = args.size();
                for (int i = 0; i < sz; ++i) {
                    args.set(i, this.absoluteValue((AbstractCSSValue)args.get(i)));
                }
            }
        }
        return pri;
    }

    private boolean isRelativeUnit(CSSPrimitiveValue pri) {
        switch (pri.getPrimitiveType()) {
            case 3: 
            case 4: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                return pri instanceof CSSNumberValue;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CSSNumberValue absoluteNumberValue(CSSNumberValue value) {
        short unit = value.getPrimitiveType();
        float fv = value.getFloatValue(unit);
        if (unit == 3) {
            value = new CSSNumberValue();
            value.setFloatValuePt(fv * (float)this.getComputedFontSize());
            return value;
        } else if (unit == 3) {
            fv = this.getStyleDatabase() != null ? (fv *= (float)this.getStyleDatabase().getExSizeInPt(this.getUsedFontFamily(), this.getComputedFontSize())) : (fv *= (float)this.getComputedFontSize() * 0.5f);
            value = new CSSNumberValue();
            value.setFloatValuePt(fv);
            return value;
        } else if (unit == 31) {
            CSSDocument doc = (CSSDocument)this.getOwnerNode().getOwnerDocument();
            value = new CSSNumberValue();
            value.setFloatValuePt(fv *= (float)doc.getStyleSheet().getComputedStyle(doc.getDocumentElement(), null).getComputedFontSize());
            return value;
        } else if (unit == 29) {
            value = new CSSNumberValue();
            value.setFloatValuePt(fv *= this.getComputedLineHeight());
            return value;
        } else if (unit == 32) {
            CSSDocument doc = (CSSDocument)this.getOwnerNode().getOwnerDocument();
            value = new CSSNumberValue();
            value.setFloatValuePt(fv *= doc.getStyleSheet().getComputedStyle(doc.getDocumentElement(), null).getComputedLineHeight());
            return value;
        } else {
            CSSCanvas canvas = ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getCanvas();
            if (unit == 26) {
                if (canvas == null) throw new IllegalStateException("cap unit requires canvas");
                fv *= canvas.getCapHeight(this);
            } else if (unit == 27) {
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("0", this)) : (fv *= (float)this.getComputedFontSize() * 0.25f);
            } else if (unit == 28) {
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("\u6c34", this)) : (fv *= (float)this.getComputedFontSize());
            }
            value = new CSSNumberValue();
            value.setFloatValuePt(fv);
        }
        return value;
    }

    private void absoluteExpressionValue(CSSExpression expr) {
        switch (expr.getPartType()) {
            case SUM: 
            case PRODUCT: {
                List<? extends CSSExpression> operands = ((CSSExpression.AlgebraicExpression)((Object)expr)).getOperands();
                Iterator<? extends CSSExpression> it = operands.iterator();
                while (it.hasNext()) {
                    this.absoluteExpressionValue(it.next());
                }
                break;
            }
            case OPERAND: {
                OperandExpression operand = (OperandExpression)expr;
                AbstractCSSPrimitiveValue primi = (AbstractCSSPrimitiveValue)operand.getOperand();
                operand.setOperand(this.absolutePrimitiveValue(primi));
            }
        }
    }

    private AbstractCSSValue applyDisplayConstrains(AbstractCSSValue value) {
        AbstractCSSValue computedValue = value;
        if (value.getCssValueType() != 1) {
            return value;
        }
        String strVal = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if (!"none".equals(strVal)) {
            String position = ((CSSPrimitiveValue)((Object)this.getCSSValue("position"))).getStringValue();
            if ("absolute".equals(position) || "fixed".equals(position)) {
                computedValue = this.computeConstrainedDisplay(value);
            } else {
                Node node;
                String floatProp = ((CSSPrimitiveValue)((Object)this.getCSSValue("float"))).getStringValue();
                if (!"none".equals(floatProp) || (node = this.getOwnerNode()) != null && node.getParentNode() == null) {
                    computedValue = this.computeConstrainedDisplay(value);
                }
            }
        }
        return computedValue;
    }

    private AbstractCSSValue computeConstrainedDisplay(AbstractCSSValue value) {
        String display = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if ("inline-table".equals(display)) {
            return new CSSIdentifierValue("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return new CSSIdentifierValue("block");
        }
        return value;
    }

    private AbstractCSSValue applyBorderWidthConstrains(String property, AbstractCSSValue value) {
        String style = null;
        if (property.equals("border-top-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-right-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-bottom-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-left-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        }
        if (style != null && (style.equals("none") || style.equals("hidden"))) {
            value = new ValueFactory().parseProperty("0");
        }
        return value;
    }

    private AbstractCSSValue computeBackgroundRepeat(AbstractCSSValue value) {
        if (value.getCssValueType() == 2) {
            OMCSSValueList list = (OMCSSValueList)value;
            if (list.isCommaSeparated()) {
                for (int i = 0; i < list.getLength(); ++i) {
                    AbstractCSSValue item = list.item(i);
                    if (item.getCssValueType() == 2) continue;
                    list.set(i, this.computeBackgroundRepeatPrimitive(item));
                }
            }
        } else {
            value = this.computeBackgroundRepeatPrimitive(value);
        }
        return value;
    }

    private AbstractCSSValue computeBackgroundRepeatPrimitive(AbstractCSSValue value) {
        OMCSSValueList list = OMCSSValueList.createWSValueList();
        String s = value.getCssText();
        if (s.equals("repeat-y")) {
            list.add(new CSSIdentifierValue("no-repeat"));
            list.add(new CSSIdentifierValue("repeat"));
        } else if (s.equals("repeat-x")) {
            list.add(new CSSIdentifierValue("repeat"));
            list.add(new CSSIdentifierValue("no-repeat"));
        } else if (s.equals("repeat")) {
            list.add(new CSSIdentifierValue("repeat"));
            list.add(new CSSIdentifierValue("repeat"));
        } else if (s.equals("no-repeat")) {
            list.add(new CSSIdentifierValue("no-repeat"));
            list.add(new CSSIdentifierValue("no-repeat"));
        } else if (s.equals("space")) {
            list.add(new CSSIdentifierValue("space"));
            list.add(new CSSIdentifierValue("space"));
        } else if (s.equals("round")) {
            list.add(new CSSIdentifierValue("round"));
            list.add(new CSSIdentifierValue("round"));
        } else {
            return value;
        }
        return list;
    }

    @Override
    protected AbstractCSSPrimitiveValue getCurrentColor() {
        return this.getCSSColor();
    }

    @Override
    public AbstractCSSPrimitiveValue getCSSColor() {
        return (AbstractCSSPrimitiveValue)this.getCSSValue("color");
    }

    @Override
    public CSSPrimitiveValue getCSSBackgroundColor() {
        return (CSSPrimitiveValue)((Object)this.getCSSValue("background-color"));
    }

    @Override
    public String[] getBackgroundImages() {
        BaseCSSDeclarationRule pRule;
        AbstractCSSValue cssVal = this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        String baseHref = cssVal instanceof WrappedValue ? ((WrappedValue)((Object)cssVal)).getParentSheetHref() : ((pRule = this.getParentRule()) != null ? pRule.getParentStyleSheet().getHref() : null);
        if (cssVal.getCssValueType() == 1) {
            return new String[]{this.getHref((CSSPrimitiveValue)((Object)cssVal), baseHref)};
        }
        CSSValueList list = (CSSValueList)((Object)cssVal);
        int len = list.getLength();
        String[] sa = new String[len];
        for (int i = 0; i < len; ++i) {
            sa[i] = this.getHref((CSSPrimitiveValue)list.item(i), baseHref);
        }
        return sa;
    }

    protected String getHref(CSSPrimitiveValue cssVal, String baseHref) {
        String href = cssVal.getStringValue();
        if (!href.contains("://")) {
            URL baseUrl = null;
            if (baseHref == null) {
                String documentURI = this.getOwnerNode().getBaseURI();
                if (documentURI != null) {
                    try {
                        baseUrl = new URL(documentURI);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!baseHref.contains("://")) {
                try {
                    baseUrl = new URL(new URL(this.getOwnerNode().getBaseURI()), baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            } else {
                try {
                    baseUrl = new URL(baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            }
            if (baseUrl != null) {
                try {
                    URL url = new URL(baseUrl, href);
                    href = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(href);
                }
            }
        }
        return href;
    }

    @Override
    public String getUsedFontFamily() {
        String requestedFamily = this.scanFontFamilyValue(this.getCSSValue("font-family"), this);
        if (requestedFamily == null) {
            requestedFamily = this.getStyleDatabase().getDefaultGenericFontFamily();
        }
        return requestedFamily;
    }

    private String scanFontFamilyValue(AbstractCSSValue value, CSSComputedProperties style) {
        CSSComputedProperties ancStyle;
        String requestedFamily = null;
        if (value != null) {
            if (value.getCssValueType() == 2) {
                OMCSSValueList fontList = (OMCSSValueList)value;
                Iterator<AbstractCSSValue> it = fontList.iterator();
                while (it.hasNext()) {
                    AbstractCSSValue item = it.next();
                    requestedFamily = this.stringValueOrNull(item);
                    if (requestedFamily == null || !this.isFontFamilyAvailable(requestedFamily)) continue;
                    return requestedFamily;
                }
            } else {
                requestedFamily = this.stringValueOrNull(value);
                if (requestedFamily != null && this.isFontFamilyAvailable(requestedFamily)) {
                    return requestedFamily;
                }
            }
        }
        if ((ancStyle = style.getParentComputedStyle()) != null) {
            value = ((BaseCSSStyleDeclaration)((Object)ancStyle)).getDeclaredCSSValue("font-family");
            requestedFamily = this.scanFontFamilyValue(value, ancStyle);
        }
        return requestedFamily;
    }

    private String stringValueOrNull(AbstractCSSValue value) {
        CSSPrimitiveValue primi;
        short ptype;
        String s = value.getCssValueType() == 1 && ((ptype = (primi = (CSSPrimitiveValue)((Object)value)).getPrimitiveType()) == 19 || ptype == 21) ? primi.getStringValue() : null;
        return s;
    }

    @Override
    public String getFontFamily() {
        return this.getCSSValue("font-family").getCssText();
    }

    @Override
    public int getComputedFontSize() {
        CSSPrimitiveValue cssSize = (CSSPrimitiveValue)((Object)this.getCSSValue("font-size"));
        int sz = this.getStyleDatabase() != null ? this.getFontSizeFromIdentifier(null, "medium") : 3;
        if (cssSize == null) {
            return sz;
        }
        switch (cssSize.getPrimitiveType()) {
            case 3: {
                float factor = cssSize.getFloatValue((short)3);
                sz = Math.round((float)this.getParentElementFontSize() * factor);
                break;
            }
            case 4: {
                float factor = cssSize.getFloatValue((short)4);
                CSSComputedProperties parentStyle = this.getParentComputedStyle();
                if (parentStyle == null) {
                    sz = Math.round((float)this.getFontSizeFromIdentifier(null, "medium") * 0.5f * factor);
                    break;
                }
                if (this.getStyleDatabase() != null) {
                    sz = Math.round((float)this.getStyleDatabase().getExSizeInPt(parentStyle.getUsedFontFamily(), parentStyle.getComputedFontSize()) * factor);
                    break;
                }
                sz = Math.round((float)parentStyle.getComputedFontSize() * 0.5f * factor);
                break;
            }
            case 21: {
                String sizeIdentifier = cssSize.getStringValue().toLowerCase(Locale.US);
                try {
                    if ("larger".equals(sizeIdentifier)) {
                        sz = this.getLargerFontSize(sz);
                        break;
                    }
                    if ("smaller".equals(sizeIdentifier)) {
                        sz = this.getSmallerFontSize(sz);
                        break;
                    }
                    sz = this.getFontSizeFromIdentifier(null, sizeIdentifier);
                }
                catch (DOMException e) {
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", sizeIdentifier);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError(this.getOwnerNode(), "font-size", sizeIdentifier, "Unknown identifier");
                }
                break;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue((short)2);
                sz = Math.round((float)this.getParentElementFontSize() * pcnt / 100.0f);
                break;
            }
            case 9: {
                sz = (int)cssSize.getFloatValue((short)9);
            }
        }
        return sz;
    }

    private int getFontSizeFromIdentifier(String familyName, String sizeIdentifier) {
        if (this.getStyleDatabase() != null) {
            return this.getStyleDatabase().getFontSizeFromIdentifier(familyName, sizeIdentifier);
        }
        int sz = "medium".equals(sizeIdentifier) ? 3 : ("large".equals(sizeIdentifier) ? 4 : ("small".equals(sizeIdentifier) ? 2 : ("x-large".equals(sizeIdentifier) ? 5 : ("x-small".equals(sizeIdentifier) ? 2 : ("xx-small".equals(sizeIdentifier) ? 1 : ("xx-large".equals(sizeIdentifier) ? 6 : 3))))));
        return sz;
    }

    protected int getLargerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 1.2f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "xx-large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = 2.0f * (float)this.getFontSizeFromIdentifier(null, "xx-large") - (float)this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError(this.getOwnerNode(), "font-size", baseFontSize, "Unknown identifier");
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 1.2f;
                }
            }
        }
        return Math.round(sz);
    }

    protected int getSmallerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 0.82f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = 2.0f * (float)this.getFontSizeFromIdentifier(null, "xx-small") - (float)this.getFontSizeFromIdentifier(null, "x-small");
                        if (!(sz < 0.1f)) break;
                        sz = this.getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError(this.getOwnerNode(), "font-size", baseFontSize, "Unknown identifier");
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 0.82f;
                }
            }
        }
        return Math.round(sz);
    }

    private int getParentElementFontSize() {
        CSSComputedProperties parentCss = this.getParentComputedStyle();
        int sz = parentCss != null ? parentCss.getComputedFontSize() : this.getFontSizeFromIdentifier(null, "medium");
        return sz;
    }

    protected boolean isFontFamilyAvailable(String requestedFamily) {
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb == null || sdb.isFontFamilyAvailable(requestedFamily)) {
            return true;
        }
        CSSCanvas canvas = ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getCanvas();
        if (canvas != null) {
            return canvas.isFontFaceName(requestedFamily);
        }
        return false;
    }

    @Override
    public float getComputedLineHeight() {
        return this.getComputedLineHeight(1.16f);
    }

    public float getComputedLineHeight(float defval) {
        float height;
        CSSPrimitiveValue cssval = (CSSPrimitiveValue)((Object)this.getCSSValue("line-height"));
        if (cssval == null) {
            return defval * (float)this.getComputedFontSize();
        }
        short declType = cssval.getPrimitiveType();
        if (declType == 2) {
            height = (float)this.getComputedFontSize() * cssval.getFloatValue((short)2) / 100.0f;
        } else if (declType == 21) {
            if (!"normal".equals(cssval.getStringValue())) {
                if (this.getParentRule() != null) {
                    CSSPropertyValueException e = new CSSPropertyValueException("Expected 'normal', found " + cssval.getStringValue());
                    this.getParentRule().getStyleDeclarationErrorHandler().wrongValue("line-height", e);
                } else {
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError(this.getOwnerNode(), "line-height", cssval.getStringValue(), "Wrong value: expected 'normal'");
                }
            }
            height = defval * (float)this.getComputedFontSize();
        } else if (cssval instanceof CSSNumberValue) {
            height = cssval.getFloatValue(declType);
            if (declType != 9) {
                height = CSSNumberValue.floatValueConversion(height, declType, (short)9);
            }
        } else {
            if (this.getParentRule() != null) {
                CSSPropertyValueException e = new CSSPropertyValueException("Expected number or identifier, found " + cssval.getCssText());
                this.getParentRule().getStyleDeclarationErrorHandler().wrongValue("line-height", e);
            } else {
                ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError(this.getOwnerNode(), "line-height", cssval.getStringValue(), "Wrong value: expected number or identifier");
            }
            height = defval * (float)this.getComputedFontSize();
        }
        return height;
    }

    @Override
    public BoxValues getBoxValues(short unitType) throws DOMException, StyleDatabaseRequiredException {
        return new MyDefaultBoxModel().getComputedBox(unitType);
    }

    @Override
    public String getCssText() {
        return this.getPlainCssText();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        this.writeComputedCssText(wri, context);
    }

    @Override
    public String getMinifiedCssText() {
        return this.getOptimizedCssText();
    }

    @Override
    public abstract CSSComputedProperties getParentComputedStyle();

    public String getText() {
        return BoxModelHelper.contractSpaces(this.getOwnerNode().getTextContent()).trim();
    }

    @Override
    public abstract ComputedCSSStyle clone();

    private class MyDefaultBoxModel
    extends SimpleBoxModel {
        MyDefaultBoxModel() {
        }

        @Override
        protected ComputedCSSStyle getComputedStyle() {
            return ComputedCSSStyle.this;
        }
    }
}

