/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.ExtendedCSSStyleSheet;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;

public class DefaultSheetErrorHandler
implements SheetErrorHandler {
    static Logger log = LoggerFactory.getLogger((String)DefaultSheetErrorHandler.class.getName());
    private ExtendedCSSStyleSheet sheet;
    private boolean logged = false;
    private LinkedList<String> unknownRules = null;
    private LinkedList<String> ignoredImports = null;
    private LinkedList<RuleParseError> ruleParseErrors = null;
    private LinkedList<String> emptyRules = null;
    private LinkedList<SACMediaList> badMediaLists = null;
    private LinkedList<String> badAtRules = null;
    private LinkedList<String> badInlineStyles = null;
    private LinkedList<ComputedStyleError> computedStyleErrors = null;
    private LinkedHashMap<CSSElement, DOMException> hintErrors;
    private List<AbstractCSSRule> ruleList = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;
    private boolean sacWarningMergedState = false;
    private boolean sacErrorMergedState = false;
    private boolean omErrorMergedState = false;

    public DefaultSheetErrorHandler(ExtendedCSSStyleSheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void badAtRule(DOMException e, String atRule) {
        if (this.badAtRules == null) {
            this.badAtRules = new LinkedList();
        }
        this.badAtRules.add(atRule);
    }

    @Override
    public void badMediaList(SACMediaList media) {
        if (this.badMediaLists == null) {
            this.badMediaLists = new LinkedList();
        }
        this.badMediaLists.add(media);
    }

    @Override
    public void computedStyleError(Node node, String propertyName, String propertyValue, String message) {
        if (this.computedStyleErrors == null) {
            this.computedStyleErrors = new LinkedList();
        }
        MyComputedStyleError cse = new MyComputedStyleError();
        cse.node = node;
        cse.propertyName = propertyName;
        cse.propertyValue = propertyValue;
        cse.message = message;
        this.computedStyleErrors.add(cse);
    }

    @Override
    public void presentationalHintError(CSSElement elm, DOMException e) {
        if (this.hintErrors == null) {
            this.hintErrors = new LinkedHashMap();
        }
        this.hintErrors.put(elm, e);
    }

    private void logSheetInfo() {
        if (!this.logged) {
            this.logged = true;
            String text = "unknown";
            Node owner = this.sheet.getOwnerNode();
            if (owner != null && owner.getNodeType() == 1 && "style".equalsIgnoreCase(((CSSElement)owner).getTagName())) {
                text = owner.toString();
            } else {
                String uri = this.sheet.getHref();
                if (uri != null) {
                    text = "at " + uri;
                }
            }
            log.warn("Issue(s) with sheet " + text);
        }
    }

    @Override
    public void emptyStyleRule(String selector) {
        if (this.emptyRules == null) {
            this.emptyRules = new LinkedList();
        }
        this.emptyRules.add(selector);
    }

    public LinkedList<String> getBadAtRules() {
        return this.badAtRules;
    }

    public LinkedList<String> getBadInlineStyles() {
        return this.badInlineStyles;
    }

    public LinkedList<SACMediaList> getBadMediaLists() {
        return this.badMediaLists;
    }

    public LinkedList<ComputedStyleError> getComputedStyleErrors() {
        return this.computedStyleErrors;
    }

    public LinkedHashMap<CSSElement, DOMException> getHintErrors() {
        return this.hintErrors;
    }

    public LinkedList<String> getEmptyStyleRules() {
        return this.emptyRules;
    }

    public LinkedList<String> getIgnoredImports() {
        return this.ignoredImports;
    }

    public ExtendedCSSRule getRuleAtError(int index) {
        return this.ruleList == null ? null : this.ruleList.get(index);
    }

    public LinkedList<RuleParseError> getRuleParseErrors() {
        return this.ruleParseErrors;
    }

    public List<CSSParseException> getSacErrors() {
        return this.sacErrors;
    }

    public List<CSSParseException> getSacWarnings() {
        return this.sacWarnings;
    }

    public LinkedList<String> getUnknownRules() {
        return this.unknownRules;
    }

    @Override
    public void handleSacError(CSSParseException exception) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
            this.ruleList = new LinkedList<AbstractCSSRule>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(null);
    }

    @Override
    public void handleSacWarning(CSSParseException exception) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(exception);
    }

    @Override
    public boolean hasOMErrors() {
        return this.omErrorMergedState || this.unknownRules != null || this.ignoredImports != null || this.ruleParseErrors != null || this.emptyRules != null || this.badMediaLists != null || this.badAtRules != null || this.badInlineStyles != null || this.computedStyleErrors != null || this.hintErrors != null;
    }

    @Override
    public boolean hasSacErrors() {
        return this.sacErrorMergedState || this.sacErrors != null;
    }

    @Override
    public boolean hasSacWarnings() {
        return this.sacWarningMergedState || this.sacWarnings != null;
    }

    @Override
    public void ignoredImport(String uri) {
        if (this.ignoredImports == null) {
            this.ignoredImports = new LinkedList();
        }
        this.ignoredImports.add(uri);
    }

    @Override
    public void inlineStyleError(DOMException e, Element elm, String attr) {
        if (this.badInlineStyles == null) {
            this.badInlineStyles = new LinkedList();
        }
        this.badInlineStyles.add(attr);
    }

    public void logSacErrors(Logger logger) {
        if (this.sacErrors != null) {
            ListIterator<CSSParseException> it = this.sacErrors.listIterator();
            while (it.hasNext()) {
                CSSParseException ex = it.next();
                logger.error("SAC error at [" + ex.getLineNumber() + "," + ex.getColumnNumber() + "]: " + ex.getMessage());
            }
        }
    }

    public void logSacWarnings(Logger logger) {
        if (this.sacWarnings != null) {
            ListIterator<CSSParseException> it = this.sacWarnings.listIterator();
            while (it.hasNext()) {
                CSSParseException ex = it.next();
                logger.warn("SAC warning at [" + ex.getLineNumber() + "," + ex.getColumnNumber() + "]: " + ex.getMessage());
            }
        }
    }

    @Override
    public void mapError(CSSParseException exception, AbstractCSSRule rule) {
        if (this.ruleList == null) {
            this.ruleList = new LinkedList<AbstractCSSRule>();
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(rule);
    }

    @Override
    public void mergeState(SheetErrorHandler other) {
        this.sacWarningMergedState = this.sacWarningMergedState || other.hasSacWarnings();
        this.sacErrorMergedState = this.sacErrorMergedState || other.hasSacErrors();
        this.omErrorMergedState = this.omErrorMergedState || other.hasOMErrors();
    }

    @Override
    public void reset() {
        this.ruleList = null;
        this.sacErrors = null;
        this.sacWarnings = null;
        this.sacErrorMergedState = false;
        this.sacWarningMergedState = false;
        this.omErrorMergedState = false;
        this.unknownRules = null;
        this.ignoredImports = null;
        this.ruleParseErrors = null;
        this.emptyRules = null;
        this.badMediaLists = null;
        this.badAtRules = null;
        this.badInlineStyles = null;
        this.resetComputedStyleErrors();
    }

    @Override
    public void resetComputedStyleErrors() {
        this.computedStyleErrors = null;
        this.hintErrors = null;
    }

    @Override
    public void ruleParseError(CSSRule rule, CSSParseException ex) {
        if (this.ruleParseErrors == null) {
            this.ruleParseErrors = new LinkedList();
        }
        MyRuleParseError rpe = new MyRuleParseError();
        rpe.rule = rule;
        rpe.ex = ex;
        this.ruleParseErrors.add(rpe);
    }

    @Override
    public void ruleParseWarning(CSSRule rule, CSSParseException ex) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this.hasSacErrors()) {
            buf.append("SAC Errors:");
            if (this.sacErrors != null) {
                buf.append('\n');
                for (int i = 0; i < this.sacErrors.size(); ++i) {
                    CSSParseException ex = this.sacErrors.get(i);
                    ExtendedCSSRule rule = this.ruleList.get(i);
                    buf.append('[').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber()).append("] ").append(ex.getMessage());
                    if (rule != null) {
                        buf.append(" --> ").append(rule.getCssText());
                    }
                    buf.append('\n');
                }
            } else {
                buf.append(" only merged.\n");
            }
        } else {
            buf.append("No SAC errors.\n");
        }
        if (this.sacWarnings != null) {
            buf.append("SAC Warnings:");
            Iterator<CSSParseException> it = this.sacWarnings.iterator();
            while (it.hasNext()) {
                buf.append(' ').append(it.next().getMessage());
            }
        } else {
            buf.append("No SAC warnings.\n");
        }
        return buf.toString();
    }

    @Override
    public void sacMalfunction(String message) {
        this.logSheetInfo();
        log.error(message);
    }

    @Override
    public void unknownRule(String rule) {
        if (this.unknownRules == null) {
            this.unknownRules = new LinkedList();
        }
        this.unknownRules.add(rule);
    }

    class MyRuleParseError
    implements RuleParseError {
        CSSRule rule;
        CSSParseException ex;

        MyRuleParseError() {
        }

        @Override
        public CSSParseException getException() {
            return this.ex;
        }

        @Override
        public CSSRule getRule() {
            return this.rule;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Rule: ").append(this.rule.getType()).append(", [").append(this.ex.getLineNumber()).append(':').append(this.ex.getColumnNumber()).append(']').append(' ').append(" Message: ").append(this.ex.getMessage());
            return buf.toString();
        }
    }

    public static interface RuleParseError {
        public CSSParseException getException();

        public CSSRule getRule();
    }

    class MyComputedStyleError
    implements ComputedStyleError {
        private Node node;
        private String propertyName;
        private String propertyValue;
        private String message;

        MyComputedStyleError() {
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Node: <").append(this.node.getNodeName()).append(">, ").append(this.propertyName).append(':').append(' ').append(this.propertyValue).append(" Message: ").append(this.message);
            return buf.toString();
        }
    }

    public static interface ComputedStyleError {
        public String getMessage();

        public Node getNode();

        public String getPropertyName();

        public String getPropertyValue();
    }
}

