/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class FlexShorthandBuilder
extends ShorthandBuilder {
    private final String FLEX_GROW = "flex-grow";
    private final String FLEX_SHRINK = "flex-shrink";
    private final String FLEX_BASIS = "flex-basis";

    FlexShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("flex", parentStyle);
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        AbstractCSSValue cssFlexGrow = null;
        if ((declaredSet.contains("flex-grow") || declaredSet.contains("flex-shrink")) && ((cssFlexGrow = this.getCSSValue("flex-grow")).getCssValueType() != 1 || this.invalidFlexGrowShrink((CSSPrimitiveValue)((Object)cssFlexGrow)))) {
            return false;
        }
        AbstractCSSValue cssFlexShrink = null;
        if (declaredSet.contains("flex-shrink") && ((cssFlexShrink = this.getCSSValue("flex-shrink")).getCssValueType() != 1 || this.invalidFlexGrowShrink((CSSPrimitiveValue)((Object)cssFlexShrink)))) {
            return false;
        }
        AbstractCSSValue cssFlexBasis = null;
        if (declaredSet.contains("flex-basis") && ((cssFlexBasis = this.getCSSValue("flex-basis")).getCssValueType() != 1 || this.invalidFlexBasis((CSSPrimitiveValue)((Object)cssFlexBasis)))) {
            return false;
        }
        CSSPrimitiveValue primiBasis = (CSSPrimitiveValue)((Object)cssFlexBasis);
        if (primiBasis != null && primiBasis.getPrimitiveType() == 21 && "auto".equalsIgnoreCase(primiBasis.getStringValue())) {
            float grow;
            float shrink;
            CSSPrimitiveValue primiGrow = (CSSPrimitiveValue)((Object)cssFlexGrow);
            CSSPrimitiveValue primiShrink = (CSSPrimitiveValue)((Object)cssFlexShrink);
            if (primiShrink != null) {
                shrink = primiShrink.getFloatValue((short)1);
                grow = primiGrow != null ? primiGrow.getFloatValue((short)1) : shrink;
            } else {
                grow = primiGrow != null ? primiGrow.getFloatValue((short)1) : 1.0f;
                shrink = grow;
            }
            if (grow == 1.0f && shrink == 1.0f) {
                buf.append("auto");
                this.appendPriority(buf, important);
                return true;
            }
            if (grow == 0.0f && shrink == 0.0f) {
                buf.append("none");
                this.appendPriority(buf, important);
                return true;
            }
        }
        boolean appended = false;
        boolean shrinkNotInitial = this.isNotInitialValue(cssFlexShrink, "flex-shrink");
        if (shrinkNotInitial || this.isNotInitialValue(cssFlexGrow, "flex-grow")) {
            this.appendValueText(buf, cssFlexGrow, false);
            appended = true;
        }
        if (shrinkNotInitial) {
            this.appendValueText(buf, cssFlexShrink, appended);
            appended = true;
        }
        if (this.isNotInitialValue(cssFlexBasis, "flex-basis")) {
            if (primiBasis.getPrimitiveType() == 1) {
                if (appended) {
                    buf.append(' ');
                }
                buf.append("0px");
            } else {
                this.appendValueText(buf, cssFlexBasis, appended);
            }
            appended = true;
        }
        if (!appended) {
            buf.append("0 1 auto");
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean invalidFlexGrowShrink(CSSPrimitiveValue primi) {
        if (primi.getPrimitiveType() == 1) {
            return primi.getFloatValue((short)1) < 0.0f;
        }
        if (primi.getPrimitiveType() == 21) {
            String ident = primi.getStringValue();
            return !"initial".equalsIgnoreCase(ident);
        }
        return true;
    }

    private boolean invalidFlexBasis(CSSPrimitiveValue primi) {
        if (primi.getPrimitiveType() == 21) {
            String ident = primi.getStringValue();
            return !"auto".equalsIgnoreCase(ident) && !"content".equalsIgnoreCase(ident) && !"initial".equalsIgnoreCase(ident);
        }
        if (primi.getPrimitiveType() == 1) {
            return primi.getFloatValue((short)1) != 0.0f;
        }
        return false;
    }

    @Override
    protected boolean isNotInitialValue(AbstractCSSValue cssVal, String propertyName) {
        return cssVal != null && !FlexShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, AbstractCSSValue cssVal, boolean prepend) {
        if (prepend) {
            buf.append(' ');
        }
        buf.append(cssVal.getCssText());
    }
}

