/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.Locale;
import java.util.Set;

class FontBuilder
extends ShorthandBuilder {
    FontBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("font", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 14;
    }

    @Override
    protected void preprocessSet() {
        this.addPropertyIfAssigned("font-variant-caps");
        this.addPropertyIfAssigned("font-variant-ligatures");
        this.addPropertyIfAssigned("font-variant-position");
        this.addPropertyIfAssigned("font-variant-numeric");
        this.addPropertyIfAssigned("font-variant-alternates");
        this.addPropertyIfAssigned("font-variant-east-asian");
    }

    private void addPropertyIfAssigned(String property) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (style.isPropertySet(property)) {
            this.addAssignedProperty(property, style.isPropertyImportant(property));
        }
    }

    void appendFontKerningValue(StringBuilder buf) {
        buf.append("font-kerning:").append(this.getCSSValue("font-kerning").getMinifiedCssText("font-kerning"));
        this.appendPriority(buf, this.isPropertyImportant("font-kerning"));
    }

    private void appendFontSizeAdjustValue(StringBuilder buf) {
        buf.append("font-size-adjust:").append(this.getCSSValue("font-size-adjust").getMinifiedCssText("font-size-adjust"));
        this.appendPriority(buf, this.isPropertyImportant("font-size-adjust"));
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (!this.appendFontShorthandSet(buf, declaredSet, important)) {
            FontVariantBuilder builder = this.createFontVariantBuilder();
            builder.appendMinifiedCssText(buf);
            return false;
        }
        if (!this.isFontVariantSetToInitialOrCss21()) {
            FontVariantBuilder builder = this.createFontVariantBuilder();
            builder.appendMinifiedCssText(buf);
        }
        if (this.isPropertyAssigned("font-kerning", important) && !this.isInitialValue("font-kerning")) {
            this.appendFontKerningValue(buf);
        }
        if (this.isPropertyAssigned("font-size-adjust", important) && !this.isInitialValue("font-size-adjust")) {
            this.appendFontSizeAdjustValue(buf);
        }
        return true;
    }

    boolean appendFontShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (!this.isFontKerningAdjustVariantSet(important)) {
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        AbstractCSSValue vFontVariant = this.getCSSValue("font-variant-caps");
        AbstractCSSValue vFontStyle = this.getCSSValue("font-style");
        AbstractCSSValue vFontWeight = this.getCSSValue("font-weight");
        AbstractCSSValue vFontStretch = this.getCSSValue("font-stretch");
        AbstractCSSValue vFontSize = this.getCSSValue("font-size");
        AbstractCSSValue vFontFamily = this.getCSSValue("font-family");
        AbstractCSSValue vLineHeight = this.getCSSValue("line-height");
        if (declaredSet.size() >= 7) {
            byte inheritcheck = this.checkValuesForInherit(vFontStyle, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight);
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (inheritcheck == 2) {
                return false;
            }
            if (this.checkValuesForInitial(vFontStyle, vFontVariant, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight)) {
                buf.append("normal");
                this.appendPriority(buf, important);
                return true;
            }
            byte unsetcheck = this.checkValuesForUnset(vFontStyle, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight);
            if (unsetcheck == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (unsetcheck == 2) {
                return false;
            }
        }
        if (!this.isFontVariantCss21(vFontVariant)) {
            return false;
        }
        if (!this.isFontStretchCss3(vFontStretch)) {
            return false;
        }
        boolean appended = false;
        if (declaredSet.contains("font-style")) {
            appended = this.appendValueIfNotInitial(buf, "font-style", vFontStyle, appended);
        }
        if (declaredSet.contains("font-variant-caps")) {
            appended = this.appendValueIfNotInitial(buf, "font-variant-caps", vFontVariant, appended);
        }
        if (declaredSet.contains("font-weight")) {
            appended = this.appendValueIfNotInitial(buf, "font-weight", vFontWeight, appended);
        }
        if (declaredSet.contains("font-stretch")) {
            appended = this.appendValueIfNotInitial(buf, "font-stretch", vFontStretch, appended);
        }
        if (declaredSet.contains("font-size") || declaredSet.contains("line-height")) {
            boolean not_initial_lh = this.isNotInitialValue(vLineHeight, "line-height");
            if (declaredSet.contains("font-size") && this.isNotInitialValue(vFontSize, "font-size") || not_initial_lh) {
                if (appended) {
                    buf.append(' ');
                } else {
                    appended = true;
                }
                buf.append(vFontSize.getMinifiedCssText("font-size"));
                if (not_initial_lh) {
                    buf.append('/').append(vLineHeight.getMinifiedCssText("line-height"));
                }
            }
        }
        if (declaredSet.contains("font-family")) {
            appended = this.appendValueIfNotInitial(buf, "font-family", vFontFamily, appended);
        }
        if (!appended) {
            buf.append("normal");
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean appendValueIfNotInitial(StringBuilder buf, String propertyName, AbstractCSSValue cssVal, boolean appended) {
        String text = this.getValueTextIfNotInitial(propertyName, cssVal);
        if (text != null) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(text);
            return true;
        }
        return appended;
    }

    private byte checkValuesForInherit(AbstractCSSValue vFontStyle, AbstractCSSValue vFontWeight, AbstractCSSValue vFontStretch, AbstractCSSValue vFontSize, AbstractCSSValue vFontFamily, AbstractCSSValue vLineHeight) {
        int count = 0;
        if (this.isInherit(vFontStyle)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontWeight)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontStretch)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontSize)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontFamily)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vLineHeight)) {
            count = (byte)(count + 1);
        }
        switch (count) {
            case 0: {
                return 0;
            }
            case 6: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkValuesForUnset(AbstractCSSValue vFontStyle, AbstractCSSValue vFontWeight, AbstractCSSValue vFontStretch, AbstractCSSValue vFontSize, AbstractCSSValue vFontFamily, AbstractCSSValue vLineHeight) {
        int ucount = 0;
        if (this.isCssKeywordValue("unset", vFontStyle)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue("unset", vFontWeight)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue("unset", vFontStretch)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue("unset", vFontSize)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue("unset", vFontFamily)) {
            ucount = (byte)(ucount + 1);
        }
        if (this.isCssKeywordValue("unset", vLineHeight)) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 6: {
                return 1;
            }
        }
        return 2;
    }

    private boolean checkValuesForInitial(AbstractCSSValue vFontStyle, AbstractCSSValue vFontVariant, AbstractCSSValue vFontWeight, AbstractCSSValue vFontStretch, AbstractCSSValue vFontSize, AbstractCSSValue vFontFamily, AbstractCSSValue vLineHeight) {
        if (!this.isCssKeywordValue("initial", vFontStyle) && this.isNotInitialValue(vFontStyle, "font-style")) {
            return false;
        }
        if (!this.isCssKeywordValue("initial", vFontVariant) && this.isNotInitialValue(vFontVariant, "font-variant")) {
            return false;
        }
        if (!this.isCssKeywordValue("initial", vFontWeight) && this.isNotInitialValue(vFontWeight, "font-weight")) {
            return false;
        }
        if (!this.isCssKeywordValue("initial", vFontStretch) && this.isNotInitialValue(vFontStretch, "font-stretch")) {
            return false;
        }
        if (!this.isCssKeywordValue("initial", vFontSize) && this.isNotInitialValue(vFontSize, "font-size")) {
            return false;
        }
        if (!this.isCssKeywordValue("initial", vFontFamily) && this.isNotInitialValue(vFontFamily, "font-family")) {
            return false;
        }
        return this.isCssKeywordValue("initial", vLineHeight) || !this.isNotInitialValue(vLineHeight, "line-height");
    }

    private boolean isFontVariantCss21(AbstractCSSValue vFontVariant) {
        String text = vFontVariant.getCssText().toLowerCase(Locale.US);
        return text.equals("normal") || text.equals("small-caps") || text.equals("initial");
    }

    private boolean isFontStretchCss3(AbstractCSSValue vFontStretch) {
        String text = vFontStretch.getCssText().toLowerCase(Locale.US);
        return text.equals("normal") || text.equals("ultra-condensed") || text.equals("extra-condensed") || text.equals("condensed") || text.equals("semi-condensed") || text.equals("semi-expanded") || text.equals("expanded") || text.equals("extra-expanded") || text.equals("ultra-expanded") || text.equals("initial");
    }

    private boolean isFontKerningAdjustVariantSet(boolean important) {
        return this.isPropertyAssigned("font-kerning", important) && this.isPropertyAssigned("font-size-adjust", important) && this.isPropertyAssigned("font-variant-ligatures", important) && this.isPropertyAssigned("font-variant-position", important) && this.isPropertyAssigned("font-variant-caps", important) && this.isPropertyAssigned("font-variant-numeric", important) && this.isPropertyAssigned("font-variant-alternates", important) && this.isPropertyAssigned("font-variant-east-asian", important);
    }

    private boolean isFontVariantSetToInitialOrCss21() {
        AbstractCSSValue cssVal = this.getCSSValue("font-variant-caps");
        String fvcaps = cssVal.getCssText();
        if (FontBuilder.isInitialIdentifier(cssVal) || fvcaps.equalsIgnoreCase("normal") || fvcaps.equalsIgnoreCase("small-caps")) {
            return this.isInitialValue("font-variant-ligatures") && this.isInitialValue("font-variant-position") && this.isInitialValue("font-variant-numeric") && this.isInitialValue("font-variant-alternates") && this.isInitialValue("font-variant-east-asian");
        }
        return false;
    }

    private FontVariantBuilder createFontVariantBuilder() {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        FontVariantBuilder builder = new FontVariantBuilder(style);
        this.addPropertyIfAssigned(builder, "font-variant-ligatures");
        this.addPropertyIfAssigned(builder, "font-variant-caps");
        this.addPropertyIfAssigned(builder, "font-variant-position");
        this.addPropertyIfAssigned(builder, "font-variant-numeric");
        this.addPropertyIfAssigned(builder, "font-variant-alternates");
        this.addPropertyIfAssigned(builder, "font-variant-east-asian");
        return builder;
    }

    private void addPropertyIfAssigned(ShorthandBuilder builder, String property) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (style.isPropertySet(property)) {
            builder.addAssignedProperty(property, style.isPropertyImportant(property));
        }
    }
}

